/*
 * Decompiled with CFR 0.152.
 */
package btw.block.tileentity.beacon;

import btw.block.tileentity.beacon.AmbientBeaconEffect;
import btw.block.tileentity.beacon.BeaconTileEntity;

public class CompanionBeaconEffect
extends AmbientBeaconEffect {
    public static int companionStrength = 0;

    public CompanionBeaconEffect() {
        super("Companion");
    }

    @Override
    public void onUpdate(BeaconTileEntity beacon) {
        super.onUpdate(beacon);
        if (beacon.updatedPowerState) {
            this.updateCompanionStrengthUpwards(beacon);
        }
    }

    private void updateCompanionStrengthUpwards(BeaconTileEntity beacon) {
        int power = beacon.l();
        if (power > companionStrength) {
            companionStrength = power;
        }
    }

    private void setCompanionStrength(int strength) {
        companionStrength = strength;
    }

    @Override
    public void onPowerOn(BeaconTileEntity beacon) {
        super.onPowerOn(beacon);
        this.updateCompanionStrengthUpwards(beacon);
        if (beacon.k.I) {
            beacon.k.playSound((double)beacon.l + 0.5, (double)beacon.m + 0.5, (double)beacon.n + 0.5, "mob.wolf.howl1", 1.2f + beacon.k.s.nextFloat() * 0.2f, 1.0f - beacon.k.s.nextFloat() * 0.2f);
        }
    }

    @Override
    public void onPowerChange(int newPowerLevel, int oldPowerLevel, BeaconTileEntity beacon) {
        super.onPowerChange(newPowerLevel, oldPowerLevel, beacon);
        this.setCompanionStrength(beacon.l());
    }

    @Override
    public void onPowerOff(BeaconTileEntity beacon) {
        super.onPowerOff(beacon);
        this.setCompanionStrength(0);
    }
}

