/*
 * Decompiled with CFR 0.152.
 */
package btw.block.tileentity.beacon;

import btw.BTWMod;
import btw.block.BTWBlocks;
import btw.block.tileentity.beacon.AmbientBeaconEffect;
import btw.block.tileentity.beacon.BeaconEffect;
import btw.block.tileentity.beacon.BeaconEffectDescriptor;
import btw.block.tileentity.beacon.CompanionBeaconEffect;
import btw.block.tileentity.beacon.DecorativeBeaconEffect;
import btw.block.tileentity.beacon.EnderAntennaBeaconEffect;
import btw.block.tileentity.beacon.LootingBeaconEffect;
import btw.block.tileentity.beacon.MagneticPointBeaconEffect;
import btw.block.tileentity.beacon.NauseaBeaconEffect;
import btw.block.tileentity.beacon.PotionBeaconEffect;
import btw.block.tileentity.beacon.SpawnAnchorBeaconEffect;
import java.util.ArrayList;
import java.util.Random;

public class BeaconTileEntity
extends apw {
    private static final long TICKS_UPDATES = 80L;
    private static ArrayList<BeaconEffectDescriptor>[] beaconEffectsByBlockID = new ArrayList[4096];
    private static Random rand = new Random();
    private long updateOffset = rand.nextInt(80);
    public boolean updatedPowerState = true;
    public boolean playerRespawnedAtBeacon = false;
    public int belowBlockID = -1;
    public int belowMetadata = -1;
    public static final BeaconEffect HASTE_EFFECT = new PotionBeaconEffect(mk.e.c(), true);
    public static final BeaconEffect FORTUNE_EFFECT = new PotionBeaconEffect(BTWMod.potionFortune.c(), true);
    public static final BeaconEffect TRUE_SIGHT_EFFECT = new PotionBeaconEffect(BTWMod.potionTrueSight.c(), false);
    public static final BeaconEffect NIGHT_VISION_EFFECT = new PotionBeaconEffect(mk.r.c(), false);
    public static final BeaconEffect FIRE_RESIST_EFFECT = new PotionBeaconEffect(mk.n.c(), false);
    public static final BeaconEffect MAGNETIC_POLE_EFFECT = new MagneticPointBeaconEffect();
    public static final BeaconEffect SPAWN_ANCHOR_EFFECT = new SpawnAnchorBeaconEffect();
    public static final BeaconEffect DECORATIVE_EFFECT = new DecorativeBeaconEffect();
    public static final BeaconEffect NAUSEA_EFFECT = new NauseaBeaconEffect();
    public static final BeaconEffect ENDER_ANTENNA_EFFECT = new EnderAntennaBeaconEffect();
    public static final AmbientBeaconEffect LOOTING_EFFECT = new LootingBeaconEffect();
    public static final CompanionBeaconEffect COMPANION_EFFECT = new CompanionBeaconEffect();
    public static final AmbientBeaconEffect JUNGLE_SPIDER_REPELLENT = new AmbientBeaconEffect("JungleRepel");
    public BeaconEffect beaconEffect;

    @Override
    public void h() {
        if ((this.k.H() + this.updateOffset) % 80L == 0L) {
            this.updatePowerState();
            this.updatedPowerState = true;
        }
        if (this.beaconEffect != null && this.isOn() && this.l() > 0) {
            this.beaconEffect.onUpdate(this);
        }
        if (this.updatedPowerState) {
            this.updatedPowerState = false;
        }
    }

    @Override
    public void a(bs par1NBTTagCompound) {
        BeaconEffectDescriptor effectDescriptor;
        super.a(par1NBTTagCompound);
        this.belowBlockID = par1NBTTagCompound.e("belowBlockID");
        this.belowMetadata = par1NBTTagCompound.e("belowMetadata");
        this.d = par1NBTTagCompound.n("isBeaconActive");
        if (this.d && (effectDescriptor = this.getEffectDescriptor(this.belowBlockID, this.belowMetadata)) != null && effectDescriptor.EFFECT != null && effectDescriptor.EFFECT != this.beaconEffect) {
            this.beaconEffect = effectDescriptor.EFFECT;
        }
    }

    @Override
    public void b(bs par1NBTTagCompound) {
        super.b(par1NBTTagCompound);
        par1NBTTagCompound.a("belowBlockID", this.belowBlockID);
        par1NBTTagCompound.a("belowMetadata", this.belowMetadata);
        par1NBTTagCompound.a("isBeaconActive", this.d);
    }

    private boolean isPyramidLevelValid(int level, int blockIDToCheck, int metadataToCheck) {
        int j2 = this.m - level;
        if (j2 < 0) {
            return false;
        }
        for (int i2 = this.l - level; i2 <= this.l + level; ++i2) {
            for (int k = this.n - level; k <= this.n + level; ++k) {
                int blockID = this.k.a(i2, j2, k);
                if (blockID == blockIDToCheck && (metadataToCheck == -1 || this.k.h(i2, j2, k) == metadataToCheck)) continue;
                return false;
            }
        }
        return true;
    }

    private void updatePowerState() {
        if (!this.k.e(this.l - 4, this.m, this.n - 4, this.l + 4, this.m, this.n + 4)) {
            return;
        }
        this.updateBelowBlockType();
        if (!this.canBeaconSeeSky()) {
            this.setPowerState(false, 0, null);
            return;
        }
        int level = 0;
        BeaconEffectDescriptor effectDescriptor = this.getEffectDescriptor(this.belowBlockID, this.belowMetadata);
        if (effectDescriptor != null) {
            int metadataToCheck = effectDescriptor.BLOCK_METADATA;
            int i2 = 1;
            while (i2 <= 4 && this.isPyramidLevelValid(i2, this.belowBlockID, metadataToCheck)) {
                level = i2++;
            }
            if (effectDescriptor.EFFECT != null) {
                if (level > 0) {
                    this.setPowerState(true, level, effectDescriptor.EFFECT);
                } else {
                    this.setPowerState(false, 0, null);
                }
            }
        }
    }

    private void updateBelowBlockType() {
        this.belowBlockID = this.k.a(this.l, this.m - 1, this.n);
        if (this.belowBlockID > 0) {
            this.belowMetadata = this.k.h(this.l, this.m - 1, this.n);
        }
    }

    public void setPowerState(boolean isOn, int newPowerLevel, BeaconEffect effectClass) {
        int oldPowerLevel = this.l();
        BeaconEffect oldEffect = this.beaconEffect;
        this.beaconEffect = effectClass;
        if (this.beaconEffect != null) {
            if (newPowerLevel != oldPowerLevel) {
                effectClass.onPowerChange(newPowerLevel, oldPowerLevel, this);
            }
            if (oldPowerLevel <= 0 && newPowerLevel > 0) {
                effectClass.onPowerOn(this);
            }
        } else if (oldEffect != null) {
            if (newPowerLevel != oldPowerLevel) {
                oldEffect.onPowerChange(newPowerLevel, oldPowerLevel, this);
            }
            if (newPowerLevel <= 0 && oldPowerLevel > 0) {
                oldEffect.onPowerOff(this);
            }
        }
        this.setIsOn(isOn);
        this.setLevelsServerSafe(newPowerLevel);
    }

    private boolean canBeaconSeeSky() {
        if (this.k.t.h != -1) {
            return this.k.l(this.l, this.m + 1, this.n);
        }
        if (!this.k.c(this.l, this.m + 1, this.n)) {
            return false;
        }
        for (int iTempY = this.m + 2; iTempY < 256; ++iTempY) {
            if (this.k.c(this.l, iTempY, this.n)) continue;
            int iBlockID = this.k.a(this.l, iTempY, this.n);
            return iBlockID == apa.D.cz;
        }
        return true;
    }

    private BeaconEffectDescriptor getEffectDescriptor(int blockID, int metadata) {
        ArrayList<BeaconEffectDescriptor> descriptorArray = beaconEffectsByBlockID[blockID];
        for (int i2 = 0; i2 < descriptorArray.size(); ++i2) {
            BeaconEffectDescriptor tempDescriptor = descriptorArray.get(i2);
            if (tempDescriptor.BLOCK_METADATA != -1 && tempDescriptor.BLOCK_METADATA != metadata) continue;
            return tempDescriptor;
        }
        return null;
    }

    public BeaconEffect getActiveEffect() {
        return this.beaconEffect;
    }

    public static void addBeaconEffect(int iBlockID, BeaconEffect effectClass) {
        BeaconTileEntity.addBeaconEffect(iBlockID, -1, effectClass);
    }

    public static void addBeaconEffect(int iBlockID, int iBlockMetadata, BeaconEffect effectClass) {
        beaconEffectsByBlockID[iBlockID].add(new BeaconEffectDescriptor(iBlockMetadata, effectClass));
    }

    public static void initializeEffectsByBlockID() {
        for (int i2 = 0; i2 < 4096; ++i2) {
            BeaconTileEntity.beaconEffectsByBlockID[i2] = new ArrayList();
        }
        BeaconTileEntity.addBeaconEffect(apa.al.cz, HASTE_EFFECT);
        BeaconTileEntity.addBeaconEffect(apa.aB.cz, FORTUNE_EFFECT);
        BeaconTileEntity.addBeaconEffect(apa.bZ.cz, LOOTING_EFFECT);
        BeaconTileEntity.addBeaconEffect(apa.S.cz, TRUE_SIGHT_EFFECT);
        BeaconTileEntity.addBeaconEffect(apa.bh.cz, NIGHT_VISION_EFFECT);
        BeaconTileEntity.addBeaconEffect(BTWBlocks.aestheticOpaque.cz, 3, FIRE_RESIST_EFFECT);
        BeaconTileEntity.addBeaconEffect(apa.am.cz, MAGNETIC_POLE_EFFECT);
        BeaconTileEntity.addBeaconEffect(BTWBlocks.soulforgedSteelBlock.cz, SPAWN_ANCHOR_EFFECT);
        BeaconTileEntity.addBeaconEffect(apa.Q.cz, DECORATIVE_EFFECT);
        BeaconTileEntity.addBeaconEffect(BTWBlocks.aestheticEarth.cz, 7, NAUSEA_EFFECT);
        BeaconTileEntity.addBeaconEffect(BTWBlocks.aestheticOpaque.cz, 14, ENDER_ANTENNA_EFFECT);
        BeaconTileEntity.addBeaconEffect(BTWBlocks.companionCube.cz, COMPANION_EFFECT);
        BeaconTileEntity.addBeaconEffect(BTWBlocks.spiderEyeBlock.cz, JUNGLE_SPIDER_REPELLENT);
    }
}

