/*
 * Decompiled with CFR 0.152.
 */
package btw.block.tileentity.beacon;

import btw.block.tileentity.beacon.BeaconEffectLocation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BeaconEffectLocationList {
    public List effectLocations = new ArrayList();

    public void loadFromNBT(ca tagList) {
        this.effectLocations.clear();
        for (int iTempCount = 0; iTempCount < tagList.c(); ++iTempCount) {
            bs tempCompound = (bs)tagList.b(iTempCount);
            BeaconEffectLocation newPoint = new BeaconEffectLocation(tempCompound);
            this.effectLocations.add(newPoint);
        }
    }

    public ca saveToNBT() {
        ca tagList = new ca("EffectLocations");
        Iterator tempIterator = this.effectLocations.iterator();
        while (tempIterator.hasNext()) {
            bs tempTagCompound = new bs();
            BeaconEffectLocation tempPoint = (BeaconEffectLocation)tempIterator.next();
            tempPoint.writeToNBT(tempTagCompound);
            tagList.a((cf)tempTagCompound);
        }
        return tagList;
    }

    public void removePointAt(int iIPos, int iJPos, int iKPos) {
        Iterator tempIterator = this.effectLocations.iterator();
        while (tempIterator.hasNext()) {
            BeaconEffectLocation tempPoint = (BeaconEffectLocation)tempIterator.next();
            if (tempPoint.posX != iIPos || tempPoint.posZ != iKPos || tempPoint.posY != iJPos) continue;
            tempIterator.remove();
            return;
        }
    }

    public void addPoint(int posX, int posY, int posZ, int effectLevel, int range, String effectID) {
        BeaconEffectLocation newPoint = new BeaconEffectLocation(posX, posY, posZ, effectLevel, range, effectID);
        this.effectLocations.add(newPoint);
    }

    public void changeEffectLevelOfPointAt(int posX, int posY, int posZ, int powerLevel, int range) {
        BeaconEffectLocation point = this.getEffectAtLocation(posX, posY, posZ);
        if (point != null) {
            point.effectLevel = powerLevel;
            point.range = range;
        }
    }

    public BeaconEffectLocation getEffectAtLocation(int posX, int posY, int posZ) {
        for (Object effectLocation : this.effectLocations) {
            BeaconEffectLocation tempPoint = (BeaconEffectLocation)effectLocation;
            if (tempPoint.posX != posX || tempPoint.posZ != posZ || tempPoint.posY != posY) continue;
            return tempPoint;
        }
        return null;
    }

    public int getMostPowerfulBeaconEffectForLocation(String effectID, int iIPos, int iKPos) {
        int maxLevel = 0;
        for (Object effectLocation : this.effectLocations) {
            BeaconEffectLocation point = (BeaconEffectLocation)effectLocation;
            if (point.effectID != effectID || iIPos < point.posX - point.range || iIPos > point.posX + point.range || iKPos < point.posZ - point.range || iKPos > point.posZ + point.range || point.effectLevel <= maxLevel) continue;
            maxLevel = point.effectLevel;
        }
        return maxLevel;
    }
}

