/*
 * Decompiled with CFR 0.152.
 */
package btw.block.tileentity.beacon;

import btw.block.tileentity.beacon.BeaconTileEntity;

public class BeaconEffectLocation {
    public int posX;
    public int posY;
    public int posZ;
    public int effectLevel;
    public int range;
    String effectID;

    public BeaconEffectLocation() {
        this.posX = 0;
        this.posY = 0;
        this.posZ = 0;
        this.effectLevel = 0;
        this.range = 0;
    }

    public BeaconEffectLocation(int posX, int posY, int posZ, int effectLevel, int range, String effectID) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.effectLevel = effectLevel;
        this.range = range;
        this.effectID = effectID;
    }

    public BeaconEffectLocation(bs tagCompound) {
        this.loadFromNBT(tagCompound);
    }

    public void loadFromNBT(bs tagCompound) {
        this.posX = tagCompound.e("IPos");
        this.posY = tagCompound.d("JPos");
        this.posZ = tagCompound.e("KPos");
        this.effectLevel = tagCompound.c("Lvl");
        this.range = tagCompound.e("Rng");
        this.effectID = tagCompound.i("effectID") != null ? tagCompound.i("effectID") : BeaconTileEntity.LOOTING_EFFECT.EFFECT_NAME;
    }

    public bs writeToNBT(bs tagCompound) {
        tagCompound.a("IPos", this.posX);
        tagCompound.a("JPos", (short)this.posY);
        tagCompound.a("KPos", this.posZ);
        tagCompound.a("Lvl", (byte)this.effectLevel);
        tagCompound.a("Rng", this.range);
        tagCompound.a("effectID", this.effectID);
        return tagCompound;
    }
}

