/*
 * Decompiled with CFR 0.152.
 */
package btw.block.tileentity.beacon;

import btw.block.tileentity.beacon.BeaconTileEntity;

public abstract class BeaconEffect {
    public static final int EFFECT_DURATION = 180;
    public static final double[] rangePerLevel = new double[]{0.0, 20.0, 40.0, 80.0, 160.0};

    public abstract void onUpdate(BeaconTileEntity var1);

    public void onPowerOn(BeaconTileEntity beacon) {
        if (beacon.k.I) {
            beacon.k.playSound((double)beacon.l + 0.5, (double)beacon.m + 0.5, (double)beacon.n + 0.5, "mob.wither.spawn", 1.0f + beacon.k.s.nextFloat() * 0.1f, 1.0f + beacon.k.s.nextFloat() * 0.1f);
        }
    }

    public void onPowerOff(BeaconTileEntity beacon) {
        if (beacon.k.I) {
            beacon.k.playSound((double)beacon.l + 0.5, (double)beacon.m + 0.5, (double)beacon.n + 0.5, "mob.wither.death", 1.0f + beacon.k.s.nextFloat() * 0.1f, 1.0f + beacon.k.s.nextFloat() * 0.1f);
        }
    }

    public void onPowerChange(int newPowerLevel, int oldPowerLevel, BeaconTileEntity beacon) {
        if (!beacon.k.I) {
            this.updateGlobalMagneticFieldListForStateChange(newPowerLevel, oldPowerLevel, beacon);
        }
    }

    protected void applyPotionEffectToPlayersInRange(int effectID, int effectLevel, BeaconTileEntity beacon) {
        if (beacon.updatedPowerState) {
            double range = rangePerLevel[beacon.l()];
            for (Object o : beacon.k.h) {
                double deltaZ;
                sq player = (sq)o;
                double deltaX = Math.abs((double)beacon.l - player.u);
                if (!(deltaX <= range) || !((deltaZ = Math.abs((double)beacon.n - player.w)) <= range) || player.M) continue;
                player.d(new ml(effectID, 180, effectLevel, true));
            }
        }
    }

    protected void updateGlobalMagneticFieldListForStateChange(int newPowerLevel, int oldPowerLevel, BeaconTileEntity beacon) {
        if (newPowerLevel <= 0) {
            beacon.k.getMagneticPointList().removePointAt(beacon.l, beacon.m, beacon.n);
        } else if (oldPowerLevel <= 0) {
            beacon.k.getMagneticPointList().addPoint(beacon.l, beacon.m, beacon.n, this.getMagneticFieldLevel(newPowerLevel));
        } else if (oldPowerLevel != newPowerLevel) {
            beacon.k.getMagneticPointList().changePowerLevelOfPointAt(beacon.l, beacon.m, beacon.n, this.getMagneticFieldLevel(newPowerLevel));
        }
    }

    protected int getMagneticFieldLevel(int powerLevel) {
        return powerLevel;
    }
}

