/*
 * Decompiled with CFR 0.152.
 */
package btw.block.tileentity.beacon;

import btw.block.tileentity.beacon.BeaconEffect;
import btw.block.tileentity.beacon.BeaconTileEntity;

public class AmbientBeaconEffect
extends BeaconEffect {
    public final String EFFECT_NAME;

    public AmbientBeaconEffect(String effectName) {
        this.EFFECT_NAME = effectName;
    }

    @Override
    public void onUpdate(BeaconTileEntity beacon) {
    }

    @Override
    public void onPowerChange(int newPowerLevel, int oldPowerLevel, BeaconTileEntity beacon) {
        super.onPowerChange(newPowerLevel, oldPowerLevel, beacon);
        if (!beacon.k.I) {
            this.updateAmbientBeaconListForStateChange(newPowerLevel, oldPowerLevel, beacon);
        }
    }

    protected void updateAmbientBeaconListForStateChange(int newPowerLevel, int oldPowerLevel, BeaconTileEntity beacon) {
        if (newPowerLevel <= 0) {
            beacon.k.getAmbientBeaconLocationList().removePointAt(beacon.l, beacon.m, beacon.n);
        } else if (oldPowerLevel <= 0) {
            beacon.k.getAmbientBeaconLocationList().addPoint(beacon.l, beacon.m, beacon.n, newPowerLevel, (int)rangePerLevel[newPowerLevel], this.EFFECT_NAME);
        } else if (oldPowerLevel != newPowerLevel) {
            beacon.k.getAmbientBeaconLocationList().changeEffectLevelOfPointAt(beacon.l, beacon.m, beacon.n, newPowerLevel, (int)rangePerLevel[newPowerLevel]);
        }
    }
}

