/*
 * Decompiled with CFR 0.152.
 */
package btw.block.tileentity;

import btw.block.blocks.FireBlock;
import btw.block.blocks.FurnaceBlock;
import btw.block.tileentity.TileEntityDataPacketHandler;
import btw.item.util.ItemUtils;
import btw.world.util.BlockPos;

public class OvenTileEntity
extends aqg
implements TileEntityDataPacketHandler {
    private static final float CHANCE_OF_FIRE_SPREAD = 0.01f;
    private boolean lightOnNextUpdate = false;
    private wm cookStack = null;
    private int unlitFuelBurnTime = 0;
    private int visualFuelLevel = 0;
    private final int brickBurnTimeMultiplier = 4;
    private final int cookTimeMultiplier = 4;
    private final int maxFuelBurnTime = 14200;
    private final int visualFuelLevelIncrement = 1600;
    private final int visualSputterFuelLevel = 400;

    @Override
    public void h() {
        boolean bWasBurning = this.a > 0;
        boolean bInventoryChanged = false;
        if (this.a > 0) {
            --this.a;
        }
        if (!this.k.I) {
            if (bWasBurning || this.lightOnNextUpdate) {
                this.a += this.unlitFuelBurnTime;
                this.unlitFuelBurnTime = 0;
                this.lightOnNextUpdate = false;
            }
            if (this.j() && this.u()) {
                ++this.c;
                if (this.c >= this.getCookTimeForCurrentItem()) {
                    this.c = 0;
                    this.l();
                    bInventoryChanged = true;
                }
            } else {
                this.c = 0;
            }
            if (this.j() && this.k.s.nextFloat() <= 0.01f) {
                BlockPos frontPos = new BlockPos(this.l, this.m, this.n);
                int iFacing = this.k.h(this.l, this.m, this.n) & 7;
                frontPos.addFacingAsOffset(iFacing);
                FireBlock.checkForFireSpreadAndDestructionToOneBlockLocation(this.k, frontPos.x, frontPos.y, frontPos.z);
            }
            FurnaceBlock furnaceBlock = (FurnaceBlock)((Object)apa.r[this.k.a(this.l, this.m, this.n)]);
            if (bWasBurning != this.j()) {
                bInventoryChanged = true;
                furnaceBlock.updateFurnaceBlockState(this.a > 0, this.k, this.l, this.m, this.n, false);
            }
            this.updateCookStack();
            this.updateVisualFuelLevel();
        }
        if (bInventoryChanged) {
            this.k_();
        }
    }

    @Override
    public String b() {
        return "container.fcFurnaceBrick";
    }

    @Override
    public void a(bs tag) {
        super.a(tag);
        if (tag.b("fcUnlitFuel")) {
            this.unlitFuelBurnTime = tag.e("fcUnlitFuel");
        }
        if (tag.b("fcVisualFuel")) {
            this.visualFuelLevel = tag.c("fcVisualFuel");
        }
    }

    @Override
    public void b(bs tag) {
        super.b(tag);
        tag.a("fcUnlitFuel", this.unlitFuelBurnTime);
        tag.a("fcVisualFuel", (byte)this.visualFuelLevel);
    }

    @Override
    public int a(wm stack) {
        return super.a(stack) * 4;
    }

    @Override
    protected int getCookTimeForCurrentItem() {
        return super.getCookTimeForCurrentItem() * 4;
    }

    @Override
    public ei m() {
        bs tag = new bs();
        if (this.cookStack != null) {
            bs cookTag = new bs();
            this.cookStack.b(cookTag);
            tag.a("x", cookTag);
        }
        tag.a("y", (byte)this.visualFuelLevel);
        return new fn(this.l, this.m, this.n, 1, tag);
    }

    @Override
    public void readNBTFromPacket(bs tag) {
        bs cookTag = tag.l("x");
        if (cookTag != null) {
            this.cookStack = wm.a(cookTag);
        }
        this.visualFuelLevel = tag.c("y");
        this.k.g(this.l, this.m, this.n, this.l, this.m, this.n);
    }

    public boolean attemptToLight() {
        if (this.unlitFuelBurnTime > 0) {
            this.lightOnNextUpdate = true;
            return true;
        }
        return false;
    }

    public boolean hasValidFuel() {
        return this.unlitFuelBurnTime > 0;
    }

    private void updateCookStack() {
        wm newCookStack = this.g[0];
        if (newCookStack == null && (newCookStack = this.g[2]) == null) {
            newCookStack = this.g[1];
        }
        if (!wm.b(newCookStack, this.cookStack)) {
            this.setCookStack(newCookStack);
        }
    }

    public void setCookStack(wm stack) {
        this.cookStack = stack != null ? stack.m() : null;
        this.k.j(this.l, this.m, this.n);
    }

    public wm getCookStack() {
        return this.cookStack;
    }

    public void givePlayerCookStack(sq player, int iFacing) {
        if (!this.k.I) {
            this.ejectAllNotCookStacksToFacing(player, iFacing);
        }
        ItemUtils.givePlayerStackOrEjectFromTowardsFacing(player, this.cookStack, this.l, this.m, this.n, iFacing);
        this.g[0] = null;
        this.g[1] = null;
        this.g[2] = null;
        this.setCookStack(null);
    }

    private void ejectAllNotCookStacksToFacing(sq player, int iFacing) {
        if (this.g[0] != null && !wm.b(this.g[0], this.cookStack)) {
            ItemUtils.ejectStackFromBlockTowardsFacing(this.k, this.l, this.m, this.n, this.g[0], iFacing);
            this.g[0] = null;
        }
        if (this.g[1] != null && !wm.b(this.g[1], this.cookStack)) {
            ItemUtils.ejectStackFromBlockTowardsFacing(this.k, this.l, this.m, this.n, this.g[1], iFacing);
            this.g[1] = null;
        }
        if (this.g[2] != null && !wm.b(this.g[2], this.cookStack)) {
            ItemUtils.ejectStackFromBlockTowardsFacing(this.k, this.l, this.m, this.n, this.g[2], iFacing);
            this.g[2] = null;
        }
        this.k_();
    }

    public void addCookStack(wm stack) {
        this.g[0] = stack;
        this.k_();
    }

    public int attemptToAddFuel(wm stack) {
        int iTotalBurnTime = this.unlitFuelBurnTime + this.a;
        int iDeltaBurnTime = 14200 - iTotalBurnTime;
        int iNumItemsBurned = 0;
        if (iDeltaBurnTime > 0) {
            iNumItemsBurned = iDeltaBurnTime / this.a(stack);
            if (iNumItemsBurned == 0 && this.getVisualFuelLevel() <= 2) {
                iNumItemsBurned = 1;
            }
            if (iNumItemsBurned > 0) {
                if (iNumItemsBurned > stack.a) {
                    iNumItemsBurned = stack.a;
                }
                this.unlitFuelBurnTime += this.a(stack) * iNumItemsBurned;
                this.k_();
            }
        }
        return iNumItemsBurned;
    }

    private void updateVisualFuelLevel() {
        int iTotalBurnTime = this.unlitFuelBurnTime + this.a;
        int iNewFuelLevel = 0;
        if (iTotalBurnTime > 0) {
            iNewFuelLevel = iTotalBurnTime < 400 ? 1 : iTotalBurnTime / 1600 + 2;
        }
        this.setVisualFuelLevel(iNewFuelLevel);
    }

    public int getVisualFuelLevel() {
        return this.visualFuelLevel;
    }

    public void setVisualFuelLevel(int iLevel) {
        if (this.visualFuelLevel != iLevel) {
            this.visualFuelLevel = iLevel;
            this.k.j(this.l, this.m, this.n);
        }
    }
}

