/*
 * Decompiled with CFR 0.152.
 */
package btw.block.tileentity;

import btw.block.BTWBlocks;
import btw.block.blocks.CookingVesselBlock;
import btw.block.tileentity.TileEntityDataPacketHandler;
import btw.crafting.manager.BulkCraftingManager;
import btw.inventory.util.InventoryUtils;
import btw.item.BTWItems;
import btw.item.util.ItemUtils;
import btw.util.MiscUtils;
import btw.world.util.BlockPos;
import btw.world.util.WorldUtils;
import java.util.List;

public abstract class CookingVesselTileEntity
extends aqp
implements lt,
TileEntityDataPacketHandler {
    protected static final int INVENTORY_SIZE = 27;
    private static final int STACK_SIZE_LIMIT = 64;
    private static final int PRIMARY_FIRE_FACTOR = 5;
    private static final int SECONDARY_FIRE_FACTOR = 3;
    protected static final int STACK_SIZE_TO_DROP_WHEN_TIPPED = 8;
    private static final double MAX_PLAYER_INTERACTION_DIST = 64.0;
    private static final int STOKED_TICKS_TO_COOLDOWN = 20;
    private static final int TIME_TO_COOK = 4350;
    protected wm[] contents = new wm[27];
    protected int cookCounter = 0;
    protected int stokedCooldownCounter = 0;
    protected boolean containsValidIngredientsForState = false;
    private boolean forceValidateOnUpdate = true;
    protected int fireUnderType = 0;
    public int scaledCookCounter = 0;
    public int forceFacing = -1;
    public short storageSlotsOccupied = 0;

    @Override
    public void a(bs nbttagcompound) {
        super.a(nbttagcompound);
        ca nbttaglist = nbttagcompound.m("Items");
        this.contents = new wm[this.j_()];
        for (int i2 = 0; i2 < nbttaglist.c(); ++i2) {
            bs nbttagcompound1 = (bs)nbttaglist.b(i2);
            int j2 = nbttagcompound1.c("Slot") & 0xFF;
            if (j2 < 0 || j2 >= this.contents.length) continue;
            this.contents[j2] = wm.a(nbttagcompound1);
        }
        this.fireUnderType = nbttagcompound.b("m_iFireUnderType") ? nbttagcompound.e("m_iFireUnderType") : -1;
        if (nbttagcompound.b("m_iFacing")) {
            this.forceFacing = nbttagcompound.e("m_iFacing");
        }
        this.validateInventoryStateVariables();
    }

    @Override
    public void b(bs nbttagcompound) {
        super.b(nbttagcompound);
        ca nbttaglist = new ca();
        for (int i2 = 0; i2 < this.contents.length; ++i2) {
            if (this.contents[i2] == null) continue;
            bs nbttagcompound1 = new bs();
            nbttagcompound1.a("Slot", (byte)i2);
            this.contents[i2].b(nbttagcompound1);
            nbttaglist.a((cf)nbttagcompound1);
        }
        nbttagcompound.a("Items", (cf)nbttaglist);
        nbttagcompound.a("m_bContainsValidIngrediantsForState", this.containsValidIngredientsForState);
        nbttagcompound.a("m_iFireUnderType", this.fireUnderType);
    }

    @Override
    public void h() {
        if (this.k.I) {
            return;
        }
        int iBlockID = this.k.a(this.l, this.m, this.n);
        apa block = apa.r[iBlockID];
        if (block == null || !(block instanceof CookingVesselBlock)) {
            return;
        }
        CookingVesselBlock cookingBlock = (CookingVesselBlock)((Object)block);
        if (this.forceFacing >= 0) {
            cookingBlock.setTiltFacing(this.k, this.l, this.m, this.n, this.forceFacing);
            this.forceFacing = -1;
        }
        if (this.fireUnderType == -1) {
            this.validateFireUnderType();
        }
        if (!cookingBlock.getMechanicallyPoweredFlag(this.k, this.l, this.m, this.n)) {
            if (this.fireUnderType > 0) {
                if (this.forceValidateOnUpdate) {
                    this.validateContentsForState();
                    this.forceValidateOnUpdate = false;
                }
                if (this.fireUnderType == 2) {
                    if (this.stokedCooldownCounter <= 0) {
                        this.cookCounter = 0;
                    }
                    this.stokedCooldownCounter = 20;
                    this.performStokedFireUpdate(this.getCurrentFireFactor());
                } else if (this.stokedCooldownCounter > 0) {
                    --this.stokedCooldownCounter;
                    if (this.stokedCooldownCounter <= 0) {
                        this.cookCounter = 0;
                    }
                } else {
                    this.performNormalFireUpdate(this.getCurrentFireFactor());
                }
            } else {
                this.cookCounter = 0;
            }
        } else {
            this.cookCounter = 0;
            int iTiltFacing = cookingBlock.getTiltFacing(this.k, this.l, this.m, this.n);
            this.attemptToEjectStackFromInv(iTiltFacing);
        }
        this.scaledCookCounter = this.cookCounter * 1000 / 4350;
    }

    @Override
    public ei m() {
        bs nbttagcompound = new bs();
        nbttagcompound.a("s", this.storageSlotsOccupied);
        return new fn(this.l, this.m, this.n, 1, nbttagcompound);
    }

    @Override
    public void readNBTFromPacket(bs nbttagcompound) {
        this.storageSlotsOccupied = nbttagcompound.d("s");
        this.k.g(this.l, this.m, this.n, this.l, this.m, this.n);
    }

    public int j_() {
        return 27;
    }

    public wm a(int iSlot) {
        return this.contents[iSlot];
    }

    public wm a(int iSlot, int iAmount) {
        return InventoryUtils.decreaseStackSize(this, iSlot, iAmount);
    }

    public wm b(int par1) {
        if (this.contents[par1] != null) {
            wm itemstack = this.contents[par1];
            this.contents[par1] = null;
            return itemstack;
        }
        return null;
    }

    public void a(int iSlot, wm itemstack) {
        this.contents[iSlot] = itemstack;
        if (itemstack != null && itemstack.a > this.d()) {
            itemstack.a = this.d();
        }
        this.k_();
    }

    public int d() {
        return 64;
    }

    @Override
    public void k_() {
        super.k_();
        this.forceValidateOnUpdate = true;
        if (this.k != null && this.validateInventoryStateVariables()) {
            this.k.j(this.l, this.m, this.n);
        }
    }

    public boolean a(sq entityPlayer) {
        if (this.k.r(this.l, this.m, this.n) != this) {
            return false;
        }
        int iBlockID = this.k.a(this.l, this.m, this.n);
        apa block = apa.r[iBlockID];
        if (!(block instanceof CookingVesselBlock)) {
            return false;
        }
        if (((CookingVesselBlock)((Object)block)).isOpenSideBlocked(this.k, this.l, this.m, this.n)) {
            return false;
        }
        return entityPlayer.e((double)this.l + 0.5, (double)this.m + 0.5, (double)this.n + 0.5) <= 64.0;
    }

    public void f() {
    }

    public void g() {
    }

    public abstract void validateContentsForState();

    protected abstract BulkCraftingManager getCraftingManager(int var1);

    public int getCurrentFireFactor() {
        int iFireFactor;
        block6: {
            iFireFactor = 0;
            if (this.fireUnderType <= 0) break block6;
            iFireFactor = 5;
            if (this.fireUnderType == 1) {
                int tempY = this.m - 1;
                for (int tempX = this.l - 1; tempX <= this.l + 1; ++tempX) {
                    for (int tempZ = this.n - 1; tempZ <= this.n + 1; ++tempZ) {
                        int iTempBlockID;
                        if (tempX == this.l && tempZ == this.n || (iTempBlockID = this.k.a(tempX, tempY, tempZ)) != apa.av.cz && iTempBlockID != BTWBlocks.mediumCampfire.cz && iTempBlockID != BTWBlocks.largeCampfire.cz) continue;
                        iFireFactor += 3;
                    }
                }
            } else {
                int tempY = this.m - 1;
                for (int tempX = this.l - 1; tempX <= this.l + 1; ++tempX) {
                    for (int tempZ = this.n - 1; tempZ <= this.n + 1; ++tempZ) {
                        if (tempX == this.l && tempZ == this.n || this.k.a(tempX, tempY, tempZ) != BTWBlocks.stokedFire.cz) continue;
                        iFireFactor += 3;
                    }
                }
            }
        }
        return iFireFactor;
    }

    public void validateFireUnderType() {
        if (this.k == null) {
            return;
        }
        int iNewType = 0;
        int iBlockUnderID = this.k.a(this.l, this.m - 1, this.n);
        if (iBlockUnderID == apa.av.cz || iBlockUnderID == BTWBlocks.mediumCampfire.cz || iBlockUnderID == BTWBlocks.largeCampfire.cz) {
            iNewType = 1;
        } else if (iBlockUnderID == BTWBlocks.stokedFire.cz) {
            iNewType = 2;
        }
        if (iNewType != this.fireUnderType) {
            this.fireUnderType = iNewType;
            this.validateContentsForState();
        }
    }

    private void performNormalFireUpdate(int iFireFactor) {
        if (this.containsValidIngredientsForState) {
            this.cookCounter += iFireFactor;
            if (this.cookCounter >= 4350) {
                this.attemptToCookNormal();
                this.cookCounter = 0;
            }
        } else {
            this.cookCounter = 0;
        }
    }

    private void performStokedFireUpdate(int iFireFactor) {
        if (this.containsValidIngredientsForState) {
            this.cookCounter += iFireFactor;
            if (this.cookCounter >= 4350) {
                if (this.doesContainExplosives()) {
                    this.blowUp();
                } else {
                    this.attemptToCookStoked();
                }
                this.cookCounter = 0;
            }
        } else {
            this.cookCounter = 0;
        }
    }

    protected boolean attemptToCookNormal() {
        return this.attemptToCookWithManager(this.getCraftingManager(1));
    }

    protected boolean attemptToCookStoked() {
        return this.attemptToCookWithManager(this.getCraftingManager(2));
    }

    private boolean attemptToCookWithManager(BulkCraftingManager manager) {
        if (manager != null && manager.getCraftingResult(this) != null) {
            List<wm> outputList = manager.consumeIngredientsAndReturnResult(this);
            assert (outputList != null && outputList.size() > 0);
            for (int listIndex = 0; listIndex < outputList.size(); ++listIndex) {
                wm cookedStack = outputList.get(listIndex).m();
                if (cookedStack == null || InventoryUtils.addItemStackToInventory(this, cookedStack)) continue;
                ItemUtils.ejectStackWithRandomOffset(this.k, this.l, this.m + 1, this.n, cookedStack);
            }
            return true;
        }
        return false;
    }

    public int getCookProgressScaled(int iScale) {
        return this.scaledCookCounter * iScale / 1000;
    }

    public boolean isCooking() {
        return this.scaledCookCounter > 0;
    }

    protected boolean doesContainExplosives() {
        return InventoryUtils.getFirstOccupiedStackOfItem(this, BTWItems.hellfireDust.cp) >= 0 || InventoryUtils.getFirstOccupiedStackOfItem(this, apa.aq.cz) >= 0 || InventoryUtils.getFirstOccupiedStackOfItem(this, wk.N.cp) >= 0 || InventoryUtils.getFirstOccupiedStackOfItem(this, BTWItems.blastingOil.cp) >= 0;
    }

    private void blowUp() {
        int iHellfireCount = InventoryUtils.countItemsInInventory(this, BTWItems.hellfireDust.cp, -1);
        float fExplosionSize = (float)iHellfireCount * 10.0f / 64.0f;
        fExplosionSize += (float)InventoryUtils.countItemsInInventory(this, wk.N.cp, -1) * 10.0f / 64.0f;
        fExplosionSize += (float)InventoryUtils.countItemsInInventory(this, BTWItems.blastingOil.cp, -1) * 10.0f / 64.0f;
        int iTNTCount = InventoryUtils.countItemsInInventory(this, apa.aq.cz, -1);
        if (iTNTCount > 0) {
            if (fExplosionSize < 4.0f) {
                fExplosionSize = 4.0f;
            }
            fExplosionSize += (float)InventoryUtils.countItemsInInventory(this, apa.aq.cz, -1);
        }
        if (fExplosionSize < 2.0f) {
            fExplosionSize = 2.0f;
        } else if (fExplosionSize > 10.0f) {
            fExplosionSize = 10.0f;
        }
        InventoryUtils.clearInventoryContents(this);
        this.k.setBlockWithNotify(this.l, this.m, this.n, 0);
        this.k.a(null, (double)this.l, (double)this.m, (double)this.n, fExplosionSize, true);
    }

    private void attemptToEjectStackFromInv(int iTiltFacing) {
        int iStackIndex = InventoryUtils.getFirstOccupiedStackNotOfItem(this, wk.aI.cp);
        if (iStackIndex >= 0 && iStackIndex < this.j_()) {
            wm invStack = this.a(iStackIndex);
            int iEjectStackSize = 8 > invStack.a ? invStack.a : 8;
            wm ejectStack = new wm(invStack.c, iEjectStackSize, invStack.k());
            InventoryUtils.copyEnchantments(ejectStack, invStack);
            BlockPos targetPos = new BlockPos(this.l, this.m, this.n);
            targetPos.addFacingAsOffset(iTiltFacing);
            boolean bEjectIntoWorld = false;
            if (this.k.c(targetPos.x, targetPos.y, targetPos.z)) {
                bEjectIntoWorld = true;
            } else if (WorldUtils.isReplaceableBlock(this.k, targetPos.x, targetPos.y, targetPos.z)) {
                bEjectIntoWorld = true;
            } else {
                int iTargetBlockID = this.k.a(targetPos.x, targetPos.y, targetPos.z);
                apa targetBlock = apa.r[iTargetBlockID];
                if (!targetBlock.cO.a()) {
                    bEjectIntoWorld = true;
                }
            }
            if (bEjectIntoWorld) {
                this.ejectStack(ejectStack, iTiltFacing);
                this.a(iStackIndex, iEjectStackSize);
            }
        }
    }

    private void ejectStack(wm stack, int iFacing) {
        arc itemPos = MiscUtils.convertBlockFacingToVector(iFacing);
        itemPos.c *= 0.5;
        itemPos.d *= 0.5;
        itemPos.e *= 0.5;
        itemPos.c += (double)((float)this.l + 0.5f);
        itemPos.d += (double)((float)this.m + 0.25f);
        itemPos.e += (double)((float)this.n + 0.5f);
        rh entityItem = (rh)mv.createEntityOfType(rh.class, this.k, itemPos.c, itemPos.d, itemPos.e, stack);
        arc itemVel = MiscUtils.convertBlockFacingToVector(iFacing);
        itemVel.c *= (double)0.1f;
        itemVel.d *= (double)0.1f;
        itemVel.e *= (double)0.1f;
        entityItem.x = itemVel.c;
        entityItem.y = itemVel.d;
        entityItem.z = itemVel.e;
        entityItem.b = 10;
        this.k.d(entityItem);
    }

    private boolean validateInventoryStateVariables() {
        boolean bStateChanged = false;
        short currentSlotsOccupied = (short)InventoryUtils.getNumOccupiedStacks(this);
        if (currentSlotsOccupied != this.storageSlotsOccupied) {
            this.storageSlotsOccupied = currentSlotsOccupied;
            bStateChanged = true;
        }
        return bStateChanged;
    }
}

