/*
 * Decompiled with CFR 0.152.
 */
package btw.block.tileentity;

import btw.block.BTWBlocks;
import btw.block.blocks.CampfireBlock;
import btw.block.blocks.FireBlock;
import btw.block.tileentity.TileEntityDataPacketHandler;
import btw.crafting.manager.CampfireCraftingManager;
import btw.item.BTWItems;
import btw.item.util.ItemUtils;

public class CampfireTileEntity
extends aqp
implements TileEntityDataPacketHandler {
    private static final int CAMPFIRE_BURN_TIME_MULTIPLIER = 8;
    private static final int TIME_TO_COOK = 4800;
    private static final int MAX_BURN_TIME = 6000;
    private static final int INITIAL_BURN_TIME = 3200;
    private static final int WARMUP_TIME = 200;
    private static final int REVERT_TO_SMALL_TIME = 400;
    private static final int BLAZE_TIME = 4800;
    private static final int SMOULDER_TIME = 6000;
    private static final int TIME_TO_BURN_FOOD = 2400;
    private static final float CHANCE_OF_FIRE_SPREAD = 0.05f;
    private static final float CHANCE_OF_GOING_OUT_FROM_RAIN = 0.01f;
    private wm spitStack = null;
    private wm cookStack = null;
    private int burnTimeCountdown = 0;
    private int burnTimeSinceLit = 0;
    private int cookCounter = 0;
    private int smoulderCounter = 0;
    private int cookBurningCounter = 0;

    @Override
    public void a(bs tag) {
        bs cookTag;
        super.a(tag);
        bs spitTag = tag.l("fcSpitStack");
        if (spitTag != null) {
            this.spitStack = wm.a(spitTag);
        }
        if ((cookTag = tag.l("fcCookStack")) != null) {
            this.cookStack = wm.a(cookTag);
        }
        if (tag.b("fcBurnCounter")) {
            this.burnTimeCountdown = tag.e("fcBurnCounter");
        }
        if (tag.b("fcBurnTime")) {
            this.burnTimeSinceLit = tag.e("fcBurnTime");
        }
        if (tag.b("fcCookCounter")) {
            this.cookCounter = tag.e("fcCookCounter");
        }
        if (tag.b("fcSmoulderCounter")) {
            this.smoulderCounter = tag.e("fcSmoulderCounter");
        }
        if (tag.b("fcCookBurning")) {
            this.cookBurningCounter = tag.e("fcCookBurning");
        }
    }

    @Override
    public void b(bs tag) {
        super.b(tag);
        if (this.spitStack != null) {
            bs spitTag = new bs();
            this.spitStack.b(spitTag);
            tag.a("fcSpitStack", spitTag);
        }
        if (this.cookStack != null) {
            bs cookTag = new bs();
            this.cookStack.b(cookTag);
            tag.a("fcCookStack", cookTag);
        }
        tag.a("fcBurnCounter", this.burnTimeCountdown);
        tag.a("fcBurnTime", this.burnTimeSinceLit);
        tag.a("fcCookCounter", this.cookCounter);
        tag.a("fcSmoulderCounter", this.smoulderCounter);
        tag.a("fcCookBurning", this.cookBurningCounter);
    }

    @Override
    public void h() {
        super.h();
        if (!this.k.I) {
            int iCurrentFireLevel = this.getCurrentFireLevel();
            if (iCurrentFireLevel > 0) {
                if (iCurrentFireLevel > 1 && this.k.s.nextFloat() <= 0.05f) {
                    FireBlock.checkForFireSpreadFromLocation(this.k, this.l, this.m, this.n, this.k.s, 0);
                }
                ++this.burnTimeSinceLit;
                if (this.burnTimeCountdown > 0) {
                    --this.burnTimeCountdown;
                    if (iCurrentFireLevel == 3) {
                        --this.burnTimeCountdown;
                    }
                }
                if ((iCurrentFireLevel = this.validateFireLevel()) > 0) {
                    this.updateCookState();
                    if (this.k.s.nextFloat() <= 0.01f && this.isRainingOnCampfire()) {
                        this.extinguishFire(false);
                    }
                }
            } else if (this.smoulderCounter > 0) {
                --this.smoulderCounter;
                if (this.smoulderCounter == 0 || this.k.s.nextFloat() <= 0.01f && this.isRainingOnCampfire()) {
                    this.stopSmouldering();
                }
            }
        }
    }

    @Override
    public ei m() {
        bs tag = new bs();
        if (this.cookStack != null) {
            bs cookTag = new bs();
            this.cookStack.b(cookTag);
            tag.a("x", cookTag);
        }
        if (this.spitStack != null) {
            bs spitTag = new bs();
            this.spitStack.b(spitTag);
            tag.a("y", spitTag);
        }
        return new fn(this.l, this.m, this.n, 1, tag);
    }

    @Override
    public void readNBTFromPacket(bs tag) {
        bs spitTag;
        bs cookTag = tag.l("x");
        if (cookTag != null) {
            this.cookStack = wm.a(cookTag);
        }
        if ((spitTag = tag.l("y")) != null) {
            this.spitStack = wm.a(spitTag);
        }
        this.k.g(this.l, this.m, this.n, this.l, this.m, this.n);
    }

    public void setSpitStack(wm stack) {
        if (stack != null) {
            this.spitStack = stack.m();
            this.spitStack.a = 1;
        } else {
            this.spitStack = null;
        }
        this.k.j(this.l, this.m, this.n);
    }

    public wm getSpitStack() {
        return this.spitStack;
    }

    public void setCookStack(wm stack) {
        if (stack != null) {
            this.cookStack = stack.m();
            this.cookStack.a = 1;
        } else {
            this.cookStack = null;
            this.cookBurningCounter = 0;
        }
        this.cookCounter = 0;
        this.k.j(this.l, this.m, this.n);
    }

    public wm getCookStack() {
        return this.cookStack;
    }

    public void ejectContents() {
        if (this.spitStack != null) {
            ItemUtils.ejectStackWithRandomOffset(this.k, this.l, this.m, this.n, this.spitStack);
            this.spitStack = null;
        }
        if (this.cookStack != null) {
            ItemUtils.ejectStackWithRandomOffset(this.k, this.l, this.m, this.n, this.cookStack);
            this.cookStack = null;
        }
    }

    public void addBurnTime(int iBurnTime) {
        this.burnTimeCountdown += iBurnTime * 8 * 2;
        if (this.burnTimeCountdown > 6000) {
            this.burnTimeCountdown = 6000;
        }
        this.validateFireLevel();
    }

    public void onFirstLit() {
        this.burnTimeCountdown = 3200;
        this.burnTimeSinceLit = 0;
    }

    public int validateFireLevel() {
        int iCurrentFireLevel = this.getCurrentFireLevel();
        if (iCurrentFireLevel > 0) {
            if (this.burnTimeCountdown <= 0) {
                this.extinguishFire(true);
                return 0;
            }
            int iDesiredFireLevel = 2;
            if (this.burnTimeSinceLit < 200 || this.burnTimeCountdown < 400) {
                iDesiredFireLevel = 1;
            } else if (this.burnTimeCountdown > 4800) {
                iDesiredFireLevel = 3;
            }
            if (iDesiredFireLevel != iCurrentFireLevel) {
                this.changeFireLevel(iDesiredFireLevel);
                if (iDesiredFireLevel == 1 && iCurrentFireLevel == 2) {
                    this.k.e(2227, this.l, this.m, this.n, 1);
                }
                return iDesiredFireLevel;
            }
        } else if (this.burnTimeCountdown > 0 && BTWBlocks.unlitCampfire.getFuelState(this.k, this.l, this.m, this.n) == 2) {
            this.relightSmouldering();
            return 1;
        }
        return iCurrentFireLevel;
    }

    private void extinguishFire(boolean bSmoulder) {
        this.smoulderCounter = bSmoulder ? 6000 : 0;
        this.cookCounter = 0;
        this.cookBurningCounter = 0;
        CampfireBlock block = (CampfireBlock)((Object)apa.r[this.k.a(this.l, this.m, this.n)]);
        block.extinguishFire(this.k, this.l, this.m, this.n, bSmoulder);
    }

    private void changeFireLevel(int iNewLevel) {
        CampfireBlock block = (CampfireBlock)((Object)apa.r[this.k.a(this.l, this.m, this.n)]);
        block.changeFireLevel(this.k, this.l, this.m, this.n, iNewLevel, this.k.h(this.l, this.m, this.n));
    }

    private int getCurrentFireLevel() {
        CampfireBlock block = (CampfireBlock)((Object)apa.r[this.k.a(this.l, this.m, this.n)]);
        return block.fireLevel;
    }

    private void updateCookState() {
        int iFireLevel;
        if (this.cookStack != null && (iFireLevel = this.getCurrentFireLevel()) >= 2) {
            wm cookResult = CampfireCraftingManager.instance.getRecipeResult(this.cookStack.b().cp);
            if (cookResult != null) {
                ++this.cookCounter;
                if (this.cookCounter >= 4800) {
                    this.setCookStack(cookResult);
                    this.cookCounter = 0;
                }
            }
            if (iFireLevel >= 3 && this.cookStack.c != BTWItems.burnedMeat.cp) {
                ++this.cookBurningCounter;
                if (this.cookBurningCounter >= 2400) {
                    this.setCookStack(new wm(BTWItems.burnedMeat));
                    this.cookCounter = 0;
                    this.cookBurningCounter = 0;
                }
            }
        }
    }

    public boolean getIsCooking() {
        wm cookResult;
        return this.cookStack != null && this.getCurrentFireLevel() >= 2 && (cookResult = CampfireCraftingManager.instance.getRecipeResult(this.cookStack.b().cp)) != null;
    }

    public boolean getIsFoodBurning() {
        return this.cookStack != null && this.getCurrentFireLevel() >= 3 && this.cookStack.c != BTWItems.burnedMeat.cp;
    }

    public boolean isRainingOnCampfire() {
        CampfireBlock block = (CampfireBlock)((Object)apa.r[this.k.a(this.l, this.m, this.n)]);
        return block.isRainingOnCampfire(this.k, this.l, this.m, this.n);
    }

    private void stopSmouldering() {
        this.smoulderCounter = 0;
        CampfireBlock block = (CampfireBlock)((Object)apa.r[this.k.a(this.l, this.m, this.n)]);
        block.stopSmouldering(this.k, this.l, this.m, this.n);
    }

    private void relightSmouldering() {
        this.burnTimeSinceLit = 0;
        CampfireBlock block = (CampfireBlock)((Object)apa.r[this.k.a(this.l, this.m, this.n)]);
        block.relightFire(this.k, this.l, this.m, this.n);
    }
}

