/*
 * Decompiled with CFR 0.152.
 */
package btw.block.tileentity;

import btw.block.blocks.ArcaneVesselBlock;
import btw.block.tileentity.TileEntityDataPacketHandler;
import btw.util.MiscUtils;
import btw.world.util.BlockPos;
import btw.world.util.WorldUtils;

public class ArcaneVesselTileEntity
extends aqp
implements TileEntityDataPacketHandler {
    public static final int MAX_CONTAINED_EXPERIENCE = 1000;
    private static final int MIN_TEMPLE_EXPERIENCE = 200;
    private static final int MAX_TEMPLE_EXPERIENCE = 256;
    public static final int MAX_VISUAL_EXPERIENCE_LEVEL = 10;
    private final int xpEjectUnitSize = 20;
    private int visualExperienceLevel = 0;
    private int containedRegularExperience = 0;
    private int containedDragonExperience = 0;

    @Override
    public void b(bs nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("regXP", this.containedRegularExperience);
        nbttagcompound.a("dragXP", this.containedDragonExperience);
    }

    @Override
    public void a(bs nbttagcompound) {
        super.a(nbttagcompound);
        this.containedRegularExperience = nbttagcompound.e("regXP");
        this.containedDragonExperience = nbttagcompound.e("dragXP");
        int iTotalExperience = this.containedRegularExperience + this.containedDragonExperience;
        this.visualExperienceLevel = (int)(10.0f * ((float)iTotalExperience / 1000.0f));
        if (iTotalExperience > 0 && this.visualExperienceLevel == 0) {
            this.visualExperienceLevel = 1;
        }
    }

    @Override
    public ei m() {
        bs nbttagcompound = new bs();
        nbttagcompound.a("x", (byte)this.visualExperienceLevel);
        return new fn(this.l, this.m, this.n, 1, nbttagcompound);
    }

    @Override
    public void h() {
        if (this.k.I) {
            return;
        }
        int iBlockID = this.k.a(this.l, this.m, this.n);
        apa block = apa.r[iBlockID];
        if (block == null || !(block instanceof ArcaneVesselBlock)) {
            return;
        }
        ArcaneVesselBlock vesselBlock = (ArcaneVesselBlock)((Object)block);
        if (vesselBlock.getMechanicallyPoweredFlag(this.k, this.l, this.m, this.n)) {
            int iTiltFacing = vesselBlock.getTiltFacing(this.k, this.l, this.m, this.n);
            this.attemptToSpillXPFromInv(iTiltFacing);
        }
    }

    @Override
    public void readNBTFromPacket(bs nbttagcompound) {
        this.visualExperienceLevel = nbttagcompound.c("x");
        this.k.g(this.l, this.m, this.n, this.l, this.m, this.n);
    }

    public int getVisualExperienceLevel() {
        return this.visualExperienceLevel;
    }

    public int getContainedRegularExperience() {
        return this.containedRegularExperience;
    }

    public void setContainedRegularExperience(int iExperience) {
        this.containedRegularExperience = iExperience;
        this.validateVisualExperience();
    }

    public int getContainedDragonExperience() {
        return this.containedDragonExperience;
    }

    public void setContainedDragonExperience(int iExperience) {
        this.containedDragonExperience = iExperience;
        this.validateVisualExperience();
    }

    public int getContainedTotalExperience() {
        return this.containedDragonExperience + this.containedRegularExperience;
    }

    public void validateVisualExperience() {
        int iTotalExperience = this.containedRegularExperience + this.containedDragonExperience;
        int iNewVisualExperience = (int)(10.0f * ((float)iTotalExperience / 1000.0f));
        if (iTotalExperience > 0 && iNewVisualExperience == 0) {
            iNewVisualExperience = 1;
        }
        if (iNewVisualExperience != this.visualExperienceLevel) {
            this.visualExperienceLevel = iNewVisualExperience;
            this.k.j(this.l, this.m, this.n);
        }
    }

    public void initTempleExperience() {
        this.setContainedRegularExperience(this.k.s.nextInt(56) + 200);
    }

    public boolean attemptToSwallowXPOrb(aab world, int i2, int j2, int k, nc entityXPOrb) {
        int iTotalContainedXP = this.containedRegularExperience + this.containedDragonExperience;
        int iRemainingSpace = 1000 - iTotalContainedXP;
        if (iRemainingSpace > 0) {
            int iXPToAddToInventory = 0;
            boolean bIsDragonOrb = entityXPOrb.notPlayerOwned;
            if (entityXPOrb.e <= iRemainingSpace) {
                iXPToAddToInventory = entityXPOrb.e;
                entityXPOrb.w();
            } else {
                iXPToAddToInventory = iRemainingSpace;
            }
            if (bIsDragonOrb) {
                this.setContainedDragonExperience(this.containedDragonExperience + iXPToAddToInventory);
            } else {
                this.setContainedRegularExperience(this.containedRegularExperience + iXPToAddToInventory);
            }
            return true;
        }
        return false;
    }

    private void attemptToSpillXPFromInv(int iTiltFacing) {
        int iXPToSpill = 0;
        boolean bSpillDragonOrb = false;
        if (this.containedDragonExperience > 0 || this.containedRegularExperience > 0 && !this.isTiltedOutputBlocked(iTiltFacing)) {
            if (this.containedDragonExperience > 0) {
                bSpillDragonOrb = true;
                iXPToSpill = this.containedDragonExperience < 20 ? this.containedDragonExperience : 20;
                this.setContainedDragonExperience(this.containedDragonExperience - iXPToSpill);
            } else {
                iXPToSpill = this.containedRegularExperience < 20 ? this.containedRegularExperience : 20;
                this.setContainedRegularExperience(this.containedRegularExperience - iXPToSpill);
            }
        }
        if (iXPToSpill > 0) {
            this.spillXPOrb(iXPToSpill, bSpillDragonOrb, iTiltFacing);
        }
    }

    private boolean isTiltedOutputBlocked(int iTiltFacing) {
        BlockPos targetPos = new BlockPos(this.l, this.m, this.n);
        targetPos.addFacingAsOffset(iTiltFacing);
        if (!this.k.c(targetPos.x, targetPos.y, targetPos.z) && !WorldUtils.isReplaceableBlock(this.k, targetPos.x, targetPos.y, targetPos.z)) {
            int iTargetBlockID = this.k.a(targetPos.x, targetPos.y, targetPos.z);
            apa targetBlock = apa.r[iTargetBlockID];
            if (targetBlock.cO.a()) {
                return true;
            }
        }
        return false;
    }

    public void ejectContentsOnBlockBreak() {
        int iEjectSize;
        while (this.containedRegularExperience > 0) {
            iEjectSize = 20;
            if (this.containedRegularExperience < 20) {
                iEjectSize = this.containedRegularExperience;
            }
            this.ejectXPOrbOnBlockBreak(iEjectSize, false);
            this.containedRegularExperience -= iEjectSize;
        }
        while (this.containedDragonExperience > 0) {
            iEjectSize = 20;
            if (this.containedDragonExperience < 20) {
                iEjectSize = this.containedDragonExperience;
            }
            this.ejectXPOrbOnBlockBreak(iEjectSize, true);
            this.containedDragonExperience -= iEjectSize;
        }
    }

    private void spillXPOrb(int iXPValue, boolean bDragonOrb, int iFacing) {
        arc itemPos = MiscUtils.convertBlockFacingToVector(iFacing);
        itemPos.c *= 0.5;
        itemPos.d *= 0.5;
        itemPos.e *= 0.5;
        itemPos.c += (double)((float)this.l + 0.5f);
        itemPos.d += (double)((float)this.m + 0.25f);
        itemPos.e += (double)((float)this.n + 0.5f + this.k.s.nextFloat() * 0.3f);
        if (itemPos.c > (double)0.1f || itemPos.c < (double)-0.1f) {
            itemPos.c += (double)(this.k.s.nextFloat() * 0.5f - 0.25f);
        } else {
            itemPos.e += (double)(this.k.s.nextFloat() * 0.5f - 0.25f);
        }
        nc xpOrb = (nc)mv.createEntityOfType(nc.class, this.k, itemPos.c, itemPos.d, itemPos.e, iXPValue, bDragonOrb);
        arc itemVel = MiscUtils.convertBlockFacingToVector(iFacing);
        itemVel.c *= (double)0.1f;
        itemVel.d *= (double)0.1f;
        itemVel.e *= (double)0.1f;
        xpOrb.x = itemVel.c;
        xpOrb.y = itemVel.d;
        xpOrb.z = itemVel.e;
        this.k.d(xpOrb);
    }

    private void ejectXPOrbOnBlockBreak(int iXPValue, boolean bDragonOrb) {
        double xOffset = this.k.s.nextDouble() * 0.7 + 0.15;
        double yOffset = this.k.s.nextDouble() * 0.7 + 0.15;
        double zOffset = this.k.s.nextDouble() * 0.7 + 0.15;
        nc xpOrb = (nc)mv.createEntityOfType(nc.class, this.k, (double)this.l + xOffset, (double)this.m + yOffset, (double)this.n + zOffset, iXPValue, bDragonOrb);
        xpOrb.x = (float)this.k.s.nextGaussian() * 0.05f;
        xpOrb.y = (float)this.k.s.nextGaussian() * 0.05f + 0.2f;
        xpOrb.z = (float)this.k.s.nextGaussian() * 0.05f;
        this.k.d(xpOrb);
    }
}

