/*
 * Decompiled with CFR 0.152.
 */
package btw.block.model;

import btw.block.model.BlockModel;

public class CampfireModel
extends BlockModel {
    private static final float LOG_THICKNESS = 0.125f;
    private static final float MINOR_BORDER_WIDTH = 0.0625f;
    private static final float MAJOR_BORDER_WIDTH = 0.0f;
    private static final float LAYER_WIDTH_OFFSET = 0.0625f;
    private static final float LAYER_LENGTH_OFFSET = 0.0625f;
    private static final int NUM_LAYERS = 4;
    public BlockModel modelInSnow;

    @Override
    protected void initModel() {
        this.modelInSnow = new BlockModel();
        for (int iTempLayer = 0; iTempLayer < 4; ++iTempLayer) {
            float fLayerMultiplier = iTempLayer;
            float fMinY = fLayerMultiplier * 0.125f;
            float fMaxY = fMinY + 0.125f;
            float fMinorOffset = 0.0f;
            float fMajorOffset = 0.0f;
            if (iTempLayer > 1) {
                fMajorOffset = 0.0625f * (fLayerMultiplier - 1.0f);
            }
            fMinorOffset = 0.0625f * fLayerMultiplier;
            float fMinorAxisMin = 0.0625f + fMinorOffset;
            float fMinorAxisMax = fMinorAxisMin + 0.125f;
            float fMajorAxisMin = 0.0f + fMajorOffset;
            float fMajorAxisMax = 1.0f - fMajorAxisMin;
            if ((iTempLayer & 1) == 0) {
                this.addBox(fMajorAxisMin, fMinY, fMinorAxisMin, fMajorAxisMax, fMaxY, fMinorAxisMax);
                this.addBox(fMajorAxisMin, fMinY, 1.0f - fMinorAxisMax, fMajorAxisMax, fMaxY, 1.0f - fMinorAxisMin);
                if (iTempLayer == 0) continue;
                this.modelInSnow.addBox(fMajorAxisMin, fMinY, fMinorAxisMin, fMajorAxisMax, fMaxY, fMinorAxisMax);
                this.modelInSnow.addBox(fMajorAxisMin, fMinY, 1.0f - fMinorAxisMax, fMajorAxisMax, fMaxY, 1.0f - fMinorAxisMin);
                continue;
            }
            this.addBox(fMinorAxisMin, fMinY, fMajorAxisMin, fMinorAxisMax, fMaxY, fMajorAxisMax);
            this.addBox(1.0f - fMinorAxisMax, fMinY, fMajorAxisMin, 1.0f - fMinorAxisMin, fMaxY, fMajorAxisMax);
            this.modelInSnow.addBox(fMinorAxisMin, fMinY, fMajorAxisMin, fMinorAxisMax, fMaxY, fMajorAxisMax);
            this.modelInSnow.addBox(1.0f - fMinorAxisMax, fMinY, fMajorAxisMin, 1.0f - fMinorAxisMin, fMaxY, fMajorAxisMax);
        }
    }
}

