/*
 * Decompiled with CFR 0.152.
 */
package btw.block.model;

import btw.block.util.RayTraceUtils;
import btw.util.PrimitiveGeometric;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class BlockModel
extends PrimitiveGeometric {
    private List<PrimitiveGeometric> primitiveList = new LinkedList<PrimitiveGeometric>();
    private int assemblyID = -1;
    private int activePrimitiveID = -1;

    public BlockModel() {
        this.initModel();
    }

    public BlockModel(int iAssemblyID) {
        this();
        this.setAssemblyID(iAssemblyID);
    }

    @Override
    public BlockModel makeTemporaryCopy() {
        BlockModel newModel = new BlockModel(this.getAssemblyID());
        this.makeTemporaryCopyOfPrimitiveList(newModel);
        return newModel;
    }

    @Override
    public void rotateAroundYToFacing(int iFacing) {
        if (iFacing > 2) {
            Iterator<PrimitiveGeometric> tempIterator = this.primitiveList.iterator();
            while (tempIterator.hasNext()) {
                tempIterator.next().rotateAroundYToFacing(iFacing);
            }
        }
    }

    @Override
    public void tiltToFacingAlongY(int iFacing) {
        if (iFacing != 1) {
            Iterator<PrimitiveGeometric> tempIterator = this.primitiveList.iterator();
            while (tempIterator.hasNext()) {
                tempIterator.next().tiltToFacingAlongY(iFacing);
            }
        }
    }

    @Override
    public void translate(double dDeltaX, double dDeltaY, double dDeltaZ) {
        Iterator<PrimitiveGeometric> tempIterator = this.primitiveList.iterator();
        while (tempIterator.hasNext()) {
            tempIterator.next().translate(dDeltaX, dDeltaY, dDeltaZ);
        }
    }

    @Override
    public void addToRayTrace(RayTraceUtils rayTrace) {
        Iterator<PrimitiveGeometric> tempIterator = this.primitiveList.iterator();
        while (tempIterator.hasNext()) {
            tempIterator.next().addToRayTrace(rayTrace);
        }
    }

    @Override
    public void addIntersectingBoxesToCollisionList(aab world, int i2, int j2, int k, aqx boxToIntersect, List collisionList) {
        Iterator<PrimitiveGeometric> tempIterator = this.primitiveList.iterator();
        while (tempIterator.hasNext()) {
            tempIterator.next().addIntersectingBoxesToCollisionList(world, i2, j2, k, boxToIntersect, collisionList);
        }
    }

    @Override
    public int getAssemblyID() {
        return this.assemblyID;
    }

    protected void initModel() {
    }

    public void makeTemporaryCopyOfPrimitiveList(BlockModel modelTo) {
        Iterator<PrimitiveGeometric> tempIterator = this.primitiveList.iterator();
        while (tempIterator.hasNext()) {
            modelTo.primitiveList.add(tempIterator.next().makeTemporaryCopy());
        }
    }

    public void addPrimitive(PrimitiveGeometric primitive) {
        this.primitiveList.add(primitive);
    }

    public void addBox(double dMinX, double dMinY, double dMinZ, double dMaxX, double dMaxY, double dMaxZ) {
        this.primitiveList.add(new aqx(dMinX, dMinY, dMinZ, dMaxX, dMaxY, dMaxZ));
    }

    public ara collisionRayTrace(aab world, int i2, int j2, int k, arc startRay, arc endRay) {
        RayTraceUtils rayTrace = new RayTraceUtils(world, i2, j2, k, startRay, endRay);
        this.addToRayTrace(rayTrace);
        return rayTrace.getFirstIntersection();
    }

    public int getActivePrimitiveID() {
        return this.activePrimitiveID;
    }

    public void setAssemblyID(int iAssemblyID) {
        this.assemblyID = iAssemblyID;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderAsBlock(bgf renderBlocks, apa block, int i2, int j2, int k) {
        for (PrimitiveGeometric tempPrimitive : this.primitiveList) {
            this.activePrimitiveID = tempPrimitive.getAssemblyID();
            tempPrimitive.renderAsBlock(renderBlocks, block, i2, j2, k);
        }
        this.activePrimitiveID = -1;
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderAsBlockWithColorMultiplier(bgf renderBlocks, apa block, int i2, int j2, int k, float fRed, float fGreen, float fBlue) {
        for (PrimitiveGeometric tempPrimitive : this.primitiveList) {
            this.activePrimitiveID = tempPrimitive.getAssemblyID();
            tempPrimitive.renderAsBlockWithColorMultiplier(renderBlocks, block, i2, j2, k, fRed, fGreen, fBlue);
        }
        this.activePrimitiveID = -1;
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderAsBlockWithTexture(bgf renderBlocks, apa block, int i2, int j2, int k, lx icon) {
        for (PrimitiveGeometric tempPrimitive : this.primitiveList) {
            this.activePrimitiveID = tempPrimitive.getAssemblyID();
            tempPrimitive.renderAsBlockWithTexture(renderBlocks, block, i2, j2, k, icon);
        }
        this.activePrimitiveID = -1;
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderAsBlockFullBrightWithTexture(bgf renderBlocks, apa block, int i2, int j2, int k, lx icon) {
        for (PrimitiveGeometric tempPrimitive : this.primitiveList) {
            this.activePrimitiveID = tempPrimitive.getAssemblyID();
            tempPrimitive.renderAsBlockFullBrightWithTexture(renderBlocks, block, i2, j2, k, icon);
        }
        this.activePrimitiveID = -1;
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderAsItemBlock(bgf renderBlocks, apa block, int iItemDamage) {
        for (PrimitiveGeometric tempPrimitive : this.primitiveList) {
            this.activePrimitiveID = tempPrimitive.getAssemblyID();
            tempPrimitive.renderAsItemBlock(renderBlocks, block, iItemDamage);
        }
        this.activePrimitiveID = -1;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderAsFallingBlock(bgf renderBlocks, apa block, int i2, int j2, int k, int iMetadata) {
        for (PrimitiveGeometric tempPrimitive : this.primitiveList) {
            this.activePrimitiveID = tempPrimitive.getAssemblyID();
            tempPrimitive.renderAsFallingBlock(renderBlocks, block, i2, j2, k, iMetadata);
        }
        this.activePrimitiveID = -1;
    }
}

