/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.LogBlock;
import btw.block.util.Flammability;
import btw.item.BTWItems;
import btw.item.items.ChiselItem;
import btw.item.util.ItemUtils;
import btw.world.util.WorldUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class WorkStumpBlock
extends apa {
    @Environment(value=EnvType.CLIENT)
    public static final String[] sideTextureNames = new String[]{"fcBlockWorkStumpOak", "fcBlockWorkStumpSpruce", "fcBlockWorkStumpBirch", "fcBlockWorkStumpJungle"};
    @Environment(value=EnvType.CLIENT)
    public static final String[] topTextureNames = new String[]{"fcBlockTrunkTop", "fcBlockTrunkTopSpruce", "fcBlockTrunkTopBirch", "fcBlockTrunkTopJungle"};
    @Environment(value=EnvType.CLIENT)
    private lx[] iconSideArray;
    @Environment(value=EnvType.CLIENT)
    private lx[] iconTopArray;

    public WorkStumpBlock(int iBlockID) {
        super(iBlockID, BTWBlocks.logMaterial);
        this.c(1.25f);
        this.setChiselsEffectiveOn();
        this.setFireProperties(Flammability.LOGS);
        this.c("fcBlockWorkStump");
    }

    @Override
    public float l(aab world, int i2, int j2, int k) {
        return super.l(world, i2, j2, k) * 3.0f;
    }

    @Override
    public boolean a(aab world, int i2, int j2, int k, sq player, int iFacing, float fClickX, float fClickY, float fClickZ) {
        int metadata;
        if (!world.I && !WorldUtils.doesBlockHaveLargeCenterHardpointToFacing(world, i2, j2 + 1, k, 0) && this.isFinishedWorkStump(metadata = world.h(i2, j2, k))) {
            player.b(i2, j2, k);
        }
        return true;
    }

    private boolean isFinishedWorkStump(int metadata) {
        return (metadata & 8) == 0;
    }

    @Override
    public boolean dropComponentItemsOnBadBreak(aab world, int i2, int j2, int k, int iMetadata, float fChanceOfDrop) {
        this.dropItemsIndividually(world, i2, j2, k, BTWItems.sawDust.cp, 6, 0, fChanceOfDrop);
        return true;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iMetadata, float fChance, int iFortuneModifier) {
        if (!world.I) {
            this.b(world, i2, j2, k, new wm(BTWItems.sawDust, 3, 0));
            this.b(world, i2, j2, k, new wm(apa.B.cz, 1, 0));
        }
    }

    @Override
    public boolean canConvertBlock(wm stack, aab world, int i2, int j2, int k) {
        return true;
    }

    @Override
    public boolean convertBlock(wm stack, aab world, int i2, int j2, int k, int iFromSide) {
        int oldMetadata = world.h(i2, j2, k);
        int chewedLogID = LogBlock.chewedLogArray[oldMetadata & 3].cz;
        if (!this.isFinishedWorkStump(oldMetadata) && this.isWorkStumpItemConversionTool(stack, world, i2, j2, k)) {
            world.e(2268, i2, j2, k, 0);
            world.setBlockMetadataWithNotify(i2, j2, k, oldMetadata & 3);
            return true;
        }
        int newMetadata = BTWBlocks.oakChewedLog.setIsStump(0);
        world.setBlockAndMetadataWithNotify(i2, j2, k, chewedLogID, newMetadata);
        if (!world.I) {
            ItemUtils.ejectStackFromBlockTowardsFacing(world, i2, j2, k, new wm(BTWItems.bark, 1, oldMetadata & 3), iFromSide);
        }
        return true;
    }

    public boolean isWorkStumpItemConversionTool(wm stack, aab world, int i2, int j2, int k) {
        if (stack != null && stack.b() instanceof ChiselItem) {
            int iToolLevel = ((ChiselItem)stack.b()).toolMaterial.d();
            return iToolLevel >= 2;
        }
        return false;
    }

    @Override
    public boolean getIsProblemToRemove(wm toolStack, aak blockAccess, int i2, int j2, int k) {
        int metadata = blockAccess.h(i2, j2, k);
        return this.isFinishedWorkStump(metadata) || !this.isWorkStumpItemConversionTool(toolStack, (aab)blockAccess, i2, j2, k);
    }

    @Override
    public boolean getDoesStumpRemoverWorkOnBlock(aak blockAccess, int i2, int j2, int k) {
        return true;
    }

    @Override
    public wm getStackRetrievedByBlockDispenser(aab world, int i2, int j2, int k) {
        return apa.N.getStackRetrievedByBlockDispenser(world, i2, j2, k);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        if (iSide > 1) {
            return this.iconSideArray[iMetadata & 3];
        }
        if (iSide == 1) {
            if (!this.isFinishedWorkStump(iMetadata)) {
                return this.iconTopArray[iMetadata & 3];
            }
            return this.cQ;
        }
        return this.iconTopArray[iMetadata & 3];
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        this.cQ = register.a("workbench_top");
        this.iconSideArray = new lx[sideTextureNames.length];
        this.iconTopArray = new lx[sideTextureNames.length];
        for (int iTextureID = 0; iTextureID < this.iconSideArray.length; ++iTextureID) {
            this.iconSideArray[iTextureID] = register.a(sideTextureNames[iTextureID]);
            this.iconTopArray[iTextureID] = register.a(topTextureNames[iTextureID]);
        }
    }
}

