/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.SidingAndCornerAndDecorativeBlock;
import btw.item.BTWItems;
import btw.item.blockitems.WoodSidingDecorativeStubBlockItem;
import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class WoodSidingAndCornerAndDecorativeBlock
extends SidingAndCornerAndDecorativeBlock {
    public WoodSidingAndCornerAndDecorativeBlock(int iBlockID, String sTextureName, String name) {
        super(iBlockID, BTWBlocks.plankMaterial, sTextureName, 2.0f, 5.0f, apa.g, name);
        this.setAxesEffectiveOn(true);
        this.setBuoyancy(1.0f);
        this.setFireProperties(5, 20);
    }

    @Override
    public int a(int iMetadata, Random random, int iFortuneModifier) {
        if (WoodSidingAndCornerAndDecorativeBlock.isDecorativeFromMetadata(iMetadata)) {
            return BTWItems.woodSidingDecorativeStubID;
        }
        if (this.getIsCorner(iMetadata)) {
            return BTWItems.woodCornerStubID;
        }
        return BTWItems.woodSidingStubID;
    }

    @Override
    public int a(int metadata) {
        return this.damageDropped(this.cz, metadata);
    }

    @Override
    public boolean doesBenchHaveLeg(aak blockAccess, int i2, int j2, int k) {
        int iBlockBelowID;
        if (this.cz == BTWBlocks.oakWoodSidingAndCorner.cz && (iBlockBelowID = blockAccess.a(i2, j2 - 1, k)) == apa.bd.cz) {
            return true;
        }
        return super.doesBenchHaveLeg(blockAccess, i2, j2, k);
    }

    @Override
    public int getHarvestToolLevel(aak blockAccess, int i2, int j2, int k) {
        return 2;
    }

    @Override
    public void onBlockDestroyedWithImproperTool(aab world, sq player, int i2, int j2, int k, int iMetadata) {
        world.e(2271, i2, j2, k, 0);
        int iNumDropped = this.getNumSawDustDroppedForType(iMetadata);
        this.dropItemsIndividually(world, i2, j2, k, BTWItems.sawDust.cp, iNumDropped, 0, 1.0f);
    }

    @Override
    public boolean a(zw explosion) {
        return false;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, zw explosion) {
        float fChanceOfPileDrop = 1.0f;
        if (explosion != null) {
            fChanceOfPileDrop = 1.0f / explosion.g;
        }
        int iNumDropped = this.getNumSawDustDroppedForType(world.h(i2, j2, k));
        this.dropItemsIndividually(world, i2, j2, k, BTWItems.sawDust.cp, iNumDropped, 0, fChanceOfPileDrop);
    }

    protected int getWoodTypeFromBlockID(int blockID) {
        int woodType = blockID == BTWBlocks.oakWoodSidingAndCorner.cz ? 0 : (blockID == BTWBlocks.spruceWoodSidingAndCorner.cz ? 1 : (blockID == BTWBlocks.birchWoodSidingAndCorner.cz ? 2 : (blockID == BTWBlocks.jungleWoodSidingAndCorner.cz ? 3 : 4)));
        return woodType;
    }

    public int getNumSawDustDroppedForType(int iMetadata) {
        if (WoodSidingAndCornerAndDecorativeBlock.isDecorativeFromMetadata(iMetadata) || !this.getIsCorner(iMetadata)) {
            return 2;
        }
        return 1;
    }

    private int damageDropped(int blockID, int metadata) {
        int woodType = this.getWoodTypeFromBlockID(blockID);
        if (WoodSidingAndCornerAndDecorativeBlock.isDecorativeFromMetadata(metadata)) {
            int blockType = metadata == 12 ? 0 : 1;
            return WoodSidingDecorativeStubBlockItem.getItemDamageForType(woodType, blockType);
        }
        return woodType;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(int iBlockID, ve creativeTabs, List list) {
        if (iBlockID == BTWBlocks.oakWoodSidingAndCorner.cz) {
            list.add(new wm(iBlockID, 1, 12));
            list.add(new wm(iBlockID, 1, 0));
            list.add(new wm(iBlockID, 1, 1));
        } else {
            super.a(iBlockID, creativeTabs, list);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int h(aab world, int x2, int y2, int z2) {
        int blockID = world.a(x2, y2, z2);
        int metadata = world.h(x2, y2, z2);
        int damageDropped = this.damageDropped(blockID, metadata);
        return damageDropped;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderBlocks, int itemDamage, float brightness) {
        int subtype = itemDamage;
        apa block = this;
        int itemType = WoodSidingDecorativeStubBlockItem.getBlockType(itemDamage);
        int woodType = WoodSidingDecorativeStubBlockItem.getWoodType(itemDamage);
        if (this.cz == BTWItems.woodSidingDecorativeStubID) {
            subtype = itemType == 0 ? 12 : 14;
            block = woodType == 0 ? BTWBlocks.oakWoodSidingAndCorner : (woodType == 1 ? BTWBlocks.spruceWoodSidingAndCorner : (woodType == 2 ? BTWBlocks.birchWoodSidingAndCorner : (woodType == 3 ? BTWBlocks.jungleWoodSidingAndCorner : BTWBlocks.bloodWoodSidingAndCorner)));
        }
        if (subtype == 12) {
            this.renderBenchInvBlock(renderBlocks, block, subtype);
        } else if (subtype == 14) {
            this.renderFenceInvBlock(renderBlocks, block, subtype);
        } else {
            super.renderBlockAsItem(renderBlocks, itemDamage, brightness);
        }
    }
}

