/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.AestheticNonOpaqueBlock;
import btw.block.blocks.MouldingAndDecorativeBlock;
import btw.client.render.util.RenderUtils;
import btw.crafting.util.FurnaceBurnTime;
import btw.item.BTWItems;
import btw.item.blockitems.WoodMouldingDecorativeStubBlockItem;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class WoodMouldingAndDecorativeBlock
extends MouldingAndDecorativeBlock {
    public static final int OAK_TABLE_TOP_TEXTURE_ID = 93;
    public static final int OAK_TABLE_LEG_TEXTURE_ID = 94;

    public WoodMouldingAndDecorativeBlock(int iBlockID, String sTextureName, String sColumnSideTextureName, int iMatchingCornerBlockID, String name) {
        super(iBlockID, BTWBlocks.plankMaterial, sTextureName, sColumnSideTextureName, iMatchingCornerBlockID, 2.0f, 5.0f, apa.g, name);
        this.setAxesEffectiveOn(true);
        this.setBuoyancy(1.0f);
        this.setFurnaceBurnTime(FurnaceBurnTime.PLANKS_OAK.burnTime / 4);
        this.setFireProperties(5, 20);
    }

    @Override
    public int a(int iMetadata, Random random, int iFortuneModifier) {
        if (this.isDecorative(iMetadata)) {
            return BTWItems.woodMouldingDecorativeStubID;
        }
        return BTWItems.woodMouldingStubID;
    }

    @Override
    public int a(int metadata) {
        return this.damageDropped(this.cz, metadata);
    }

    @Override
    public boolean doesTableHaveLeg(aak blockAccess, int i2, int j2, int k) {
        int iBlockBelowID;
        if (this.cz == BTWBlocks.oakWoodMouldingAndDecorative.cz && (iBlockBelowID = blockAccess.a(i2, j2 - 1, k)) == apa.bd.cz) {
            return true;
        }
        return super.doesTableHaveLeg(blockAccess, i2, j2, k);
    }

    @Override
    public int getHarvestToolLevel(aak blockAccess, int i2, int j2, int k) {
        return 2;
    }

    @Override
    public void onBlockDestroyedWithImproperTool(aab world, sq player, int i2, int j2, int k, int iMetadata) {
        world.e(2271, i2, j2, k, 0);
        int iNumDropped = this.getNumSawDustDroppedForType(iMetadata);
        this.dropItemsIndividually(world, i2, j2, k, BTWItems.sawDust.cp, iNumDropped, 0, 1.0f);
    }

    @Override
    public boolean a(zw explosion) {
        return false;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, zw explosion) {
        float fChanceOfPileDrop = 1.0f;
        if (explosion != null) {
            fChanceOfPileDrop = 1.0f / explosion.g;
        }
        int iNumDropped = this.getNumSawDustDroppedForType(world.h(i2, j2, k));
        this.dropItemsIndividually(world, i2, j2, k, BTWItems.sawDust.cp, iNumDropped, 0, fChanceOfPileDrop);
    }

    protected int getWoodTypeFromBlockID(int blockID) {
        int woodType = blockID == BTWBlocks.oakWoodMouldingAndDecorative.cz ? 0 : (blockID == BTWBlocks.spruceWoodMouldingAndDecorative.cz ? 1 : (blockID == BTWBlocks.birchWoodMouldingAndDecorative.cz ? 2 : (blockID == BTWBlocks.jungleWoodMouldingAndDecorative.cz ? 3 : 4)));
        return woodType;
    }

    public int getNumSawDustDroppedForType(int iMetadata) {
        if (this.isDecorative(iMetadata)) {
            return 2;
        }
        return 1;
    }

    private int damageDropped(int blockID, int metadata) {
        int woodType = this.getWoodTypeFromBlockID(blockID);
        if (!this.isDecorative(metadata)) {
            return woodType;
        }
        int iBlockType = metadata == 12 ? 0 : (metadata == 13 || metadata == 14 ? 1 : 2);
        return WoodMouldingDecorativeStubBlockItem.getItemDamageForType(woodType, iBlockType);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderBlocks, int i2, int j2, int k) {
        aak blockAccess = renderBlocks.a;
        int iMetadata = blockAccess.h(i2, j2, k);
        if (iMetadata == 15 && this.cz == BTWBlocks.oakWoodMouldingAndDecorative.cz) {
            return WoodMouldingAndDecorativeBlock.renderOakTable(renderBlocks, blockAccess, i2, j2, k, this);
        }
        return super.renderBlock(renderBlocks, i2, j2, k);
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean renderOakTable(bgf renderBlocks, aak blockAccess, int i2, int j2, int k, apa block) {
        MouldingAndDecorativeBlock tableBlock = (MouldingAndDecorativeBlock)block;
        renderBlocks.a(0.0, 0.875, 0.0, 1.0, 1.0, 1.0);
        RenderUtils.renderStandardBlockWithTexture(renderBlocks, block, i2, j2, k, ((AestheticNonOpaqueBlock)BTWBlocks.aestheticNonOpaque).iconTableWoodOakTop);
        if (tableBlock.doesTableHaveLeg(blockAccess, i2, j2, k)) {
            renderBlocks.a(0.375, 0.0, 0.375, 0.625, 0.875, 0.625);
            RenderUtils.renderStandardBlockWithTexture(renderBlocks, block, i2, j2, k, ((AestheticNonOpaqueBlock)BTWBlocks.aestheticNonOpaque).iconTableWoodOakLeg);
        }
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderBlocks, int iItemDamage, float fBrightness) {
        if (this.cz == BTWItems.woodMouldingDecorativeStubID) {
            apa block = this;
            int iItemType = WoodMouldingDecorativeStubBlockItem.getBlockType(iItemDamage);
            int iWoodType = WoodMouldingDecorativeStubBlockItem.getWoodType(iItemDamage);
            iItemDamage = iItemType == 0 ? 12 : (iItemType == 1 ? 13 : 15);
            block = iWoodType == 0 ? BTWBlocks.oakWoodMouldingAndDecorative : (iWoodType == 1 ? BTWBlocks.spruceWoodMouldingAndDecorative : (iWoodType == 2 ? BTWBlocks.birchWoodMouldingAndDecorative : (iWoodType == 3 ? BTWBlocks.jungleWoodMouldingAndDecorative : BTWBlocks.bloodWoodMouldingAndDecorative)));
            this.renderDecorativeInvBlock(renderBlocks, block, iItemDamage, fBrightness);
        } else {
            lx woodTexture;
            renderBlocks.setRenderBounds(this.getBlockBoundsFromPoolForItemRender(iItemDamage));
            switch (iItemDamage) {
                case 1: {
                    woodTexture = BTWBlocks.spruceWoodMouldingAndDecorative.cQ;
                    break;
                }
                case 2: {
                    woodTexture = BTWBlocks.birchWoodMouldingAndDecorative.cQ;
                    break;
                }
                case 3: {
                    woodTexture = BTWBlocks.jungleWoodMouldingAndDecorative.cQ;
                    break;
                }
                case 4: {
                    woodTexture = BTWBlocks.bloodWoodMouldingAndDecorative.cQ;
                    break;
                }
                default: {
                    woodTexture = BTWBlocks.oakWoodMouldingAndDecorative.cQ;
                }
            }
            RenderUtils.renderInvBlockWithTexture(renderBlocks, this, -0.5f, -0.5f, -0.5f, woodTexture);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int h(aab world, int x2, int y2, int z2) {
        int blockID = world.a(x2, y2, z2);
        int metadata = world.h(x2, y2, z2);
        int damageDropped = this.damageDropped(blockID, metadata);
        return damageDropped;
    }
}

