/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.blocks.BasketBlock;
import btw.block.model.BlockModel;
import btw.block.tileentity.WickerBasketTileEntity;
import btw.block.util.RayTraceUtils;
import btw.item.BTWItems;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class WickerBasketBlock
extends BasketBlock {
    private static final float BASKET_OPEN_HEIGHT = 0.75f;
    private static final float BASKET_HEIGHT = 0.5f;
    private static final float BASKET_RIM_WIDTH = 0.0625f;
    private static final float BASKET_WIDTH_LIP = 0.0f;
    private static final float BASKET_DEPTH_LIP = 0.0625f;
    private static final float BASKET_LID_HEIGHT = 0.125f;
    private static final float BASKET_LID_LAYER_HEIGHT = 0.0625f;
    private static final float BASKET_LID_LAYER_WIDTH_GAP = 0.0625f;
    private static final float BASKET_HANDLE_HEIGHT = 0.0625f;
    private static final float BASKET_HANDLE_WIDTH = 0.125f;
    private static final float BASKET_HANDLE_HALF_WIDTH = 0.0625f;
    private static final float BASKET_HANDLE_LENGTH = 0.25f;
    private static final float BASKET_HANDLE_HALF_LENGTH = 0.125f;
    private static final float BASKET_INTERIOR_WALL_THICKNESS = 0.0625f;
    private static final float MIND_THE_GAP = 0.001f;
    private static final double LID_OPEN_LIP_HEIGHT = 0.0625;
    private static final double LID_OPEN_LIP_Y_POS = 0.9375;
    private static final double LID_OPEN_LIP_WIDTH = 0.125;
    private static final double LID_OPEN_LIP_LENGTH = 1.0;
    private static final double LID_OPEN_LIP_HALF_LENGTH = 0.5;
    private static final double LID_OPEN_LIP_HORIZONTAL_OFFSET = 0.3125;
    public BlockModel blockModelBase;
    public BlockModel blockModelBaseOpenCollision;
    public BlockModel blockModelLid;
    public BlockModel blockModelLidFull;
    public BlockModel blockModelInterior;
    private static aqx boxCollisionLidOpenLip = new aqx(0.0, 0.9375, 0.3125, 1.0, 1.0, 0.4375);
    private static final arc lidRotationPoint = arc.a(0.5, 0.375, 0.875);
    @Environment(value=EnvType.CLIENT)
    private lx iconBaseOpenTop;
    @Environment(value=EnvType.CLIENT)
    private lx iconFront;
    @Environment(value=EnvType.CLIENT)
    private lx iconTop;
    @Environment(value=EnvType.CLIENT)
    private lx iconBottom;
    @Environment(value=EnvType.CLIENT)
    private boolean renderingBase = false;
    @Environment(value=EnvType.CLIENT)
    private boolean renderingInterior = false;

    public WickerBasketBlock(int iBlockID) {
        super(iBlockID);
        this.initBlockBounds(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
        this.initModelBase();
        this.initModelBaseOpenCollison();
        this.initModelLid();
        this.initModelLidFull();
        this.initModelInterior();
        this.c("fcBlockBasketWicker");
    }

    public aqp b(aab world) {
        return new WickerBasketTileEntity();
    }

    public boolean a(aab world, int i2, int j2, int k, sq player, int iFacing, float fXClick, float fYClick, float fZClick) {
        int iMetadata = world.h(i2, j2, k);
        if (!this.getIsOpen(iMetadata)) {
            if (!world.I) {
                this.setIsOpen(world, i2, j2, k, true);
            } else {
                player.a("step.gravel", 0.25f + world.s.nextFloat() * 0.1f, 0.5f + world.s.nextFloat() * 0.1f);
            }
            return true;
        }
        if (this.isClickingOnLid(world, i2, j2, k, iFacing, fXClick, fYClick, fZClick)) {
            WickerBasketTileEntity tileEntity = (WickerBasketTileEntity)world.r(i2, j2, k);
            if (!tileEntity.closing) {
                if (!world.I) {
                    tileEntity.startClosingServerSide();
                }
                return true;
            }
        } else {
            if (this.getHasContents(iMetadata)) {
                if (world.I) {
                    player.a("step.gravel", 0.5f + world.s.nextFloat() * 0.25f, 1.0f + world.s.nextFloat() * 0.25f);
                } else {
                    this.ejectStorageStack(world, i2, j2, k);
                }
                this.setHasContents(world, i2, j2, k, false);
                return true;
            }
            wm heldStack = player.cd();
            if (heldStack != null) {
                if (world.I) {
                    player.a("step.gravel", 0.5f + world.s.nextFloat() * 0.25f, 0.5f + world.s.nextFloat() * 0.25f);
                } else {
                    WickerBasketTileEntity tileEntity = (WickerBasketTileEntity)world.r(i2, j2, k);
                    tileEntity.setStorageStack(heldStack);
                }
                heldStack.a = 0;
                this.setHasContents(world, i2, j2, k, true);
                return true;
            }
        }
        return false;
    }

    private void ejectStorageStack(aab world, int i2, int j2, int k) {
        WickerBasketTileEntity tileEntity = (WickerBasketTileEntity)world.r(i2, j2, k);
        wm storageStack = tileEntity.getStorageStack();
        if (storageStack != null) {
            float xOffset = 0.5f;
            float yOffset = 0.4f;
            float zOffset = 0.5f;
            double xPos = (float)i2 + xOffset;
            double yPos = (float)j2 + yOffset;
            double zPos = (float)k + zOffset;
            rh entityitem = (rh)mv.createEntityOfType(rh.class, world, xPos, yPos, zPos, storageStack);
            entityitem.y = 0.2;
            double fFacingFactor = 0.15;
            double fRandomFactor = 0.05;
            int iFacing = this.getFacing(world, i2, j2, k);
            if (iFacing <= 3) {
                entityitem.x = (world.s.nextDouble() * 2.0 - 1.0) * fRandomFactor;
                entityitem.z = iFacing == 2 ? -fFacingFactor : fFacingFactor;
            } else {
                entityitem.z = (world.s.nextDouble() * 2.0 - 1.0) * fRandomFactor;
                entityitem.x = iFacing == 4 ? -fFacingFactor : fFacingFactor;
            }
            entityitem.b = 10;
            world.d(entityitem);
            tileEntity.setStorageStack(null);
        }
    }

    public aqx b(aab world, int i2, int j2, int k) {
        return this.getFixedBlockBoundsFromPool().d(i2, j2, k);
    }

    public aqx getBlockBoundsFromPoolBasedOnState(aak blockAccess, int i2, int j2, int k) {
        if (!this.getIsOpen(blockAccess, i2, j2, k)) {
            return aqx.a().a(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
        }
        return aqx.a().a(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
    }

    public ara a(aab world, int i2, int j2, int k, arc startRay, arc endRay) {
        BlockModel tempBaseModel;
        RayTraceUtils rayTrace = new RayTraceUtils(world, i2, j2, k, startRay, endRay);
        int iMetadata = world.h(i2, j2, k);
        int iFacing = this.getFacing(iMetadata);
        if (!this.getIsOpen(iMetadata)) {
            tempBaseModel = this.blockModelBase.makeTemporaryCopy();
            BlockModel tempLidModel = this.getHasContents(iMetadata) ? this.blockModelLidFull.makeTemporaryCopy() : this.blockModelLid.makeTemporaryCopy();
            tempLidModel.rotateAroundYToFacing(iFacing);
            tempLidModel.addToRayTrace(rayTrace);
        } else {
            tempBaseModel = this.blockModelBaseOpenCollision.makeTemporaryCopy();
            WickerBasketTileEntity tileEntity = (WickerBasketTileEntity)world.r(i2, j2, k);
            if (tileEntity.lidOpenRatio > 0.95f) {
                aqx tempLidBox = boxCollisionLidOpenLip.makeTemporaryCopy();
                tempLidBox.rotateAroundYToFacing(iFacing);
                rayTrace.addBoxWithLocalCoordsToIntersectionList(tempLidBox);
            }
        }
        tempBaseModel.rotateAroundYToFacing(iFacing);
        tempBaseModel.addToRayTrace(rayTrace);
        return rayTrace.getFirstIntersection();
    }

    public void onCrushedByFallingEntity(aab world, int i2, int j2, int k, rg entity) {
        if (!world.I) {
            this.dropItemsIndividually(world, i2, j2, k, BTWItems.wickerPane.cp, 1, 0, 0.75f);
        }
    }

    @Override
    public BlockModel getLidModel(int iMetadata) {
        if (this.getHasContents(iMetadata)) {
            return this.blockModelLidFull;
        }
        return this.blockModelLid;
    }

    @Override
    public arc getLidRotationPoint() {
        return lidRotationPoint;
    }

    public float mobSpawnOnVerticalOffset(aab world, int i2, int j2, int k) {
        return -0.5f;
    }

    private void initModelBase() {
        this.blockModelBase = new BlockModel();
        this.blockModelBase.addBox(0.0625, 0.0, 0.125, 0.9375, 0.375, 0.875);
    }

    private void initModelBaseOpenCollison() {
        this.blockModelBaseOpenCollision = new BlockModel();
        this.blockModelBaseOpenCollision.addBox(0.0625, 0.0, 0.125, 0.9375, 0.75, 0.875);
    }

    private void initModelLid() {
        this.blockModelLid = new BlockModel();
        this.blockModelLid.addBox(0.0, 0.375, 0.0625, 1.0, 0.4375, 0.9375);
        this.blockModelLid.addBox(0.0625, 0.4375, 0.125, 0.9375, 0.5, 0.875);
        this.blockModelLid.addBox(0.375, 0.5, 0.4375, 0.625, 0.5625, 0.5625);
    }

    private void initModelLidFull() {
        this.blockModelLidFull = new BlockModel();
        this.blockModelLidFull.addBox(0.0, 0.375, 0.0625, 1.0, 0.4375, 0.9375);
        this.blockModelLidFull.addBox(0.0625, 0.4375, 0.125, 0.9375, 0.5, 0.875);
        this.blockModelLidFull.addBox(0.125, 0.5, 0.1875, 0.875, 0.5625, 0.8125);
    }

    private void initModelInterior() {
        this.blockModelInterior = new BlockModel();
        this.blockModelInterior.addBox(0.8760000000474975, 0.375, 0.8135000000474975, 0.124f, 0.0625, 0.1865f);
    }

    private boolean isClickingOnLid(aab world, int i2, int j2, int k, int iSideClicked, float fXClick, float fYClick, float fZClick) {
        return fYClick > 0.75f;
    }

    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        super.a(register);
        this.iconBaseOpenTop = register.a("fcBlockBasketWicker_open_top");
        this.iconFront = register.a("fcBlockBasketWicker_front");
        this.iconTop = register.a("fcBlockBasketWicker_top");
        this.iconBottom = register.a("fcBlockBasketWicker_bottom");
    }

    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        if (iSide == 1 && this.renderingBase) {
            return this.iconBaseOpenTop;
        }
        if (!this.renderingInterior) {
            if (iSide == 1) {
                return this.iconTop;
            }
            if (iSide == 0) {
                return this.iconBottom;
            }
            int iFacing = this.getFacing(iMetadata);
            if (iSide == iFacing) {
                return this.iconFront;
            }
        }
        return super.a(iSide, iMetadata);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        if (iSide == 0) {
            if (this.renderingInterior) {
                return false;
            }
            return !this.renderingBase || super.a(blockAccess, iNeighborI, iNeighborJ, iNeighborK, iSide);
        }
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderer, int i2, int j2, int k) {
        int iMetadata = renderer.a.h(i2, j2, k);
        int iFacing = this.getFacing(iMetadata);
        this.renderingBase = true;
        BlockModel transformedModel = this.blockModelBase.makeTemporaryCopy();
        transformedModel.rotateAroundYToFacing(this.getFacing(renderer.a, i2, j2, k));
        renderer.setUVRotateTop(this.convertFacingToTopTextureRotation(iFacing));
        renderer.setUVRotateBottom(this.convertFacingToBottomTextureRotation(iFacing));
        boolean bReturnValue = transformedModel.renderAsBlock(renderer, (apa)((Object)this), i2, j2, k);
        this.renderingBase = false;
        if (!this.getIsOpen(iMetadata)) {
            transformedModel = this.getHasContents(iMetadata) ? this.blockModelLidFull.makeTemporaryCopy() : this.blockModelLid.makeTemporaryCopy();
            transformedModel.rotateAroundYToFacing(this.getFacing(renderer.a, i2, j2, k));
            transformedModel.renderAsBlockWithColorMultiplier(renderer, (apa)((Object)this), i2, j2, k);
        } else {
            transformedModel = this.blockModelInterior.makeTemporaryCopy();
            transformedModel.rotateAroundYToFacing(iFacing);
            this.renderingInterior = true;
            transformedModel.renderAsBlockWithColorMultiplier(renderer, (apa)((Object)this), i2, j2, k);
            this.renderingInterior = false;
        }
        renderer.clearUVRotation();
        return bReturnValue;
    }

    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderBlocks, int iItemDamage, float fBrightness) {
        this.blockModelLid.renderAsItemBlock(renderBlocks, (apa)((Object)this), iItemDamage);
        this.blockModelBase.renderAsItemBlock(renderBlocks, (apa)((Object)this), iItemDamage);
    }

    @Environment(value=EnvType.CLIENT)
    public aqx getSelectedBoundingBoxFromPool(aab world, ara rayTraceHit) {
        double maxZBox;
        double minZBox;
        double maxXBox;
        double minXBox;
        int i2 = rayTraceHit.b;
        int j2 = rayTraceHit.c;
        int k = rayTraceHit.d;
        int iMetadata = world.h(i2, j2, k);
        int iFacing = this.getFacing(iMetadata);
        double minYBox = j2;
        double maxYBox = (float)j2 + 0.5f;
        if (this.getIsOpen(iMetadata)) {
            if (rayTraceHit.f.d - minYBox >= 0.9364999999525025) {
                aqx tempLidBox = boxCollisionLidOpenLip.makeTemporaryCopy();
                tempLidBox.rotateAroundYToFacing(iFacing);
                return tempLidBox.d(i2, j2, k);
            }
            maxYBox -= 0.125;
        }
        if (iFacing == 2 || iFacing == 3) {
            minXBox = (double)i2 + 0.0625 + 0.0;
            maxXBox = (double)i2 + 1.0 - 0.0625 - 0.0;
            minZBox = (double)k + 0.0625 + 0.0625;
            maxZBox = (double)k + 1.0 - 0.0625 - 0.0625;
        } else {
            minXBox = (double)i2 + 0.0625 + 0.0625;
            maxXBox = (double)i2 + 1.0 - 0.0625 - 0.0625;
            minZBox = (double)k + 0.0625 + 0.0;
            maxZBox = (double)k + 1.0 - 0.0625 - 0.0;
        }
        return aqx.a().a(minXBox, minYBox, minZBox, maxXBox, maxYBox, maxZBox);
    }
}

