/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.DailyGrowthCropsBlock;
import btw.item.BTWItems;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class WheatCropTopBlock
extends DailyGrowthCropsBlock {
    @Environment(value=EnvType.CLIENT)
    private lx[] iconArray;

    public WheatCropTopBlock(int iBlockID) {
        super(iBlockID);
        this.c("fcBlockWheatCropTop");
    }

    @Override
    public boolean doesBlockDropAsItemOnSaw(aab world, int i2, int j2, int k) {
        return true;
    }

    @Override
    protected int getSeedItemID() {
        return 0;
    }

    @Override
    protected int getCropItemID() {
        return BTWItems.wheat.cp;
    }

    @Override
    protected boolean isFullyGrown(int iMetadata) {
        return this.getGrowthLevel(iMetadata) >= 3;
    }

    @Override
    protected boolean canGrowOnBlock(aab world, int i2, int j2, int k) {
        return world.a(i2, j2, k) == BTWBlocks.wheatCrop.cz;
    }

    @Override
    public aqx getBlockBoundsFromPoolBasedOnState(aak blockAccess, int x2, int y2, int z2) {
        float verticalOffset = 0.0f;
        apa blockBelow = apa.r[blockAccess.a(x2, y2 - 1, z2)];
        if (blockBelow != null) {
            verticalOffset = blockBelow.groundCoverRestingOnVisualOffset(blockAccess, x2, y2 - 1, z2);
        }
        int metadata = blockAccess.h(x2, y2, z2);
        int growthLevel = this.getGrowthLevel(metadata);
        return aqx.a().a(0.125, verticalOffset - 1.0f, 0.125, 0.875, (double)(1 + growthLevel) / 8.0 + (double)verticalOffset, 0.875);
    }

    @Override
    public void a(aab world, int x2, int y2, int z2, int blockID, int metadata) {
        super.a(world, x2, y2, z2, blockID, metadata);
        int blockBelowID = world.a(x2, y2 - 1, z2);
        if (blockBelowID == BTWBlocks.wheatCrop.cz) {
            int blockBelowMetadata = world.h(x2, y2 - 1, z2);
            if (this.isFullyGrown(metadata)) {
                BTWBlocks.wheatCrop.a(world, x2, y2, z2, blockBelowMetadata, 1.0f, 0);
            }
            world.i(x2, y2 - 1, z2);
        }
    }

    @Override
    protected void updateFlagForGrownToday(aab world, int i2, int j2, int k) {
        apa blockBelow = apa.r[world.a(i2, j2 - 1, k)];
        if (!(blockBelow == null || blockBelow.getIsFertilizedForPlantGrowth(world, i2, j2 - 1, k) && this.getGrowthLevel(world, i2, j2, k) % 2 != 1)) {
            this.setHasGrownToday(world, i2, j2, k, true);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        this.iconArray = new lx[4];
        for (int iTempIndex = 0; iTempIndex < this.iconArray.length; ++iTempIndex) {
            this.iconArray[iTempIndex] = register.a("fcBlockWheatCropTop_" + iTempIndex);
        }
        this.cQ = this.iconArray[3];
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx b_(aak blockAccess, int i2, int j2, int k, int iSide) {
        int iGrowthLevel = this.getGrowthLevel(blockAccess, i2, j2, k);
        iGrowthLevel = kx.a(iGrowthLevel, 0, 3);
        return this.iconArray[iGrowthLevel];
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderer, int i2, int j2, int k) {
        this.renderCrops(renderer, i2, j2, k);
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public aqx c_(aab world, int i2, int j2, int k) {
        apa blockBelow;
        if (!this.isFullyGrown(world, i2, j2, k) && (blockBelow = apa.r[world.a(i2, j2 - 1, k)]) != null) {
            return blockBelow.c_(world, i2, j2 - 1, k);
        }
        return super.c_(world, i2, j2, k);
    }
}

