/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.DailyGrowthCropsBlock;
import btw.item.BTWItems;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class WheatCropBlock
extends DailyGrowthCropsBlock {
    @Environment(value=EnvType.CLIENT)
    private lx[] iconArray;
    @Environment(value=EnvType.CLIENT)
    private lx[] connectToTopIconArray;

    public WheatCropBlock(int iBlockID) {
        super(iBlockID);
        this.c("fcBlockWheatCrop");
    }

    @Override
    protected int getSeedItemID() {
        return 0;
    }

    @Override
    protected int getCropItemID() {
        return BTWItems.straw.cp;
    }

    @Override
    public boolean isBlockHydratedForPlantGrowthOn(aab world, int i2, int j2, int k) {
        apa blockBelow = apa.r[world.a(i2, j2 - 1, k)];
        return blockBelow != null && blockBelow.isBlockHydratedForPlantGrowthOn(world, i2, j2 - 1, k);
    }

    @Override
    protected void incrementGrowthLevel(aab world, int i2, int j2, int k) {
        int iGrowthLevel = this.getGrowthLevel(world, i2, j2, k);
        if (iGrowthLevel == 6) {
            if (world.c(i2, j2 + 1, k)) {
                this.setGrowthLevel(world, i2, j2, k, iGrowthLevel + 1);
                int iTopMetadata = 0;
                apa blockBelow = apa.r[world.a(i2, j2 - 1, k)];
                if (blockBelow == null || !blockBelow.getIsFertilizedForPlantGrowth(world, i2, j2 - 1, k)) {
                    iTopMetadata = BTWBlocks.wheatCrop.setHasGrownToday(iTopMetadata, true);
                }
                world.setBlockAndMetadataWithNotify(i2, j2 + 1, k, BTWBlocks.wheatCropTop.cz, iTopMetadata);
            }
        } else {
            super.incrementGrowthLevel(world, i2, j2, k);
        }
    }

    @Override
    public float groundCoverRestingOnVisualOffset(aak blockAccess, int i2, int j2, int k) {
        apa blockBelow = apa.r[blockAccess.a(i2, j2 - 1, k)];
        if (blockBelow != null) {
            return blockBelow.groundCoverRestingOnVisualOffset(blockAccess, i2, j2 - 1, k);
        }
        return 0.0f;
    }

    @Override
    public boolean getIsFertilizedForPlantGrowth(aab world, int i2, int j2, int k) {
        apa blockBelow = apa.r[world.a(i2, j2 - 1, k)];
        return blockBelow != null && blockBelow.getIsFertilizedForPlantGrowth(world, i2, j2 - 1, k);
    }

    @Override
    public void notifyOfFullStagePlantGrowthOn(aab world, int i2, int j2, int k, apa plantBlock) {
        apa blockBelow = apa.r[world.a(i2, j2 - 1, k)];
        if (blockBelow != null) {
            blockBelow.notifyOfFullStagePlantGrowthOn(world, i2, j2 - 1, k, plantBlock);
        }
    }

    @Override
    protected int getLightLevelForGrowth() {
        return 11;
    }

    public boolean hasTopBlock(aak blockAccess, int i2, int j2, int k) {
        return blockAccess.a(i2, j2 + 1, k) == BTWBlocks.wheatCropTop.cz;
    }

    public int getTopBlockGrowthLevel(aak blockAccess, int i2, int j2, int k) {
        return BTWBlocks.wheatCropTop.getGrowthLevel(blockAccess, i2, j2 + 1, k);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        int iTempIndex;
        this.iconArray = new lx[8];
        for (iTempIndex = 0; iTempIndex < this.iconArray.length; ++iTempIndex) {
            this.iconArray[iTempIndex] = register.a("fcBlockWheatCrop_" + iTempIndex);
        }
        this.cQ = this.iconArray[7];
        this.connectToTopIconArray = new lx[4];
        for (iTempIndex = 0; iTempIndex < this.connectToTopIconArray.length; ++iTempIndex) {
            this.connectToTopIconArray[iTempIndex] = register.a("fcBlockWheatCrop_7_" + iTempIndex);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx b_(aak blockAccess, int i2, int j2, int k, int iSide) {
        int iGrowthLevel = this.getGrowthLevel(blockAccess, i2, j2, k);
        if ((iGrowthLevel = kx.a(iGrowthLevel, 0, 7)) == 7 && this.hasTopBlock(blockAccess, i2, j2, k)) {
            int iTopGrowthLevel = this.getTopBlockGrowthLevel(blockAccess, i2, j2, k);
            iTopGrowthLevel = kx.a(iTopGrowthLevel, 0, 3);
            return this.connectToTopIconArray[iTopGrowthLevel];
        }
        return this.iconArray[iGrowthLevel];
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public aqx c_(aab world, int x2, int y2, int z2) {
        if (this.isFullyGrown(world, x2, y2, z2) && this.hasTopBlock(world, x2, y2, z2)) {
            int topGrowthLevel = this.getTopBlockGrowthLevel(world, x2, y2, z2);
            float verticalOffset = 0.0f;
            apa blockBelow = apa.r[world.a(x2, y2 - 1, z2)];
            if (blockBelow != null) {
                verticalOffset = blockBelow.groundCoverRestingOnVisualOffset(world, x2, y2 - 1, z2);
            }
            double topHeight = (double)(1 + topGrowthLevel) / 8.0;
            return aqx.a().a(0.125, 0.0 + (double)verticalOffset, 0.125, 0.875, 1.0 + (double)verticalOffset + topHeight, 0.875).d(x2, y2, z2);
        }
        return super.c_(world, x2, y2, z2);
    }
}

