/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.blocks.PaneBlock;
import btw.block.util.RayTraceUtils;
import btw.item.BTWItems;
import btw.world.util.BlockPos;
import btw.world.util.WorldUtils;
import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class WallBlock
extends apo {
    public WallBlock(int iBlockID, apa baseBlock) {
        super(iBlockID, baseBlock);
        this.a(ve.c);
    }

    @Override
    public boolean hasCenterHardPointToFacing(aak blockAccess, int i2, int j2, int k, int iFacing, boolean bIgnoreTransparency) {
        return iFacing == 0 || iFacing == 1;
    }

    @Override
    public int getWeightOnPathBlocked(aak blockAccess, int i2, int j2, int k) {
        return -3;
    }

    @Override
    public int a(int iMetadata, Random rand, int iFortuneModifier) {
        int iType = iMetadata & 1;
        if (iType == 0) {
            return BTWItems.stone.cp;
        }
        return super.a(iMetadata, rand, iFortuneModifier);
    }

    @Override
    public int a(int metadata) {
        int type = metadata & 1;
        if (type == 0) {
            return metadata >> 2;
        }
        return super.a(metadata);
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iMetadata, float fChance, int iFortuneModifier) {
        int iType = iMetadata & 1;
        if (iType == 0) {
            if (!world.I) {
                int iNumDropped = 4;
                for (int k1 = 0; k1 < iNumDropped; ++k1) {
                    int iItemID = this.a(iMetadata, world.s, iFortuneModifier);
                    if (iItemID <= 0) continue;
                    this.b(world, i2, j2, k, new wm(iItemID, 1, this.a(iMetadata)));
                }
            }
        } else {
            super.a(world, i2, j2, k, iMetadata, fChance, iFortuneModifier);
        }
    }

    @Override
    public boolean canGroundCoverRestOnBlock(aab world, int i2, int j2, int k) {
        return world.w(i2, j2 - 1, k);
    }

    @Override
    public float groundCoverRestingOnVisualOffset(aak blockAccess, int i2, int j2, int k) {
        return -1.0f;
    }

    @Override
    public void a(aak blockAccess, int i2, int j2, int k) {
    }

    @Override
    public aqx getBlockBoundsFromPoolBasedOnState(aak blockAccess, int x2, int y2, int z2) {
        boolean post = WallBlock.wallHasPost(blockAccess, x2, y2, z2, true, true);
        boolean east = WallBlock.canConnectToBlockToFacing(blockAccess, x2, y2, z2, 4);
        boolean west = WallBlock.canConnectToBlockToFacing(blockAccess, x2, y2, z2, 5);
        boolean north = WallBlock.canConnectToBlockToFacing(blockAccess, x2, y2, z2, 2);
        boolean south = WallBlock.canConnectToBlockToFacing(blockAccess, x2, y2, z2, 3);
        boolean eastFullWall = WallBlock.shouldHaveFullHeightWallToFacing(blockAccess, x2, y2, z2, 4);
        boolean westFullWall = WallBlock.shouldHaveFullHeightWallToFacing(blockAccess, x2, y2, z2, 5);
        boolean northFullWall = WallBlock.shouldHaveFullHeightWallToFacing(blockAccess, x2, y2, z2, 2);
        boolean southFullWall = WallBlock.shouldHaveFullHeightWallToFacing(blockAccess, x2, y2, z2, 3);
        double minX = 0.3125;
        double minZ = 0.3125;
        double maxX = 0.6875;
        double maxZ = 0.6875;
        double height = 0.8125;
        if (eastFullWall || westFullWall || northFullWall || southFullWall || post) {
            height = 1.0;
        }
        if (post) {
            minX = 0.25;
            minZ = 0.25;
            maxX = 0.75;
            maxZ = 0.75;
        }
        if (east) {
            minX = 0.0;
        }
        if (west) {
            maxX = 1.0;
        }
        if (north) {
            minZ = 0.0;
        }
        if (south) {
            maxZ = 1.0;
        }
        return aqx.a().a(minX, 0.0, minZ, maxX, height, maxZ);
    }

    @Override
    public void a(aab world, int x2, int y2, int z2, aqx aabb, List collisionList, mp entity) {
        boolean post = WallBlock.wallHasPost(world, x2, y2, z2, true, true);
        boolean east = WallBlock.canConnectToBlockToFacing(world, x2, y2, z2, 4);
        boolean west = WallBlock.canConnectToBlockToFacing(world, x2, y2, z2, 5);
        boolean north = WallBlock.canConnectToBlockToFacing(world, x2, y2, z2, 2);
        boolean south = WallBlock.canConnectToBlockToFacing(world, x2, y2, z2, 3);
        if (post) {
            aqx.a().a(0.25, 0.0, 0.25, 0.75, 1.5, 0.75).d(x2, y2, z2).addToListIfIntersects(aabb, collisionList);
        }
        double height = 1.5;
        if (east) {
            aqx.a().a(0.0, 0.0, 0.3125, 0.5, height, 0.6875).d(x2, y2, z2).addToListIfIntersects(aabb, collisionList);
        }
        if (west) {
            aqx.a().a(0.5, 0.0, 0.3125, 1.0, height, 0.6875).d(x2, y2, z2).addToListIfIntersects(aabb, collisionList);
        }
        if (north) {
            aqx.a().a(0.3125, 0.0, 0.0, 0.6875, height, 0.5).d(x2, y2, z2).addToListIfIntersects(aabb, collisionList);
        }
        if (south) {
            aqx.a().a(0.3125, 0.0, 0.5, 0.6875, height, 1.0).d(x2, y2, z2).addToListIfIntersects(aabb, collisionList);
        }
    }

    @Override
    public aqx b(aab world, int i2, int j2, int k) {
        aqx box = this.getBlockBoundsFromPoolBasedOnState(world, i2, j2, k);
        box.e = 1.5;
        return box.d(i2, j2, k);
    }

    @Override
    public ara a(aab world, int x2, int y2, int z2, arc var5, arc var6) {
        double height;
        boolean post = WallBlock.wallHasPost(world, x2, y2, z2, true, true);
        boolean east = WallBlock.canConnectToBlockToFacing(world, x2, y2, z2, 4);
        boolean west = WallBlock.canConnectToBlockToFacing(world, x2, y2, z2, 5);
        boolean north = WallBlock.canConnectToBlockToFacing(world, x2, y2, z2, 2);
        boolean south = WallBlock.canConnectToBlockToFacing(world, x2, y2, z2, 3);
        boolean eastFullWall = WallBlock.shouldHaveFullHeightWallToFacing(world, x2, y2, z2, 4);
        boolean westFullWall = WallBlock.shouldHaveFullHeightWallToFacing(world, x2, y2, z2, 5);
        boolean northFullWall = WallBlock.shouldHaveFullHeightWallToFacing(world, x2, y2, z2, 2);
        boolean southFullWall = WallBlock.shouldHaveFullHeightWallToFacing(world, x2, y2, z2, 3);
        RayTraceUtils raytracer = new RayTraceUtils(world, x2, y2, z2, var5, var6);
        if (post) {
            raytracer.addBoxWithLocalCoordsToIntersectionList(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
        }
        if (east) {
            height = 0.8125;
            if (eastFullWall) {
                height = 1.0;
            }
            raytracer.addBoxWithLocalCoordsToIntersectionList(0.0, 0.0, 0.3125, 0.5, height, 0.6875);
        }
        if (west) {
            height = 0.8125;
            if (westFullWall) {
                height = 1.0;
            }
            raytracer.addBoxWithLocalCoordsToIntersectionList(0.5, 0.0, 0.3125, 1.0, height, 0.6875);
        }
        if (north) {
            height = 0.8125;
            if (northFullWall) {
                height = 1.0;
            }
            raytracer.addBoxWithLocalCoordsToIntersectionList(0.3125, 0.0, 0.0, 0.6875, height, 0.5);
        }
        if (south) {
            height = 0.8125;
            if (southFullWall) {
                height = 1.0;
            }
            raytracer.addBoxWithLocalCoordsToIntersectionList(0.3125, 0.0, 0.5, 0.6875, height, 1.0);
        }
        return raytracer.getFirstIntersection();
    }

    @Override
    public boolean isWall(int metadata) {
        return true;
    }

    @Override
    public boolean shouldPaneConnectToThisBlockToFacing(aak blockAccess, int x2, int y2, int z2, int facing) {
        return true;
    }

    public int getStoneType(int metadata) {
        return metadata & 1;
    }

    public int getStrata(aak blockAccess, int i2, int j2, int k) {
        return this.getStrata(blockAccess.h(i2, j2, k));
    }

    public int getStrata(int iMetadata) {
        return (iMetadata & 0xC) >>> 2;
    }

    public static boolean canConnectToBlockToFacing(aak blockAccess, int x2, int y2, int z2, int facing) {
        BlockPos blockPos = new BlockPos(x2, y2, z2, facing);
        apa block = apa.r[blockAccess.a(blockPos.x, blockPos.y, blockPos.z)];
        if (block != null) {
            return block.shouldWallConnectToThisBlockToFacing(blockAccess, blockPos.x, blockPos.y, blockPos.z, s.a[facing]);
        }
        return false;
    }

    public static boolean wallHasPost(aak blockAccess, int x2, int y2, int z2, boolean checkAbove, boolean checkBelow) {
        boolean EW;
        int idAbove = blockAccess.a(x2, y2 + 1, z2);
        apa blockAbove = apa.r[idAbove];
        int metaAbove = blockAccess.h(x2, y2 + 1, z2);
        int idBelow = blockAccess.a(x2, y2 - 1, z2);
        apa blockBelow = apa.r[idBelow];
        int metaBelow = blockAccess.h(x2, y2 - 1, z2);
        boolean north = WallBlock.canConnectToBlockToFacing(blockAccess, x2, y2, z2, 2);
        boolean south = WallBlock.canConnectToBlockToFacing(blockAccess, x2, y2, z2, 3);
        boolean east = WallBlock.canConnectToBlockToFacing(blockAccess, x2, y2, z2, 4);
        boolean west = WallBlock.canConnectToBlockToFacing(blockAccess, x2, y2, z2, 5);
        boolean NS = north && south && !east && !west;
        boolean bl = EW = !north && !south && east && west;
        if (!NS && !EW) {
            return true;
        }
        if (blockAbove != null && blockAbove.isWall(metaAbove) || blockBelow != null && blockBelow.isWall(metaBelow)) {
            if (blockAbove != null && blockAbove.isWall(metaAbove) && checkAbove) {
                return WallBlock.wallHasPost(blockAccess, x2, y2 + 1, z2, true, false);
            }
            if (blockBelow == null || !blockBelow.isWall(metaBelow) || checkBelow) {
                // empty if block
            }
        }
        boolean airAbove = blockAccess.c(x2, y2 + 1, z2) || WorldUtils.isGroundCoverOnBlock(blockAccess, x2, y2, z2);
        boolean solidSurface = blockAbove != null && blockAbove.hasLargeCenterHardPointToFacing(blockAccess, x2, y2 + 1, z2, 0);
        boolean paneAbove = blockAbove instanceof aoz;
        boolean paneToSide = false;
        for (int i2 = 0; i2 < 4; ++i2) {
            BlockPos blockPos = new BlockPos(x2, y2, z2, i2 + 2);
            int idOffset = blockAccess.a(blockPos.x, blockPos.y, blockPos.z);
            if (!(apa.r[idOffset] instanceof aoz)) continue;
            paneToSide = true;
        }
        if (airAbove && !paneToSide) {
            return false;
        }
        if (solidSurface || paneToSide) {
            if (NS) {
                boolean northFullWall = WallBlock.shouldHaveFullHeightWallToFacing(blockAccess, x2, y2, z2, 2);
                boolean southFullWall = WallBlock.shouldHaveFullHeightWallToFacing(blockAccess, x2, y2, z2, 3);
                return !northFullWall || !southFullWall;
            }
            boolean eastFullWall = WallBlock.shouldHaveFullHeightWallToFacing(blockAccess, x2, y2, z2, 4);
            boolean westFullWall = WallBlock.shouldHaveFullHeightWallToFacing(blockAccess, x2, y2, z2, 5);
            return !eastFullWall || !westFullWall;
        }
        return blockAbove != null && blockAbove.shouldWallFormPostBelowThisBlock(blockAccess, x2, y2 + 1, z2);
    }

    public static boolean shouldHaveFullHeightWallToFacing(aak blockAccess, int x2, int y2, int z2, int facing) {
        boolean connect = WallBlock.canConnectToBlockToFacing(blockAccess, x2, y2, z2, facing);
        if (!connect) {
            return false;
        }
        int idAbove = blockAccess.a(x2, y2 + 1, z2);
        int metaAbove = blockAccess.h(x2, y2 + 1, z2);
        apa blockAbove = apa.r[idAbove];
        boolean solidSurfaceAbove = blockAbove != null && blockAbove.hasLargeCenterHardPointToFacing(blockAccess, x2, y2 + 1, z2, 0);
        boolean paneAbove = blockAbove instanceof aoz;
        boolean canPaneAboveConnectToFacing = false;
        if (paneAbove) {
            BlockPos blockPosPane = new BlockPos(x2, y2 + 1, z2, facing);
            canPaneAboveConnectToFacing = PaneBlock.canConnectToBlockToFacing(blockAccess, blockPosPane.x, blockPosPane.y, blockPosPane.z, s.a[facing]);
        }
        BlockPos blockPos = new BlockPos(x2, y2, z2, facing);
        apa sideBlock = apa.r[blockAccess.a(blockPos.x, blockPos.y, blockPos.z)];
        boolean solidSide = sideBlock.hasLargeCenterHardPointToFacing(blockAccess, blockPos.x, blockPos.y, blockPos.z, s.a[facing]);
        int idOffset = blockAccess.a(blockPos.x, blockPos.y, blockPos.z);
        boolean paneToSide = apa.r[idOffset] instanceof aoz;
        int idAboveOffset = blockAccess.a(blockPos.x, blockPos.y + 1, blockPos.z);
        int metaAboveOffset = blockAccess.h(blockPos.x, blockPos.y + 1, blockPos.z);
        apa blockAboveOffset = apa.r[idAboveOffset];
        boolean solidSurfaceDiagonal = blockAboveOffset != null && blockAboveOffset.hasLargeCenterHardPointToFacing(blockAccess, blockPos.x, blockPos.y + 1, blockPos.z, 0);
        boolean paneAboveDiagonal = blockAboveOffset instanceof aoz;
        if (blockAbove != null && blockAbove.isWall(metaAbove) && !solidSurfaceDiagonal && !paneToSide) {
            return WallBlock.canConnectToBlockToFacing(blockAccess, x2, y2 + 1, z2, facing);
        }
        boolean wallOrBenchAbove = blockAbove != null && (blockAbove.isWall(metaAbove) || blockAbove.isBenchOrTable(metaAbove));
        boolean paneAboveInSameDirection = paneAbove && canPaneAboveConnectToFacing;
        boolean aboveConditionMet = wallOrBenchAbove || solidSurfaceAbove || paneAboveInSameDirection;
        boolean wallOrBenchDiagonal = blockAboveOffset != null && (blockAboveOffset.isWall(metaAboveOffset) || blockAboveOffset.isBenchOrTable(metaAboveOffset));
        boolean canIgnoreDiagonals = solidSide && (!paneAbove || canPaneAboveConnectToFacing);
        boolean diagonalConditionMet = wallOrBenchDiagonal || solidSurfaceDiagonal || canIgnoreDiagonals || paneAboveDiagonal;
        return paneToSide || aboveConditionMet && diagonalConditionMet;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf render, int x2, int y2, int z2) {
        return WallBlock.renderWall(render, this, x2, y2, z2);
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean renderWall(bgf render, apa block, int x2, int y2, int z2) {
        double height;
        boolean post = WallBlock.wallHasPost(render.a, x2, y2, z2, true, true);
        boolean east = WallBlock.canConnectToBlockToFacing(render.a, x2, y2, z2, 4);
        boolean west = WallBlock.canConnectToBlockToFacing(render.a, x2, y2, z2, 5);
        boolean north = WallBlock.canConnectToBlockToFacing(render.a, x2, y2, z2, 2);
        boolean south = WallBlock.canConnectToBlockToFacing(render.a, x2, y2, z2, 3);
        boolean eastFullWall = WallBlock.shouldHaveFullHeightWallToFacing(render.a, x2, y2, z2, 4);
        boolean westFullWall = WallBlock.shouldHaveFullHeightWallToFacing(render.a, x2, y2, z2, 5);
        boolean northFullWall = WallBlock.shouldHaveFullHeightWallToFacing(render.a, x2, y2, z2, 2);
        boolean southFullWall = WallBlock.shouldHaveFullHeightWallToFacing(render.a, x2, y2, z2, 3);
        if (post) {
            render.a(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
            render.p(block, x2, y2, z2);
        }
        if (east) {
            height = 0.8125;
            if (eastFullWall) {
                height = 1.0;
            }
            render.a(0.0, 0.0, 0.3125, 0.5, height, 0.6875);
            render.p(block, x2, y2, z2);
        }
        if (west) {
            height = 0.8125;
            if (westFullWall) {
                height = 1.0;
            }
            render.a(0.5, 0.0, 0.3125, 1.0, height, 0.6875);
            render.p(block, x2, y2, z2);
        }
        if (north) {
            height = 0.8125;
            if (northFullWall) {
                height = 1.0;
            }
            render.a(0.3125, 0.0, 0.0, 0.6875, height, 0.5);
            render.p(block, x2, y2, z2);
        }
        if (south) {
            height = 0.8125;
            if (southFullWall) {
                height = 1.0;
            }
            render.a(0.3125, 0.0, 0.5, 0.6875, height, 1.0);
            render.p(block, x2, y2, z2);
        }
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        return this.currentBlockRenderer.shouldSideBeRenderedBasedOnCurrentBounds(iNeighborI, iNeighborJ, iNeighborK, iSide);
    }

    @Override
    public void a(int par1, ve par2CreativeTabs, List par3List) {
        for (int i2 = 0; i2 < 3; ++i2) {
            par3List.add(new wm(par1, 1, 0 + i2 << 2));
            par3List.add(new wm(par1, 1, 1 + (i2 << 2)));
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int side, int metadata) {
        int strata = this.getStrata(metadata);
        int type = this.getStoneType(metadata);
        return type == 1 ? apa.as.a(side, strata) : apa.A.a(side, strata);
    }
}

