/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.MechanicalBlock;
import btw.block.blocks.AxleBlock;
import btw.block.blocks.HandCrankBlock;
import btw.block.util.MechPowerUtils;
import btw.client.render.util.RenderUtils;
import btw.world.util.BlockPos;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.opengl.GL11;

public abstract class VesselBlock
extends akz
implements MechanicalBlock {
    private static final int TICK_RATE = 1;
    public static final double COLLISION_BOX_HEIGHT = 1.0;
    public static final float MODEL_HEIGHT = 1.0f;
    public static final float MODEL_WIDTH = 0.875f;
    public static final float MODEL_HALF_WIDTH = 0.4375f;
    public static final float MODEL_BAND_HEIGHT = 0.75f;
    public static final float MODEL_BAND_HALF_HEIGHT = 0.375f;
    @Environment(value=EnvType.CLIENT)
    protected lx[] iconWideBandBySideArray = new lx[6];
    @Environment(value=EnvType.CLIENT)
    protected lx[] iconCenterColumnBySideArray = new lx[6];
    @Environment(value=EnvType.CLIENT)
    protected lx[] iconInteriorBySideArray = new lx[6];
    @Environment(value=EnvType.CLIENT)
    private boolean renderingInterior = false;
    @Environment(value=EnvType.CLIENT)
    private boolean renderingWideBand = false;

    public VesselBlock(int iBlockID, aif material) {
        super(iBlockID, material);
    }

    public int a(aab world) {
        return 1;
    }

    public void a(aab world, int i2, int j2, int k) {
        super.a(world, i2, j2, k);
        world.a(i2, j2, k, this.cz, this.a(world));
    }

    public boolean c() {
        return false;
    }

    public boolean b() {
        return false;
    }

    public aqx b(aab world, int i2, int j2, int k) {
        return aqx.a().a(i2, j2, k, i2 + 1, (double)j2 + 1.0, (double)k + 1.0);
    }

    public void a(aab world, int i2, int j2, int k, Random rand) {
        boolean bWasPowered = this.getMechanicallyPoweredFlag(world, i2, j2, k);
        boolean bIsPowered = false;
        int iPoweredFromFacing = 0;
        for (int iFacing = 2; iFacing <= 5; ++iFacing) {
            if (!MechPowerUtils.isBlockPoweredByAxleToSide(world, i2, j2, k, iFacing) && !MechPowerUtils.isBlockPoweredByHandCrankToSide(world, i2, j2, k, iFacing)) continue;
            bIsPowered = true;
            iPoweredFromFacing = iFacing;
            this.breakPowerSourceThatOpposePoweredFacing(world, i2, j2, k, iPoweredFromFacing);
        }
        if (bWasPowered != bIsPowered) {
            world.a((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "step.gravel", 2.0f + rand.nextFloat() * 0.1f, 0.5f + rand.nextFloat() * 0.1f);
            this.setMechanicallyPoweredFlag(world, i2, j2, k, bIsPowered);
            if (!bIsPowered) {
                this.setTiltFacing(world, i2, j2, k, 0);
            } else {
                this.setFacingBasedOnPoweredFromFacing(world, i2, j2, k, iPoweredFromFacing);
            }
        }
    }

    public void a(aab world, int i2, int j2, int k, int iBlockID) {
        if (!world.isUpdatePendingThisTickForBlock(i2, j2, k, this.cz)) {
            world.a(i2, j2, k, this.cz, this.a(world));
        }
    }

    public int getFacing(aak blockAccess, int i2, int j2, int k) {
        int iFacing = 1;
        if (this.getMechanicallyPoweredFlag(blockAccess, i2, j2, k)) {
            iFacing = this.getTiltFacing(blockAccess, i2, j2, k);
        }
        return iFacing;
    }

    public void setFacing(aab world, int i2, int j2, int k, int iFacing) {
    }

    public int getFacing(int iMetadata) {
        return 0;
    }

    public int setFacing(int iMetadata, int iFacing) {
        return iMetadata;
    }

    @Override
    public boolean canOutputMechanicalPower() {
        return false;
    }

    @Override
    public boolean canInputMechanicalPower() {
        return true;
    }

    @Override
    public boolean isInputtingMechanicalPower(aab world, int i2, int j2, int k) {
        return MechPowerUtils.isBlockPoweredByAxle(world, i2, j2, k, this);
    }

    @Override
    public boolean canInputAxlePowerToFacing(aab world, int i2, int j2, int k, int iFacing) {
        return iFacing >= 2;
    }

    @Override
    public boolean isOutputtingMechanicalPower(aab world, int i2, int j2, int k) {
        return false;
    }

    @Override
    public void overpower(aab world, int i2, int j2, int k) {
    }

    public int getTiltFacing(aak iBlockAccess, int i2, int j2, int k) {
        return (iBlockAccess.h(i2, j2, k) & 3) + 2;
    }

    public void setTiltFacing(aab world, int i2, int j2, int k, int iFacing) {
        int iFlatFacing = iFacing - 2;
        if (iFlatFacing < 0) {
            iFlatFacing = 0;
        }
        int iMetaData = world.h(i2, j2, k) & 0xFFFFFFFC;
        world.setBlockMetadataWithNotify(i2, j2, k, iMetaData |= iFlatFacing & 3);
        world.g(i2, j2, k, i2, j2, k);
    }

    public boolean getMechanicallyPoweredFlag(aak iBlockAccess, int i2, int j2, int k) {
        return (iBlockAccess.h(i2, j2, k) & 4) > 0;
    }

    private void setMechanicallyPoweredFlag(aab world, int i2, int j2, int k, boolean bFlag) {
        int iMetaData = world.h(i2, j2, k) & 0xFFFFFFFB;
        if (bFlag) {
            iMetaData |= 4;
        }
        world.setBlockMetadataWithNotify(i2, j2, k, iMetaData);
    }

    private void setFacingBasedOnPoweredFromFacing(aab world, int i2, int j2, int k, int iPoweredFromFacing) {
        int iNewFacing = apa.rotateFacingAroundY(iPoweredFromFacing, false);
        this.setTiltFacing(world, i2, j2, k, iNewFacing);
    }

    private void breakPowerSourceThatOpposePoweredFacing(aab world, int i2, int j2, int k, int iPoweredFromFacing) {
        int iOppositePoweredFromFacing = apa.getOppositeFacing(iPoweredFromFacing);
        for (int iFacing = 2; iFacing <= 5; ++iFacing) {
            BlockPos tempPos;
            if (iFacing == iPoweredFromFacing) continue;
            boolean bShouldBreak = false;
            if (iFacing == iOppositePoweredFromFacing) {
                if (MechPowerUtils.isBlockPoweredByAxleToSide(world, i2, j2, k, iFacing)) {
                    bShouldBreak = true;
                }
            } else if (MechPowerUtils.doesBlockHaveFacingAxleToSide(world, i2, j2, k, iFacing)) {
                bShouldBreak = true;
            }
            if (bShouldBreak) {
                tempPos = new BlockPos(i2, j2, k);
                tempPos.addFacingAsOffset(iFacing);
                ((AxleBlock)BTWBlocks.axle).breakAxle(world, tempPos.x, tempPos.y, tempPos.z);
            }
            if (!MechPowerUtils.isBlockPoweredByHandCrankToSide(world, i2, j2, k, iFacing)) continue;
            tempPos = new BlockPos(i2, j2, k);
            tempPos.addFacingAsOffset(iFacing);
            ((HandCrankBlock)BTWBlocks.handCrank).breakCrankWithDrop(world, tempPos.x, tempPos.y, tempPos.z);
        }
    }

    public boolean isOpenSideBlocked(aab world, int i2, int j2, int k) {
        int iFacing = this.getFacing(world, i2, j2, k);
        BlockPos targetPos = new BlockPos(i2, j2, k, iFacing);
        return world.u(targetPos.x, targetPos.y, targetPos.z);
    }

    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        if (this.renderingInterior) {
            return this.iconInteriorBySideArray[iSide];
        }
        if (this.renderingWideBand) {
            return this.iconWideBandBySideArray[iSide];
        }
        return this.iconCenterColumnBySideArray[iSide];
    }

    @Environment(value=EnvType.CLIENT)
    public lx b_(aak blockAccess, int i2, int j2, int k, int iSide) {
        int iTextureSide = iSide;
        if (this.getMechanicallyPoweredFlag(blockAccess, i2, j2, k)) {
            int iFacing = this.getTiltFacing(blockAccess, i2, j2, k);
            iTextureSide = iFacing == iSide ? 1 : (iSide == apa.getOppositeFacing(iFacing) ? 0 : 2);
        }
        return this.a(iTextureSide, 0);
    }

    @Environment(value=EnvType.CLIENT)
    public abstract void a(ly var1);

    @Environment(value=EnvType.CLIENT)
    public void b(aab world, int i2, int j2, int k, Random random) {
        int iBlockUnderID;
        if (!(this.getMechanicallyPoweredFlag(world, i2, j2, k) || (iBlockUnderID = world.a(i2, j2 - 1, k)) != apa.av.cz && iBlockUnderID != BTWBlocks.stokedFire.cz)) {
            for (int counter = 0; counter < 1; ++counter) {
                float smokeX = (float)i2 + random.nextFloat();
                float smokeY = (float)j2 + random.nextFloat() * 0.5f + 1.0f;
                float smokeZ = (float)k + random.nextFloat();
                world.a("fcwhitesmoke", (double)smokeX, (double)smokeY, (double)smokeZ, 0.0, 0.0, 0.0);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderBlocks, int i2, int j2, int k) {
        aak blockAccess = renderBlocks.a;
        int iFacing = this.getFacing(blockAccess, i2, j2, k);
        this.renderingInterior = false;
        this.renderingWideBand = true;
        RenderUtils.renderBlockWithBoundsAndTextureRotation(renderBlocks, (apa)((Object)this), i2, j2, k, iFacing, 0.0f, 0.125f, 0.0f, 1.0f, 0.875f, 1.0f);
        this.renderingWideBand = false;
        RenderUtils.renderBlockWithBoundsAndTextureRotation(renderBlocks, (apa)((Object)this), i2, j2, k, iFacing, 0.0625f, 0.0f, 0.0625f, 0.9375f, 1.0f, 0.9375f);
        this.renderingInterior = true;
        bgd tesselator = bgd.a;
        RenderUtils.setRenderBoundsToBlockFacing(renderBlocks, iFacing, 0.0625f, 0.0f, 0.0625f, 0.9375f, 1.0f, 0.9375f);
        RenderUtils.setTextureRotationBasedOnBlockFacing(renderBlocks, iFacing);
        tesselator.c(this.e(blockAccess, i2, j2, k));
        float fInteriorBrightnessMultiplier = 0.66f;
        int iColorMultiplier = this.c(blockAccess, i2, j2, k);
        float iColorRed = (float)(iColorMultiplier >> 16 & 0xFF) / 255.0f;
        float iColorGreen = (float)(iColorMultiplier >> 8 & 0xFF) / 255.0f;
        float iColorBlue = (float)(iColorMultiplier & 0xFF) / 255.0f;
        tesselator.a(0.66f * iColorRed, 0.66f * iColorGreen, 0.66f * iColorBlue);
        double dInteriorOffset = 0.249;
        renderBlocks.f((apa)((Object)this), (double)i2 - 1.0 + 0.249, j2, k, this.b_(blockAccess, i2, j2, k, 4));
        renderBlocks.e((apa)((Object)this), (double)i2 + 1.0 - 0.249, j2, k, this.b_(blockAccess, i2, j2, k, 5));
        renderBlocks.d((apa)((Object)this), i2, j2, (double)k - 1.0 + 0.249, this.b_(blockAccess, i2, j2, k, 2));
        renderBlocks.c((apa)((Object)this), (double)i2, (double)j2, (double)k + 1.0 - 0.249, this.b_(blockAccess, i2, j2, k, 3));
        renderBlocks.b((apa)((Object)this), (double)i2, (double)((float)j2 - 1.0f) + 0.249, (double)k, this.b_(blockAccess, i2, j2, k, 0));
        renderBlocks.a((apa)((Object)this), (double)i2, (double)((float)j2 + 1.0f) - 0.249, (double)k, this.b_(blockAccess, i2, j2, k, 1));
        renderBlocks.clearUVRotation();
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderBlocks, int iItemDamage, float fBrightness) {
        this.renderingInterior = false;
        this.renderingWideBand = true;
        renderBlocks.a(0.0, 0.125, 0.0, 1.0, 0.875, 1.0);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, (apa)((Object)this), -0.5f, -0.5f, -0.5f, 0);
        this.renderingWideBand = false;
        renderBlocks.a(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, (apa)((Object)this), -0.5f, -0.5f, -0.5f, 0);
        this.renderingInterior = true;
        renderBlocks.a(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);
        bgd tessellator = bgd.a;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        double dInteriorOffset = 0.249;
        tessellator.b();
        tessellator.b(0.0f, 1.0f, 0.0f);
        renderBlocks.b((apa)((Object)this), 0.0, -0.751, 0.0, this.a(0, 0));
        tessellator.a();
        tessellator.b();
        tessellator.b(0.0f, 0.0f, -1.0f);
        renderBlocks.c((apa)((Object)this), 0.0, 0.0, 0.751, this.a(3, 0));
        tessellator.a();
        tessellator.b();
        tessellator.b(0.0f, 0.0f, 1.0f);
        renderBlocks.d((apa)((Object)this), 0.0, 0.0, -0.751, this.a(2, 0));
        tessellator.a();
        tessellator.b();
        tessellator.b(-1.0f, 0.0f, 0.0f);
        renderBlocks.e((apa)((Object)this), 0.751, 0.0, 0.0, this.a(5, 0));
        tessellator.a();
        tessellator.b();
        tessellator.b(1.0f, 0.0f, 0.0f);
        renderBlocks.f((apa)((Object)this), -0.751, 0.0, 0.0, this.a(4, 0));
        tessellator.a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }
}

