/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.world.util.BlockPos;
import btw.world.util.WorldUtils;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class TorchBlockBase
extends apa {
    protected TorchBlockBase(int iBlockID) {
        super(iBlockID, aif.q);
        this.c(0.0f);
        this.setBuoyant();
        this.setFilterableProperties(4);
        this.a(g);
        this.b(true);
    }

    @Override
    public aqx b(aab world, int i2, int j2, int k) {
        return null;
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public int d() {
        return 2;
    }

    @Override
    public boolean c(aab world, int i2, int j2, int k) {
        for (int iFacing = 2; iFacing < 6; ++iFacing) {
            BlockPos targetPos = new BlockPos(i2, j2, k, iFacing);
            if (!WorldUtils.doesBlockHaveCenterHardpointToFacing(world, targetPos.x, targetPos.y, targetPos.z, apa.getOppositeFacing(iFacing))) continue;
            return true;
        }
        return this.canPlaceTorchOn(world, i2, j2 - 1, k);
    }

    @Override
    public int a(aab world, int i2, int j2, int k, int iFacing, float fClickX, float fClickY, float fClickZ, int iMetadata) {
        if (iFacing == 1) {
            if (this.canPlaceTorchOn(world, i2, j2 - 1, k)) {
                iMetadata = TorchBlockBase.setOrientation(iMetadata, 5);
            }
        } else if (iFacing != 0) {
            BlockPos targetPos = new BlockPos(i2, j2, k, apa.getOppositeFacing(iFacing));
            if (WorldUtils.doesBlockHaveCenterHardpointToFacing(world, targetPos.x, targetPos.y, targetPos.z, iFacing)) {
                iMetadata = TorchBlockBase.setOrientation(iMetadata, 6 - iFacing);
            }
        }
        return iMetadata;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random rand) {
        super.a(world, i2, j2, k, rand);
        if (this.getOrientation(world, i2, j2, k) == 0) {
            this.a(world, i2, j2, k);
        }
    }

    @Override
    public void a(aab world, int i2, int j2, int k) {
        if (this.getOrientation(world, i2, j2, k) == 0) {
            for (int iFacing = 1; iFacing < 6; ++iFacing) {
                BlockPos targetPos = new BlockPos(i2, j2, k, apa.getOppositeFacing(iFacing));
                if (!WorldUtils.doesBlockHaveCenterHardpointToFacing(world, targetPos.x, targetPos.y, targetPos.z, iFacing)) continue;
                this.setOrientation(world, i2, j2, k, 6 - iFacing);
                return;
            }
            this.c(world, i2, j2, k, world.h(i2, j2, k), 0);
            world.setBlockWithNotify(i2, j2, k, 0);
        }
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iNeighborID) {
        this.validateState(world, i2, j2, k, iNeighborID);
    }

    @Override
    public aqx getBlockBoundsFromPoolBasedOnState(aak blockAccess, int i2, int j2, int k) {
        int iOrientation = this.getOrientation(blockAccess, i2, j2, k);
        float fTorchWidth = 0.15f;
        if (iOrientation == 1) {
            return aqx.a().a(0.0, 0.2f, 0.5f - fTorchWidth, fTorchWidth * 2.0f, 0.8f, 0.5f + fTorchWidth);
        }
        if (iOrientation == 2) {
            return aqx.a().a(1.0f - fTorchWidth * 2.0f, 0.2f, 0.5f - fTorchWidth, 1.0, 0.8f, 0.5f + fTorchWidth);
        }
        if (iOrientation == 3) {
            return aqx.a().a(0.5f - fTorchWidth, 0.2f, 0.0, 0.5f + fTorchWidth, 0.8f, fTorchWidth * 2.0f);
        }
        if (iOrientation == 4) {
            return aqx.a().a(0.5f - fTorchWidth, 0.2f, 1.0f - fTorchWidth * 2.0f, 0.5f + fTorchWidth, 0.8f, 1.0);
        }
        fTorchWidth = 0.1f;
        return aqx.a().a(0.5f - fTorchWidth, 0.0, 0.5f - fTorchWidth, 0.5f + fTorchWidth, 0.6f, 0.5f + fTorchWidth);
    }

    @Override
    public boolean isBlockRestingOnThatBelow(aak blockAccess, int i2, int j2, int k) {
        return this.getOrientation(blockAccess, i2, j2, k) == 5;
    }

    @Override
    public int getFacing(int iMetadata) {
        return kx.a(6 - TorchBlockBase.getOrientation(iMetadata), 1, 5);
    }

    @Override
    public int setFacing(int iMetadata, int iFacing) {
        iFacing = kx.a(iFacing, 1, 5);
        return TorchBlockBase.setOrientation(iMetadata, 6 - iFacing);
    }

    @Override
    public boolean canRotateAroundBlockOnTurntableToFacing(aab world, int i2, int j2, int k, int iFacing) {
        return iFacing == apa.getOppositeFacing(this.getFacing(world, i2, j2, k));
    }

    @Override
    public int getNewMetadataRotatedAroundBlockOnTurntableToFacing(aab world, int i2, int j2, int k, int iInitialFacing, int iRotatedFacing) {
        int iOldMetadata = world.h(i2, j2, k);
        return this.setFacing(iOldMetadata, apa.getOppositeFacing(iRotatedFacing));
    }

    @Override
    public void onNeighborDisrupted(aab world, int i2, int j2, int k, int iToFacing) {
        if (iToFacing == apa.getOppositeFacing(this.getFacing(world, i2, j2, k))) {
            this.c(world, i2, j2, k, world.h(i2, j2, k), 0);
            world.setBlockWithNotify(i2, j2, k, 0);
        }
    }

    protected boolean canPlaceTorchOn(aab world, int i2, int j2, int k) {
        return WorldUtils.doesBlockHaveSmallCenterHardpointToFacing(world, i2, j2, k, 1, true);
    }

    protected boolean validateState(aab world, int i2, int j2, int k, int iNeighborID) {
        int iOrientation = this.getOrientation(world, i2, j2, k);
        int iFacing = 0;
        if (iOrientation != 0) {
            iFacing = 6 - iOrientation;
            boolean bShouldDrop = false;
            if (iFacing == 1) {
                if (!this.canPlaceTorchOn(world, i2, j2 - 1, k)) {
                    bShouldDrop = true;
                }
            } else {
                BlockPos targetPos = new BlockPos(i2, j2, k, apa.getOppositeFacing(iFacing));
                if (!WorldUtils.doesBlockHaveCenterHardpointToFacing(world, targetPos.x, targetPos.y, targetPos.z, iFacing)) {
                    bShouldDrop = true;
                }
            }
            if (bShouldDrop) {
                this.c(world, i2, j2, k, world.h(i2, j2, k), 0);
                world.setBlockWithNotify(i2, j2, k, 0);
                return true;
            }
        }
        return false;
    }

    public int getOrientation(aak blockAccess, int i2, int j2, int k) {
        return TorchBlockBase.getOrientation(blockAccess.h(i2, j2, k));
    }

    public static int getOrientation(int iMetadata) {
        return iMetadata & 7;
    }

    public void setOrientation(aab world, int i2, int j2, int k, int iOrientation) {
        int iMetadata = TorchBlockBase.setOrientation(world.h(i2, j2, k), iOrientation);
        world.setBlockMetadataWithNotify(i2, j2, k, iMetadata);
    }

    public static int setOrientation(int iMetadata, int iOrientation) {
        return (iMetadata &= 0xFFFFFFF8) | iOrientation;
    }

    public boolean isRainingOnTorch(aab world, int i2, int j2, int k) {
        return world.P() && world.isRainingAtPos(i2, j2, k);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderBlocks, int i2, int j2, int k) {
        return renderBlocks.c(this, i2, j2, k);
    }
}

