/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.FullBlock;
import btw.block.blocks.RoughStoneBlock;
import btw.item.BTWItems;
import btw.item.items.ChiselItem;
import btw.item.items.PickaxeItem;
import btw.item.items.ToolItem;
import btw.item.util.ItemUtils;
import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class StoneBlock
extends FullBlock {
    @Environment(value=EnvType.CLIENT)
    private lx[] iconByMetadataArray = new lx[16];

    public StoneBlock(int iBlockID) {
        super(iBlockID, aif.e);
        this.c(2.25f);
        this.b(10.0f);
        this.setPicksEffectiveOn();
        this.setChiselsEffectiveOn();
        this.a(j);
        this.c("stone");
        this.a(ve.b);
    }

    @Override
    public float l(aab world, int i2, int j2, int k) {
        int iStrata = this.getStrata(world, i2, j2, k);
        if (iStrata != 0) {
            if (iStrata == 1) {
                return 3.0f;
            }
            return 4.5f;
        }
        return super.l(world, i2, j2, k);
    }

    @Override
    public float getExplosionResistance(mp entity, aab world, int i2, int j2, int k) {
        int iStrata = this.getStrata(world, i2, j2, k);
        if (iStrata != 0) {
            if (iStrata == 1) {
                return 7.8f;
            }
            return 12.0f;
        }
        return super.getExplosionResistance(entity, world, i2, j2, k);
    }

    @Override
    public int a(int iMetaData, Random random, int iFortuneModifier) {
        return BTWBlocks.looseCobblestone.cz;
    }

    @Override
    public int a(int metadata) {
        return this.getStrata(metadata) << 2;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iMetadata, float fChance, int iFortuneModifier) {
        super.a(world, i2, j2, k, iMetadata, fChance, iFortuneModifier);
        if (!world.I) {
            this.b(world, i2, j2, k, new wm(BTWItems.stone, 1, this.getStrata(iMetadata)));
            if (!this.getIsCracked(iMetadata)) {
                this.b(world, i2, j2, k, new wm(BTWItems.gravelPile));
            }
        }
    }

    @Override
    public boolean dropComponentItemsOnBadBreak(aab world, int i2, int j2, int k, int iMetadata, float fChanceOfDrop) {
        this.dropItemsIndividually(world, i2, j2, k, BTWItems.stone.cp, 5, this.getStrata(iMetadata), fChanceOfDrop);
        int iNumGravel = this.getIsCracked(iMetadata) ? 2 : 3;
        this.dropItemsIndividually(world, i2, j2, k, BTWItems.gravelPile.cp, iNumGravel, 0, fChanceOfDrop);
        return true;
    }

    @Override
    public boolean canConvertBlock(wm stack, aab world, int i2, int j2, int k) {
        return true;
    }

    @Override
    public boolean convertBlock(wm stack, aab world, int i2, int j2, int k, int iFromSide) {
        int iMetadata = world.h(i2, j2, k);
        int iStrata = this.getStrata(iMetadata);
        int iToolLevel = this.getConversionLevelForTool(stack, world, i2, j2, k);
        if (this.getIsCracked(iMetadata)) {
            world.setBlockAndMetadataWithNotify(i2, j2, k, RoughStoneBlock.strataLevelBlockArray[iStrata].cz, 0);
            if (!world.I && iToolLevel > 0) {
                world.e(2269, i2, j2, k, 0);
                ItemUtils.ejectStackFromBlockTowardsFacing(world, i2, j2, k, new wm(BTWItems.stone, 1, iStrata), iFromSide);
            }
        } else if (iToolLevel == 2) {
            world.setBlockAndMetadataWithNotify(i2, j2, k, RoughStoneBlock.strataLevelBlockArray[iStrata].cz, 4);
            if (!world.I) {
                world.e(2269, i2, j2, k, 0);
                ItemUtils.ejectStackFromBlockTowardsFacing(world, i2, j2, k, new wm(BTWItems.stone, 3, iStrata), iFromSide);
                ItemUtils.ejectStackFromBlockTowardsFacing(world, i2, j2, k, new wm(BTWItems.gravelPile, 1), iFromSide);
            }
        } else if (iToolLevel == 3) {
            world.setBlockAndMetadataWithNotify(i2, j2, k, RoughStoneBlock.strataLevelBlockArray[iStrata].cz, 2);
            if (!world.I) {
                world.e(2269, i2, j2, k, 0);
                ItemUtils.ejectStackFromBlockTowardsFacing(world, i2, j2, k, new wm(BTWItems.stoneBrick, 1, iStrata), iFromSide);
                ItemUtils.ejectStackFromBlockTowardsFacing(world, i2, j2, k, new wm(BTWItems.gravelPile, 1), iFromSide);
            }
        } else {
            if (!world.I) {
                world.e(2270, i2, j2, k, 0);
                ItemUtils.ejectStackFromBlockTowardsFacing(world, i2, j2, k, new wm(BTWItems.gravelPile, 1), iFromSide);
            }
            this.setIsCracked(world, i2, j2, k, true);
        }
        return true;
    }

    @Override
    public int getHarvestToolLevel(aak blockAccess, int i2, int j2, int k) {
        int iStrata = this.getStrata(blockAccess, i2, j2, k);
        if (iStrata > 1) {
            return iStrata + 1;
        }
        return 2;
    }

    @Override
    public int getEfficientToolLevel(aak blockAccess, int i2, int j2, int k) {
        int iStrata = this.getStrata(blockAccess, i2, j2, k);
        if (iStrata > 0) {
            return iStrata + 1;
        }
        return 0;
    }

    @Override
    public boolean isNaturalStone(aak blockAccess, int i2, int j2, int k) {
        return true;
    }

    @Override
    public boolean isBlockInfestable(ng entity, int metadata) {
        return entity instanceof se;
    }

    @Override
    public int getBlockIDOnInfest(ng entity, int metadata) {
        int strata = this.getStrata(metadata);
        if (strata == 1) {
            return BTWBlocks.infestedMidStrataStone.cz;
        }
        if (strata == 2) {
            return BTWBlocks.infestedDeepStrataStone.cz;
        }
        return BTWBlocks.infestedStone.cz;
    }

    private int getConversionLevelForTool(wm stack, aab world, int i2, int j2, int k) {
        if (stack != null) {
            int iToolLevel;
            if (stack.b() instanceof PickaxeItem) {
                int iToolLevel2 = ((ToolItem)stack.b()).toolMaterial.d();
                if (iToolLevel2 >= this.getEfficientToolLevel(world, i2, j2, k)) {
                    return 2;
                }
            } else if (stack.b() instanceof ChiselItem && (iToolLevel = ((ToolItem)stack.b()).toolMaterial.d()) >= this.getEfficientToolLevel(world, i2, j2, k)) {
                if (iToolLevel >= this.getUberToolLevel(world, i2, j2, k)) {
                    return 3;
                }
                return 1;
            }
        }
        return 0;
    }

    public int getStrata(aak blockAccess, int i2, int j2, int k) {
        return this.getStrata(blockAccess.h(i2, j2, k));
    }

    public int getStrata(int iMetadata) {
        return iMetadata & 3;
    }

    public void setIsCracked(aab world, int i2, int j2, int k, boolean bCracked) {
        int iMetadata = this.setIsCracked(world.h(i2, j2, k), bCracked);
        world.setBlockMetadataWithNotify(i2, j2, k, iMetadata);
    }

    public int setIsCracked(int iMetadata, boolean bIsCracked) {
        iMetadata = bIsCracked ? (iMetadata |= 4) : (iMetadata &= 0xFFFFFFFB);
        return iMetadata;
    }

    public boolean getIsCracked(aak blockAccess, int i2, int j2, int k) {
        return this.getIsCracked(blockAccess.h(i2, j2, k));
    }

    public boolean getIsCracked(int iMetadata) {
        return (iMetadata & 4) != 0;
    }

    public int getUberToolLevel(aak blockAccess, int i2, int j2, int k) {
        return 2;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(int iBlockID, ve creativeTabs, List list) {
        list.add(new wm(iBlockID, 1, 0));
        list.add(new wm(iBlockID, 1, 1));
        list.add(new wm(iBlockID, 1, 2));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int h(aab world, int x2, int y2, int z2) {
        return world.h(x2, y2, z2);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        super.a(register);
        this.iconByMetadataArray[0] = this.cQ;
        this.iconByMetadataArray[1] = register.a("fcBlockStone_1");
        this.iconByMetadataArray[2] = register.a("fcBlockStone_2");
        this.iconByMetadataArray[3] = this.cQ;
        this.iconByMetadataArray[4] = register.a("fcBlockStone_cracked");
        this.iconByMetadataArray[5] = register.a("fcBlockStone_1_cracked");
        this.iconByMetadataArray[6] = register.a("fcBlockStone_2_cracked");
        this.iconByMetadataArray[7] = this.cQ;
        for (int iTempIndex = 8; iTempIndex < 16; ++iTempIndex) {
            this.iconByMetadataArray[iTempIndex] = this.cQ;
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        return this.iconByMetadataArray[iMetadata];
    }
}

