/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.WeedsBlock;
import btw.world.util.BlockPos;
import btw.world.util.WorldUtils;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class StemBlock
extends aor {
    private static final int STEM_TICK_RATE = 2;
    private static final double WIDTH = 0.25;
    private static final double HALF_WIDTH = 0.125;

    public StemBlock(int iBlockID, apa fruitBlock) {
        super(iBlockID, fruitBlock);
        this.c(0.0f);
        this.setBuoyant();
        this.initBlockBounds(0.375, 0.0, 0.375, 0.625, 0.25, 0.625);
        this.a(i);
        this.c("pumpkinStem");
    }

    @Override
    public int a(aab world) {
        return 2;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random rand) {
        this.e(world, i2, j2, k);
        if (world.a(i2, j2, k) == this.cz) {
            this.validateFruitState(world, i2, j2, k, rand);
        }
    }

    @Override
    public void randomUpdateTick(aab world, int i2, int j2, int k, Random rand) {
        this.a(world, i2, j2, k, rand);
        if (world.a(i2, j2, k) == this.cz && world.t.h != 1) {
            this.checkForGrowth(world, i2, j2, k, rand);
        }
    }

    @Override
    public boolean onBlockSawed(aab world, int i2, int j2, int k) {
        return false;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iMetadata, float fChance, int iFortuneModifier) {
    }

    @Override
    public void a(aak blockAccess, int i2, int j2, int k) {
    }

    @Override
    public void g() {
    }

    @Override
    public aqx getBlockBoundsFromPoolBasedOnState(aak blockAccess, int i2, int j2, int k) {
        double dMaxY;
        int iMetadata = blockAccess.h(i2, j2, k);
        if (iMetadata == 15 && !this.hasConnectedFruit(blockAccess, i2, j2, k)) {
            iMetadata = 7;
        }
        if ((dMaxY = (double)(iMetadata + 1) / 16.0) < 0.125) {
            dMaxY = 0.125;
        }
        double dHalfWidth = 0.125;
        int iWeedsGrowthLevel = this.getWeedsGrowthLevel(blockAccess, i2, j2, k);
        if (iWeedsGrowthLevel > 0) {
            dMaxY = Math.max(dMaxY, WeedsBlock.getWeedsBoundsHeight(iWeedsGrowthLevel));
            dHalfWidth = 0.375;
        }
        return aqx.a().a(0.5 - dHalfWidth, 0.0, 0.5 - dHalfWidth, 0.5 + dHalfWidth, dMaxY, 0.5 + dHalfWidth);
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iBlockID) {
        super.a(world, i2, j2, k, iBlockID);
        if (world.a(i2, j2, k) == this.cz) {
            this.validateFruitState(world, i2, j2, k, world.s);
        }
    }

    @Override
    public boolean canBeGrazedOn(aak blockAccess, int i2, int j2, int k, qh animal) {
        return true;
    }

    @Override
    protected boolean canGrowOnBlock(aab world, int i2, int j2, int k) {
        apa blockOn = apa.r[world.a(i2, j2, k)];
        return blockOn != null && blockOn.canDomesticatedCropsGrowOnBlock(world, i2, j2, k);
    }

    @Override
    public boolean canWeedsGrowInBlock(aak blockAccess, int i2, int j2, int k) {
        return true;
    }

    public void setFruitBlock(apa block) {
        this.a = block;
    }

    private boolean hasConnectedFruit(aak blockAccess, int i2, int j2, int k) {
        return this.getConnectedFruitDirection(blockAccess, i2, j2, k) > 0;
    }

    private int getConnectedFruitDirection(aak blockAccess, int i2, int j2, int k) {
        for (int iTempFacing = 2; iTempFacing < 6; ++iTempFacing) {
            BlockPos targetPos = new BlockPos(i2, j2, k);
            targetPos.addFacingAsOffset(iTempFacing);
            int iTempBlockID = blockAccess.a(targetPos.x, targetPos.y, targetPos.z);
            if (iTempBlockID != this.a.cz || !this.a.isBlockAttachedToFacing(blockAccess, targetPos.x, targetPos.y, targetPos.z, apa.getOppositeFacing(iTempFacing))) continue;
            return iTempFacing;
        }
        return -1;
    }

    private void validateFruitState(aab world, int i2, int j2, int k, Random rand) {
        int iMetadata = world.h(i2, j2, k);
        if (iMetadata == 15 && !this.hasConnectedFruit(world, i2, j2, k)) {
            world.setBlockMetadataWithNotify(i2, j2, k, 7);
        }
    }

    private void checkForGrowth(aab world, int i2, int j2, int k, Random rand) {
        apa blockBelow;
        if (this.getWeedsGrowthLevel(world, i2, j2, k) == 0 && world.n(i2, j2 + 1, k) >= 9 && (blockBelow = apa.r[world.a(i2, j2 - 1, k)]) != null && blockBelow.isBlockHydratedForPlantGrowthOn(world, i2, j2 - 1, k)) {
            float fGrowthChance = 0.2f * blockBelow.getPlantGrowthOnMultiplier(world, i2, j2 - 1, k, this);
            if (rand.nextFloat() <= fGrowthChance) {
                int iMetadata = world.h(i2, j2, k);
                if (iMetadata < 14) {
                    world.setBlockMetadataWithNotify(i2, j2, k, ++iMetadata);
                } else if (iMetadata == 14) {
                    BlockPos targetPos = new BlockPos(i2, j2, k);
                    int iTargetFacing = 0;
                    if (this.hasSpaceToGrow(world, i2, j2, k)) {
                        iTargetFacing = rand.nextInt(4) + 2;
                        targetPos.addFacingAsOffset(iTargetFacing);
                    }
                    if (this.canGrowFruitAt(world, targetPos.x, targetPos.y, targetPos.z)) {
                        blockBelow.notifyOfFullStagePlantGrowthOn(world, i2, j2 - 1, k, this);
                        world.setBlockWithNotify(targetPos.x, targetPos.y, targetPos.z, this.a.cz);
                        if (iTargetFacing != 0) {
                            this.a.attachToFacing(world, targetPos.x, targetPos.y, targetPos.z, apa.getOppositeFacing(iTargetFacing));
                            world.setBlockMetadataWithNotify(i2, j2, k, 15);
                        }
                    }
                }
            }
        }
    }

    protected boolean hasSpaceToGrow(aab world, int i2, int j2, int k) {
        for (int iTargetFacing = 2; iTargetFacing <= 5; ++iTargetFacing) {
            BlockPos targetPos = new BlockPos(i2, j2, k);
            targetPos.addFacingAsOffset(iTargetFacing);
            if (!this.canGrowFruitAt(world, targetPos.x, targetPos.y, targetPos.z)) continue;
            return true;
        }
        return false;
    }

    protected boolean canGrowFruitAt(aab world, int i2, int j2, int k) {
        int iBlockID = world.a(i2, j2, k);
        apa block = apa.r[iBlockID];
        return (WorldUtils.isReplaceableBlock(world, i2, j2, k) || block != null && block.cO == aif.k && iBlockID != apa.bT.cz) && (world.w(i2, j2 - 1, k) || this.canGrowOnBlock(world, i2, j2 - 1, k));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderer, int i2, int j2, int k) {
        renderer.setRenderBounds(this.getBlockBoundsFromPoolBasedOnState(renderer.a, i2, j2, k));
        renderer.l(this, i2, j2, k);
        BTWBlocks.weeds.renderWeeds(this, renderer, i2, j2, k);
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int b(int iMetadata) {
        int iRed = iMetadata * 16;
        int iGreen = 255 - iMetadata * 4;
        int iBlue = iMetadata * 2;
        return iRed << 16 | iGreen << 8 | iBlue;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int c(aak blockAccess, int i2, int j2, int k) {
        int iMetadata = blockAccess.h(i2, j2, k);
        if (iMetadata == 15 && !this.hasConnectedFruit(blockAccess, i2, j2, k)) {
            iMetadata = 7;
        }
        return this.b(iMetadata);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int d(aak blockAccess, int i2, int j2, int k) {
        int iFruitDirection;
        int iMetadata = blockAccess.h(i2, j2, k);
        if (iMetadata == 15 && (iFruitDirection = this.getConnectedFruitDirection(blockAccess, i2, j2, k)) > 0) {
            if (iFruitDirection == 2) {
                return 2;
            }
            if (iFruitDirection == 3) {
                return 3;
            }
            if (iFruitDirection == 4) {
                return 0;
            }
            if (iFruitDirection == 5) {
                return 1;
            }
        }
        return -1;
    }
}

