/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.util.Flammability;
import btw.item.util.ItemUtils;
import btw.util.MiscUtils;
import btw.world.util.BlockPos;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class StakeStringBlock
extends apa {
    public static final double HEIGHT = 0.015625;
    public static final double HALF_HEIGHT = 0.0078125;
    public static final double SELECTION_BOX_HEIGHT = 0.0625;
    public static final double SELECTION_BOX_HALF_HEIGHT = 0.03125;
    private static final long MIN_TIME_BETWEEN_LENGTH_DISPLAYS = 200L;
    static long timeOfLastLengthDisplay = 0L;
    static int lengthOfLastLengthDisplay = 0;

    public StakeStringBlock(int iBlockID) {
        super(iBlockID, aif.q);
        this.setAxesEffectiveOn(true);
        this.setFireProperties(Flammability.EXTREME);
        this.a(m);
        this.c("fcBlockStakeString");
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public ara a(aab world, int i2, int j2, int k, arc startRay, arc endRay) {
        ara rayIntersectPos = null;
        ara[] possibleIntersectPoints = new ara[8];
        int iCurrentIntersectIndex = 0;
        for (int iAxis = 0; iAxis < 3; ++iAxis) {
            if (!this.getExtendsAlongAxis(world, i2, j2, k, iAxis)) continue;
            arc boxMin = arc.a(0.0, 0.0, 0.0);
            arc boxMax = arc.a(0.0, 0.0, 0.0);
            this.getBlockBoundsForAxis(iAxis, boxMin, boxMax, 0.03125);
            possibleIntersectPoints[iCurrentIntersectIndex] = MiscUtils.rayTraceWithBox(world, i2, j2, k, boxMin, boxMax, startRay, endRay);
            if (possibleIntersectPoints[iCurrentIntersectIndex] == null) continue;
            ++iCurrentIntersectIndex;
        }
        if (iCurrentIntersectIndex > 0) {
            --iCurrentIntersectIndex;
            double dMaxDistance = 0.0;
            while (iCurrentIntersectIndex >= 0) {
                double dCurrentIntersectDistance = possibleIntersectPoints[iCurrentIntersectIndex].f.e(endRay);
                if (dCurrentIntersectDistance > dMaxDistance) {
                    rayIntersectPos = possibleIntersectPoints[iCurrentIntersectIndex];
                    dMaxDistance = dCurrentIntersectDistance;
                }
                --iCurrentIntersectIndex;
            }
        }
        return rayIntersectPos;
    }

    @Override
    public aqx b(aab world, int i2, int j2, int k) {
        return null;
    }

    @Override
    public int a(int iMetadata, Random random, int iFortuneModifier) {
        return wk.L.cp;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iMetadata, float fChance, int iFortuneModifier) {
        if (!world.I) {
            for (int iAxis = 0; iAxis < 3; ++iAxis) {
                if (!this.getExtendsAlongAxisFromMetadata(iMetadata, iAxis)) continue;
                ItemUtils.dropSingleItemAsIfBlockHarvested(world, i2, j2, k, this.a(iMetadata, world.s, iFortuneModifier), this.a(iMetadata));
            }
        }
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iNeighborBlockID) {
        this.validateState(world, i2, j2, k);
    }

    @Override
    public boolean a(aab world, int i2, int j2, int k, sq player, int iFacing, float fXClick, float fYClick, float fZClick) {
        int iLength = this.computeStringLength(world, i2, j2, k);
        double dInvertedLength = 64.0 - (double)iLength;
        if (!world.I) {
            float fPitch = (float)Math.pow(2.0, (dInvertedLength - 32.0) / 32.0);
            world.a((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "note.bass", 3.0f, fPitch - 0.0f);
        } else {
            world.a("note", (double)i2 + 0.5, (double)j2 + 1.2, (double)k + 0.5, dInvertedLength / 64.0, 0.0, 0.0);
            long lCurrentTime = world.I();
            long lDeltaTime = lCurrentTime - timeOfLastLengthDisplay;
            if (lDeltaTime < 0L || lDeltaTime >= 200L || lengthOfLastLengthDisplay != iLength) {
                player.b("Sounds like " + (iLength + 1) + ".");
                timeOfLastLengthDisplay = lCurrentTime;
                lengthOfLastLengthDisplay = iLength;
            }
        }
        return true;
    }

    @Override
    public boolean canGroundCoverRestOnBlock(aab world, int i2, int j2, int k) {
        return world.w(i2, j2 - 1, k);
    }

    @Override
    public float groundCoverRestingOnVisualOffset(aak blockAccess, int i2, int j2, int k) {
        return -1.0f;
    }

    public void setExtendsAlongAxis(aab world, int i2, int j2, int k, int iAxis, boolean bExtends) {
        this.setExtendsAlongAxis(world, i2, j2, k, iAxis, bExtends, true);
    }

    public void setExtendsAlongAxis(aab world, int i2, int j2, int k, int iAxis, boolean bExtends, boolean bNotify) {
        int iMetadata = world.h(i2, j2, k) & ~(1 << iAxis);
        if (bExtends) {
            iMetadata |= 1 << iAxis;
        }
        if (bNotify) {
            world.setBlockMetadataWithNotify(i2, j2, k, iMetadata);
        } else {
            world.setBlockMetadataWithClient(i2, j2, k, iMetadata);
        }
    }

    public void setExtendsAlongFacing(aab world, int i2, int j2, int k, int iFacing, boolean bExtends) {
        this.setExtendsAlongAxis(world, i2, j2, k, StakeStringBlock.convertFacingToAxis(iFacing), bExtends);
    }

    public void setExtendsAlongFacing(aab world, int i2, int j2, int k, int iFacing, boolean bExtends, boolean bNotify) {
        this.setExtendsAlongAxis(world, i2, j2, k, StakeStringBlock.convertFacingToAxis(iFacing), bExtends, bNotify);
    }

    public boolean getExtendsAlongAxis(aak blockAccess, int i2, int j2, int k, int iAxis) {
        return this.getExtendsAlongAxisFromMetadata(blockAccess.h(i2, j2, k), iAxis);
    }

    public boolean getExtendsAlongAxisFromMetadata(int iMetadata, int iAxis) {
        return (iMetadata & 1 << iAxis) > 0;
    }

    public boolean getExtendsAlongFacing(aak blockAccess, int i2, int j2, int k, int iFacing) {
        return this.getExtendsAlongAxis(blockAccess, i2, j2, k, StakeStringBlock.convertFacingToAxis(iFacing));
    }

    public boolean getExtendsAlongOtherFacing(aak blockAccess, int i2, int j2, int k, int iFacing) {
        return this.getExtendsAlongOtherAxis(blockAccess, i2, j2, k, StakeStringBlock.convertFacingToAxis(iFacing));
    }

    public boolean getExtendsAlongOtherAxis(aak blockAccess, int i2, int j2, int k, int iAxis) {
        return this.getExtendsAlongOtherAxisFromMetadata(blockAccess.h(i2, j2, k), iAxis);
    }

    public boolean getExtendsAlongOtherAxisFromMetadata(int iMetadata, int iAxis) {
        return ((iMetadata &= ~(1 << iAxis)) & 7) != 0;
    }

    public static int convertFacingToAxis(int iFacing) {
        if (iFacing == 4 || iFacing == 5) {
            return 0;
        }
        if (iFacing == 0 || iFacing == 1) {
            return 1;
        }
        return 2;
    }

    private void getBlockBoundsForAxis(int iAxis, arc min, arc max, double dHalfHeight) {
        if (iAxis == 0) {
            min.b(0.0, 0.5 - dHalfHeight, 0.5 - dHalfHeight);
            max.b(1.0, 0.5 + dHalfHeight, 0.5 + dHalfHeight);
        } else if (iAxis == 1) {
            min.b(0.5 - dHalfHeight, 0.0, 0.5 - dHalfHeight);
            max.b(0.5 + dHalfHeight, 1.0, 0.5 + dHalfHeight);
        } else {
            min.b(0.5 - dHalfHeight, 0.5 - dHalfHeight, 0.0);
            max.b(0.5 + dHalfHeight, 0.5 + dHalfHeight, 1.0);
        }
    }

    public void validateState(aab world, int i2, int j2, int k) {
        int iValidAxisCount = 0;
        for (int iTempAxis = 0; iTempAxis < 3; ++iTempAxis) {
            if (!this.getExtendsAlongAxis(world, i2, j2, k, iTempAxis)) continue;
            if (this.hasValidAttachmentPointsAlongAxis(world, i2, j2, k, iTempAxis)) {
                ++iValidAxisCount;
                continue;
            }
            this.setExtendsAlongAxis(world, i2, j2, k, iTempAxis, false);
            ItemUtils.dropSingleItemAsIfBlockHarvested(world, i2, j2, k, wk.L.cp, 0);
        }
        if (iValidAxisCount <= 0) {
            world.setBlockWithNotify(i2, j2, k, 0);
        }
    }

    private boolean hasValidAttachmentPointsAlongAxis(aab world, int i2, int j2, int k, int iAxis) {
        int iFacing2;
        int iFacing1;
        switch (iAxis) {
            case 0: {
                iFacing1 = 4;
                iFacing2 = 5;
                break;
            }
            case 1: {
                iFacing1 = 0;
                iFacing2 = 1;
                break;
            }
            default: {
                iFacing1 = 2;
                iFacing2 = 3;
            }
        }
        return this.hasValidAttachmentPointToFacing(world, i2, j2, k, iFacing1) && this.hasValidAttachmentPointToFacing(world, i2, j2, k, iFacing2);
    }

    private boolean hasValidAttachmentPointToFacing(aab world, int i2, int j2, int k, int iFacing) {
        BlockPos targetPos = new BlockPos(i2, j2, k);
        targetPos.addFacingAsOffset(iFacing);
        int iTargetBlockID = world.a(targetPos.x, targetPos.y, targetPos.z);
        return iTargetBlockID == this.cz ? this.getExtendsAlongFacing(world, targetPos.x, targetPos.y, targetPos.z, iFacing) : iTargetBlockID == BTWBlocks.stake.cz;
    }

    protected int computeStringLength(aab world, int i2, int j2, int k) {
        int iLength = 0;
        for (int iAxis = 0; iAxis < 3; ++iAxis) {
            int iAxisLength = this.computeStringLengthAlongAxis(world, i2, j2, k, iAxis);
            if (iAxisLength <= iLength) continue;
            iLength = iAxisLength;
        }
        return iLength;
    }

    protected int computeStringLengthAlongAxis(aab world, int i2, int j2, int k, int iAxis) {
        int iLength = 0;
        if (this.getExtendsAlongAxis(world, i2, j2, k, iAxis)) {
            int iTempFacing = this.getFirstFacingForAxis(iAxis);
            iLength = this.computeStringLengthToFacing(world, i2, j2, k, iTempFacing);
            iTempFacing = apa.getOppositeFacing(iTempFacing);
            iLength += this.computeStringLengthToFacing(world, i2, j2, k, iTempFacing);
            ++iLength;
        }
        return iLength;
    }

    protected int computeStringLengthToFacing(aab world, int i2, int j2, int k, int iFacing) {
        int iLength = 0;
        BlockPos tempPos = new BlockPos(i2, j2, k, iFacing);
        while (world.f(tempPos.x, tempPos.y, tempPos.z) && world.a(tempPos.x, tempPos.y, tempPos.z) == this.cz) {
            ++iLength;
            tempPos.addFacingAsOffset(iFacing);
        }
        return iLength;
    }

    protected int getFirstFacingForAxis(int iAxis) {
        if (iAxis == 0) {
            return 4;
        }
        if (iAxis == 1) {
            return 0;
        }
        return 2;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        int iAxis;
        BlockPos myPos = new BlockPos(iNeighborI, iNeighborJ, iNeighborK, StakeStringBlock.getOppositeFacing(iSide));
        int iMetadata = blockAccess.h(myPos.x, myPos.y, myPos.z);
        if (this.getExtendsAlongAxisFromMetadata(iMetadata, iAxis = StakeStringBlock.convertFacingToAxis(iSide))) {
            return this.getExtendsAlongOtherAxisFromMetadata(iMetadata, iAxis);
        }
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public aqx c_(aab world, int i2, int j2, int k) {
        double minXBox = (double)i2 + 0.5 - 0.03125;
        double minYBox = (double)j2 + 0.5 - 0.03125;
        double minZBox = (double)k + 0.5 - 0.03125;
        double maxXBox = (double)i2 + 0.5 + 0.03125;
        double maxYBox = (double)j2 + 0.5 + 0.03125;
        double maxZBox = (double)k + 0.5 + 0.03125;
        if (this.getExtendsAlongAxis(world, i2, j2, k, 0)) {
            minXBox = i2;
            maxXBox = (double)i2 + 1.0;
        }
        if (this.getExtendsAlongAxis(world, i2, j2, k, 1)) {
            minYBox = j2;
            maxYBox = (double)j2 + 1.0;
        }
        if (this.getExtendsAlongAxis(world, i2, j2, k, 2)) {
            minZBox = k;
            maxZBox = (double)k + 1.0;
        }
        return aqx.a().a(minXBox, minYBox, minZBox, maxXBox, maxYBox, maxZBox);
    }

    @Environment(value=EnvType.CLIENT)
    private void setRenderBoundsForAxis(bgf renderBlocks, int iAxis) {
        arc min = arc.a(0.0, 0.0, 0.0);
        arc max = arc.a(0.0, 0.0, 0.0);
        this.getBlockBoundsForAxis(iAxis, min, max, 0.0078125);
        renderBlocks.a((float)min.c, (float)min.d, (double)((float)min.e), (double)((float)max.c), (double)((float)max.d), (double)((float)max.e));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int d(aab world, int i2, int j2, int k) {
        return this.a(world.h(i2, j2, k), world.s, 0);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderBlocks, int i2, int j2, int k) {
        aak blockAccess = renderBlocks.a;
        for (int iAxis = 0; iAxis < 3; ++iAxis) {
            if (!this.getExtendsAlongAxis(blockAccess, i2, j2, k, iAxis)) continue;
            this.setRenderBoundsForAxis(renderBlocks, iAxis);
            renderBlocks.p(this, i2, j2, k);
        }
        return true;
    }
}

