/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.StakeStringBlock;
import btw.block.util.Flammability;
import btw.client.render.util.RenderUtils;
import btw.item.BTWItems;
import btw.item.util.ItemUtils;
import btw.util.MiscUtils;
import btw.world.util.BlockPos;
import btw.world.util.WorldUtils;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class StakeBlock
extends apa {
    private final double blockHeight = 0.625;
    private final double blockWidth = 0.25;
    private final double blockHalfWidth = 0.125;
    @Environment(value=EnvType.CLIENT)
    private static final int TOP_TEXTURE_INDEX = 142;
    @Environment(value=EnvType.CLIENT)
    private static final int TOP_WITH_STRING_TEXTURE_INDEX = 143;
    @Environment(value=EnvType.CLIENT)
    private static final int SIDE_TEXTURE_INDEX = 144;
    @Environment(value=EnvType.CLIENT)
    private static final int SIDE_WITH_TOP_STRING_TEXTURE_INDEX = 145;
    @Environment(value=EnvType.CLIENT)
    private lx iconTop;
    @Environment(value=EnvType.CLIENT)
    private lx iconTopWithString;
    @Environment(value=EnvType.CLIENT)
    private lx iconSide;
    @Environment(value=EnvType.CLIENT)
    private lx iconSideWithString;
    @Environment(value=EnvType.CLIENT)
    private lx iconString;

    public StakeBlock(int iBlockID) {
        super(iBlockID, aif.d);
        this.c(2.0f);
        this.b(5.0f);
        this.setAxesEffectiveOn(true);
        this.setFireProperties(Flammability.PLANKS);
        this.a(g);
        this.c("fcBlockStake");
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public boolean c(aab world, int i2, int j2, int k) {
        for (int iFacing = 0; iFacing < 6; ++iFacing) {
            BlockPos targetPos = new BlockPos(i2, j2, k, iFacing);
            if (!WorldUtils.doesBlockHaveCenterHardpointToFacing(world, targetPos.x, targetPos.y, targetPos.z, apa.getOppositeFacing(iFacing))) continue;
            return true;
        }
        return false;
    }

    @Override
    public int a(aab world, int i2, int j2, int k, int iFacing, float fClickX, float fClickY, float fClickZ, int iMetadata) {
        BlockPos targetPos = new BlockPos(i2, j2, k, apa.getOppositeFacing(iFacing));
        if (!WorldUtils.doesBlockHaveCenterHardpointToFacing(world, targetPos.x, targetPos.y, targetPos.z, iFacing)) {
            iFacing = this.findValidFacing(world, i2, j2, k);
        }
        return this.setFacing(iMetadata, iFacing);
    }

    @Override
    public aqx getBlockBoundsFromPoolBasedOnState(aak blockAccess, int i2, int j2, int k) {
        aqx box = aqx.a().a(0.375, 0.0, 0.375, 0.625, 0.625, 0.625);
        box.tiltToFacingAlongY(this.getFacing(blockAccess, i2, j2, k));
        return box;
    }

    @Override
    public int a(int iMetaData, Random random, int iFortuneModifier) {
        return BTWItems.stake.cp;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iNeighborBlockID) {
        int iFacing = this.getFacing(world, i2, j2, k);
        BlockPos anchorPos = new BlockPos(i2, j2, k, apa.getOppositeFacing(iFacing));
        if (!WorldUtils.doesBlockHaveCenterHardpointToFacing(world, anchorPos.x, anchorPos.y, anchorPos.z, iFacing)) {
            this.c(world, i2, j2, k, world.h(i2, j2, k), 0);
            world.setBlockWithNotify(i2, j2, k, 0);
        }
    }

    @Override
    public boolean a(aab world, int i2, int j2, int k, sq player, int iFacing, float fXClick, float fYClick, float fZClick) {
        int iStringStackSize;
        wm equippedItem = player.cd();
        int iTargetFacing = apa.getOppositeFacing(MiscUtils.convertPlacingEntityOrientationToBlockFacingReversed(player));
        if (this.hasConnectedStringToFacing(world, i2, j2, k, iTargetFacing)) {
            if (!world.I) {
                int iStringCount = this.clearStringToFacingNoDrop(world, i2, j2, k, iTargetFacing);
                if (iStringCount > 0) {
                    ItemUtils.dropStackAsIfBlockHarvested(world, i2, j2, k, new wm(wk.L.cp, iStringCount, 0));
                }
                world.a((mp)player, "random.bow", 0.25f, world.s.nextFloat() * 0.4f + 1.2f);
            }
            return true;
        }
        if (equippedItem != null && equippedItem.b().cp == wk.L.cp && (iStringStackSize = equippedItem.a) > 0) {
            int iStakeFacing = this.getFacing(world, i2, j2, k);
            int iDistanceToOtherStake = this.checkForValidConnectingStakeToFacing(world, i2, j2, k, iTargetFacing, iStringStackSize);
            if (iDistanceToOtherStake <= 0) {
                int iYawOctant = kx.c((double)(player.A * 8.0f / 360.0f)) & 7;
                iTargetFacing = iYawOctant >= 0 && iYawOctant <= 3 ? 4 : 5;
                iDistanceToOtherStake = this.checkForValidConnectingStakeToFacing(world, i2, j2, k, iTargetFacing, iStringStackSize);
                if (iDistanceToOtherStake <= 0) {
                    iTargetFacing = iYawOctant >= 2 && iYawOctant <= 5 ? 2 : 3;
                }
                if ((iDistanceToOtherStake = this.checkForValidConnectingStakeToFacing(world, i2, j2, k, iTargetFacing, iStringStackSize)) <= 0) {
                    iTargetFacing = player.B > 0.0f ? 0 : 1;
                    iDistanceToOtherStake = this.checkForValidConnectingStakeToFacing(world, i2, j2, k, iTargetFacing, iStringStackSize);
                }
            }
            if (iDistanceToOtherStake > 0) {
                if (!world.I) {
                    int iTempDistance;
                    StakeStringBlock stringBlock = (StakeStringBlock)BTWBlocks.stakeString;
                    BlockPos tempPos = new BlockPos(i2, j2, k);
                    for (iTempDistance = 0; iTempDistance < iDistanceToOtherStake; ++iTempDistance) {
                        tempPos.addFacingAsOffset(iTargetFacing);
                        int iTargetBlockID = world.a(tempPos.x, tempPos.y, tempPos.z);
                        if (iTargetBlockID != stringBlock.cz) {
                            world.f(tempPos.x, tempPos.y, tempPos.z, stringBlock.cz, 0, 2);
                        }
                        stringBlock.setExtendsAlongFacing(world, tempPos.x, tempPos.y, tempPos.z, iTargetFacing, true, false);
                        if (player.ce.d) continue;
                        --equippedItem.a;
                    }
                    tempPos = new BlockPos(i2, j2, k);
                    for (iTempDistance = 0; iTempDistance < iDistanceToOtherStake; ++iTempDistance) {
                        tempPos.addFacingAsOffset(iTargetFacing);
                        world.d(tempPos.x, tempPos.y, tempPos.z, BTWBlocks.stakeString.cz);
                    }
                    world.a((mp)player, "random.bow", 0.25f, world.s.nextFloat() * 0.2f + 0.8f);
                } else if (!player.ce.d) {
                    equippedItem.a -= iDistanceToOtherStake;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int getFacing(int iMetadata) {
        return iMetadata & 7;
    }

    @Override
    public int setFacing(int iMetadata, int iFacing) {
        iMetadata &= 0xFFFFFFF8;
        return iMetadata |= iFacing;
    }

    @Override
    public boolean canRotateAroundBlockOnTurntableToFacing(aab world, int i2, int j2, int k, int iFacing) {
        return iFacing == apa.getOppositeFacing(this.getFacing(world, i2, j2, k));
    }

    @Override
    public int getNewMetadataRotatedAroundBlockOnTurntableToFacing(aab world, int i2, int j2, int k, int iInitialFacing, int iRotatedFacing) {
        int iMetadata = world.h(i2, j2, k);
        return this.setFacing(iMetadata, apa.getOppositeFacing(iRotatedFacing));
    }

    @Override
    public boolean canGroundCoverRestOnBlock(aab world, int i2, int j2, int k) {
        return world.w(i2, j2 - 1, k);
    }

    @Override
    public float groundCoverRestingOnVisualOffset(aak blockAccess, int i2, int j2, int k) {
        return -1.0f;
    }

    private int checkForValidConnectingStakeToFacing(aab world, int i2, int j2, int k, int iFacing, int iMaxDistance) {
        StakeStringBlock stringBlock = (StakeStringBlock)BTWBlocks.stakeString;
        BlockPos tempPos = new BlockPos(i2, j2, k);
        boolean bFoundOtherStake = false;
        for (int iDistanceToOtherStake = 0; iDistanceToOtherStake <= iMaxDistance; ++iDistanceToOtherStake) {
            tempPos.addFacingAsOffset(iFacing);
            if (world.c(tempPos.x, tempPos.y, tempPos.z)) continue;
            int iTargetBlockID = world.a(tempPos.x, tempPos.y, tempPos.z);
            if (iTargetBlockID == this.cz) {
                return iDistanceToOtherStake;
            }
            if (iTargetBlockID == stringBlock.cz) {
                if (!stringBlock.getExtendsAlongFacing(world, tempPos.x, tempPos.y, tempPos.z, iFacing)) continue;
                return 0;
            }
            apa tempBlock = apa.r[iTargetBlockID];
            if (tempBlock.cO.j() && !tempBlock.cO.d()) continue;
            return 0;
        }
        return 0;
    }

    private int findValidFacing(aab world, int i2, int j2, int k) {
        for (int iFacing = 0; iFacing < 6; ++iFacing) {
            BlockPos targetPos = new BlockPos(i2, j2, k, iFacing);
            if (!WorldUtils.doesBlockHaveCenterHardpointToFacing(world, targetPos.x, targetPos.y, targetPos.z, apa.getOppositeFacing(iFacing))) continue;
            return apa.getOppositeFacing(iFacing);
        }
        return 0;
    }

    public boolean hasConnectedStringToFacing(aak blockAccess, int i2, int j2, int k, int iFacing) {
        StakeStringBlock stringBlock = (StakeStringBlock)BTWBlocks.stakeString;
        BlockPos targetPos = new BlockPos(i2, j2, k);
        targetPos.addFacingAsOffset(iFacing);
        int iTargetBlockID = blockAccess.a(targetPos.x, targetPos.y, targetPos.z);
        if (iTargetBlockID == stringBlock.cz) {
            return stringBlock.getExtendsAlongFacing(blockAccess, targetPos.x, targetPos.y, targetPos.z, iFacing);
        }
        return false;
    }

    private int clearStringToFacingNoDrop(aab world, int i2, int j2, int k, int iTargetFacing) {
        int iStringCount = 0;
        BlockPos tempPos = new BlockPos(i2, j2, k);
        do {
            StakeStringBlock stringBlock;
            tempPos.addFacingAsOffset(iTargetFacing);
            if (world.a(tempPos.x, tempPos.y, tempPos.z) != BTWBlocks.stakeString.cz || !(stringBlock = (StakeStringBlock)BTWBlocks.stakeString).getExtendsAlongFacing(world, tempPos.x, tempPos.y, tempPos.z, iTargetFacing)) break;
            if (stringBlock.getExtendsAlongOtherFacing(world, tempPos.x, tempPos.y, tempPos.z, iTargetFacing)) {
                stringBlock.setExtendsAlongFacing(world, tempPos.x, tempPos.y, tempPos.z, iTargetFacing, false, false);
                continue;
            }
            world.f(tempPos.x, tempPos.y, tempPos.z, 0, 0, 2);
        } while (++iStringCount < 64);
        if (iStringCount > 0) {
            tempPos = new BlockPos(i2, j2, k);
            for (int iTempCount = 0; iTempCount < iStringCount; ++iTempCount) {
                tempPos.addFacingAsOffset(iTargetFacing);
                world.d(tempPos.x, tempPos.y, tempPos.z, BTWBlocks.stakeString.cz);
            }
        }
        return iStringCount;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        lx sideIcon;
        this.cQ = sideIcon = register.a("fcBlockStake_side");
        this.iconTop = register.a("fcBlockStake_top");
        this.iconTopWithString = register.a("fcBlockStake_top_string");
        this.iconSide = sideIcon;
        this.iconSideWithString = register.a("fcBlockStake_side_string");
        this.iconString = register.a("fcBlockStakeString");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx b_(aak blockAccess, int i2, int j2, int k, int iSide) {
        int iFacing = this.getFacing(blockAccess, i2, j2, k);
        boolean bTopConnectedString = this.hasConnectedStringToFacing(blockAccess, i2, j2, k, iFacing);
        if (iSide == iFacing || iSide == apa.getOppositeFacing(iFacing)) {
            if (!bTopConnectedString) {
                return this.iconTop;
            }
            return this.iconTopWithString;
        }
        if (!bTopConnectedString) {
            return this.iconSide;
        }
        return this.iconSideWithString;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    private aqx getBoundsFromPoolForStringToFacing(int iFacing) {
        aqx box = aqx.a().a(0.4921875, 0.5, 0.4921875, 0.5078125, 1.0, 0.5078125);
        box.tiltToFacingAlongY(iFacing);
        return box;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int d(aab world, int i2, int j2, int k) {
        return this.a(world.h(i2, j2, k), world.s, 0);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderer, int i2, int j2, int k) {
        aak blockAccess = renderer.a;
        int iFacing = this.getFacing(blockAccess, i2, j2, k);
        if (iFacing == 0) {
            renderer.setUVRotateSouth(3);
            renderer.setUVRotateNorth(3);
            renderer.setUVRotateEast(3);
            renderer.setUVRotateWest(3);
        } else if (iFacing == 2) {
            renderer.setUVRotateSouth(1);
            renderer.setUVRotateNorth(2);
        } else if (iFacing == 3) {
            renderer.setUVRotateSouth(2);
            renderer.setUVRotateNorth(1);
            renderer.setUVRotateTop(3);
            renderer.setUVRotateBottom(3);
        } else if (iFacing == 4) {
            renderer.setUVRotateEast(1);
            renderer.setUVRotateWest(2);
            renderer.setUVRotateTop(2);
            renderer.setUVRotateBottom(1);
        } else if (iFacing == 5) {
            renderer.setUVRotateEast(2);
            renderer.setUVRotateWest(1);
            renderer.setUVRotateTop(1);
            renderer.setUVRotateBottom(2);
        }
        renderer.setRenderBounds(this.getBlockBoundsFromPoolBasedOnState(renderer.a, i2, j2, k));
        renderer.p(this, i2, j2, k);
        renderer.clearUVRotation();
        lx stringTexture = this.iconString;
        for (int iStringFacing = 0; iStringFacing < 6; ++iStringFacing) {
            if (!this.hasConnectedStringToFacing(blockAccess, i2, j2, k, iStringFacing)) continue;
            renderer.setRenderBounds(this.getBoundsFromPoolForStringToFacing(iStringFacing));
            RenderUtils.renderStandardBlockWithTexture(renderer, this, i2, j2, k, stringTexture);
        }
        return true;
    }
}

