/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.util.RayTraceUtils;
import btw.world.util.BlockPos;
import btw.world.util.WorldUtils;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class StairsBlockBase
extends apa {
    @Environment(value=EnvType.CLIENT)
    private boolean renderingBase = false;

    protected StairsBlockBase(int iBlockID, aif material) {
        super(iBlockID, material);
        this.k(255);
        apa.w[iBlockID] = true;
        this.a(ve.c);
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public int d() {
        return 10;
    }

    @Override
    public void a(aab world, int i2, int j2, int k) {
        this.notifyAllNearbyBlocksFlat(world, i2, j2, k);
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iBlockID, int iMetadata) {
        this.notifyAllNearbyBlocksFlat(world, i2, j2, k);
    }

    @Override
    public int preBlockPlacedBy(aab world, int i2, int j2, int k, int iMetadata, ng entityBy) {
        int iFlatFacing = kx.d(entityBy.A * 4.0f / 360.0f + 0.5f) & 3;
        iMetadata = iFlatFacing == 0 ? this.setDirection(iMetadata, 2) : (iFlatFacing == 1 ? this.setDirection(iMetadata, 1) : (iFlatFacing == 2 ? this.setDirection(iMetadata, 3) : this.setDirection(iMetadata, 0)));
        return this.validateMetadataForLocation(world, i2, j2, k, iMetadata);
    }

    @Override
    public int a(aab world, int i2, int j2, int k, int iFacing, float fClickX, float fClickY, float fClickZ, int iMetadata) {
        if (iFacing == 0 || iFacing != 1 && (double)fClickY > 0.5) {
            iMetadata = this.setUpsideDown(iMetadata);
        }
        return iMetadata;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, aqx intersectingBox, List list, mp entity) {
        aqx tertiaryBox;
        int iTertiaryFacing;
        aqx baseBox = this.getBoundsFromPoolForBase(world, i2, j2, k).d(i2, j2, k);
        baseBox.addToListIfIntersects(intersectingBox, list);
        aqx secondaryBox = aqx.a().a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        boolean bIsFullStep = this.getBoundsForSecondaryPiece(world, i2, j2, k, secondaryBox);
        secondaryBox.d(i2, j2, k);
        secondaryBox.addToListIfIntersects(intersectingBox, list);
        if (bIsFullStep && (iTertiaryFacing = this.getBoundsForTertiaryPiece(world, i2, j2, k, tertiaryBox = aqx.a().a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0))) >= 0) {
            tertiaryBox.d(i2, j2, k);
            tertiaryBox.addToListIfIntersects(intersectingBox, list);
        }
    }

    @Override
    public ara a(aab world, int i2, int j2, int k, arc startVec, arc endVec) {
        aqx tertiaryBox;
        int iTertiaryFacing;
        RayTraceUtils rayTrace = new RayTraceUtils(world, i2, j2, k, startVec, endVec);
        aqx baseBox = this.getBoundsFromPoolForBase(world, i2, j2, k);
        rayTrace.addBoxWithLocalCoordsToIntersectionList(baseBox);
        aqx secondaryBox = aqx.a().a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        boolean bIsFullStep = this.getBoundsForSecondaryPiece(world, i2, j2, k, secondaryBox);
        rayTrace.addBoxWithLocalCoordsToIntersectionList(secondaryBox);
        if (bIsFullStep && (iTertiaryFacing = this.getBoundsForTertiaryPiece(world, i2, j2, k, tertiaryBox = aqx.a().a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0))) >= 0) {
            rayTrace.addBoxWithLocalCoordsToIntersectionList(tertiaryBox);
        }
        return rayTrace.getFirstIntersection();
    }

    @Override
    public boolean hasLargeCenterHardPointToFacing(aak blockAccess, int i2, int j2, int k, int iFacing, boolean bIgnoreTransparency) {
        if (iFacing == 0) {
            return !this.getIsUpsideDown(blockAccess, i2, j2, k);
        }
        if (iFacing == 1) {
            return this.getIsUpsideDown(blockAccess, i2, j2, k);
        }
        int iBlockFacing = this.convertDirectionToFacing(this.getDirection(blockAccess, i2, j2, k));
        if (iFacing == iBlockFacing) {
            return true;
        }
        if (iFacing != apa.getOppositeFacing(iBlockFacing)) {
            return this.hasSecondaryFullSurfaceToFacing(blockAccess, i2, j2, k, iFacing);
        }
        return false;
    }

    @Override
    public boolean isStairBlock() {
        return true;
    }

    @Override
    protected boolean r_() {
        return true;
    }

    @Override
    public boolean hasContactPointToFullFace(aak blockAccess, int i2, int j2, int k, int iFacing) {
        return true;
    }

    @Override
    public boolean hasContactPointToSlabSideFace(aak blockAccess, int i2, int j2, int k, int iFacing, boolean bIsSlabUpsideDown) {
        int iStairFacing = this.convertDirectionToFacing(this.getDirection(blockAccess, i2, j2, k));
        if (iFacing == apa.getOppositeFacing(iStairFacing)) {
            return this.getIsUpsideDown(blockAccess, i2, j2, k) == bIsSlabUpsideDown;
        }
        return true;
    }

    @Override
    public boolean hasContactPointToStairNarrowVerticalFace(aak blockAccess, int i2, int j2, int k, int iFacing, int iStairFacing) {
        boolean bIsUpsideDown = this.getIsUpsideDown(blockAccess, i2, j2, k);
        if (bIsUpsideDown == (iFacing == 1)) {
            return true;
        }
        int iMyStairFacing = this.convertDirectionToFacing(this.getDirection(blockAccess, i2, j2, k));
        return iMyStairFacing != apa.getOppositeFacing(iStairFacing);
    }

    @Override
    public boolean hasNeighborWithMortarInContact(aab world, int i2, int j2, int k) {
        int iFacing = this.convertDirectionToFacing(this.getDirection(world, i2, j2, k));
        boolean bIsUpsideDown = this.getIsUpsideDown(world, i2, j2, k);
        return this.hasNeighborWithMortarInContact(world, i2, j2, k, iFacing, bIsUpsideDown);
    }

    @Override
    public boolean canRotateOnTurntable(aak blockAccess, int i2, int j2, int k) {
        return true;
    }

    @Override
    public boolean canTransmitRotationVerticallyOnTurntable(aak blockAccess, int i2, int j2, int k) {
        return true;
    }

    @Override
    public int rotateMetadataAroundJAxis(int iMetadata, boolean bReverse) {
        int iDirection = (iMetadata & 3) + 2;
        iDirection = apa.rotateFacingAroundY(iDirection, !bReverse);
        return iMetadata & 0xFFFFFFFC | iDirection - 2;
    }

    @Override
    public boolean canMobsSpawnOn(aab world, int i2, int j2, int k) {
        return this.cO.getMobsCanSpawnOn(world.t.h);
    }

    protected int validateMetadataForLocation(aab world, int i2, int j2, int k, int iMetadata) {
        return iMetadata;
    }

    public boolean hasNeighborWithMortarInContact(aab world, int i2, int j2, int k, int iFacing, boolean bIsUpsideDown) {
        if (!bIsUpsideDown ? WorldUtils.hasNeighborWithMortarInFullFaceContactToFacing(world, i2, j2, k, 0) || WorldUtils.hasNeighborWithMortarInStairNarrowVerticalContactToFacing(world, i2, j2, k, 1, iFacing) : WorldUtils.hasNeighborWithMortarInFullFaceContactToFacing(world, i2, j2, k, 1) || WorldUtils.hasNeighborWithMortarInStairNarrowVerticalContactToFacing(world, i2, j2, k, 0, iFacing)) {
            return true;
        }
        int iHalfBlockFacing = apa.getOppositeFacing(iFacing);
        for (int iTempFacing = 2; iTempFacing < 6; ++iTempFacing) {
            if (!(iTempFacing == iHalfBlockFacing ? WorldUtils.hasNeighborWithMortarInSlabSideContactToFacing(world, i2, j2, k, iTempFacing, bIsUpsideDown) : WorldUtils.hasNeighborWithMortarInStairShapedContactToFacing(world, i2, j2, k, iTempFacing))) continue;
            return true;
        }
        return false;
    }

    protected int convertDirectionToFacing(int iDirection) {
        int iFacing = 5 - iDirection;
        return iFacing;
    }

    protected aqx getBoundsFromPoolForBase(aak blockAccess, int i2, int j2, int k) {
        return this.getBoundsFromPoolForBase(blockAccess.h(i2, j2, k));
    }

    protected aqx getBoundsFromPoolForBase(int iMetadata) {
        if (this.getIsUpsideDown(iMetadata)) {
            return aqx.a().a(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
        }
        return aqx.a().a(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    }

    protected boolean getBoundsForSecondaryPiece(aak blockAccess, int i2, int j2, int k, aqx box) {
        int iMetadata = blockAccess.h(i2, j2, k);
        int iBlockDir = this.getDirection(iMetadata);
        boolean bUpsideDown = this.getIsUpsideDown(iMetadata);
        box.b = 0.5;
        box.e = 1.0;
        if (bUpsideDown) {
            box.b = 0.0;
            box.e = 0.5;
        }
        box.a = 0.0;
        box.c = 0.0;
        box.d = 1.0;
        box.f = 0.5;
        boolean bIsFullStep = true;
        if (iBlockDir == 0) {
            box.a = 0.5;
            box.f = 1.0;
            int iNeighborID = blockAccess.a(i2 + 1, j2, k);
            int iNeighborMetadata = blockAccess.h(i2 + 1, j2, k);
            if (this.isStairBlock(iNeighborID) && (iMetadata & 4) == (iNeighborMetadata & 4)) {
                int iNeighborDir = iNeighborMetadata & 3;
                if (iNeighborDir == 3 && !this.isStairBlockWithMetadata(blockAccess, i2, j2, k + 1, iMetadata)) {
                    box.f = 0.5;
                    bIsFullStep = false;
                } else if (iNeighborDir == 2 && !this.isStairBlockWithMetadata(blockAccess, i2, j2, k - 1, iMetadata)) {
                    box.c = 0.5;
                    bIsFullStep = false;
                }
            }
        } else if (iBlockDir == 1) {
            box.d = 0.5;
            box.f = 1.0;
            int iNeighborID = blockAccess.a(i2 - 1, j2, k);
            int iNeighborMetadata = blockAccess.h(i2 - 1, j2, k);
            if (this.isStairBlock(iNeighborID) && (iMetadata & 4) == (iNeighborMetadata & 4)) {
                int iNeighborDir = iNeighborMetadata & 3;
                if (iNeighborDir == 3 && !this.isStairBlockWithMetadata(blockAccess, i2, j2, k + 1, iMetadata)) {
                    box.f = 0.5;
                    bIsFullStep = false;
                } else if (iNeighborDir == 2 && !this.isStairBlockWithMetadata(blockAccess, i2, j2, k - 1, iMetadata)) {
                    box.c = 0.5;
                    bIsFullStep = false;
                }
            }
        } else if (iBlockDir == 2) {
            box.c = 0.5;
            box.f = 1.0;
            int iNeighborID = blockAccess.a(i2, j2, k + 1);
            int iNeighborMetadata = blockAccess.h(i2, j2, k + 1);
            if (this.isStairBlock(iNeighborID) && (iMetadata & 4) == (iNeighborMetadata & 4)) {
                int iNeighborDir = iNeighborMetadata & 3;
                if (iNeighborDir == 1 && !this.isStairBlockWithMetadata(blockAccess, i2 + 1, j2, k, iMetadata)) {
                    box.d = 0.5;
                    bIsFullStep = false;
                } else if (iNeighborDir == 0 && !this.isStairBlockWithMetadata(blockAccess, i2 - 1, j2, k, iMetadata)) {
                    box.a = 0.5;
                    bIsFullStep = false;
                }
            }
        } else if (iBlockDir == 3) {
            int iNeighborID = blockAccess.a(i2, j2, k - 1);
            int iNeighborMetadata = blockAccess.h(i2, j2, k - 1);
            if (this.isStairBlock(iNeighborID) && (iMetadata & 4) == (iNeighborMetadata & 4)) {
                int iNeighborDir = iNeighborMetadata & 3;
                if (iNeighborDir == 1 && !this.isStairBlockWithMetadata(blockAccess, i2 + 1, j2, k, iMetadata)) {
                    box.d = 0.5;
                    bIsFullStep = false;
                } else if (iNeighborDir == 0 && !this.isStairBlockWithMetadata(blockAccess, i2 - 1, j2, k, iMetadata)) {
                    box.a = 0.5;
                    bIsFullStep = false;
                }
            }
        }
        return bIsFullStep;
    }

    protected aqx getBoundsFromPoolForSecondaryPiece(int iMetadata) {
        aqx box = aqx.a().a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        int iBlockDir = this.getDirection(iMetadata);
        boolean bUpsideDown = this.getIsUpsideDown(iMetadata);
        box.b = 0.5;
        box.e = 1.0;
        if (bUpsideDown) {
            box.b = 0.0;
            box.e = 0.5;
        }
        box.a = 0.0;
        box.c = 0.0;
        box.d = 1.0;
        box.f = 0.5;
        if (iBlockDir == 0) {
            box.a = 0.5;
            box.f = 1.0;
        } else if (iBlockDir == 1) {
            box.d = 0.5;
            box.f = 1.0;
        } else if (iBlockDir == 2) {
            box.c = 0.5;
            box.f = 1.0;
        }
        return box;
    }

    protected int getBoundsForTertiaryPiece(aak blockAccess, int i2, int j2, int k, aqx box) {
        int iMetadata = blockAccess.h(i2, j2, k);
        int iBlockDir = this.getDirection(iMetadata);
        boolean bUpsideDown = this.getIsUpsideDown(iMetadata);
        int iFacing = -1;
        box.b = 0.5;
        box.e = 1.0;
        if (bUpsideDown) {
            box.b = 0.0;
            box.e = 0.5;
        }
        box.a = 0.0;
        box.c = 0.5;
        box.d = 0.5;
        box.f = 1.0;
        if (iBlockDir == 0) {
            int iNeighborBlockID = blockAccess.a(i2 - 1, j2, k);
            int iNeighborMetadata = blockAccess.h(i2 - 1, j2, k);
            if (this.isStairBlock(iNeighborBlockID) && (iMetadata & 4) == (iNeighborMetadata & 4)) {
                int iNeighborDir = iNeighborMetadata & 3;
                if (iNeighborDir == 3 && !this.isStairBlockWithMetadata(blockAccess, i2, j2, k - 1, iMetadata)) {
                    box.c = 0.0;
                    box.f = 0.5;
                    iFacing = 2;
                } else if (iNeighborDir == 2 && !this.isStairBlockWithMetadata(blockAccess, i2, j2, k + 1, iMetadata)) {
                    box.c = 0.5;
                    box.f = 1.0;
                    iFacing = 3;
                }
            }
        } else if (iBlockDir == 1) {
            int iNeighborBlockID = blockAccess.a(i2 + 1, j2, k);
            int iNeighborMetadata = blockAccess.h(i2 + 1, j2, k);
            if (this.isStairBlock(iNeighborBlockID) && (iMetadata & 4) == (iNeighborMetadata & 4)) {
                box.a = 0.5;
                box.d = 1.0;
                int iNeighborDir = iNeighborMetadata & 3;
                if (iNeighborDir == 3 && !this.isStairBlockWithMetadata(blockAccess, i2, j2, k - 1, iMetadata)) {
                    box.c = 0.0;
                    box.f = 0.5;
                    iFacing = 2;
                } else if (iNeighborDir == 2 && !this.isStairBlockWithMetadata(blockAccess, i2, j2, k + 1, iMetadata)) {
                    box.c = 0.5;
                    box.f = 1.0;
                    iFacing = 3;
                }
            }
        } else if (iBlockDir == 2) {
            int iNeighborBlockID = blockAccess.a(i2, j2, k - 1);
            int iNeighborMetadata = blockAccess.h(i2, j2, k - 1);
            if (this.isStairBlock(iNeighborBlockID) && (iMetadata & 4) == (iNeighborMetadata & 4)) {
                box.c = 0.0;
                box.f = 0.5;
                int iNeighborDir = iNeighborMetadata & 3;
                if (iNeighborDir == 1 && !this.isStairBlockWithMetadata(blockAccess, i2 - 1, j2, k, iMetadata)) {
                    iFacing = 4;
                } else if (iNeighborDir == 0 && !this.isStairBlockWithMetadata(blockAccess, i2 + 1, j2, k, iMetadata)) {
                    box.a = 0.5;
                    box.d = 1.0;
                    iFacing = 5;
                }
            }
        } else if (iBlockDir == 3) {
            int iNeighborBlockID = blockAccess.a(i2, j2, k + 1);
            int iNeighborMetadata = blockAccess.h(i2, j2, k + 1);
            if (this.isStairBlock(iNeighborBlockID) && (iMetadata & 4) == (iNeighborMetadata & 4)) {
                int iNeighborDir = iNeighborMetadata & 3;
                if (iNeighborDir == 1 && !this.isStairBlockWithMetadata(blockAccess, i2 - 1, j2, k, iMetadata)) {
                    iFacing = 4;
                } else if (iNeighborDir == 0 && !this.isStairBlockWithMetadata(blockAccess, i2 + 1, j2, k, iMetadata)) {
                    box.a = 0.5;
                    box.d = 1.0;
                    iFacing = 5;
                }
            }
        }
        return iFacing;
    }

    private boolean hasSecondaryFullSurfaceToFacing(aak blockAccess, int i2, int j2, int k, int iFacing) {
        aqx box = aqx.a().a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        boolean bHasFullStep = this.getBoundsForSecondaryPiece(blockAccess, i2, j2, k, box);
        return bHasFullStep && iFacing == this.getBoundsForTertiaryPiece(blockAccess, i2, j2, k, box);
    }

    protected boolean isStairBlock(int iBlockID) {
        apa block = apa.r[iBlockID];
        if (block != null) {
            return block.isStairBlock();
        }
        return false;
    }

    protected boolean getIsUpsideDown(aak blockAccess, int i2, int j2, int k) {
        return this.getIsUpsideDown(blockAccess.h(i2, j2, k));
    }

    protected boolean getIsUpsideDown(int iMetadata) {
        return (iMetadata & 4) != 0;
    }

    protected int setUpsideDown(int iMetadata) {
        return iMetadata | 4;
    }

    protected int setIsUpsideDown(int iMetadata, boolean bUpsideDown) {
        iMetadata = bUpsideDown ? (iMetadata |= 4) : (iMetadata &= 0xFFFFFFFB);
        return iMetadata;
    }

    protected void setIsUpsideDown(aab world, int i2, int j2, int k, boolean bUpsideDown) {
        int iMetadata = this.setIsUpsideDown(world.h(i2, j2, k), bUpsideDown);
        world.setBlockMetadataWithNotify(i2, j2, k, iMetadata);
    }

    protected void setDirection(aab world, int i2, int j2, int k, int iDirection) {
        int iMetadata = this.setDirection(world.h(i2, j2, k), iDirection);
        world.SetBlockMetadataWithNotify(i2, j2, k, iMetadata, 2);
    }

    protected int setDirection(int iMetadata, int iDirection) {
        return (iMetadata &= 0xFFFFFFFC) | iDirection;
    }

    protected int getDirection(aak blockAccess, int i2, int j2, int k) {
        return this.getDirection(blockAccess.h(i2, j2, k));
    }

    protected int getDirection(int iMetadata) {
        return iMetadata & 3;
    }

    protected boolean isStairBlockWithMetadata(aak blockAccess, int i2, int j2, int k, int iMetadata) {
        return WorldUtils.isStairBlock(blockAccess, i2, j2, k) && blockAccess.h(i2, j2, k) == iMetadata;
    }

    protected void notifyAllNearbyBlocksFlat(aab world, int i2, int j2, int k) {
        world.g(i2 - 1, j2, k, this.cz);
        world.g(i2 - 2, j2, k, this.cz);
        world.g(i2 + 1, j2, k, this.cz);
        world.g(i2 + 2, j2, k, this.cz);
        world.g(i2, j2, k - 1, this.cz);
        world.g(i2, j2, k - 2, this.cz);
        world.g(i2, j2, k + 1, this.cz);
        world.g(i2, j2, k + 2, this.cz);
        world.g(i2 - 1, j2, k - 1, this.cz);
        world.g(i2 - 1, j2, k + 1, this.cz);
        world.g(i2 + 1, j2, k - 1, this.cz);
        world.g(i2 + 1, j2, k + 1, this.cz);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderer, int i2, int j2, int k) {
        renderer.setRenderBounds(this.getBlockBoundsFromPoolBasedOnState(renderer.a, i2, j2, k));
        return this.renderBlockStairs(renderer, i2, j2, k);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        if (!this.renderingBase && iSide < 2) {
            BlockPos myPos = new BlockPos(iNeighborI, iNeighborJ, iNeighborK, StairsBlockBase.getOppositeFacing(iSide));
            if (this.getIsUpsideDown(blockAccess, myPos.x, myPos.y, myPos.z) ? iSide == 1 : iSide == 0) {
                return false;
            }
        }
        return this.currentBlockRenderer.shouldSideBeRenderedBasedOnCurrentBounds(iNeighborI, iNeighborJ, iNeighborK, iSide);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean shouldRenderNeighborHalfSlabSide(aak blockAccess, int i2, int j2, int k, int iNeighborSlabSide, boolean bNeighborUpsideDown) {
        boolean bUpsideDown = this.getIsUpsideDown(blockAccess, i2, j2, k);
        if (bUpsideDown == bNeighborUpsideDown) {
            return false;
        }
        int iBlockFacing = this.convertDirectionToFacing(this.getDirection(blockAccess, i2, j2, k));
        return iNeighborSlabSide != apa.getOppositeFacing(iBlockFacing);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean shouldRenderNeighborFullFaceSide(aak blockAccess, int i2, int j2, int k, int iNeighborSide) {
        if (iNeighborSide < 2) {
            boolean bUpsideDown = this.getIsUpsideDown(blockAccess, i2, j2, k);
            if (iNeighborSide == 0) {
                return !bUpsideDown;
            }
            return bUpsideDown;
        }
        int iBlockFacing = this.convertDirectionToFacing(this.getDirection(blockAccess, i2, j2, k));
        return iNeighborSide != apa.getOppositeFacing(iBlockFacing);
    }

    @Environment(value=EnvType.CLIENT)
    private boolean renderBlockStairs(bgf renderBlocks, int i2, int j2, int k) {
        this.renderingBase = true;
        renderBlocks.setRenderBounds(this.getBoundsFromPoolForBase(renderBlocks.a, i2, j2, k));
        renderBlocks.p(this, i2, j2, k);
        this.renderingBase = false;
        aqx secondaryBox = aqx.a().a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        boolean bIsFullStep = this.getBoundsForSecondaryPiece(renderBlocks.a, i2, j2, k, secondaryBox);
        renderBlocks.setRenderBounds(secondaryBox);
        renderBlocks.p(this, i2, j2, k);
        aqx tertiaryBox = aqx.a().a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        int iTertiaryFacing = this.getBoundsForTertiaryPiece(renderBlocks.a, i2, j2, k, tertiaryBox);
        if (iTertiaryFacing >= 0) {
            renderBlocks.setRenderBounds(tertiaryBox);
            renderBlocks.p(this, i2, j2, k);
        }
        return true;
    }
}

