/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class SoulforgedSteelBlock
extends apa {
    private static final float BLOCK_HARDNESS = 100.0f;
    private static final float BLOCK_EXPLOSION_RESISTANCE = 2000.0f;
    private static final int TICK_RATE = 4;
    private static final float STRONGHOLD_ACTIVATION_DISTANCE = 64.0f;
    private static final float STRONGHOLD_ACTIVATION_DISTANCE_SQ = 4096.0f;

    public SoulforgedSteelBlock(int iBlockID) {
        super(iBlockID, BTWBlocks.soulforgedSteelMaterial);
        this.c(100.0f);
        this.b(2000.0f);
        this.a(k);
        this.c("fcBlockSoulforgedSteel");
        this.a(ve.b);
    }

    @Override
    public void a(aab world, int i2, int j2, int k) {
        super.a(world, i2, j2, k);
        world.a(i2, j2, k, this.cz, this.a(world));
    }

    @Override
    public int h() {
        return 2;
    }

    @Override
    public int a(aab world) {
        return 4;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iChangedBlockID) {
        if (!(this.isRedstonePowerFlagOn(world, i2, j2, k) == this.isReceivingRedstonePower(world, i2, j2, k) && this.isActivatedByWaterFlagOn(world, i2, j2, k) == this.isBlockNeighboringOnWater(world, i2, j2, k) || world.isUpdatePendingThisTickForBlock(i2, j2, k, this.cz))) {
            world.a(i2, j2, k, this.cz, this.a(world));
        }
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random random) {
        boolean bPowered = this.isReceivingRedstonePower(world, i2, j2, k);
        if (this.isRedstonePowerFlagOn(world, i2, j2, k) != bPowered) {
            this.setRedstonePowerFlag(world, i2, j2, k, bPowered);
            if (bPowered) {
                world.e(2225, i2, j2, k, 1);
            }
        }
        boolean bIsNeighboringOnWater = this.isBlockNeighboringOnWater(world, i2, j2, k);
        if (this.isActivatedByWaterFlagOn(world, i2, j2, k) != bIsNeighboringOnWater) {
            this.setActivatedByWaterFlag(world, i2, j2, k, bIsNeighboringOnWater);
            if (bIsNeighboringOnWater) {
                world.a((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "random.drink", 0.25f + world.s.nextFloat() * 0.25f, world.s.nextFloat() * 0.75f + 0.25f);
                if (this.getStrongholdIndexWithinActivationRange(world, i2, j2, k) == 0) {
                    world.e(2228, i2, j2, k, 0);
                }
            }
        }
    }

    public boolean isRedstonePowerFlagOn(aak blockAccess, int i2, int j2, int k) {
        int iMetadata = blockAccess.h(i2, j2, k);
        return (iMetadata & 1) > 0;
    }

    private void setRedstonePowerFlag(aab world, int i2, int j2, int k, boolean bPowerFlag) {
        int iMetadata = world.h(i2, j2, k) & 0xFFFFFFFE;
        if (bPowerFlag) {
            iMetadata |= 1;
        }
        world.setBlockMetadataWithNotify(i2, j2, k, iMetadata);
    }

    private boolean isReceivingRedstonePower(aak blockAccess, int i2, int j2, int k) {
        int iBlockAboveID = blockAccess.a(i2, j2 + 1, k);
        if (iBlockAboveID == apa.az.cz) {
            return blockAccess.h(i2, j2 + 1, k) > 0;
        }
        return false;
    }

    private void emitPoweredParticles(aab world, int i2, int j2, int k, Random random) {
        for (int counter = 0; counter < 10; ++counter) {
            float smokeX = (float)i2 + random.nextFloat();
            float smokeY = (float)j2 + random.nextFloat() * 0.5f + 1.0f;
            float smokeZ = (float)k + random.nextFloat();
            world.a("largesmoke", (double)smokeX, (double)smokeY, (double)smokeZ, 0.0, 0.0, 0.0);
        }
    }

    public boolean isActivatedByWaterFlagOn(aak blockAccess, int i2, int j2, int k) {
        int iMetadata = blockAccess.h(i2, j2, k);
        return (iMetadata & 2) > 0;
    }

    private void setActivatedByWaterFlag(aab world, int i2, int j2, int k, boolean bActivatedByWaterFlag) {
        int iMetadata = world.h(i2, j2, k) & 0xFFFFFFFD;
        if (bActivatedByWaterFlag) {
            iMetadata |= 2;
        }
        world.setBlockMetadataWithNotify(i2, j2, k, iMetadata);
    }

    public boolean isRecentlyActivatedFlagOn(aak blockAccess, int i2, int j2, int k) {
        int iMetadata = blockAccess.h(i2, j2, k);
        return (iMetadata & 4) > 0;
    }

    private void setRecentlyActivatedFlag(aab world, int i2, int j2, int k, boolean bActivatedByWaterFlag) {
        int iMetadata = world.h(i2, j2, k) & 0xFFFFFFFB;
        if (bActivatedByWaterFlag) {
            iMetadata |= 4;
        }
        world.setBlockMetadataWithNotify(i2, j2, k, iMetadata);
    }

    private boolean isBlockNeighboringOnWater(aab world, int i2, int j2, int k) {
        return this.isWaterBlock(world, i2 + 1, j2, k) || this.isWaterBlock(world, i2 - 1, j2, k) || this.isWaterBlock(world, i2, j2 + 1, k) || this.isWaterBlock(world, i2, j2 - 1, k) || this.isWaterBlock(world, i2, j2, k + 1) || this.isWaterBlock(world, i2, j2, k - 1);
    }

    private boolean isWaterBlock(aab world, int i2, int j2, int k) {
        int iBlockID = world.a(i2, j2, k);
        return iBlockID == apa.E.cz || iBlockID == apa.F.cz;
    }

    public int getStrongholdIndexWithinActivationRange(aab world, int i2, int j2, int k) {
        return -1;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void b(aab world, int i2, int j2, int k, Random random) {
        if (this.isRedstonePowerFlagOn(world, i2, j2, k)) {
            this.emitPoweredParticles(world, i2, j2, k, random);
        }
    }
}

