/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.BTWMod;
import btw.block.blocks.GroundCoverBlock;
import btw.block.util.RayTraceUtils;
import btw.item.util.ItemUtils;
import btw.world.util.BlockPos;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class SnowCoverBlock
extends GroundCoverBlock {
    public SnowCoverBlock(int iBlockID) {
        super(iBlockID, aif.w);
        this.b(true);
        this.a(o);
        this.c("snow");
    }

    @Override
    public void a(aab world, int i2, int j2, int k, mp entity) {
        if (BTWMod.enableSnowRework && entity.isAffectedByMovementModifiers() && entity.F) {
            double snowheight = world.h(i2, j2, k);
            entity.x *= 1.0 - 0.025 * snowheight;
            entity.z *= 1.0 - 0.025 * snowheight;
        }
    }

    @Override
    public boolean c(aab world, int i2, int j2, int k) {
        int iBlockBelowID = world.a(i2, j2 - 1, k);
        apa blockBelow = apa.r[iBlockBelowID];
        if (blockBelow != null && blockBelow.getIsBlockWarm(world, i2, j2 - 1, k)) {
            return false;
        }
        return super.c(world, i2, j2, k);
    }

    @Override
    public void a(aab world, sq player, int i2, int j2, int k, int iMetadata) {
        int iItemID = wk.aE.cp;
        int amount = iMetadata / 2 + 1;
        this.b(world, i2, j2, k, new wm(iItemID, amount, 0));
        world.i(i2, j2, k);
        player.a(kf.C[this.cz], 1);
    }

    @Override
    public int a(int par1, Random par2Random, int par3) {
        return wk.aE.cp;
    }

    @Override
    public int a(Random par1Random) {
        return 1;
    }

    @Override
    public boolean a(zw explosion) {
        return false;
    }

    @Override
    public void onBlockDestroyedWithImproperTool(aab world, sq player, int i2, int j2, int k, int metadata) {
        if (!BTWMod.enableSnowRework) {
            metadata = 0;
        }
        this.c(world, i2, j2, k, metadata, 0);
    }

    @Override
    public boolean canConvertBlock(wm stack, aab world, int i2, int j2, int k) {
        return BTWMod.enableSnowRework;
    }

    @Override
    public boolean convertBlock(wm stack, aab world, int i2, int j2, int k, int iFromSide) {
        int iMetadata = world.h(i2, j2, k);
        if (!world.I && iMetadata > 1) {
            world.setBlockMetadataWithNotify(i2, j2, k, iMetadata - 2);
            world.e(2001, i2, j2, k, this.cz);
            ItemUtils.ejectStackFromBlockTowardsFacing(world, i2, j2, k, new wm(wk.aE, 1), iFromSide);
        } else if (!world.I) {
            world.i(i2, j2, k);
            ItemUtils.ejectStackFromBlockTowardsFacing(world, i2, j2, k, new wm(wk.aE, 1), iFromSide);
        }
        return true;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random rand) {
        int metadata = world.h(i2, j2, k);
        if (world.b(aam.b, i2, j2, k) > 11) {
            if (metadata == 0) {
                world.i(i2, j2, k);
            } else {
                world.setBlockMetadata(i2, j2, k, --metadata);
            }
        } else if (world.isSnowingAtPos(i2, j2, k) && metadata < 7) {
            float flooroffset;
            int onfloorwithoffset = 0;
            int floorblockID = world.a(i2, j2 - 1, k);
            if (floorblockID != 0 && (flooroffset = r[floorblockID].groundCoverRestingOnVisualOffset(world, i2, j2 - 1, k)) < 0.0f) {
                onfloorwithoffset = 1;
            }
            int lowestside = 7;
            int steepness = 2;
            boolean sidegrew = false;
            for (int side = 2; side < 6; ++side) {
                float offset;
                BlockPos sideblock = new BlockPos(i2, j2 - onfloorwithoffset, k, apa.getOppositeFacing(side));
                int sideblockID = world.a(sideblock.x, sideblock.y, sideblock.z);
                if (sideblockID != 0 && (offset = r[sideblockID].groundCoverRestingOnVisualOffset(world, sideblock.x, sideblock.y, sideblock.z)) < 0.0f) {
                    ++sideblock.y;
                    sideblockID = world.a(sideblock.x, sideblock.y, sideblock.z);
                }
                if (sideblockID == apa.aW.cz) {
                    int sidelimiter;
                    int sidemetadata = world.h(sideblock.x, sideblock.y, sideblock.z);
                    if (sidemetadata <= metadata - steepness) {
                        world.a(sideblock.x, sideblock.y, sideblock.z, world.a(sideblock.x, sideblock.y, sideblock.z), this.a(world));
                        sidegrew = true;
                    }
                    if ((sidelimiter = sidemetadata + steepness) >= lowestside) continue;
                    lowestside = sidelimiter;
                    continue;
                }
                if (sideblockID != 0 && world.t(sideblock.x, sideblock.y, sideblock.z)) continue;
                lowestside = 1;
                break;
            }
            if (!sidegrew && metadata < lowestside) {
                world.setBlockMetadataWithNotify(i2, j2, k, ++metadata);
            }
        }
    }

    @Override
    public void onFluidFlowIntoBlock(aab world, int i2, int j2, int k, ane newBlock) {
    }

    @Override
    public boolean getCanBeSetOnFireDirectly(aak blockAccess, int i2, int j2, int k) {
        return true;
    }

    @Override
    public boolean getCanBeSetOnFireDirectlyByItem(aak blockAccess, int i2, int j2, int k) {
        return false;
    }

    @Override
    public boolean setOnFireDirectly(aab world, int i2, int j2, int k) {
        world.i(i2, j2, k);
        return true;
    }

    @Override
    public int getChanceOfFireSpreadingDirectlyTo(aak blockAccess, int i2, int j2, int k) {
        return 60;
    }

    @Override
    public void onBrokenByPistonPush(aab world, int i2, int j2, int k, int iMetadata) {
    }

    public static boolean canSnowCoverReplaceBlock(aab world, int i2, int j2, int k) {
        apa block = apa.r[world.a(i2, j2, k)];
        return block == null || block.isAirBlock() || block.isGroundCover() && block != apa.aW;
    }

    public boolean isMaxSnowHeightLimited(aab world, int i2, int j2, int k) {
        int validside = 0;
        for (int side = 2; side < 6; ++side) {
            BlockPos sideblock = new BlockPos(i2, j2, k, apa.getOppositeFacing(side));
            int sideblockID = world.a(sideblock.x, sideblock.y, sideblock.z);
            if (sideblockID == 0 || r[sideblockID].groundCoverRestingOnVisualOffset(world, sideblock.x, sideblock.y, sideblock.z) < 0.0f) {
                // empty if block
            }
            ++sideblock.y;
            sideblockID = world.a(sideblock.x, sideblock.y, sideblock.z);
            if (sideblockID == apa.aW.cz || world.z(sideblock.x, sideblock.y, sideblock.z) || world.t(sideblock.x, sideblock.y, sideblock.z)) {
                ++validside;
                continue;
            }
            return false;
        }
        return validside < 4;
    }

    public void raiseSnowOnSides(aab world, int i2, int j2, int k) {
        for (int side = 2; side < 6; ++side) {
            BlockPos sideblock = new BlockPos(i2, j2, k, apa.getOppositeFacing(side));
            int sideblockID = world.a(sideblock.x, sideblock.y, sideblock.z);
            if (sideblockID == 0 || r[sideblockID].groundCoverRestingOnVisualOffset(world, sideblock.x, sideblock.y, sideblock.z) < 0.0f) {
                // empty if block
            }
            ++sideblock.y;
            sideblockID = world.a(sideblock.x, sideblock.y, sideblock.z);
            if (sideblockID != apa.aW.cz && !world.z(sideblock.x, sideblock.y, sideblock.z) && !world.t(sideblock.x, sideblock.y, sideblock.z)) continue;
        }
    }

    @Override
    public ara a(aab world, int i2, int j2, int k, arc startRay, arc endRay) {
        float fVisualOffset = 0.0f;
        int iBlockBelowID = world.a(i2, j2 - 1, k);
        apa blockBelow = apa.r[iBlockBelowID];
        if (blockBelow != null) {
            fVisualOffset = blockBelow.groundCoverRestingOnVisualOffset(world, i2, j2 - 1, k);
        }
        RayTraceUtils rayTrace = new RayTraceUtils(world, i2, j2, k, startRay, endRay);
        rayTrace.addBoxWithLocalCoordsToIntersectionList(0.0, fVisualOffset, 0.0, 1.0, this.getSnowHeight(world, i2, j2, k) + fVisualOffset, 1.0);
        return rayTrace.getFirstIntersection();
    }

    public float getSnowHeight(aak blockAccess, int i2, int j2, int k) {
        if (BTWMod.enableSnowRework) {
            return (float)(blockAccess.h(i2, j2, k) + 1) * 0.125f;
        }
        return 0.125f;
    }

    @Override
    public aqx getBlockBoundsFromPoolBasedOnState(aak blockAccess, int i2, int j2, int k) {
        float snowheight = this.getSnowHeight(blockAccess, i2, j2, k);
        return aqx.a().a(0.0, 0.0, 0.0, 1.0, snowheight, 1.0);
    }

    @Override
    public aqx c_(aab world, int i2, int j2, int k) {
        float fVisualOffset = 0.0f;
        int iBlockBelowID = world.a(i2, j2 - 1, k);
        apa blockBelow = apa.r[iBlockBelowID];
        if (blockBelow != null) {
            fVisualOffset = blockBelow.groundCoverRestingOnVisualOffset(world, i2, j2 - 1, k);
        }
        return this.getBlockBoundsFromPoolBasedOnState(world, i2, j2, k).d(i2, (float)j2 + fVisualOffset, k);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        this.cQ = register.a("snow");
    }
}

