/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.FallingBlock;
import btw.block.blocks.FireBlock;
import btw.client.render.util.RenderUtils;
import btw.entity.FallingBlockEntity;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class SmolderingLogBlock
extends FallingBlock {
    private static final int CHANCE_OF_DECAY = 5;
    private static final int CHANCE_OF_EXTINGUISH_IN_RAIN = 5;
    private static final float EXPLOSION_STRENGTH = 1.0f;
    @Environment(value=EnvType.CLIENT)
    private lx iconEmbers;

    public SmolderingLogBlock(int iBlockID) {
        super(iBlockID, BTWBlocks.logMaterial);
        this.c(2.0f);
        this.setAxesEffectiveOn();
        this.setChiselsEffectiveOn();
        this.setBuoyant();
        this.b(true);
        this.a(g);
        this.c("fcBlockLogSmouldering");
    }

    @Override
    public float l(aab world, int i2, int j2, int k) {
        float fHardness = super.l(world, i2, j2, k);
        int iMetadata = world.h(i2, j2, k);
        if (this.getIsStump(world, i2, j2, k)) {
            fHardness *= 3.0f;
        }
        return fHardness;
    }

    @Override
    public int a(int iMetadata, Random rand, int iFortuneModifier) {
        return 0;
    }

    @Override
    public boolean getIsProblemToRemove(wm toolStack, aak blockAccess, int i2, int j2, int k) {
        return this.getIsStump(blockAccess, i2, j2, k);
    }

    @Override
    public boolean getCanBlockBeIncinerated(aab world, int i2, int j2, int k) {
        return !this.getIsStump(world, i2, j2, k);
    }

    @Override
    public boolean canConvertBlock(wm stack, aab world, int i2, int j2, int k) {
        return this.getIsStump(world, i2, j2, k);
    }

    @Override
    public boolean convertBlock(wm stack, aab world, int i2, int j2, int k, int iFromSide) {
        if (this.getIsStump(world.h(i2, j2, k))) {
            world.setBlockWithNotify(i2, j2, k, BTWBlocks.charredStump.cz);
            return true;
        }
        return false;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random rand) {
        if (!this.hasWaterToSidesOrTop(world, i2, j2, k)) {
            int iMetadata = world.h(i2, j2, k);
            if (!this.getIsStump(iMetadata) && this.getBurnLevel(iMetadata) > 0) {
                super.a(world, i2, j2, k, rand);
            }
        } else {
            this.convertToCinders(world, i2, j2, k);
            world.e(2227, i2, j2, k, 0);
        }
    }

    @Override
    public void randomUpdateTick(aab world, int i2, int j2, int k, Random rand) {
        if (world.N().b("doFireTick") && !this.checkForGoOutInRain(world, i2, j2, k)) {
            FireBlock.checkForSmoulderingSpreadFromLocation(world, i2, j2, k);
            int iBurnLevel = this.getBurnLevel(world, i2, j2, k);
            if (iBurnLevel == 0) {
                if (!FireBlock.hasFlammableNeighborsWithinSmoulderRange(world, i2, j2, k)) {
                    int iMetadata = world.h(i2, j2, k);
                    iMetadata = this.setBurnLevel(iMetadata, 1);
                    if (this.isSupportedBySolidBlocks(world, i2, j2, k)) {
                        iMetadata = this.setShouldSuppressSnapOnFall(iMetadata, true);
                    }
                    world.setBlockMetadataWithNotify(i2, j2, k, iMetadata);
                    this.scheduleCheckForFall(world, i2, j2, k);
                }
            } else if (rand.nextInt(5) == 0) {
                if (iBurnLevel < 3) {
                    this.setBurnLevel(world, i2, j2, k, iBurnLevel + 1);
                } else {
                    this.convertToCinders(world, i2, j2, k);
                }
            }
        }
    }

    @Override
    public boolean getIsBlockWarm(aak blockAccess, int i2, int j2, int k) {
        return true;
    }

    @Override
    public boolean getCanBlockLightItemOnFire(aak blockAccess, int i2, int j2, int k) {
        return true;
    }

    @Override
    protected void a(rg entity) {
        if (!this.getShouldSuppressSnapOnFall(entity.b)) {
            entity.q.e(2276, kx.c(entity.u), kx.c(entity.v), kx.c(entity.w), 0);
            entity.b = this.setShouldSuppressSnapOnFall(entity.b, true);
        }
    }

    @Override
    public void onFallingUpdate(FallingBlockEntity entity) {
        if (entity.q.I) {
            this.emitSmokeParticles(entity.q, entity.u, entity.v, entity.w, entity.q.s, this.getBurnLevel(entity.b));
        }
    }

    @Override
    public boolean onFinishedFalling(rg entity, float fFallDistance) {
        if (!entity.q.I) {
            int i2 = kx.c(entity.u);
            int j2 = kx.c(entity.v);
            int k = kx.c(entity.w);
            int iFallDistance = kx.f(fFallDistance - 5.0f);
            if (iFallDistance >= 0 && !aif.h.equals(entity.q.g(i2, j2, k)) && entity.ab.nextInt(5) < iFallDistance) {
                this.explode(entity.q, (double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5);
                return false;
            }
        }
        return true;
    }

    @Override
    public int getHarvestToolLevel(aak blockAccess, int i2, int j2, int k) {
        return 1000;
    }

    @Override
    public void onBlockDestroyedWithImproperTool(aab world, sq player, int i2, int j2, int k, int iMetadata) {
        this.explode(world, (double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5);
    }

    public int getBurnLevel(aak blockAccess, int i2, int j2, int k) {
        int iMetadata = blockAccess.h(i2, j2, k);
        return this.getBurnLevel(iMetadata);
    }

    public int getBurnLevel(int iMetadata) {
        return iMetadata & 3;
    }

    public void setBurnLevel(aab world, int i2, int j2, int k, int iLevel) {
        int iMetadata = this.setBurnLevel(world.h(i2, j2, k), iLevel);
        world.setBlockMetadataWithNotify(i2, j2, k, iMetadata);
    }

    public int setBurnLevel(int iMetadata, int iLevel) {
        return (iMetadata &= 0xFFFFFFFC) | iLevel;
    }

    public boolean getShouldSuppressSnapOnFall(aak blockAccess, int i2, int j2, int k) {
        int iMetadata = blockAccess.h(i2, j2, k);
        return this.getShouldSuppressSnapOnFall(iMetadata);
    }

    public boolean getShouldSuppressSnapOnFall(int iMetadata) {
        return (iMetadata & 4) != 0;
    }

    public int setShouldSuppressSnapOnFall(int iMetadata, boolean bSnap) {
        iMetadata = bSnap ? (iMetadata |= 4) : (iMetadata &= 0xFFFFFFFB);
        return iMetadata;
    }

    public boolean getIsStump(aak blockAccess, int i2, int j2, int k) {
        int iMetadata = blockAccess.h(i2, j2, k);
        return this.getIsStump(iMetadata);
    }

    public boolean getIsStump(int iMetadata) {
        return (iMetadata & 8) != 0;
    }

    public int setIsStump(int iMetadata, boolean bStump) {
        iMetadata = bStump ? (iMetadata |= 8) : (iMetadata &= 0xFFFFFFF7);
        return iMetadata;
    }

    private boolean checkForGoOutInRain(aab world, int i2, int j2, int k) {
        if (world.s.nextInt(5) == 0 && world.isRainingAtPos(i2, j2 + 1, k)) {
            world.e(2227, i2, j2, k, 0);
            this.convertToCinders(world, i2, j2, k);
            return true;
        }
        return false;
    }

    private void convertToCinders(aab world, int i2, int j2, int k) {
        if (this.getIsStump(world, i2, j2, k)) {
            int iNewMetadata = BTWBlocks.woodCinders.setIsStump(0, true);
            world.setBlockAndMetadataWithNotify(i2, j2, k, BTWBlocks.woodCinders.cz, iNewMetadata);
        } else {
            world.setBlockWithNotify(i2, j2, k, BTWBlocks.woodCinders.cz);
        }
    }

    private void emitSmokeParticles(aab world, double dCenterX, double dCenterY, double dCenterZ, Random rand, int iBurnLevel) {
        for (int iTempCount = 0; iTempCount < 5; ++iTempCount) {
            double xPos = dCenterX - 0.6 + rand.nextDouble() * 1.2;
            double yPos = dCenterY + 0.25 + rand.nextDouble() * 0.25;
            double zPos = dCenterZ - 0.6 + rand.nextDouble() * 1.2;
            if (iBurnLevel > 0) {
                world.a("fcwhitesmoke", xPos, yPos, zPos, 0.0, 0.0, 0.0);
                continue;
            }
            world.a("largesmoke", xPos, yPos, zPos, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void a(aab world, int i2, int j2, int k, zw explosion) {
        if (!world.I) {
            explosion.addSecondaryExplosionNoFX((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, 1.0f, true, false);
        }
    }

    private void explode(aab world, double posX, double posY, double posZ) {
        world.newExplosionNoFX(null, posX, posY, posZ, 1.0f, true, false);
        this.notifyNearbyAnimalsFinishedFalling(world, kx.c(posX), kx.c(posY), kx.c(posZ));
        world.e(2277, kx.c(posX), kx.c(posY), kx.c(posZ), 0);
    }

    protected boolean isSupportedBySolidBlocks(aab world, int i2, int j2, int k) {
        apa blockBelow = apa.r[world.a(i2, j2 - 1, k)];
        return blockBelow != null && blockBelow.hasLargeCenterHardPointToFacing(world, i2, j2 - 1, k, 1, false);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        super.a(register);
        this.iconEmbers = register.a("fcOverlayLogEmbers");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderer, int i2, int j2, int k) {
        renderer.setRenderBounds(this.getBlockBoundsFromPoolBasedOnState(renderer.a, i2, j2, k));
        return renderer.q(this, i2, j2, k);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockSecondPass(bgf renderBlocks, int i2, int j2, int k, boolean bFirstPassResult) {
        if (bFirstPassResult) {
            RenderUtils.renderBlockFullBrightWithTexture(renderBlocks, renderBlocks.a, i2, j2, k, this.iconEmbers);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderBlocks, int iItemDamage, float fBrightness) {
        renderBlocks.renderBlockAsItemVanilla(this, iItemDamage, fBrightness);
        RenderUtils.renderInvBlockFullBrightWithTexture(renderBlocks, this, -0.5f, -0.5f, -0.5f, this.iconEmbers);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderFallingBlock(bgf renderBlocks, int i2, int j2, int k, int iMetadata) {
        renderBlocks.setRenderAllFaces(true);
        renderBlocks.setRenderBounds(this.getFixedBlockBoundsFromPool());
        renderBlocks.p(this, i2, j2, k);
        RenderUtils.renderBlockFullBrightWithTexture(renderBlocks, renderBlocks.a, i2, j2, k, this.iconEmbers);
        renderBlocks.setRenderAllFaces(false);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void b(aab world, int i2, int j2, int k, Random rand) {
        this.emitSmokeParticles(world, (double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, rand, this.getBurnLevel(world, i2, j2, k));
        if (rand.nextInt(24) == 0) {
            float fVolume = 0.1f + rand.nextFloat() * 0.1f;
            world.a((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "fire.fire", fVolume, rand.nextFloat() * 0.7f + 0.3f, false);
        }
    }
}

