/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.client.render.util.RenderUtils;
import btw.world.util.BlockPos;
import btw.world.util.WorldUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public abstract class SlabBlock
extends apa {
    public SlabBlock(int iBlockID, aif material) {
        super(iBlockID, material);
        this.initBlockBounds(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
        this.k(255);
        apa.w[iBlockID] = true;
    }

    @Override
    public int a(aab world, int i2, int j2, int k, int iFacing, float fClickX, float fClickY, float fClickZ, int iMetadata) {
        if ((iFacing == 0 || iFacing != 1 && fClickY > 0.5f) && this.canBePlacedUpsideDownAtLocation(world, i2, j2, k)) {
            iMetadata = this.setIsUpsideDown(iMetadata, true);
        }
        return iMetadata;
    }

    @Override
    public aqx getBlockBoundsFromPoolBasedOnState(aak blockAccess, int i2, int j2, int k) {
        return this.getBlockBoundsFromPoolFromMetadata(blockAccess.h(i2, j2, k));
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public boolean hasLargeCenterHardPointToFacing(aak blockAccess, int i2, int j2, int k, int iFacing, boolean bIgnoreTransparency) {
        boolean bIsUpsideDown = this.getIsUpsideDown(blockAccess, i2, j2, k);
        if (bIsUpsideDown) {
            return iFacing == 1;
        }
        return iFacing == 0;
    }

    @Override
    public boolean canGroundCoverRestOnBlock(aab world, int i2, int j2, int k) {
        return true;
    }

    @Override
    public float groundCoverRestingOnVisualOffset(aak blockAccess, int i2, int j2, int k) {
        if (!this.getIsUpsideDown(blockAccess, i2, j2, k)) {
            return -0.5f;
        }
        return 0.0f;
    }

    @Override
    public boolean isSnowCoveringTopSurface(aak blockAccess, int i2, int j2, int k) {
        if (!this.getIsUpsideDown(blockAccess, i2, j2, k)) {
            return blockAccess.a(i2, j2 + 1, k) == apa.aW.cz;
        }
        return super.isSnowCoveringTopSurface(blockAccess, i2, j2, k);
    }

    @Override
    public boolean hasContactPointToFullFace(aak blockAccess, int i2, int j2, int k, int iFacing) {
        if (iFacing < 2) {
            boolean bIsUpsideDown = this.getIsUpsideDown(blockAccess, i2, j2, k);
            return bIsUpsideDown == (iFacing == 1);
        }
        return true;
    }

    @Override
    public boolean hasContactPointToSlabSideFace(aak blockAccess, int i2, int j2, int k, int iFacing, boolean bIsSlabUpsideDown) {
        return bIsSlabUpsideDown == this.getIsUpsideDown(blockAccess, i2, j2, k);
    }

    @Override
    public boolean hasNeighborWithMortarInContact(aab world, int i2, int j2, int k) {
        boolean bIsUpsideDown = this.getIsUpsideDown(world, i2, j2, k);
        return this.hasNeighborWithMortarInContact(world, i2, j2, k, bIsUpsideDown);
    }

    @Override
    public boolean hasStickySnowNeighborInContact(aab world, int i2, int j2, int k) {
        boolean bIsUpsideDown = this.getIsUpsideDown(world, i2, j2, k);
        return this.hasStickySnowNeighborInContact(world, i2, j2, k, bIsUpsideDown);
    }

    @Override
    protected wm c_(int iMetadata) {
        iMetadata = this.setIsUpsideDown(iMetadata, false);
        return super.c_(iMetadata);
    }

    @Override
    public boolean canMobsSpawnOn(aab world, int i2, int j2, int k) {
        return this.cO.getMobsCanSpawnOn(world.t.h);
    }

    @Override
    public float mobSpawnOnVerticalOffset(aab world, int i2, int j2, int k) {
        if (!this.getIsUpsideDown(world, i2, j2, k)) {
            return -0.5f;
        }
        return 0.0f;
    }

    protected boolean hasNeighborWithMortarInContact(aab world, int i2, int j2, int k, boolean bIsUpsideDown) {
        if (bIsUpsideDown ? WorldUtils.hasNeighborWithMortarInFullFaceContactToFacing(world, i2, j2, k, 1) : WorldUtils.hasNeighborWithMortarInFullFaceContactToFacing(world, i2, j2, k, 0)) {
            return true;
        }
        for (int iTempFacing = 2; iTempFacing < 6; ++iTempFacing) {
            if (!WorldUtils.hasNeighborWithMortarInSlabSideContactToFacing(world, i2, j2, k, iTempFacing, bIsUpsideDown)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasStickySnowNeighborInContact(aab world, int i2, int j2, int k, boolean bIsUpsideDown) {
        if (bIsUpsideDown ? WorldUtils.hasStickySnowNeighborInFullFaceContactToFacing(world, i2, j2, k, 1) : WorldUtils.hasStickySnowNeighborInFullFaceContactToFacing(world, i2, j2, k, 0)) {
            return true;
        }
        for (int iTempFacing = 2; iTempFacing < 6; ++iTempFacing) {
            if (!WorldUtils.hasStickySnowNeighborInSlabSideContactToFacing(world, i2, j2, k, iTempFacing, bIsUpsideDown)) continue;
            return true;
        }
        return false;
    }

    public boolean canBePlacedUpsideDownAtLocation(aab world, int i2, int j2, int k) {
        return true;
    }

    public boolean getIsUpsideDown(aak blockAccess, int i2, int j2, int k) {
        return this.getIsUpsideDown(blockAccess.h(i2, j2, k));
    }

    public boolean getIsUpsideDown(int iMetadata) {
        return (iMetadata & 1) > 0;
    }

    public void setIsUpsideDown(aab world, int i2, int j2, int k, boolean bUpsideDown) {
        int iMetadata = world.h(i2, j2, k);
        world.setBlockMetadataWithNotify(i2, j2, k, this.setIsUpsideDown(iMetadata, bUpsideDown));
    }

    public int setIsUpsideDown(int iMetadata, boolean bUpsideDown) {
        iMetadata = bUpsideDown ? (iMetadata |= 1) : (iMetadata &= 0xFFFFFFFE);
        return iMetadata;
    }

    public boolean convertToFullBlock(aab world, int i2, int j2, int k) {
        int iMetadata = world.h(i2, j2, k);
        return world.setBlockAndMetadataWithNotify(i2, j2, k, this.getCombinedBlockID(iMetadata), this.getCombinedMetadata(iMetadata));
    }

    public abstract int getCombinedBlockID(int var1);

    public int getCombinedMetadata(int iMetadata) {
        return 0;
    }

    protected aqx getBlockBoundsFromPoolFromMetadata(int iMetadata) {
        if (this.getIsUpsideDown(iMetadata)) {
            return aqx.a().a(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
        }
        return aqx.a().a(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        BlockPos myPos = new BlockPos(iNeighborI, iNeighborJ, iNeighborK, SlabBlock.getOppositeFacing(iSide));
        boolean bUpsideDown = this.getIsUpsideDown(blockAccess, myPos.x, myPos.y, myPos.z);
        if (iSide < 2) {
            if (iSide == 0) {
                return bUpsideDown || !blockAccess.t(iNeighborI, iNeighborJ, iNeighborK);
            }
            return !bUpsideDown || !blockAccess.t(iNeighborI, iNeighborJ, iNeighborK);
        }
        return RenderUtils.shouldRenderNeighborHalfSlabSide(blockAccess, iNeighborI, iNeighborJ, iNeighborK, iSide, bUpsideDown);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean shouldRenderNeighborHalfSlabSide(aak blockAccess, int i2, int j2, int k, int iNeighborSlabSide, boolean bNeighborUpsideDown) {
        return this.getIsUpsideDown(blockAccess, i2, j2, k) != bNeighborUpsideDown;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean shouldRenderNeighborFullFaceSide(aak blockAccess, int i2, int j2, int k, int iNeighborSide) {
        if (iNeighborSide < 2) {
            boolean bUpsideDown = this.getIsUpsideDown(blockAccess, i2, j2, k);
            if (iNeighborSide == 0) {
                return !bUpsideDown;
            }
            return bUpsideDown;
        }
        return true;
    }
}

