/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.client.render.util.RenderUtils;
import btw.item.BTWItems;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class SidingAndCornerBlock
extends apa {
    protected static final double SIDING_HEIGHT = 0.5;
    protected static final double CORNER_WIDTH = 0.5;
    protected static final double CORNER_WIDTH_OFFSET = 0.5;
    String textureName;

    protected SidingAndCornerBlock(int iBlockID, aif material, String sTextureName, float fHardness, float fResistance, ape stepSound, String name) {
        super(iBlockID, material);
        this.c(fHardness);
        this.b(fResistance);
        this.a(stepSound);
        this.c(name);
        this.textureName = sTextureName;
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public int a(int iMetadata) {
        return iMetadata & 1;
    }

    @Override
    public aqx getBlockBoundsFromPoolBasedOnState(aak blockAccess, int i2, int j2, int k) {
        int iFacing = this.getFacing(blockAccess, i2, j2, k);
        if (!this.getIsCorner(blockAccess, i2, j2, k)) {
            aqx sidingBox = aqx.a().a(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
            sidingBox.tiltToFacingAlongY(iFacing);
            return sidingBox;
        }
        aqx cornerBox = aqx.a().a(0.0, 0.0, 0.0, 0.5, 0.5, 0.5);
        if (this.isCornerFacingXOffset(iFacing)) {
            cornerBox.a += 0.5;
            cornerBox.d += 0.5;
        }
        if (this.isCornerFacingYOffset(iFacing)) {
            cornerBox.b += 0.5;
            cornerBox.e += 0.5;
        }
        if (this.isCornerFacingZOffset(iFacing)) {
            cornerBox.c += 0.5;
            cornerBox.f += 0.5;
        }
        return cornerBox;
    }

    @Override
    public int a(aab world, int i2, int j2, int k, int iFacing, float fClickX, float fClickY, float fClickZ, int iMetadata) {
        if (!this.getIsCorner(iMetadata)) {
            int iSlabFacing = iFacing;
            return this.setFacing(iMetadata, iSlabFacing);
        }
        boolean bIOffset = false;
        boolean bJOffset = false;
        boolean bKOffset = false;
        if (iFacing == 0) {
            bJOffset = true;
            bIOffset = this.isPlayerClickOffsetOnAxis(fClickX);
            bKOffset = this.isPlayerClickOffsetOnAxis(fClickZ);
        } else if (iFacing == 1) {
            bIOffset = this.isPlayerClickOffsetOnAxis(fClickX);
            bKOffset = this.isPlayerClickOffsetOnAxis(fClickZ);
        } else if (iFacing == 2) {
            bKOffset = true;
            bIOffset = this.isPlayerClickOffsetOnAxis(fClickX);
            bJOffset = this.isPlayerClickOffsetOnAxis(fClickY);
        } else if (iFacing == 3) {
            bIOffset = this.isPlayerClickOffsetOnAxis(fClickX);
            bJOffset = this.isPlayerClickOffsetOnAxis(fClickY);
        } else if (iFacing == 4) {
            bIOffset = true;
            bJOffset = this.isPlayerClickOffsetOnAxis(fClickY);
            bKOffset = this.isPlayerClickOffsetOnAxis(fClickZ);
        } else if (iFacing == 5) {
            bJOffset = this.isPlayerClickOffsetOnAxis(fClickY);
            bKOffset = this.isPlayerClickOffsetOnAxis(fClickZ);
        }
        return this.setCornerFacingInMetadata(iMetadata, bIOffset, bJOffset, bKOffset);
    }

    @Override
    public boolean hasLargeCenterHardPointToFacing(aak blockAccess, int i2, int j2, int k, int iFacing, boolean bIgnoreTransparency) {
        if (!this.getIsCorner(blockAccess, i2, j2, k)) {
            int iBlockFacing = this.getFacing(blockAccess, i2, j2, k);
            return iFacing == apa.getOppositeFacing(iBlockFacing);
        }
        return false;
    }

    @Override
    public boolean canGroundCoverRestOnBlock(aab world, int i2, int j2, int k) {
        int iFacing;
        if (super.canGroundCoverRestOnBlock(world, i2, j2, k)) {
            return true;
        }
        return !this.getIsCorner(world, i2, j2, k) && (iFacing = this.getFacing(world, i2, j2, k)) == 1;
    }

    @Override
    public float groundCoverRestingOnVisualOffset(aak blockAccess, int i2, int j2, int k) {
        int iFacing;
        if (!this.getIsCorner(blockAccess, i2, j2, k) && (iFacing = this.getFacing(blockAccess, i2, j2, k)) == 1) {
            return -0.5f;
        }
        return 0.0f;
    }

    @Override
    public int getFacing(int iMetadata) {
        return iMetadata >> 1;
    }

    @Override
    public int setFacing(int iMetadata, int iFacing) {
        iMetadata &= 1;
        return iMetadata |= iFacing << 1;
    }

    @Override
    public boolean canRotateOnTurntable(aak blockAccess, int i2, int j2, int k) {
        int iFacing = this.getFacing(blockAccess, i2, j2, k);
        if (!this.getIsCorner(blockAccess, i2, j2, k)) {
            return iFacing != 0;
        }
        return !this.isCornerFacingYOffset(iFacing);
    }

    @Override
    public boolean canTransmitRotationVerticallyOnTurntable(aak blockAccess, int i2, int j2, int k) {
        int iFacing;
        return !this.getIsCorner(blockAccess, i2, j2, k) && (iFacing = this.getFacing(blockAccess, i2, j2, k)) > 1;
    }

    @Override
    public int rotateMetadataAroundJAxis(int iMetadata, boolean bReverse) {
        int iFacing = this.getFacing(iMetadata);
        if ((iMetadata & 1) == 0) {
            return super.rotateMetadataAroundJAxis(iMetadata, bReverse);
        }
        boolean bIOffset = this.isCornerFacingXOffset(iFacing);
        boolean bJOffset = this.isCornerFacingYOffset(iFacing);
        boolean bKOffset = this.isCornerFacingZOffset(iFacing);
        if (bReverse) {
            if (bIOffset) {
                if (bKOffset) {
                    bIOffset = false;
                } else {
                    bKOffset = true;
                }
            } else if (bKOffset) {
                bKOffset = false;
            } else {
                bIOffset = true;
            }
        } else if (bIOffset) {
            if (bKOffset) {
                bKOffset = false;
            } else {
                bIOffset = false;
            }
        } else if (bKOffset) {
            bIOffset = true;
        } else {
            bKOffset = true;
        }
        return this.setCornerFacingInMetadata(iMetadata, bIOffset, bJOffset, bKOffset);
    }

    @Override
    public boolean toggleFacing(aab world, int i2, int j2, int k, boolean bReverse) {
        int iFacing = this.getFacing(world, i2, j2, k);
        if (!this.getIsCorner(world, i2, j2, k)) {
            iFacing = apa.cycleFacing(iFacing, bReverse);
        } else if (!bReverse) {
            if (++iFacing > 7) {
                iFacing = 0;
            }
        } else if (--iFacing < 0) {
            iFacing = 7;
        }
        this.setFacing(world, i2, j2, k, iFacing);
        return true;
    }

    @Override
    public float mobSpawnOnVerticalOffset(aab world, int i2, int j2, int k) {
        int iFacing = this.getFacing(world, i2, j2, k);
        if (this.getIsCorner(world, i2, j2, k) ? !this.isCornerFacingYOffset(iFacing) : iFacing == 1) {
            return -0.5f;
        }
        return 0.0f;
    }

    public boolean getIsCorner(aak iBlockAccess, int i2, int j2, int k) {
        return this.getIsCorner(iBlockAccess.h(i2, j2, k));
    }

    public boolean getIsCorner(int iMetadata) {
        return (iMetadata & 1) > 0;
    }

    public boolean isCornerFacingXOffset(int iFacing) {
        return (iFacing & 4) > 0;
    }

    public boolean isCornerFacingYOffset(int iFacing) {
        return (iFacing & 2) > 0;
    }

    public boolean isCornerFacingZOffset(int iFacing) {
        return (iFacing & 1) > 0;
    }

    private boolean isPlayerClickOffsetOnAxis(float fPlayerClick) {
        return fPlayerClick > 0.0f && fPlayerClick >= 0.5f;
    }

    public void setCornerFacing(aab world, int i2, int j2, int k, boolean bIAligned, boolean bJAligned, boolean bKAligned) {
        int iFacing = 0;
        if (bIAligned) {
            iFacing |= 4;
        }
        if (bJAligned) {
            iFacing |= 2;
        }
        if (bKAligned) {
            iFacing |= 1;
        }
        this.setFacing(world, i2, j2, k, iFacing);
    }

    public int setCornerFacingInMetadata(int iMetadata, boolean bIAligned, boolean bJAligned, boolean bKAligned) {
        int iFacing = 0;
        if (bIAligned) {
            iFacing |= 4;
        }
        if (bJAligned) {
            iFacing |= 2;
        }
        if (bKAligned) {
            iFacing |= 1;
        }
        return this.setFacing(iMetadata, iFacing);
    }

    public static int getCornerAlignmentOffsetAlongAxis(int iCornerFacing, int iAxis) {
        if ((iCornerFacing & 4 >> iAxis) > 0) {
            return 1;
        }
        return -1;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        this.cQ = register.a(this.textureName);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(int iBlockID, ve creativeTabs, List list) {
        list.add(new wm(iBlockID, 1, 0));
        list.add(new wm(iBlockID, 1, 1));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int d(aab world, int i2, int j2, int k) {
        return this.a(world.h(i2, j2, k), world.s, 0);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        return this.currentBlockRenderer.shouldSideBeRenderedBasedOnCurrentBounds(iNeighborI, iNeighborJ, iNeighborK, iSide);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderBlocks, int iItemDamage, float fBrightness) {
        if (this.cz == BTWItems.woodSidingStubID || (iItemDamage & 1) == 0 && this.cz != BTWItems.woodCornerStubID) {
            renderBlocks.a(0.0, 0.0, 0.0, 0.5, 1.0, 1.0);
        } else {
            renderBlocks.a(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);
        }
        if (this.cz == BTWItems.woodSidingStubID || this.cz == BTWItems.woodCornerStubID) {
            lx woodTexture;
            switch (iItemDamage) {
                case 1: {
                    woodTexture = BTWBlocks.spruceWoodSidingAndCorner.cQ;
                    break;
                }
                case 2: {
                    woodTexture = BTWBlocks.birchWoodSidingAndCorner.cQ;
                    break;
                }
                case 3: {
                    woodTexture = BTWBlocks.jungleWoodSidingAndCorner.cQ;
                    break;
                }
                case 4: {
                    woodTexture = BTWBlocks.bloodWoodSidingAndCorner.cQ;
                    break;
                }
                default: {
                    woodTexture = BTWBlocks.oakWoodSidingAndCorner.cQ;
                }
            }
            RenderUtils.renderInvBlockWithTexture(renderBlocks, this, -0.5f, -0.5f, -0.5f, woodTexture);
        } else {
            RenderUtils.renderInvBlockWithMetadata(renderBlocks, this, -0.5f, -0.5f, -0.5f, 0);
        }
    }
}

