/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.FenceBlock;
import btw.block.blocks.SidingAndCornerBlock;
import btw.block.util.RayTraceUtils;
import btw.client.render.util.RenderUtils;
import btw.world.util.BlockPos;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.opengl.GL11;

public class SidingAndCornerAndDecorativeBlock
extends SidingAndCornerBlock {
    public static final int SUBTYPE_BENCH = 12;
    public static final int SUBTYPE_FENCE = 14;
    protected static final float BENCH_TOP_HEIGHT = 0.125f;
    protected static final float BENCH_LEG_HEIGHT = 0.375f;
    protected static final float BENCH_LEG_WIDTH = 0.25f;
    protected static final float BENCH_LEG_HALF_WIDTH = 0.125f;
    public static final int OAK_BENCH_TOP_TEXTURE_ID = 93;
    public static final int OAK_BENCH_LEG_TEXTURE_ID = 94;

    public SidingAndCornerAndDecorativeBlock(int iBlockID, aif material, String sTextureName, float fHardness, float fResistance, ape stepSound, String name) {
        super(iBlockID, material, sTextureName, fHardness, fResistance, stepSound, name);
    }

    @Override
    public void a(aab world, int i2, int j2, int k, aqx axisalignedbb, List list, mp entity) {
        int iSubtype = world.h(i2, j2, k);
        if (iSubtype == 14) {
            this.addCollisionBoxesToListForFence(world, i2, j2, k, axisalignedbb, list, entity);
        } else {
            super.a(world, i2, j2, k, axisalignedbb, list, entity);
        }
    }

    @Override
    public aqx getBlockBoundsFromPoolBasedOnState(aak blockAccess, int i2, int j2, int k) {
        int iSubtype = blockAccess.h(i2, j2, k);
        if (iSubtype == 12) {
            return this.getBlockBoundsFromPoolForBench(blockAccess, i2, j2, k);
        }
        if (iSubtype == 14) {
            return this.getBlockBoundsFromPoolForFence(blockAccess, i2, j2, k);
        }
        return super.getBlockBoundsFromPoolBasedOnState(blockAccess, i2, j2, k);
    }

    @Override
    public ara a(aab world, int i2, int j2, int k, arc startRay, arc endRay) {
        int iBlockID = world.a(i2, j2, k);
        if (this.isBlockBench(world, i2, j2, k) && this.doesBenchHaveLeg(world, i2, j2, k)) {
            return this.collisionRayTraceBenchWithLeg(world, i2, j2, k, startRay, endRay);
        }
        if (iBlockID == this.cz && world.h(i2, j2, k) == 14 || iBlockID == apa.bz.cz) {
            return this.collisionRayTraceFence(world, i2, j2, k, startRay, endRay);
        }
        return super.a(world, i2, j2, k, startRay, endRay);
    }

    @Override
    public int a(aab world, int i2, int j2, int k, int iFacing, float fClickX, float fClickY, float fClickZ, int iMetadata) {
        int iSubtype = world.h(i2, j2, k);
        if (iSubtype == 12 || iSubtype == 14) {
            return iMetadata;
        }
        return super.a(world, i2, j2, k, iFacing, fClickX, fClickY, fClickZ, iMetadata);
    }

    @Override
    public boolean hasCenterHardPointToFacing(aak blockAccess, int i2, int j2, int k, int iFacing, boolean bIgnoreTransparency) {
        int iSubtype = blockAccess.h(i2, j2, k);
        if (iSubtype == 12) {
            return iFacing == 0;
        }
        if (iSubtype == 14) {
            return iFacing == 0 || iFacing == 1;
        }
        return super.hasCenterHardPointToFacing(blockAccess, i2, j2, k, iFacing, bIgnoreTransparency);
    }

    @Override
    public boolean hasLargeCenterHardPointToFacing(aak blockAccess, int i2, int j2, int k, int iFacing, boolean bIgnoreTransparency) {
        int iSubtype = blockAccess.h(i2, j2, k);
        if (iSubtype == 12 || iSubtype == 14) {
            return false;
        }
        return super.hasLargeCenterHardPointToFacing(blockAccess, i2, j2, k, iFacing, bIgnoreTransparency);
    }

    @Override
    public int a(int iMetadata) {
        if (SidingAndCornerAndDecorativeBlock.isDecorativeFromMetadata(iMetadata)) {
            return iMetadata;
        }
        return super.a(iMetadata);
    }

    @Override
    public boolean b(aak blockAccess, int i2, int j2, int k) {
        int iSubtype = blockAccess.h(i2, j2, k);
        if (iSubtype == 14) {
            return false;
        }
        return super.b(blockAccess, i2, j2, k);
    }

    @Override
    public boolean canGroundCoverRestOnBlock(aab world, int i2, int j2, int k) {
        int iMetadata = world.h(i2, j2, k);
        if (iMetadata == 12) {
            return true;
        }
        if (SidingAndCornerAndDecorativeBlock.isDecorativeFromMetadata(iMetadata)) {
            return world.w(i2, j2, k);
        }
        return super.canGroundCoverRestOnBlock(world, i2, j2, k);
    }

    @Override
    public float groundCoverRestingOnVisualOffset(aak blockAccess, int i2, int j2, int k) {
        int iMetadata = blockAccess.h(i2, j2, k);
        if (iMetadata == 12) {
            return -0.5f;
        }
        if (SidingAndCornerAndDecorativeBlock.isDecorativeFromMetadata(iMetadata)) {
            return 0.0f;
        }
        return super.groundCoverRestingOnVisualOffset(blockAccess, i2, j2, k);
    }

    @Override
    public int getWeightOnPathBlocked(aak blockAccess, int i2, int j2, int k) {
        int iMetadata = blockAccess.h(i2, j2, k);
        if (iMetadata == 14) {
            return -3;
        }
        return 0;
    }

    @Override
    public int getFacing(int iMetadata) {
        if (iMetadata == 12 || iMetadata == 14) {
            return 0;
        }
        return super.getFacing(iMetadata);
    }

    @Override
    public int setFacing(int iMetadata, int iFacing) {
        if (iMetadata == 12 || iMetadata == 14) {
            return iMetadata;
        }
        return super.setFacing(iMetadata, iFacing);
    }

    @Override
    public boolean canRotateOnTurntable(aak blockAccess, int i2, int j2, int k) {
        int iSubtype = blockAccess.h(i2, j2, k);
        if (iSubtype == 12 || iSubtype == 14) {
            return true;
        }
        return super.canRotateOnTurntable(blockAccess, i2, j2, k);
    }

    @Override
    public boolean canTransmitRotationVerticallyOnTurntable(aak blockAccess, int i2, int j2, int k) {
        int iSubtype = blockAccess.h(i2, j2, k);
        if (iSubtype == 14) {
            return true;
        }
        if (iSubtype == 12) {
            return false;
        }
        return super.canTransmitRotationVerticallyOnTurntable(blockAccess, i2, j2, k);
    }

    @Override
    public int rotateMetadataAroundJAxis(int iMetadata, boolean bReverse) {
        if (iMetadata == 12 || iMetadata == 14) {
            return iMetadata;
        }
        return super.rotateMetadataAroundJAxis(iMetadata, bReverse);
    }

    @Override
    public boolean toggleFacing(aab world, int i2, int j2, int k, boolean bReverse) {
        int iSubtype = world.h(i2, j2, k);
        if (iSubtype == 12 || iSubtype == 14) {
            return false;
        }
        return super.toggleFacing(world, i2, j2, k, bReverse);
    }

    @Override
    public float mobSpawnOnVerticalOffset(aab world, int i2, int j2, int k) {
        int iSubtype = world.h(i2, j2, k);
        if (iSubtype == 14) {
            return 0.5f;
        }
        if (iSubtype == 12) {
            return -0.5f;
        }
        return super.mobSpawnOnVerticalOffset(world, i2, j2, k);
    }

    @Override
    public boolean isFence(int metadata) {
        return metadata == 14;
    }

    @Override
    public boolean isBenchOrTable(int metadata) {
        return metadata == 12;
    }

    @Override
    public boolean shouldWallFormPostBelowThisBlock(aak blockAccess, int x2, int y2, int z2) {
        return blockAccess.h(x2, y2, z2) == 12 && this.doesBenchHaveLeg(blockAccess, x2, y2, z2);
    }

    public boolean isDecorative(aak blockAccess, int i2, int j2, int k) {
        return SidingAndCornerAndDecorativeBlock.isDecorativeFromMetadata(blockAccess.h(i2, j2, k));
    }

    public static boolean isDecorativeFromMetadata(int iMetadata) {
        return iMetadata == 12 || iMetadata == 14;
    }

    public aqx getBlockBoundsFromPoolForBench(aak blockAccess, int i2, int j2, int k) {
        if (!this.doesBenchHaveLeg(blockAccess, i2, j2, k)) {
            return aqx.a().a(0.0, 0.375, 0.0, 1.0, 0.5, 1.0);
        }
        return aqx.a().a(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    }

    public aqx getBlockBoundsFromPoolForFence(aak blockAccess, int i2, int j2, int k) {
        aqx fenceBox = aqx.a().a(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
        if (FenceBlock.canConnectToBlockToFacing(blockAccess, i2, j2, k, 2)) {
            fenceBox.c = 0.0;
        }
        if (FenceBlock.canConnectToBlockToFacing(blockAccess, i2, j2, k, 3)) {
            fenceBox.f = 1.0;
        }
        if (FenceBlock.canConnectToBlockToFacing(blockAccess, i2, j2, k, 4)) {
            fenceBox.a = 0.0;
        }
        if (FenceBlock.canConnectToBlockToFacing(blockAccess, i2, j2, k, 5)) {
            fenceBox.d = 1.0;
        }
        return fenceBox;
    }

    public void addCollisionBoxesToListForFence(aab world, int i2, int j2, int k, aqx intersectingBox, List list, mp entity) {
        boolean bConnectsNegativeK = FenceBlock.canConnectToBlockToFacing(world, i2, j2, k, 2);
        boolean bConnectsPositiveK = FenceBlock.canConnectToBlockToFacing(world, i2, j2, k, 3);
        boolean bConnectsNegativeI = FenceBlock.canConnectToBlockToFacing(world, i2, j2, k, 4);
        boolean bConnectsPositiveI = FenceBlock.canConnectToBlockToFacing(world, i2, j2, k, 5);
        float fXMin = 0.375f;
        float fXMax = 0.625f;
        float fZMin = 0.375f;
        float fZMax = 0.625f;
        if (bConnectsNegativeK) {
            fZMin = 0.0f;
        }
        if (bConnectsPositiveK) {
            fZMax = 1.0f;
        }
        if (bConnectsNegativeK || bConnectsPositiveK) {
            aqx.a().a(fXMin, 0.0, fZMin, fXMax, 1.5, fZMax).d(i2, j2, k).addToListIfIntersects(intersectingBox, list);
        }
        if (bConnectsNegativeI) {
            fXMin = 0.0f;
        }
        if (bConnectsPositiveI) {
            fXMax = 1.0f;
        }
        if (bConnectsNegativeI || bConnectsPositiveI || !bConnectsNegativeK && !bConnectsPositiveK) {
            aqx.a().a(fXMin, 0.0, 0.375, fXMax, 1.5, 0.625).d(i2, j2, k).addToListIfIntersects(intersectingBox, list);
        }
    }

    public boolean doesBenchHaveLeg(aak blockAccess, int i2, int j2, int k) {
        int iBlockBelowMetadata;
        int iBlockBelowID = blockAccess.a(i2, j2 - 1, k);
        if (this.cz == BTWBlocks.netherBrickSidingAndCorner.cz ? iBlockBelowID == apa.bF.cz : this.cz == iBlockBelowID && (iBlockBelowMetadata = blockAccess.h(i2, j2 - 1, k)) == 14) {
            return true;
        }
        boolean positiveIBench = this.isBlockBench(blockAccess, i2 + 1, j2, k);
        boolean negativeIBench = this.isBlockBench(blockAccess, i2 - 1, j2, k);
        boolean positiveKBench = this.isBlockBench(blockAccess, i2, j2, k + 1);
        boolean negativeKBench = this.isBlockBench(blockAccess, i2, j2, k - 1);
        return !positiveIBench && (!positiveKBench || !negativeKBench) || !negativeIBench && (!positiveKBench || !negativeKBench);
    }

    public boolean isBlockBench(aak blockAccess, int i2, int j2, int k) {
        return blockAccess.a(i2, j2, k) == this.cz && blockAccess.h(i2, j2, k) == 12;
    }

    public ara collisionRayTraceBenchWithLeg(aab world, int i2, int j2, int k, arc startRay, arc endRay) {
        RayTraceUtils rayTrace = new RayTraceUtils(world, i2, j2, k, startRay, endRay);
        rayTrace.addBoxWithLocalCoordsToIntersectionList(0.0, 0.375, 0.0, 1.0, 0.5, 1.0);
        rayTrace.addBoxWithLocalCoordsToIntersectionList(0.375, 0.0, 0.375, 0.625, 0.375, 0.625);
        return rayTrace.getFirstIntersection();
    }

    public ara collisionRayTraceFence(aab world, int i2, int j2, int k, arc startRay, arc endRay) {
        float var19;
        RayTraceUtils rayTrace = new RayTraceUtils(world, i2, j2, k, startRay, endRay);
        rayTrace.addBoxWithLocalCoordsToIntersectionList(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
        boolean bConnectsAlongI = false;
        boolean bConnectsNegativeK = FenceBlock.canConnectToBlockToFacing(world, i2, j2, k, 2);
        boolean bConnectsPositiveK = FenceBlock.canConnectToBlockToFacing(world, i2, j2, k, 3);
        boolean bConnectsNegativeI = FenceBlock.canConnectToBlockToFacing(world, i2, j2, k, 4);
        boolean bConnectsPositiveI = FenceBlock.canConnectToBlockToFacing(world, i2, j2, k, 5);
        if (bConnectsNegativeI || bConnectsPositiveI) {
            bConnectsAlongI = true;
        }
        boolean bConnectsAlongK = false;
        if (bConnectsNegativeK || bConnectsPositiveK) {
            bConnectsAlongK = true;
        }
        if (!bConnectsAlongI && !bConnectsAlongK) {
            bConnectsAlongI = true;
        }
        float var6 = 0.4375f;
        float var7 = 0.5625f;
        float var14 = 0.75f;
        float var15 = 0.9375f;
        float var16 = bConnectsNegativeI ? 0.0f : var6;
        float var17 = bConnectsPositiveI ? 1.0f : var7;
        float var18 = bConnectsNegativeK ? 0.0f : var6;
        float f2 = var19 = bConnectsPositiveK ? 1.0f : var7;
        if (bConnectsAlongI) {
            rayTrace.addBoxWithLocalCoordsToIntersectionList(var16, var14, var6, var17, var15, var7);
        }
        if (bConnectsAlongK) {
            rayTrace.addBoxWithLocalCoordsToIntersectionList(var6, var14, var18, var7, var15, var19);
        }
        var14 = 0.375f;
        var15 = 0.5625f;
        if (bConnectsAlongI) {
            rayTrace.addBoxWithLocalCoordsToIntersectionList(var16, var14, var6, var17, var15, var7);
        }
        if (bConnectsAlongK) {
            rayTrace.addBoxWithLocalCoordsToIntersectionList(var6, var14, var18, var7, var15, var19);
        }
        return rayTrace.getFirstIntersection();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(int iBlockID, ve creativeTabs, List list) {
        super.a(iBlockID, creativeTabs, list);
        list.add(new wm(iBlockID, 1, 12));
        if (iBlockID != BTWBlocks.netherBrickSidingAndCorner.cz) {
            list.add(new wm(iBlockID, 1, 14));
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        BlockPos thisPos = new BlockPos(iNeighborI, iNeighborJ, iNeighborK, apa.getOppositeFacing(iSide));
        int iSubtype = blockAccess.h(thisPos.x, thisPos.y, thisPos.z);
        if (iSubtype == 14 || iSubtype == 12) {
            return true;
        }
        return super.a(blockAccess, iNeighborI, iNeighborJ, iNeighborK, iSide);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderBlocks, int i2, int j2, int k) {
        aak blockAccess = renderBlocks.a;
        int iSubtype = blockAccess.h(i2, j2, k);
        if (iSubtype == 12) {
            return this.renderBench(renderBlocks, i2, j2, k);
        }
        if (iSubtype == 14) {
            return this.renderFence(renderBlocks, i2, j2, k);
        }
        return super.renderBlock(renderBlocks, i2, j2, k);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderBlocks, int iItemDamage, float fBrightness) {
        int iSubtype = iItemDamage;
        SidingAndCornerAndDecorativeBlock block = this;
        if (iSubtype == 12) {
            this.renderBenchInvBlock(renderBlocks, block, iSubtype);
        } else if (iSubtype == 14) {
            this.renderFenceInvBlock(renderBlocks, block, iSubtype);
        } else {
            super.renderBlockAsItem(renderBlocks, iItemDamage, fBrightness);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public boolean renderBench(bgf renderBlocks, int i2, int j2, int k) {
        renderBlocks.a(0.0, 0.375, 0.0, 1.0, 0.5, 1.0);
        renderBlocks.p(this, i2, j2, k);
        if (this.doesBenchHaveLeg(renderBlocks.a, i2, j2, k)) {
            renderBlocks.a(0.375, 0.0, 0.375, 0.625, 0.375, 0.625);
            renderBlocks.p(this, i2, j2, k);
        }
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public void renderBenchInvBlock(bgf renderBlocks, apa block, int iItemDamage) {
        renderBlocks.a(0.0, 0.375, 0.0, 1.0, 0.5, 1.0);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, block, -0.5f, -0.5f, -0.5f, 12);
        renderBlocks.a(0.375, 0.0, 0.375, 0.625, 0.375, 0.625);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, block, -0.5f, -0.5f, -0.5f, 12);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean renderFence(bgf renderBlocks, int i2, int j2, int k) {
        float var19;
        renderBlocks.a(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
        renderBlocks.p(this, i2, j2, k);
        boolean bConnectsAlongI = false;
        boolean bConnectsNegativeK = FenceBlock.canConnectToBlockToFacing(renderBlocks.a, i2, j2, k, 2);
        boolean bConnectsPositiveK = FenceBlock.canConnectToBlockToFacing(renderBlocks.a, i2, j2, k, 3);
        boolean bConnectsNegativeI = FenceBlock.canConnectToBlockToFacing(renderBlocks.a, i2, j2, k, 4);
        boolean bConnectsPositiveI = FenceBlock.canConnectToBlockToFacing(renderBlocks.a, i2, j2, k, 5);
        if (bConnectsNegativeI || bConnectsPositiveI) {
            bConnectsAlongI = true;
        }
        boolean bConnectsAlongK = false;
        if (bConnectsNegativeK || bConnectsPositiveK) {
            bConnectsAlongK = true;
        }
        if (!bConnectsAlongI && !bConnectsAlongK) {
            bConnectsAlongI = true;
        }
        float var6 = 0.4375f;
        float var7 = 0.5625f;
        float var14 = 0.75f;
        float var15 = 0.9375f;
        float var16 = bConnectsNegativeI ? 0.0f : var6;
        float var17 = bConnectsPositiveI ? 1.0f : var7;
        float var18 = bConnectsNegativeK ? 0.0f : var6;
        float f2 = var19 = bConnectsPositiveK ? 1.0f : var7;
        if (bConnectsAlongI) {
            renderBlocks.a(var16, var14, (double)var6, (double)var17, (double)var15, (double)var7);
            renderBlocks.p(this, i2, j2, k);
        }
        if (bConnectsAlongK) {
            renderBlocks.a(var6, var14, (double)var18, (double)var7, (double)var15, (double)var19);
            renderBlocks.p(this, i2, j2, k);
        }
        var14 = 0.375f;
        var15 = 0.5625f;
        if (bConnectsAlongI) {
            renderBlocks.a(var16, var14, (double)var6, (double)var17, (double)var15, (double)var7);
            renderBlocks.p(this, i2, j2, k);
        }
        if (bConnectsAlongK) {
            renderBlocks.a(var6, var14, (double)var18, (double)var7, (double)var15, (double)var19);
            renderBlocks.p(this, i2, j2, k);
        }
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public void renderFenceInvBlock(bgf renderBlocks, apa block, int itemDamage) {
        bgd tessellator = bgd.a;
        for (int i2 = 0; i2 < 4; ++i2) {
            float var5 = 0.125f;
            if (i2 == 0) {
                renderBlocks.a(0.5f - var5, 0.0, 0.0, (double)(0.5f + var5), 1.0, (double)(var5 * 2.0f));
            }
            if (i2 == 1) {
                renderBlocks.a(0.5f - var5, 0.0, (double)(1.0f - var5 * 2.0f), (double)(0.5f + var5), 1.0, 1.0);
            }
            var5 = 0.0625f;
            if (i2 == 2) {
                renderBlocks.a(0.5f - var5, 1.0f - var5 * 4.0f, (double)(-var5 * 2.0f), (double)(0.5f + var5), (double)(1.0f - var5), (double)(1.0f + var5 * 2.0f));
            }
            if (i2 == 3) {
                renderBlocks.a(0.5f - var5, 0.5f - var5 * 2.0f, (double)(-var5 * 2.0f), (double)(0.5f + var5), (double)(0.5f + var5), (double)(1.0f + var5 * 2.0f));
            }
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            tessellator.b();
            tessellator.b(0.0f, -1.0f, 0.0f);
            renderBlocks.a(block, 0.0, 0.0, 0.0, block.m(0));
            tessellator.a();
            tessellator.b();
            tessellator.b(0.0f, 1.0f, 0.0f);
            renderBlocks.b(block, 0.0, 0.0, 0.0, block.m(1));
            tessellator.a();
            tessellator.b();
            tessellator.b(0.0f, 0.0f, -1.0f);
            renderBlocks.c(block, 0.0, 0.0, 0.0, block.m(2));
            tessellator.a();
            tessellator.b();
            tessellator.b(0.0f, 0.0f, 1.0f);
            renderBlocks.d(block, 0.0, 0.0, 0.0, block.m(3));
            tessellator.a();
            tessellator.b();
            tessellator.b(-1.0f, 0.0f, 0.0f);
            renderBlocks.e(block, 0.0, 0.0, 0.0, block.m(4));
            tessellator.a();
            tessellator.b();
            tessellator.b(1.0f, 0.0f, 0.0f);
            renderBlocks.f(block, 0.0, 0.0, 0.0, block.m(5));
            tessellator.a();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }
        renderBlocks.a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }
}

