/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.FluidSource;
import btw.block.MechanicalBlock;
import btw.block.util.Flammability;
import btw.block.util.MechPowerUtils;
import btw.item.BTWItems;
import btw.util.MiscUtils;
import btw.world.util.BlockPos;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class ScrewPumpBlock
extends apa
implements MechanicalBlock,
FluidSource {
    public static final int TICK_RATE = 20;
    @Environment(value=EnvType.CLIENT)
    private lx[] iconBySideArray = new lx[6];
    @Environment(value=EnvType.CLIENT)
    private lx iconFront;

    public ScrewPumpBlock(int iBlockID) {
        super(iBlockID, BTWBlocks.plankMaterial);
        this.c(2.0f);
        this.b(5.0f);
        this.setAxesEffectiveOn(true);
        this.setBuoyancy(1.0f);
        this.setFireProperties(Flammability.PLANKS);
        this.a(g);
        this.c("fcBlockScrewPump");
        this.b(true);
        this.a(ve.d);
    }

    @Override
    public int a(aab world) {
        return 20;
    }

    @Override
    public void a(aab world, int i2, int j2, int k) {
        super.a(world, i2, j2, k);
        world.a(i2, j2, k, this.cz, this.a(world));
    }

    @Override
    public int a(aab world, int i2, int j2, int k, int iFacing, float fClickX, float fClickY, float fClickZ, int iMetadata) {
        if (iFacing < 2) {
            iFacing = 2;
        }
        return this.setFacing(iMetadata, iFacing);
    }

    @Override
    public void a(aab world, int i2, int j2, int k, ng entityLiving, wm stack) {
        int iFacing = MiscUtils.convertOrientationToFlatBlockFacingReversed(entityLiving);
        this.setFacing(world, i2, j2, k, iFacing);
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iBlockID) {
        if (!world.isUpdatePendingThisTickForBlock(i2, j2, k, this.cz)) {
            world.a(i2, j2, k, this.cz, this.a(world));
        }
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random random) {
        boolean bOn;
        boolean bReceivingPower;
        boolean bIsJammed = this.isJammed(world, i2, j2, k);
        if (bIsJammed) {
            BlockPos sourcePos = new BlockPos(i2, j2, k);
            sourcePos.addFacingAsOffset(this.getFacing(world, i2, j2, k));
            int iSourceBlockID = world.a(sourcePos.x, sourcePos.y, sourcePos.z);
            if (iSourceBlockID != apa.E.cz && iSourceBlockID != apa.F.cz) {
                this.setIsJammed(world, i2, j2, k, false);
            }
        }
        if ((bReceivingPower = this.isInputtingMechanicalPower(world, i2, j2, k)) != (bOn = this.isMechanicalOn(world, i2, j2, k))) {
            this.setMechanicalOn(world, i2, j2, k, bReceivingPower);
            world.j(i2, j2, k);
            if (this.isPumpingWater(world, i2, j2, k)) {
                world.a(i2, j2, k, this.cz, this.a(world));
            }
            if (!bReceivingPower && this.isJammed(world, i2, j2, k)) {
                this.setIsJammed(world, i2, j2, k, false);
            }
        } else if (bOn) {
            if (this.isPumpingWater(world, i2, j2, k)) {
                boolean bSourceValidated = false;
                int iTargetBlockID = world.a(i2, j2 + 1, k);
                if (iTargetBlockID == apa.E.cz || iTargetBlockID == apa.F.cz) {
                    if (this.onNeighborChangeShortPumpSourceCheck(world, i2, j2, k)) {
                        int iTargetHeight = world.h(i2, j2 + 1, k);
                        if (iTargetHeight > 1 && iTargetHeight < 8) {
                            world.setBlockAndMetadataWithNotify(i2, j2 + 1, k, apa.E.cz, iTargetHeight - 1);
                            world.a(i2, j2, k, this.cz, this.a(world));
                        }
                    } else {
                        this.setIsJammed(world, i2, j2, k, true);
                    }
                } else if (world.c(i2, j2 + 1, k)) {
                    if (this.startPumpSourceCheck(world, i2, j2, k)) {
                        world.setBlockAndMetadataWithNotify(i2, j2 + 1, k, apa.E.cz, 7);
                        world.a(i2, j2, k, this.cz, this.a(world));
                    } else {
                        this.setIsJammed(world, i2, j2, k, true);
                    }
                }
            } else {
                int iTargetBlockID = world.a(i2, j2 + 1, k);
                if (iTargetBlockID == apa.E.cz || iTargetBlockID == apa.F.cz) {
                    apa.r[iTargetBlockID].a(world, i2, j2 + 1, k, this.cz);
                }
            }
        }
    }

    @Override
    public void randomUpdateTick(aab world, int i2, int j2, int k, Random rand) {
        boolean bWasJammed;
        boolean bIsJammed = bWasJammed = this.isJammed(world, i2, j2, k);
        boolean bMechanicalOn = this.isMechanicalOn(world, i2, j2, k);
        boolean bReceivingPower = this.isInputtingMechanicalPower(world, i2, j2, k);
        if (bReceivingPower != bMechanicalOn && !world.isUpdateScheduledForBlock(i2, j2, k, this.cz)) {
            world.a(i2, j2, k, this.cz, this.a(world));
            return;
        }
        if (bMechanicalOn) {
            BlockPos sourcePos = new BlockPos(i2, j2, k);
            sourcePos.addFacingAsOffset(this.getFacing(world, i2, j2, k));
            int iSourceBlockID = world.a(sourcePos.x, sourcePos.y, sourcePos.z);
            if (iSourceBlockID != apa.E.cz && iSourceBlockID != apa.F.cz) {
                bIsJammed = false;
            } else {
                int iDistanceToCheck = this.getRandomDistanceForSourceCheck(rand);
                boolean bl = bIsJammed = !MiscUtils.doesWaterHaveValidSource(world, sourcePos.x, sourcePos.y, sourcePos.z, iDistanceToCheck);
                if (!bIsJammed && bWasJammed) {
                    world.a(i2, j2, k, this.cz, this.a(world));
                }
            }
        } else {
            bIsJammed = false;
        }
        if (bWasJammed != bIsJammed) {
            this.setIsJammed(world, i2, j2, k, bIsJammed);
        }
    }

    @Override
    public int getHarvestToolLevel(aak blockAccess, int i2, int j2, int k) {
        return 2;
    }

    @Override
    public boolean dropComponentItemsOnBadBreak(aab world, int i2, int j2, int k, int iMetadata, float fChanceOfDrop) {
        this.dropItemsIndividually(world, i2, j2, k, BTWItems.screw.cp, 1, 0, fChanceOfDrop);
        this.dropItemsIndividually(world, i2, j2, k, wk.E.cp, 4, 0, fChanceOfDrop);
        this.dropItemsIndividually(world, i2, j2, k, BTWItems.sawDust.cp, 4, 0, fChanceOfDrop);
        return true;
    }

    @Override
    public int getFacing(int iMetadata) {
        return (iMetadata & 3) + 2;
    }

    @Override
    public int setFacing(int iMetadata, int iFacing) {
        iMetadata &= 0xFFFFFFFC;
        iFacing = iFacing >= 2 ? (iFacing -= 2) : 0;
        return iMetadata |= iFacing;
    }

    @Override
    public boolean isIncineratedInCrucible() {
        return false;
    }

    @Override
    public boolean canOutputMechanicalPower() {
        return false;
    }

    @Override
    public boolean canInputMechanicalPower() {
        return true;
    }

    @Override
    public boolean isInputtingMechanicalPower(aab world, int i2, int j2, int k) {
        return MechPowerUtils.isBlockPoweredByAxleToSide(world, i2, j2, k, 0);
    }

    @Override
    public boolean canInputAxlePowerToFacing(aab world, int i2, int j2, int k, int iFacing) {
        return iFacing == 0;
    }

    @Override
    public boolean isOutputtingMechanicalPower(aab world, int i2, int j2, int k) {
        return false;
    }

    @Override
    public void overpower(aab world, int i2, int j2, int k) {
        this.breakScrewPump(world, i2, j2, k);
    }

    @Override
    public int isSourceToFluidBlockAtFacing(aab world, int i2, int j2, int k, int iFacing) {
        int iTargetBlockID;
        if (iFacing == 1 && this.isPumpingWater(world, i2, j2, k) && ((iTargetBlockID = world.a(i2, j2 + 1, k)) == apa.E.cz || iTargetBlockID == apa.F.cz)) {
            int iSourceHeight = 0;
            int iTargetHeight = world.h(i2, j2 + 1, k);
            if (iTargetHeight > 0 && iTargetHeight < 8) {
                iSourceHeight = iTargetHeight - 1;
            }
            return iSourceHeight;
        }
        return -1;
    }

    public boolean isMechanicalOn(aak blockAccess, int i2, int j2, int k) {
        return (blockAccess.h(i2, j2, k) & 4) > 0;
    }

    public void setMechanicalOn(aab world, int i2, int j2, int k, boolean bOn) {
        int iMetadata = world.h(i2, j2, k) & 0xFFFFFFFB;
        if (bOn) {
            iMetadata |= 4;
        }
        world.setBlockMetadataWithNotify(i2, j2, k, iMetadata);
    }

    public boolean isJammed(aak blockAccess, int i2, int j2, int k) {
        return (blockAccess.h(i2, j2, k) & 8) > 0;
    }

    public void setIsJammed(aab world, int i2, int j2, int k, boolean bJammed) {
        int iMetadata = world.h(i2, j2, k) & 0xFFFFFFF7;
        if (bJammed) {
            iMetadata |= 8;
        }
        world.setBlockMetadataWithNotify(i2, j2, k, iMetadata);
    }

    public boolean isPumpingWater(aab world, int i2, int j2, int k) {
        if (this.isMechanicalOn(world, i2, j2, k) && !this.isJammed(world, i2, j2, k)) {
            BlockPos sourcePos = new BlockPos(i2, j2, k);
            sourcePos.addFacingAsOffset(this.getFacing(world, i2, j2, k));
            int iSourceBlockID = world.a(sourcePos.x, sourcePos.y, sourcePos.z);
            if (iSourceBlockID == apa.E.cz || iSourceBlockID == apa.F.cz) {
                return true;
            }
        }
        return false;
    }

    private boolean startPumpSourceCheck(aab world, int i2, int j2, int k) {
        BlockPos sourcePos = new BlockPos(i2, j2, k);
        sourcePos.addFacingAsOffset(this.getFacing(world, i2, j2, k));
        int iSourceBlockID = world.a(sourcePos.x, sourcePos.y, sourcePos.z);
        if (iSourceBlockID == apa.E.cz || iSourceBlockID == apa.F.cz) {
            int iDistanceToCheck = 128;
            return MiscUtils.doesWaterHaveValidSource(world, sourcePos.x, sourcePos.y, sourcePos.z, iDistanceToCheck);
        }
        return false;
    }

    private boolean onNeighborChangeShortPumpSourceCheck(aab world, int i2, int j2, int k) {
        BlockPos sourcePos = new BlockPos(i2, j2, k);
        sourcePos.addFacingAsOffset(this.getFacing(world, i2, j2, k));
        int iSourceBlockID = world.a(sourcePos.x, sourcePos.y, sourcePos.z);
        if (iSourceBlockID == apa.E.cz || iSourceBlockID == apa.F.cz) {
            int iDistanceToCheck = 4;
            return MiscUtils.doesWaterHaveValidSource(world, sourcePos.x, sourcePos.y, sourcePos.z, iDistanceToCheck);
        }
        return false;
    }

    private int getRandomDistanceForSourceCheck(Random rand) {
        int iDistanceToCheck = 32;
        int iRandomFactor = rand.nextInt(32);
        if (iRandomFactor == 0) {
            iDistanceToCheck = 512;
        } else if (iRandomFactor <= 2) {
            iDistanceToCheck = 256;
        } else if (iRandomFactor <= 6) {
            iDistanceToCheck = 128;
        } else if (iRandomFactor <= 14) {
            iDistanceToCheck = 64;
        }
        return iDistanceToCheck;
    }

    private void breakScrewPump(aab world, int i2, int j2, int k) {
        this.dropComponentItemsOnBadBreak(world, i2, j2, k, world.h(i2, j2, k), 1.0f);
        world.e(2235, i2, j2, k, 0);
        world.setBlockWithNotify(i2, j2, k, 0);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        lx sideIcon;
        this.cQ = sideIcon = register.a("fcBlockScrewPump_side");
        this.iconFront = register.a("fcBlockScrewPump_front");
        this.iconBySideArray[0] = register.a("fcBlockScrewPump_bottom");
        this.iconBySideArray[1] = register.a("fcBlockScrewPump_top");
        this.iconBySideArray[2] = sideIcon;
        this.iconBySideArray[3] = sideIcon;
        this.iconBySideArray[4] = sideIcon;
        this.iconBySideArray[5] = sideIcon;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        if (iSide == 3) {
            return this.iconFront;
        }
        return this.iconBySideArray[iSide];
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx b_(aak blockAccess, int i2, int j2, int k, int iSide) {
        int iFacing = this.getFacing(blockAccess, i2, j2, k);
        if (iFacing == iSide) {
            return this.iconFront;
        }
        return this.iconBySideArray[iSide];
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void b(aab world, int i2, int j2, int k, Random random) {
        if (this.isMechanicalOn(world, i2, j2, k)) {
            this.emitPoweredParticles(world, i2, j2, k, random);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void emitPoweredParticles(aab world, int i2, int j2, int k, Random random) {
        int iBlockAboveID = world.a(i2, j2 + 1, k);
        if (iBlockAboveID == apa.E.cz || iBlockAboveID == apa.F.cz) {
            for (int counter = 0; counter < 5; ++counter) {
                float smokeX = (float)i2 + random.nextFloat();
                float smokeY = (float)j2 + random.nextFloat() * 0.1f + 1.0f;
                float smokeZ = (float)k + random.nextFloat();
                world.a("bubble", (double)smokeX, (double)smokeY, (double)smokeZ, 0.0, 0.0, 0.0);
            }
        } else {
            for (int counter = 0; counter < 5; ++counter) {
                float smokeX = (float)i2 + random.nextFloat();
                float smokeY = (float)j2 + random.nextFloat() * 0.5f + 1.0f;
                float smokeZ = (float)k + random.nextFloat();
                world.a("smoke", (double)smokeX, (double)smokeY, (double)smokeZ, 0.0, 0.0, 0.0);
            }
        }
    }
}

