/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.MechanicalBlock;
import btw.block.util.MechPowerUtils;
import btw.client.render.util.RenderUtils;
import btw.crafting.manager.SawCraftingManager;
import btw.item.BTWItems;
import btw.util.CustomDamageSource;
import btw.util.MiscUtils;
import btw.world.util.BlockPos;
import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class SawBlock
extends apa
implements MechanicalBlock {
    private static final int POWER_CHANGE_TICK_RATE = 10;
    private static final int SAW_TIME_BASE_TICK_RATE = 20;
    private static final int SAW_TIME_TICK_RATE_VARIANCE = 4;
    public static final float BASE_HEIGHT = 0.75f;
    public static final float BLADE_LENGTH = 0.625f;
    public static final float BLADE_HALF_LENGTH = 0.3125f;
    public static final float BLADE_WIDTH = 0.015625f;
    public static final float BLADE_HALF_WIDTH = 0.0078125f;
    public static final float BLADE_HEIGHT = 0.25f;
    @Environment(value=EnvType.CLIENT)
    private lx iconFront;
    @Environment(value=EnvType.CLIENT)
    private lx iconBladeOff;
    @Environment(value=EnvType.CLIENT)
    private lx iconBladeOn;

    public SawBlock(int iBlockID) {
        super(iBlockID, BTWBlocks.plankMaterial);
        this.c(2.0f);
        this.setAxesEffectiveOn(true);
        this.setBuoyancy(1.0f);
        this.initBlockBounds(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
        this.setFireProperties(5, 20);
        this.a(g);
        this.c("fcBlockSaw");
        this.b(true);
        this.a(ve.d);
    }

    @Override
    public int a(aab world) {
        return 10;
    }

    @Override
    public int a(aab world, int i2, int j2, int k, int iFacing, float fClickX, float fClickY, float fClickZ, int iMetadata) {
        return this.setFacing(iMetadata, apa.getOppositeFacing(iFacing));
    }

    @Override
    public void a(aab world, int i2, int j2, int k, ng entityLiving, wm stack) {
        int iFacing = MiscUtils.convertPlacingEntityOrientationToBlockFacingReversed(entityLiving);
        this.setFacing(world, i2, j2, k, iFacing);
    }

    @Override
    public void a(aab world, int i2, int j2, int k) {
        super.a(world, i2, j2, k);
        world.a(i2, j2, k, this.cz, 10);
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public aqx b(aab world, int i2, int j2, int k) {
        float fBaseHeight = 0.71875f;
        return this.getBlockBoundsFromPoolForBaseHeight(world, i2, j2, k, fBaseHeight).d(i2, j2, k);
    }

    @Override
    public aqx getBlockBoundsFromPoolBasedOnState(aak blockAccess, int i2, int j2, int k) {
        return this.getBlockBoundsFromPoolForBaseHeight(blockAccess, i2, j2, k, 0.75f);
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iBlockID) {
        if (!world.isUpdatePendingThisTickForBlock(i2, j2, k, this.cz)) {
            this.scheduleUpdateIfRequired(world, i2, j2, k);
        }
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random rand) {
        boolean bReceivingPower = this.isInputtingMechanicalPower(world, i2, j2, k);
        boolean bOn = this.isBlockOn(world, i2, j2, k);
        if (bOn != bReceivingPower) {
            this.emitSawParticles(world, i2, j2, k, rand);
            this.setBlockOn(world, i2, j2, k, bReceivingPower);
            if (bReceivingPower) {
                world.a((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "minecart.base", 1.0f + rand.nextFloat() * 0.1f, 1.5f + rand.nextFloat() * 0.1f);
                this.scheduleUpdateIfRequired(world, i2, j2, k);
            } else {
                world.a((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "minecart.base", 1.0f + rand.nextFloat() * 0.1f, 0.75f + rand.nextFloat() * 0.1f);
            }
        } else if (bOn) {
            this.sawBlockToFront(world, i2, j2, k, rand);
        }
    }

    @Override
    public void randomUpdateTick(aab world, int i2, int j2, int k, Random rand) {
        if (!world.isUpdateScheduledForBlock(i2, j2, k, this.cz)) {
            this.scheduleUpdateIfRequired(world, i2, j2, k);
        }
    }

    @Override
    public void a(aab world, int i2, int j2, int k, mp entity) {
        if (world.I) {
            return;
        }
        if (this.isBlockOn(world, i2, j2, k) && entity instanceof ng) {
            aqx sawBox;
            int iFacing = this.getFacing(world, i2, j2, k);
            float fHalfLength = 0.3125f;
            float fHalfWidth = 0.0078125f;
            float fBlockHeight = 0.25f;
            switch (iFacing) {
                case 0: {
                    sawBox = aqx.a().a(0.5f - fHalfLength, 0.0, 0.5f - fHalfWidth, 0.5f + fHalfLength, fBlockHeight, 0.5f + fHalfWidth);
                    break;
                }
                case 1: {
                    sawBox = aqx.a().a(0.5f - fHalfLength, 1.0f - fBlockHeight, 0.5f - fHalfWidth, 0.5f + fHalfLength, 1.0, 0.5f + fHalfWidth);
                    break;
                }
                case 2: {
                    sawBox = aqx.a().a(0.5f - fHalfLength, 0.5f - fHalfWidth, 0.0, 0.5f + fHalfLength, 0.5f + fHalfWidth, fBlockHeight);
                    break;
                }
                case 3: {
                    sawBox = aqx.a().a(0.5f - fHalfLength, 0.5f - fHalfWidth, 1.0f - fBlockHeight, 0.5f + fHalfLength, 0.5f + fHalfWidth, 1.0);
                    break;
                }
                case 4: {
                    sawBox = aqx.a().a(0.0, 0.5f - fHalfWidth, 0.5f - fHalfLength, fBlockHeight, 0.5f + fHalfWidth, 0.5f + fHalfLength);
                    break;
                }
                default: {
                    sawBox = aqx.a().a(1.0f - fBlockHeight, 0.5f - fHalfWidth, 0.5f - fHalfLength, 1.0, 0.5f + fHalfWidth, 0.5f + fHalfLength);
                }
            }
            sawBox = sawBox.c(i2, j2, k);
            List collisionList = null;
            collisionList = world.a(ng.class, sawBox);
            if (collisionList != null && collisionList.size() > 0) {
                mg source = CustomDamageSource.damageSourceSaw;
                int iDamage = 4;
                BlockPos targetPos = new BlockPos(i2, j2, k);
                targetPos.addFacingAsOffset(iFacing);
                int iTargetBlockID = world.a(targetPos.x, targetPos.y, targetPos.z);
                int iTargetMetadata = world.h(targetPos.x, targetPos.y, targetPos.z);
                if (iTargetBlockID == BTWBlocks.aestheticOpaque.cz && (iTargetMetadata == 13 || iTargetMetadata == 12)) {
                    source = CustomDamageSource.damageSourceChoppingBlock;
                    iDamage *= 3;
                    if (iTargetMetadata == 13) {
                        world.setBlockMetadataWithNotify(targetPos.x, targetPos.y, targetPos.z, 12);
                    }
                }
                for (int iTempListIndex = 0; iTempListIndex < collisionList.size(); ++iTempListIndex) {
                    ng tempTargetEntity = (ng)collisionList.get(iTempListIndex);
                    if (!tempTargetEntity.a(source, iDamage)) continue;
                    world.e(2223, i2, j2, k, iFacing);
                }
            }
        }
    }

    @Override
    public boolean hasCenterHardPointToFacing(aak blockAccess, int i2, int j2, int k, int iFacing, boolean bIgnoreTransparency) {
        return iFacing != this.getFacing(blockAccess, i2, j2, k);
    }

    @Override
    public boolean hasLargeCenterHardPointToFacing(aak blockAccess, int i2, int j2, int k, int iFacing, boolean bIgnoreTransparency) {
        return apa.getOppositeFacing(iFacing) == this.getFacing(blockAccess, i2, j2, k);
    }

    @Override
    public int getHarvestToolLevel(aak blockAccess, int i2, int j2, int k) {
        return 2;
    }

    @Override
    public boolean dropComponentItemsOnBadBreak(aab world, int i2, int j2, int k, int iMetadata, float fChanceOfDrop) {
        this.dropItemsIndividually(world, i2, j2, k, BTWItems.gear.cp, 1, 0, fChanceOfDrop);
        this.dropItemsIndividually(world, i2, j2, k, wk.E.cp, 2, 0, fChanceOfDrop);
        this.dropItemsIndividually(world, i2, j2, k, BTWItems.sawDust.cp, 3, 0, fChanceOfDrop);
        this.dropItemsIndividually(world, i2, j2, k, wk.p.cp, 2, 0, fChanceOfDrop);
        this.dropItemsIndividually(world, i2, j2, k, BTWItems.ironNugget.cp, 4, 0, fChanceOfDrop);
        this.dropItemsIndividually(world, i2, j2, k, BTWItems.leatherStrap.cp, 3, 0, fChanceOfDrop);
        return true;
    }

    @Override
    public int getFacing(int iMetadata) {
        return iMetadata & 7;
    }

    @Override
    public int setFacing(int iMetadata, int iFacing) {
        iMetadata &= 0xFFFFFFF8;
        return iMetadata |= iFacing;
    }

    @Override
    public boolean canRotateOnTurntable(aak iBlockAccess, int i2, int j2, int k) {
        int iFacing = this.getFacing(iBlockAccess, i2, j2, k);
        return iFacing != 0;
    }

    @Override
    public boolean canTransmitRotationVerticallyOnTurntable(aak blockAccess, int i2, int j2, int k) {
        int iFacing = this.getFacing(blockAccess, i2, j2, k);
        return iFacing != 0 && iFacing != 1;
    }

    @Override
    public boolean rotateAroundJAxis(aab world, int i2, int j2, int k, boolean bReverse) {
        if (super.rotateAroundJAxis(world, i2, j2, k, bReverse)) {
            world.a(i2, j2, k, this.cz, this.a(world));
            MechPowerUtils.destroyHorizontallyAttachedAxles(world, i2, j2, k);
            return true;
        }
        return false;
    }

    @Override
    public boolean toggleFacing(aab world, int i2, int j2, int k, boolean bReverse) {
        int iFacing = this.getFacing(world, i2, j2, k);
        iFacing = apa.cycleFacing(iFacing, bReverse);
        this.setFacing(world, i2, j2, k, iFacing);
        world.a(i2, j2, k, this.cz, this.a(world));
        world.d(i2, j2, k, this.cz);
        return true;
    }

    @Override
    public boolean isIncineratedInCrucible() {
        return false;
    }

    protected boolean isCurrentPowerStateValid(aab world, int i2, int j2, int k) {
        boolean bReceivingPower = this.isInputtingMechanicalPower(world, i2, j2, k);
        boolean bOn = this.isBlockOn(world, i2, j2, k);
        return bOn == bReceivingPower;
    }

    public boolean isBlockOn(aak iBlockAccess, int i2, int j2, int k) {
        return (iBlockAccess.h(i2, j2, k) & 8) > 0;
    }

    public void setBlockOn(aab world, int i2, int j2, int k, boolean bOn) {
        int iMetaData = world.h(i2, j2, k) & 7;
        if (bOn) {
            iMetaData |= 8;
        }
        world.setBlockMetadataWithNotify(i2, j2, k, iMetaData);
    }

    protected void scheduleUpdateIfRequired(aab world, int i2, int j2, int k) {
        if (!this.isCurrentPowerStateValid(world, i2, j2, k)) {
            world.a(i2, j2, k, this.cz, 10);
        } else if (this.isBlockOn(world, i2, j2, k)) {
            int iFacing = this.getFacing(world, i2, j2, k);
            BlockPos targetPos = new BlockPos(i2, j2, k, iFacing);
            apa targetBlock = apa.r[world.a(targetPos.x, targetPos.y, targetPos.z)];
            int targetMetadata = world.h(targetPos.x, targetPos.y, targetPos.z);
            if (targetBlock != null && (targetBlock.cO.a() || SawCraftingManager.instance.getRecipe(targetBlock, targetMetadata) != null || targetBlock.doesBlockDropAsItemOnSaw(world, targetPos.x, targetPos.y, targetPos.z))) {
                world.a((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "minecart.base", 1.5f + world.s.nextFloat() * 0.1f, 1.9f + world.s.nextFloat() * 0.1f);
                world.a(i2, j2, k, this.cz, 20 + world.s.nextInt(4));
            }
        }
    }

    public aqx getBlockBoundsFromPoolForBaseHeight(aak blockAccess, int i2, int j2, int k, float fBaseHeight) {
        int iFacing = this.getFacing(blockAccess, i2, j2, k);
        switch (iFacing) {
            case 0: {
                return aqx.a().a(0.0, 1.0f - fBaseHeight, 0.0, 1.0, 1.0, 1.0);
            }
            case 1: {
                return aqx.a().a(0.0, 0.0, 0.0, 1.0, fBaseHeight, 1.0);
            }
            case 2: {
                return aqx.a().a(0.0, 0.0, 1.0f - fBaseHeight, 1.0, 1.0, 1.0);
            }
            case 3: {
                return aqx.a().a(0.0, 0.0, 0.0, 1.0, 1.0, fBaseHeight);
            }
            case 4: {
                return aqx.a().a(1.0f - fBaseHeight, 0.0, 0.0, 1.0, 1.0, 1.0);
            }
        }
        return aqx.a().a(0.0, 0.0, 0.0, fBaseHeight, 1.0, 1.0);
    }

    void emitSawParticles(aab world, int i2, int j2, int k, Random random) {
        int iFacing = this.getFacing(world, i2, j2, k);
        float fBladeXPos = i2;
        float fBladeYPos = j2;
        float fBladeZPos = k;
        float fBladeXExtent = 0.0f;
        float fBladeZExtent = 0.0f;
        switch (iFacing) {
            case 0: {
                fBladeXPos += 0.5f;
                fBladeZPos += 0.5f;
                fBladeXExtent = 1.0f;
                break;
            }
            case 1: {
                fBladeXPos += 0.5f;
                fBladeZPos += 0.5f;
                fBladeYPos += 1.0f;
                fBladeXExtent = 1.0f;
                break;
            }
            case 2: {
                fBladeXPos += 0.5f;
                fBladeYPos += 0.5f;
                fBladeXExtent = 1.0f;
                break;
            }
            case 3: {
                fBladeXPos += 0.5f;
                fBladeYPos += 0.5f;
                fBladeZPos += 1.0f;
                fBladeXExtent = 1.0f;
                break;
            }
            case 4: {
                fBladeYPos += 0.5f;
                fBladeZPos += 0.5f;
                fBladeZExtent = 1.0f;
                break;
            }
            default: {
                fBladeYPos += 0.5f;
                fBladeZPos += 0.5f;
                fBladeXPos += 1.0f;
                fBladeZExtent = 1.0f;
            }
        }
        for (int counter = 0; counter < 5; ++counter) {
            float smokeX = fBladeXPos + (random.nextFloat() - 0.5f) * fBladeXExtent;
            float smokeY = fBladeYPos + random.nextFloat() * 0.1f;
            float smokeZ = fBladeZPos + (random.nextFloat() - 0.5f) * fBladeZExtent;
            world.a("smoke", (double)smokeX, (double)smokeY, (double)smokeZ, 0.0, 0.0, 0.0);
        }
    }

    protected void sawBlockToFront(aab world, int i2, int j2, int k, Random random) {
        apa targetBlock;
        int iFacing = this.getFacing(world, i2, j2, k);
        BlockPos targetPos = new BlockPos(i2, j2, k, iFacing);
        if (!world.c(targetPos.x, targetPos.y, targetPos.z) && !this.handleSawingExceptionCases(world, targetPos.x, targetPos.y, targetPos.z, i2, j2, k, iFacing, random) && (targetBlock = apa.r[world.a(targetPos.x, targetPos.y, targetPos.z)]) != null) {
            if (targetBlock.doesBlockBreakSaw(world, targetPos.x, targetPos.y, targetPos.z)) {
                this.breakSaw(world, i2, j2, k);
            } else if (targetBlock.onBlockSawed(world, targetPos.x, targetPos.y, targetPos.z, i2, j2, k)) {
                this.emitSawParticles(world, targetPos.x, targetPos.y, targetPos.z, random);
            }
        }
    }

    private boolean handleSawingExceptionCases(aab world, int i2, int j2, int k, int iSawI, int iSawJ, int iSawK, int iSawFacing, Random random) {
        int iTargetBlockID = world.a(i2, j2, k);
        return iTargetBlockID == apa.ag.cz;
    }

    public void breakSaw(aab world, int i2, int j2, int k) {
        this.dropComponentItemsOnBadBreak(world, i2, j2, k, world.h(i2, j2, k), 1.0f);
        world.e(2235, i2, j2, k, 0);
        world.setBlockWithNotify(i2, j2, k, 0);
    }

    @Override
    public boolean canOutputMechanicalPower() {
        return false;
    }

    @Override
    public boolean canInputMechanicalPower() {
        return true;
    }

    @Override
    public boolean isInputtingMechanicalPower(aab world, int i2, int j2, int k) {
        return MechPowerUtils.isBlockPoweredByAxle(world, i2, j2, k, this);
    }

    @Override
    public boolean canInputAxlePowerToFacing(aab world, int i2, int j2, int k, int iFacing) {
        int iBlockFacing = this.getFacing(world, i2, j2, k);
        return iFacing != iBlockFacing;
    }

    @Override
    public boolean isOutputtingMechanicalPower(aab world, int i2, int j2, int k) {
        return false;
    }

    @Override
    public void overpower(aab world, int i2, int j2, int k) {
        this.breakSaw(world, i2, j2, k);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        super.a(register);
        this.iconFront = register.a("fcBlockSaw_front");
        this.iconBladeOff = register.a("fcBlockSawBlade_off");
        this.iconBladeOn = register.a("fcBlockSawBlade_on");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        if (iSide == 1) {
            return this.iconFront;
        }
        return this.cQ;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx b_(aak blockAccess, int i2, int j2, int k, int iSide) {
        int iFacing = this.getFacing(blockAccess, i2, j2, k);
        if (iSide == iFacing) {
            return this.iconFront;
        }
        return this.cQ;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void b(aab world, int i2, int j2, int k, Random random) {
        if (this.isBlockOn(world, i2, j2, k)) {
            this.emitSawParticles(world, i2, j2, k, random);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        return this.currentBlockRenderer.shouldSideBeRenderedBasedOnCurrentBounds(iNeighborI, iNeighborJ, iNeighborK, iSide);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderer, int i2, int j2, int k) {
        aak blockAccess = renderer.a;
        float fHalfLength = 0.5f;
        float fHalfWidth = 0.5f;
        float fBlockHeight = 0.75f;
        int iFacing = this.getFacing(blockAccess, i2, j2, k);
        renderer.setRenderBounds(this.getBlockBoundsFromPoolBasedOnState(renderer.a, i2, j2, k));
        renderer.p(this, i2, j2, k);
        fHalfLength = 0.3125f;
        fHalfWidth = 0.0078125f;
        fBlockHeight = 0.25f;
        switch (iFacing) {
            case 0: {
                renderer.a(0.5f - fHalfLength, 0.0, (double)(0.5f - fHalfWidth), (double)(0.5f + fHalfLength), (double)0.999f, (double)(0.5f + fHalfWidth));
                renderer.setUVRotateEast(3);
                renderer.setUVRotateWest(3);
                renderer.setUVRotateSouth(1);
                renderer.setUVRotateNorth(2);
                renderer.setUVRotateBottom(3);
                break;
            }
            case 1: {
                renderer.a(0.5f - fHalfLength, 0.001f, (double)(0.5f - fHalfWidth), (double)(0.5f + fHalfLength), 1.0, (double)(0.5f + fHalfWidth));
                renderer.setUVRotateSouth(2);
                renderer.setUVRotateNorth(1);
                break;
            }
            case 2: {
                renderer.a(0.5f - fHalfLength, 0.5f - fHalfWidth, 0.0, (double)(0.5f + fHalfLength), (double)(0.5f + fHalfWidth), (double)fBlockHeight);
                renderer.setUVRotateSouth(3);
                renderer.setUVRotateNorth(4);
                renderer.setUVRotateEast(3);
                renderer.setUVRotateWest(3);
                break;
            }
            case 3: {
                renderer.a(0.5f - fHalfLength, 0.5f - fHalfWidth, (double)(1.0f - fBlockHeight), (double)(0.5f + fHalfLength), (double)(0.5f + fHalfWidth), 1.0);
                renderer.setUVRotateSouth(4);
                renderer.setUVRotateNorth(3);
                renderer.setUVRotateTop(3);
                renderer.setUVRotateBottom(3);
                break;
            }
            case 4: {
                renderer.a(0.0, 0.5f - fHalfWidth, (double)(0.5f - fHalfLength), (double)fBlockHeight, (double)(0.5f + fHalfWidth), (double)(0.5f + fHalfLength));
                renderer.setUVRotateEast(4);
                renderer.setUVRotateWest(3);
                renderer.setUVRotateTop(2);
                renderer.setUVRotateBottom(1);
                renderer.setUVRotateNorth(3);
                renderer.setUVRotateSouth(4);
                break;
            }
            default: {
                renderer.a(1.0f - fBlockHeight, 0.5f - fHalfWidth, (double)(0.5f - fHalfLength), 1.0, (double)(0.5f + fHalfWidth), (double)(0.5f + fHalfLength));
                renderer.setUVRotateEast(3);
                renderer.setUVRotateWest(4);
                renderer.setUVRotateTop(1);
                renderer.setUVRotateBottom(2);
                renderer.setUVRotateSouth(4);
                renderer.setUVRotateNorth(3);
            }
        }
        renderer.setRenderAllFaces(true);
        lx bladeIcon = this.iconBladeOff;
        if (this.isBlockOn(blockAccess, i2, j2, k)) {
            bladeIcon = this.iconBladeOn;
        }
        RenderUtils.renderStandardBlockWithTexture(renderer, this, i2, j2, k, bladeIcon);
        renderer.setRenderAllFaces(false);
        renderer.clearUVRotation();
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderBlocks, int iItemDamage, float fBrightness) {
        renderBlocks.a(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, this, -0.5f, -0.5f, -0.5f, 1);
        renderBlocks.a(0.1875, 0.001f, 0.4921875, 0.8125, 1.0, 0.5078125);
        RenderUtils.renderInvBlockWithTexture(renderBlocks, this, -0.5f, -0.5f, -0.5f, this.iconBladeOff);
    }
}

