/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.blocks.DailyGrowthCropsBlock;
import btw.crafting.util.FurnaceBurnTime;
import btw.util.RandomSelector;
import btw.world.feature.trees.grower.AbstractTreeGrower;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.ToDoubleFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class SaplingBlock
extends DailyGrowthCropsBlock {
    private static final double WIDTH = 0.8;
    private static final double HALF_WIDTH = 0.4;
    private String textureBase;
    private static final int NOT_2X2 = 0;
    private static final int VALID_2X2_NOT_MATURE = 1;
    private static final int VALID_2X2 = 2;
    private final Map<AbstractTreeGrower, Integer> treeGrowers = new HashMap<AbstractTreeGrower, Integer>();
    private final Map<AbstractTreeGrower, Integer> treeGrowers2x2 = new HashMap<AbstractTreeGrower, Integer>();
    @Environment(value=EnvType.CLIENT)
    private lx[] icons = new lx[4];
    @Environment(value=EnvType.CLIENT)
    private final int[] iconIndexByGrowthStage = new int[]{0, 0, 0, 1, 1, 2, 2, 3};

    public SaplingBlock(int id, String name, String textureBase) {
        super(id);
        this.setFurnaceBurnTime(FurnaceBurnTime.KINDLING);
        this.setFilterableProperties(0);
        this.initBlockBounds(0.09999999999999998, 0.0, 0.09999999999999998, 0.9, 0.8, 0.9);
        this.c(name);
        this.textureBase = textureBase;
        this.a(ve.c);
    }

    @Override
    public void a(aab world, int x2, int y2, int z2, Random rand) {
        if (this.updateIfBlockStays(world, x2, y2, z2) && world.t.h != 1) {
            this.attemptToGrow(world, x2, y2, z2, rand);
        }
    }

    @Override
    protected void attemptToGrow(aab world, int x2, int y2, int z2, Random rand) {
        apa blockBelow;
        int timeOfDay = (int)(world.x.g() % 24000L);
        if (timeOfDay > 14000 && timeOfDay < 22000) {
            if (this.getHasGrownToday(world, x2, y2, z2)) {
                this.setHasGrownToday(world, x2, y2, z2, false);
            }
        } else if (!this.getHasGrownToday(world, x2, y2, z2) && this.canGrowAtCurrentLightLevel(world, x2, y2, z2) && (blockBelow = apa.r[world.a(x2, y2 - 1, z2)]) != null) {
            float growthChance = this.getBaseGrowthChance(world, x2, y2, z2);
            if (blockBelow.getIsFertilizedForPlantGrowth(world, x2, y2 - 1, z2)) {
                growthChance *= 2.0f;
            }
            if (rand.nextFloat() <= growthChance) {
                this.incrementGrowthLevel(world, x2, y2, z2);
                if (world.a(x2, y2, z2) == this.cz) {
                    this.updateFlagForGrownToday(world, x2, y2, z2);
                }
            }
        }
    }

    @Override
    protected void incrementGrowthLevel(aab world, int x2, int y2, int z2) {
        if (this.isFullyGrown(world, x2, y2, z2)) {
            this.attemptToGrowTree(world, x2, y2, z2);
        } else {
            apa blockBelow;
            int newGrowthLevel = this.getGrowthLevel(world, x2, y2, z2) + 1;
            this.setGrowthLevel(world, x2, y2, z2, newGrowthLevel);
            if (this.isFullyGrown(world, x2, y2, z2) && (blockBelow = apa.r[world.a(x2, y2 - 1, z2)]) != null) {
                blockBelow.notifyOfFullStagePlantGrowthOn(world, x2, y2 - 1, z2, this);
            }
        }
    }

    @Override
    protected boolean requiresNaturalLight() {
        return false;
    }

    @Override
    public boolean canWeedsGrowInBlock(aak blockAccess, int i2, int j2, int k) {
        return false;
    }

    @Override
    protected boolean canGrowOnBlock(aab world, int x2, int y2, int z2) {
        apa block = apa.r[world.a(x2, y2, z2)];
        return block != null && block.canSaplingsGrowOnBlock(world, x2, y2, z2);
    }

    @Override
    public boolean canBeCrushedByFallingEntity(aab world, int i2, int j2, int k, rg entity) {
        return true;
    }

    @Override
    public aqx getBlockBoundsFromPoolBasedOnState(aak blockAccess, int x2, int y2, int z2) {
        return this.getFixedBlockBoundsFromPool();
    }

    @Override
    public int a(int metadata, Random rand, int fortuneModifier) {
        return this.cz;
    }

    @Override
    public int a(int metadata) {
        if (this.isFullyGrown(metadata)) {
            return this.getGrowthLevel(metadata);
        }
        return 0;
    }

    @Override
    protected int getCropItemID() {
        return 0;
    }

    @Override
    protected int getSeedItemID() {
        return 0;
    }

    @Override
    protected boolean onlyDropWhenFullyGrown() {
        return false;
    }

    protected void attemptToGrowTree(aab world, int x2, int y2, int z2) {
        if (!this.checkFor2x2Tree(world, x2, y2, z2)) {
            AbstractTreeGrower treeGrower = this.getTreeGrower(world.s);
            int metadata = world.h(x2, y2, z2);
            world.c(x2, y2, z2, 0);
            if (!treeGrower.growTree(world, world.s, x2, y2, z2, false)) {
                world.setBlockAndMetadata(x2, y2, z2, this.cz, metadata);
            }
        }
    }

    protected boolean checkFor2x2Tree(aab world, int x2, int y2, int z2) {
        if (this.treeGrowers2x2.isEmpty()) {
            return false;
        }
        boolean has2x2 = false;
        if (this.canGrow2x2Tree(world, x2, y2, z2) != 0) {
            has2x2 = true;
            if (this.canGrow2x2Tree(world, x2, y2, z2) == 2) {
                this.attemptToGrow2x2Tree(world, x2, y2, z2);
            }
        }
        if (this.canGrow2x2Tree(world, x2 - 1, y2, z2) != 0) {
            has2x2 = true;
            if (this.canGrow2x2Tree(world, x2 - 1, y2, z2) == 2) {
                this.attemptToGrow2x2Tree(world, x2 - 1, y2, z2);
            }
        }
        if (this.canGrow2x2Tree(world, x2, y2, z2 - 1) != 0) {
            has2x2 = true;
            if (this.canGrow2x2Tree(world, x2, y2, z2 - 1) == 2) {
                this.attemptToGrow2x2Tree(world, x2, y2, z2 - 1);
            }
        }
        if (this.canGrow2x2Tree(world, x2 - 1, y2, z2 - 1) != 0) {
            has2x2 = true;
            if (this.canGrow2x2Tree(world, x2 - 1, y2, z2 - 1) == 2) {
                this.attemptToGrow2x2Tree(world, x2 - 1, y2, z2 - 1);
            }
        }
        return has2x2;
    }

    protected void attemptToGrow2x2Tree(aab world, int x2, int y2, int z2) {
        AbstractTreeGrower treeGrower = this.getTreeGrower2x2(world.s);
        int metadata = world.h(x2, y2, z2);
        world.c(x2, y2, z2, 0);
        world.c(x2 + 1, y2, z2, 0);
        world.c(x2, y2, z2 + 1, 0);
        world.c(x2 + 1, y2, z2 + 1, 0);
        if (!treeGrower.growTree(world, world.s, x2, y2, z2, false)) {
            world.setBlockAndMetadata(x2, y2, z2, this.cz, metadata);
            world.setBlockAndMetadata(x2 + 1, y2, z2, this.cz, metadata);
            world.setBlockAndMetadata(x2, y2, z2 + 1, this.cz, metadata);
            world.setBlockAndMetadata(x2 + 1, y2, z2 + 1, this.cz, metadata);
        }
    }

    protected int canGrow2x2Tree(aab world, int x2, int y2, int z2) {
        if (world.a(x2 + 1, y2, z2) == this.cz && world.a(x2, y2, z2 + 1) == this.cz && world.a(x2 + 1, y2, z2 + 1) == this.cz) {
            if (this.isFullyGrown(world, x2, y2, z2) && this.isFullyGrown(world, x2 + 1, y2, z2) && this.isFullyGrown(world, x2, y2, z2 + 1) && this.isFullyGrown(world, x2 + 1, y2, z2 + 1)) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public AbstractTreeGrower getTreeGrower(Random rand) {
        ToDoubleFunction<AbstractTreeGrower> weighter = this.treeGrowers::get;
        RandomSelector<AbstractTreeGrower> selector = RandomSelector.weighted(this.treeGrowers.keySet(), weighter);
        return selector.next(rand);
    }

    public AbstractTreeGrower getTreeGrower2x2(Random rand) {
        ToDoubleFunction<AbstractTreeGrower> weighter = this.treeGrowers2x2::get;
        RandomSelector<AbstractTreeGrower> selector = RandomSelector.weighted(this.treeGrowers2x2.keySet(), weighter);
        return selector.next(rand);
    }

    public SaplingBlock addTreeGrower(AbstractTreeGrower grower, int weight) {
        this.treeGrowers.put(grower, weight);
        return this;
    }

    public SaplingBlock add2x2TreeGrower(AbstractTreeGrower grower, int weight) {
        this.treeGrowers2x2.put(grower, weight);
        return this;
    }

    public boolean removeTreeGrower(String name) {
        for (AbstractTreeGrower treeGrower : this.treeGrowers.keySet()) {
            if (!treeGrower.name.equals(name)) continue;
            this.treeGrowers.remove(treeGrower);
            return true;
        }
        for (AbstractTreeGrower treeGrower : this.treeGrowers2x2.keySet()) {
            if (!treeGrower.name.equals(name)) continue;
            this.treeGrowers2x2.remove(treeGrower);
            return true;
        }
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        for (int i2 = 0; i2 < 4; ++i2) {
            this.icons[i2] = register.a(this.textureBase + i2);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int side, int metadata) {
        return this.icons[this.iconIndexByGrowthStage[this.getGrowthLevel(metadata)]];
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(int metadata, ve creativeTabs, List list) {
        list.add(new wm(this.cz, 1, 0));
        list.add(new wm(this.cz, 1, 7));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderer, int x2, int y2, int z2) {
        renderer.setRenderBounds(this.getBlockBoundsFromPoolBasedOnState(renderer.a, x2, y2, z2));
        renderer.k(this, x2, y2, z2);
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int d() {
        return 1;
    }
}

