/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.blocks.FullBlock;
import btw.item.BTWItems;
import btw.item.items.ChiselItem;
import btw.item.items.PickaxeItem;
import btw.item.items.ToolItem;
import btw.item.util.ItemUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class RoughStoneBlock
extends FullBlock {
    public static RoughStoneBlock[] strataLevelBlockArray = new RoughStoneBlock[3];
    public int strataLevel;
    @Environment(value=EnvType.CLIENT)
    private lx iconBroken;
    @Environment(value=EnvType.CLIENT)
    private lx[] crackIcons;

    public RoughStoneBlock(int iBlockID, int iStrataLevel) {
        super(iBlockID, aif.e);
        this.strataLevel = iStrataLevel;
        RoughStoneBlock.strataLevelBlockArray[iStrataLevel] = this;
        if (iStrataLevel == 0) {
            this.c(2.25f);
            this.b(10.0f);
        } else if (iStrataLevel == 1) {
            this.c(3.0f);
            this.b(13.0f);
        } else {
            this.c(4.5f);
            this.b(20.0f);
        }
        this.setPicksEffectiveOn();
        this.setChiselsEffectiveOn();
        this.a(j);
        this.c("fcBlockStoneRough");
    }

    @Override
    public boolean canConvertBlock(wm stack, aab world, int i2, int j2, int k) {
        int iToolLevel;
        return this.strataLevel != 0 || stack == null || !(stack.b() instanceof PickaxeItem) || (iToolLevel = ((ToolItem)stack.b()).toolMaterial.d()) > 1;
    }

    @Override
    public boolean convertBlock(wm stack, aab world, int i2, int j2, int k, int iFromSide) {
        int iMetadata = world.h(i2, j2, k);
        if (iMetadata < 15) {
            ++iMetadata;
            if (!world.I && this.isEffectiveItemConversionTool(stack, world, i2, j2, k)) {
                if (iMetadata <= 8) {
                    if ((iMetadata & 1) == 0) {
                        world.e(2269, i2, j2, k, 0);
                        ItemUtils.ejectStackFromBlockTowardsFacing(world, i2, j2, k, new wm(BTWItems.stone, 1, this.strataLevel), iFromSide);
                    } else if (iMetadata <= 5 && this.isUberItemConversionTool(stack, world, i2, j2, k)) {
                        iMetadata += 3;
                        world.e(2269, i2, j2, k, 0);
                        ItemUtils.ejectStackFromBlockTowardsFacing(world, i2, j2, k, new wm(BTWItems.stoneBrick, 1, this.strataLevel), iFromSide);
                    }
                } else if (iMetadata == 12) {
                    world.e(2270, i2, j2, k, 0);
                    ItemUtils.ejectStackFromBlockTowardsFacing(world, i2, j2, k, new wm(BTWItems.gravelPile, 1), iFromSide);
                }
            }
            world.setBlockMetadataWithNotify(i2, j2, k, iMetadata);
            return true;
        }
        if (!world.I && this.isEffectiveItemConversionTool(stack, world, i2, j2, k)) {
            world.e(2270, i2, j2, k, 0);
            ItemUtils.dropStackAsIfBlockHarvested(world, i2, j2, k, new wm(BTWItems.gravelPile, 1));
        }
        return false;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iMetadata, float fChance, int iFortuneModifier) {
        if (!world.I) {
            int iItemIDDropped = BTWItems.stone.cp;
            int iNumDropped = 1;
            int metadataDropped = this.strataLevel;
            if (iMetadata < 8) {
                iNumDropped = 8 - iMetadata / 2;
            } else {
                iItemIDDropped = BTWItems.gravelPile.cp;
                metadataDropped = 0;
                if (iMetadata < 12) {
                    iNumDropped = 2;
                }
            }
            for (int iTempCount = 0; iTempCount < iNumDropped; ++iTempCount) {
                this.b(world, i2, j2, k, new wm(iItemIDDropped, 1, metadataDropped));
            }
        }
    }

    @Override
    public void onBlockDestroyedWithImproperTool(aab world, sq player, int i2, int j2, int k, int iMetadata) {
        world.e(2270, i2, j2, k, 0);
        this.dropComponentItemsWithChance(world, i2, j2, k, iMetadata, 1.0f);
    }

    @Override
    public boolean a(zw explosion) {
        return false;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, zw explosion) {
        int iMetadata = world.h(i2, j2, k);
        float fChanceOfPileDrop = 1.0f;
        if (explosion != null) {
            fChanceOfPileDrop = 1.0f / explosion.g;
        }
        this.dropComponentItemsWithChance(world, i2, j2, k, iMetadata, fChanceOfPileDrop);
    }

    @Override
    public int getHarvestToolLevel(aak blockAccess, int i2, int j2, int k) {
        if (this.strataLevel > 1) {
            return this.strataLevel + 1;
        }
        return 2;
    }

    @Override
    public int getEfficientToolLevel(aak blockAccess, int i2, int j2, int k) {
        if (this.strataLevel > 0) {
            return this.strataLevel + 1;
        }
        return 0;
    }

    @Override
    public boolean arechiselseffectiveon(aab world, int i2, int j2, int k) {
        if (world.h(i2, j2, k) >= 8) {
            return false;
        }
        return super.arechiselseffectiveon(world, i2, j2, k);
    }

    @Override
    protected boolean r_() {
        return false;
    }

    @Override
    public boolean isNaturalStone(aak blockAccess, int i2, int j2, int k) {
        return true;
    }

    @Override
    public wm getStackRetrievedByBlockDispenser(aab world, int i2, int j2, int k) {
        if (world.h(i2, j2, k) != 0) {
            return null;
        }
        return super.getStackRetrievedByBlockDispenser(world, i2, j2, k);
    }

    @Override
    public void onRemovedByBlockDispenser(aab world, int i2, int j2, int k) {
        int metadata = world.h(i2, j2, k);
        if (metadata != 0) {
            this.c(world, i2, j2, k, metadata, 0);
        }
        super.onRemovedByBlockDispenser(world, i2, j2, k);
    }

    public boolean isEffectiveItemConversionTool(wm stack, aab world, int i2, int j2, int k) {
        if (stack != null && stack.b() instanceof ChiselItem) {
            int iToolLevel = ((ChiselItem)stack.b()).toolMaterial.d();
            return iToolLevel >= this.getEfficientToolLevel(world, i2, j2, k);
        }
        return false;
    }

    public boolean isUberItemConversionTool(wm stack, aab world, int i2, int j2, int k) {
        if (stack != null && stack.b() instanceof ChiselItem) {
            int iToolLevel = ((ChiselItem)stack.b()).toolMaterial.d();
            return iToolLevel >= this.getUberToolLevel(world, i2, j2, k);
        }
        return false;
    }

    public int getUberToolLevel(aak blockAccess, int i2, int j2, int k) {
        return 2;
    }

    private void dropComponentItemsWithChance(aab world, int i2, int j2, int k, int iMetadata, float fChanceOfItemDrop) {
        if (iMetadata < 8) {
            int iNumStoneDropped = 4 - iMetadata / 2;
            this.dropItemsIndividually(world, i2, j2, k, BTWItems.stone.cp, iNumStoneDropped, this.strataLevel, fChanceOfItemDrop);
        }
        int iNumGravelDropped = 1;
        if (iMetadata < 12) {
            iNumGravelDropped = 2;
        }
        this.dropItemsIndividually(world, i2, j2, k, BTWItems.gravelPile.cp, iNumGravelDropped, 0, fChanceOfItemDrop);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        String sBaseName = this.B();
        if (this.strataLevel > 0) {
            sBaseName = sBaseName + "_" + this.strataLevel;
        }
        this.cQ = register.a(sBaseName);
        this.iconBroken = register.a(sBaseName + "_broken");
        this.crackIcons = new lx[7];
        for (int iTempIndex = 0; iTempIndex < 7; ++iTempIndex) {
            this.crackIcons[iTempIndex] = register.a("fcOverlayStoneRough_" + (iTempIndex + 1));
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        if (iMetadata >= 8) {
            return this.iconBroken;
        }
        return this.cQ;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockSecondPass(bgf renderBlocks, int i2, int j2, int k, boolean bFirstPassResult) {
        aak blockAccess;
        int iMetadata;
        if (bFirstPassResult && (iMetadata = (blockAccess = renderBlocks.a).h(i2, j2, k)) > 0 && iMetadata != 8) {
            int iTextureIndex = 0;
            iTextureIndex = iMetadata < 8 ? kx.a(iMetadata - 1, 0, 6) : kx.a(iMetadata - 9, 0, 6);
            lx overlayTexture = this.crackIcons[iTextureIndex];
            if (overlayTexture != null) {
                this.renderBlockWithTexture(renderBlocks, i2, j2, k, overlayTexture);
            }
        }
    }
}

