/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.AnchorBlock;
import btw.block.util.Flammability;
import btw.client.render.util.RenderUtils;
import btw.entity.mechanical.platform.BlockLiftedByPlatformEntity;
import btw.entity.mechanical.platform.MovingAnchorEntity;
import btw.entity.mechanical.platform.MovingPlatformEntity;
import btw.world.util.BlockPos;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class PlatformBlock
extends apa {
    private boolean[][][] platformAlreadyConsideredForEntityConversion;
    private boolean[][][] platformAlreadyConsideredForConnectedTest;
    @Environment(value=EnvType.CLIENT)
    private lx[] iconBySideArray = new lx[6];

    public PlatformBlock(int iBlockID) {
        super(iBlockID, aif.d);
        this.c(2.0f);
        this.setAxesEffectiveOn();
        this.setBuoyancy(1.0f);
        this.setFireProperties(Flammability.WICKER);
        this.a(g);
        this.c("fcBlockPlatform");
        this.platformAlreadyConsideredForEntityConversion = new boolean[5][5][5];
        this.platformAlreadyConsideredForConnectedTest = new boolean[5][5][5];
        this.resetPlatformConsideredForEntityConversionArray();
        this.resetPlatformConsideredForConnectedTestArray();
        this.a(ve.e);
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public boolean hasCenterHardPointToFacing(aak blockAccess, int i2, int j2, int k, int iFacing, boolean bIgnoreTransparency) {
        return true;
    }

    @Override
    public boolean hasLargeCenterHardPointToFacing(aak blockAccess, int i2, int j2, int k, int iFacing, boolean bIgnoreTransparency) {
        return iFacing <= 1;
    }

    @Override
    public boolean canRotateOnTurntable(aak iBlockAccess, int i2, int j2, int k) {
        return true;
    }

    @Override
    public boolean canTransmitRotationHorizontallyOnTurntable(aak blockAccess, int i2, int j2, int k) {
        return true;
    }

    @Override
    public boolean canTransmitRotationVerticallyOnTurntable(aak blockAccess, int i2, int j2, int k) {
        return true;
    }

    @Override
    public boolean isNormalCube(aak blockAccess, int i2, int j2, int k) {
        return true;
    }

    private void convertToEntity(aab world, int i2, int j2, int k, MovingAnchorEntity associatedAnchorEntity) {
        MovingPlatformEntity entityPlatform = (MovingPlatformEntity)mv.createEntityOfType(MovingPlatformEntity.class, world, Float.valueOf((float)i2 + 0.5f), Float.valueOf((float)j2 + 0.5f), Float.valueOf((float)k + 0.5f), associatedAnchorEntity);
        world.d(entityPlatform);
        this.attemptToLiftBlockWithPlatform(world, i2, j2 + 1, k);
        world.setBlockWithNotify(i2, j2, k, 0);
    }

    private void attemptToLiftBlockWithPlatform(aab world, int i2, int j2, int k) {
        if (BlockLiftedByPlatformEntity.canBlockBeConvertedToEntity(world, i2, j2, k)) {
            mv.createEntityOfType(BlockLiftedByPlatformEntity.class, world, i2, j2, k);
        }
    }

    private int getDistToClosestConnectedAnchorPoint(aab world, int i2, int j2, int k) {
        int iClosestDist = -1;
        for (int tempI = i2 - 2; tempI <= i2 + 2; ++tempI) {
            for (int tempJ = j2 - 2; tempJ <= j2 + 2; ++tempJ) {
                for (int tempK = k - 2; tempK <= k + 2; ++tempK) {
                    int iUpwardsBlockID;
                    int iTempBlockID = world.a(tempI, tempJ, tempK);
                    if (iTempBlockID != this.cz || (iUpwardsBlockID = world.a(tempI, tempJ + 1, tempK)) != BTWBlocks.anchor.cz || ((AnchorBlock)BTWBlocks.anchor).getFacing(world, tempI, tempJ + 1, tempK) != 1 || !this.isPlatformConnectedToAnchorPoint(world, i2, j2, k, tempI, tempJ, tempK)) continue;
                    int iTempDist = Math.abs(tempI - i2) + Math.abs(tempJ - j2) + Math.abs(tempK - k);
                    if (iClosestDist != -1 && iTempDist >= iClosestDist) continue;
                    iClosestDist = iTempDist;
                }
            }
        }
        return iClosestDist;
    }

    private boolean isPlatformConnectedToAnchorPoint(aab world, int platformI, int platformJ, int platformK, int anchorPointI, int anchorPointJ, int anchorPointK) {
        this.resetPlatformConsideredForConnectedTestArray();
        if (platformI == anchorPointI && platformJ == anchorPointJ && platformK == anchorPointK) {
            return true;
        }
        return this.propogateTestForConnected(world, anchorPointI, anchorPointJ, anchorPointK, anchorPointI, anchorPointJ, anchorPointK, platformI, platformJ, platformK);
    }

    private boolean propogateTestForConnected(aab world, int i2, int j2, int k, int sourceI, int sourceJ, int sourceK, int targetI, int targetJ, int targetK) {
        int iDeltaI = i2 - sourceI;
        int iDeltaJ = j2 - sourceJ;
        int iDeltaK = k - sourceK;
        if (this.platformAlreadyConsideredForConnectedTest[iDeltaI + 2][iDeltaJ + 2][iDeltaK + 2]) {
            return false;
        }
        this.platformAlreadyConsideredForConnectedTest[iDeltaI + 2][iDeltaJ + 2][iDeltaK + 2] = true;
        for (int iFacing = 0; iFacing < 6; ++iFacing) {
            BlockPos tempPos = new BlockPos(i2, j2, k);
            tempPos.addFacingAsOffset(iFacing);
            if (tempPos.x == targetI && tempPos.y == targetJ && tempPos.z == targetK) {
                return true;
            }
            int iTempBlockID = world.a(tempPos.x, tempPos.y, tempPos.z);
            if (iTempBlockID != this.cz) continue;
            int tempDistI = Math.abs(sourceI - tempPos.x);
            int tempDistJ = Math.abs(sourceJ - tempPos.y);
            int tempDistK = Math.abs(sourceK - tempPos.z);
            if (tempDistI > 2 || tempDistJ > 2 || tempDistK > 2 || !this.propogateTestForConnected(world, tempPos.x, tempPos.y, tempPos.z, sourceI, sourceJ, sourceK, targetI, targetJ, targetK)) continue;
            return true;
        }
        return false;
    }

    void resetPlatformConsideredForEntityConversionArray() {
        for (int tempI = 0; tempI < 5; ++tempI) {
            for (int tempJ = 0; tempJ < 5; ++tempJ) {
                for (int tempK = 0; tempK < 5; ++tempK) {
                    this.platformAlreadyConsideredForEntityConversion[tempI][tempJ][tempK] = false;
                }
            }
        }
    }

    void resetPlatformConsideredForConnectedTestArray() {
        for (int tempI = 0; tempI < 5; ++tempI) {
            for (int tempJ = 0; tempJ < 5; ++tempJ) {
                for (int tempK = 0; tempK < 5; ++tempK) {
                    this.platformAlreadyConsideredForConnectedTest[tempI][tempJ][tempK] = false;
                }
            }
        }
    }

    public void covertToEntitiesFromThisPlatform(aab world, int i2, int j2, int k, MovingAnchorEntity associatedAnchorEntity) {
        this.resetPlatformConsideredForEntityConversionArray();
        this.propagateCovertToEntity(world, i2, j2, k, associatedAnchorEntity, i2, j2, k);
    }

    private void propagateCovertToEntity(aab world, int i2, int j2, int k, MovingAnchorEntity associatedAnchorEntity, int sourceI, int sourceJ, int sourceK) {
        int iDeltaI = i2 - sourceI;
        int iDeltaJ = j2 - sourceJ;
        int iDeltaK = k - sourceK;
        if (this.platformAlreadyConsideredForEntityConversion[iDeltaI + 2][iDeltaJ + 2][iDeltaK + 2]) {
            return;
        }
        this.platformAlreadyConsideredForEntityConversion[iDeltaI + 2][iDeltaJ + 2][iDeltaK + 2] = true;
        int distToSource = Math.abs(iDeltaI) + Math.abs(iDeltaJ) + Math.abs(iDeltaK);
        int closestAnchorDist = this.getDistToClosestConnectedAnchorPoint(world, i2, j2, k);
        if (closestAnchorDist != -1 && distToSource > closestAnchorDist) {
            return;
        }
        this.convertToEntity(world, i2, j2, k, associatedAnchorEntity);
        for (int iFacing = 0; iFacing < 6; ++iFacing) {
            BlockPos tempPos = new BlockPos(i2, j2, k);
            tempPos.addFacingAsOffset(iFacing);
            int iTempBlockID = world.a(tempPos.x, tempPos.y, tempPos.z);
            if (iTempBlockID != this.cz) continue;
            int tempDistI = Math.abs(sourceI - tempPos.x);
            int tempDistJ = Math.abs(sourceJ - tempPos.y);
            int tempDistK = Math.abs(sourceK - tempPos.z);
            if (tempDistI > 2 || tempDistJ > 2 || tempDistK > 2) continue;
            this.propagateCovertToEntity(world, tempPos.x, tempPos.y, tempPos.z, associatedAnchorEntity, sourceI, sourceJ, sourceK);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        lx sideIcon;
        lx topIcon;
        this.cQ = topIcon = register.a("fcBlockPlatform_top");
        this.iconBySideArray[0] = register.a("fcBlockPlatform_bottom");
        this.iconBySideArray[1] = topIcon;
        this.iconBySideArray[2] = sideIcon = register.a("fcBlockPlatform_side");
        this.iconBySideArray[3] = sideIcon;
        this.iconBySideArray[4] = sideIcon;
        this.iconBySideArray[5] = sideIcon;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        return this.iconBySideArray[iSide];
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderBlocks, int i2, int j2, int k) {
        aak blockAccess = renderBlocks.a;
        if (blockAccess.a(i2 - 1, j2, k) != this.cz) {
            renderBlocks.a(1.0E-4f, 0.0625, (double)1.0E-4f, 0.0625, 0.9375, (double)0.9999f);
            renderBlocks.p(this, i2, j2, k);
        }
        if (blockAccess.a(i2, j2, k + 1) != this.cz) {
            renderBlocks.a(0.0, 0.0625, 0.9375, 1.0, 0.9375, 1.0);
            renderBlocks.p(this, i2, j2, k);
        }
        if (blockAccess.a(i2 + 1, j2, k) != this.cz) {
            renderBlocks.a(0.9375, 0.0625, (double)1.0E-4f, (double)0.9999f, 0.9375, (double)0.9999f);
            renderBlocks.p(this, i2, j2, k);
        }
        if (blockAccess.a(i2, j2, k - 1) != this.cz) {
            renderBlocks.a(0.0, 0.0625, 0.0, 1.0, 0.9375, 0.0625);
            renderBlocks.p(this, i2, j2, k);
        }
        renderBlocks.a(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
        renderBlocks.p(this, i2, j2, k);
        renderBlocks.a(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0);
        renderBlocks.p(this, i2, j2, k);
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderBlocks, int iItemDamage, float fBrightness) {
        lx sideTexture = this.iconBySideArray[2];
        renderBlocks.a(1.0E-5f, 1.0E-5f, (double)1.0E-5f, 0.0625, (double)0.99999f, (double)0.99999f);
        RenderUtils.renderInvBlockWithTexture(renderBlocks, this, -0.5f, -0.5f, -0.5f, sideTexture);
        renderBlocks.a(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0);
        RenderUtils.renderInvBlockWithTexture(renderBlocks, this, -0.5f, -0.5f, -0.5f, sideTexture);
        renderBlocks.a(0.9375, 1.0E-5f, (double)1.0E-5f, (double)0.99999f, (double)0.99999f, (double)0.99999f);
        RenderUtils.renderInvBlockWithTexture(renderBlocks, this, -0.5f, -0.5f, -0.5f, sideTexture);
        renderBlocks.a(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625);
        RenderUtils.renderInvBlockWithTexture(renderBlocks, this, -0.5f, -0.5f, -0.5f, sideTexture);
        renderBlocks.a(1.0E-4f, 0.001f, (double)1.0E-4f, (double)0.9999f, 0.0625, (double)0.9999f);
        RenderUtils.renderInvBlockWithTexture(renderBlocks, this, -0.5f, -0.5f, -0.5f, this.iconBySideArray[0]);
        renderBlocks.a(1.0E-4f, 0.9375, (double)1.0E-4f, (double)0.9999f, (double)0.999f, (double)0.9999f);
        RenderUtils.renderInvBlockWithTexture(renderBlocks, this, -0.5f, -0.5f, -0.5f, this.iconBySideArray[1]);
    }
}

