/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.blocks.PlanterBlockBase;
import btw.client.render.util.RenderUtils;
import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class PlanterBlock
extends PlanterBlockBase {
    public static final int TYPE_EMPTY = 0;
    public static final int TYPE_SOIL = 1;
    public static final int TYPE_SOIL_FERTILIZED = 2;
    public static final int TYPE_SOUL_SAND = 8;
    public static final int TYPE_GRASS_0 = 9;
    public static final int TYPE_GRASS_1 = 11;
    public static final int TYPE_GRASS_2 = 13;
    public static final int TYPE_GRASS_3 = 15;
    @Environment(value=EnvType.CLIENT)
    private lx iconTopGrass;
    @Environment(value=EnvType.CLIENT)
    private lx iconTopSoulSand;

    public PlanterBlock(int iBlockID) {
        super(iBlockID);
        this.c("fcBlockPlanter");
    }

    @Override
    public int a(int iMetadata) {
        if (iMetadata == 11 || iMetadata == 13 || iMetadata == 15) {
            iMetadata = 9;
        }
        return iMetadata;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random random) {
        int iPlanterType = this.getPlanterType(world, i2, j2, k);
        if (iPlanterType == 9 || iPlanterType == 11 || iPlanterType == 13 || iPlanterType == 15) {
            int iOldGrowthState = this.getGrassGrowthState(world, i2, j2, k);
            int iNewGrowthState = 0;
            if (world.c(i2, j2 + 1, k) && world.n(i2, j2 + 1, k) >= 8) {
                iNewGrowthState = iOldGrowthState;
                if (++iNewGrowthState > 3) {
                    iNewGrowthState = 0;
                    int iPlantType = random.nextInt(4);
                    if (iPlantType == 0) {
                        world.setBlockWithNotify(i2, j2 + 1, k, apa.ai.cz);
                    } else if (iPlantType == 1) {
                        world.setBlockWithNotify(i2, j2 + 1, k, apa.ah.cz);
                    } else {
                        world.setBlockAndMetadataWithNotify(i2, j2 + 1, k, apa.ab.cz, 1);
                    }
                }
            }
            if (world.n(i2, j2 + 1, k) >= 9) {
                for (int tempCount = 0; tempCount < 4; ++tempCount) {
                    int tempi = i2 + random.nextInt(3) - 1;
                    int tempj = j2 + random.nextInt(5) - 3;
                    int tempk = k + random.nextInt(3) - 1;
                    int iTempBlockAboveID = world.a(tempi, tempj + 1, tempk);
                    if (world.a(tempi, tempj, tempk) != apa.z.cz || world.n(tempi, tempj + 1, tempk) < 4 || apa.t[iTempBlockAboveID] > 2) continue;
                    world.setBlockWithNotify(tempi, tempj, tempk, apa.y.cz);
                }
            }
            if (iNewGrowthState != iOldGrowthState) {
                this.setGrassGrowthState(world, i2, j2, k, iNewGrowthState);
            }
        }
    }

    @Override
    public boolean attemptToApplyFertilizerTo(aab world, int i2, int j2, int k) {
        int iPlanterType = this.getPlanterType(world, i2, j2, k);
        if (iPlanterType == 1) {
            this.setPlanterType(world, i2, j2, k, 2);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasLargeCenterHardPointToFacing(aak blockAccess, int i2, int j2, int k, int iFacing, boolean bIgnoreTransparency) {
        if (this.getPlanterType(blockAccess, i2, j2, k) == 0) {
            return false;
        }
        return super.hasLargeCenterHardPointToFacing(blockAccess, i2, j2, k, iFacing, bIgnoreTransparency);
    }

    @Override
    public boolean canDomesticatedCropsGrowOnBlock(aab world, int i2, int j2, int k) {
        int iPlanterType = this.getPlanterType(world, i2, j2, k);
        return iPlanterType == 1 || iPlanterType == 2;
    }

    @Override
    public boolean canReedsGrowOnBlock(aab world, int i2, int j2, int k) {
        int iPlanterType = this.getPlanterType(world, i2, j2, k);
        return iPlanterType != 0 && iPlanterType != 8;
    }

    @Override
    public boolean canSaplingsGrowOnBlock(aab world, int i2, int j2, int k) {
        int iPlanterType = this.getPlanterType(world, i2, j2, k);
        return iPlanterType != 0 && iPlanterType != 8;
    }

    @Override
    public boolean canWildVegetationGrowOnBlock(aab world, int i2, int j2, int k) {
        int iPlanterType = this.getPlanterType(world, i2, j2, k);
        return iPlanterType != 0 && iPlanterType != 8;
    }

    @Override
    public boolean canNetherWartGrowOnBlock(aab world, int i2, int j2, int k) {
        return this.getPlanterType(world, i2, j2, k) == 8;
    }

    @Override
    public boolean canCactusGrowOnBlock(aab world, int i2, int j2, int k) {
        int iPlanterType = this.getPlanterType(world, i2, j2, k);
        return iPlanterType != 0 && iPlanterType != 8;
    }

    @Override
    public boolean isBlockHydratedForPlantGrowthOn(aab world, int i2, int j2, int k) {
        int iPlanterType = this.getPlanterType(world, i2, j2, k);
        return iPlanterType == 1 || iPlanterType == 2;
    }

    @Override
    public boolean isConsideredNeighbouringWaterForReedGrowthOn(aab world, int i2, int j2, int k) {
        int iPlanterType = this.getPlanterType(world, i2, j2, k);
        return iPlanterType == 1 || iPlanterType == 2 || super.isConsideredNeighbouringWaterForReedGrowthOn(world, i2, j2, k);
    }

    @Override
    public boolean getIsFertilizedForPlantGrowth(aab world, int i2, int j2, int k) {
        return this.getPlanterType(world, i2, j2, k) == 2;
    }

    @Override
    public void notifyOfFullStagePlantGrowthOn(aab world, int i2, int j2, int k, apa plantBlock) {
        int iPlanterType = this.getPlanterType(world, i2, j2, k);
        if (iPlanterType == 2) {
            this.setPlanterType(world, i2, j2, k, 1);
        }
    }

    public int getPlanterType(aak blockAccess, int i2, int j2, int k) {
        return this.getPlanterTypeFromMetadata(blockAccess.h(i2, j2, k));
    }

    public void setPlanterType(aab world, int i2, int j2, int k, int iType) {
        world.setBlockMetadataWithNotify(i2, j2, k, iType);
    }

    public int getPlanterTypeFromMetadata(int iMetadata) {
        return iMetadata;
    }

    public int getGrassGrowthState(aak blockAccess, int i2, int j2, int k) {
        int iPlanterType = this.getPlanterType(blockAccess, i2, j2, k);
        switch (iPlanterType) {
            case 9: {
                return 0;
            }
            case 11: {
                return 1;
            }
            case 13: {
                return 2;
            }
            case 15: {
                return 3;
            }
        }
        return 0;
    }

    public void setGrassGrowthState(aab world, int i2, int j2, int k, int iGrowthState) {
        int iPlanterType = 9;
        if (iGrowthState == 1) {
            iPlanterType = 11;
        } else if (iGrowthState == 2) {
            iPlanterType = 13;
        } else if (iGrowthState == 3) {
            iPlanterType = 15;
        }
        this.setPlanterType(world, i2, j2, k, iPlanterType);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        super.a(register);
        this.iconTopGrass = register.a("fcBlockPlanter_top_grass");
        this.iconTopSoulSand = register.a("fcBlockPlanter_top_soulsand");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        int iPlanterType = this.getPlanterTypeFromMetadata(iMetadata);
        if (iSide == 1 && iPlanterType != 0) {
            if (iPlanterType == 1) {
                return this.iconTopSoilWet;
            }
            if (iPlanterType == 8) {
                return this.iconTopSoulSand;
            }
            if (iPlanterType == 2) {
                return this.iconTopSoilWetFertilized;
            }
            return this.iconTopGrass;
        }
        return this.cQ;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(int blockID, ve creativeTabs, List list) {
        list.add(new wm(blockID, 1, 0));
        list.add(new wm(blockID, 1, 8));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderBlocks, int i2, int j2, int k) {
        aak blockAccess = renderBlocks.a;
        int iPlanterType = this.getPlanterType(blockAccess, i2, j2, k);
        if (iPlanterType == 0) {
            return PlanterBlock.renderEmptyPlanterBlock(renderBlocks, blockAccess, i2, j2, k, this);
        }
        return this.renderFilledPlanterBlock(renderBlocks, i2, j2, k);
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean renderEmptyPlanterBlock(bgf renderBlocks, aak blockAccess, int i2, int j2, int k, apa block) {
        renderBlocks.a(0.125, 0.0, 0.125, 0.25, 0.6875, 0.75);
        renderBlocks.p(block, i2, j2, k);
        renderBlocks.a(0.125, 0.0, 0.75, 0.75, 0.6875, 0.875);
        renderBlocks.p(block, i2, j2, k);
        renderBlocks.a(0.75, 0.0, 0.25, 0.875, 0.6875, 0.875);
        renderBlocks.p(block, i2, j2, k);
        renderBlocks.a(0.25, 0.0, 0.125, 0.875, 0.6875, 0.25);
        renderBlocks.p(block, i2, j2, k);
        renderBlocks.a(0.25, 0.0, 0.25, 0.75, 0.125, 0.75);
        renderBlocks.p(block, i2, j2, k);
        renderBlocks.a(0.0, 0.6875, 0.0, 0.125, 1.0, 0.875);
        renderBlocks.p(block, i2, j2, k);
        renderBlocks.a(0.0, 0.6875, 0.875, 0.875, 1.0, 1.0);
        renderBlocks.p(block, i2, j2, k);
        renderBlocks.a(0.875, 0.6875, 0.125, 1.0, 1.0, 1.0);
        renderBlocks.p(block, i2, j2, k);
        renderBlocks.a(0.125, 0.6875, 0.0, 1.0, 1.0, 0.125);
        renderBlocks.p(block, i2, j2, k);
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderBlocks, int iItemDamage, float fBrightness) {
        if (iItemDamage == 0) {
            PlanterBlock.renderEmptyPlanterInvBlock(renderBlocks, this, iItemDamage);
        } else {
            this.renderFilledPlanterInvBlock(renderBlocks, this, iItemDamage);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void renderEmptyPlanterInvBlock(bgf renderBlocks, apa block, int iItemDamage) {
        renderBlocks.a(0.125, 0.0, 0.125, 0.25, 0.6875, 0.75);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, block, -0.5f, -0.5f, -0.5f, iItemDamage);
        renderBlocks.a(0.125, 0.0, 0.75, 0.75, 0.6875, 0.875);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, block, -0.5f, -0.5f, -0.5f, iItemDamage);
        renderBlocks.a(0.75, 0.0, 0.25, 0.875, 0.6875, 0.875);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, block, -0.5f, -0.5f, -0.5f, iItemDamage);
        renderBlocks.a(0.25, 0.0, 0.125, 0.875, 0.6875, 0.25);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, block, -0.5f, -0.5f, -0.5f, iItemDamage);
        renderBlocks.a(0.25, 0.0, 0.25, 0.75, 0.125, 0.75);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, block, -0.5f, -0.5f, -0.5f, iItemDamage);
        renderBlocks.a(0.0, 0.6875, 0.0, 0.125, 1.0, 0.875);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, block, -0.5f, -0.5f, -0.5f, iItemDamage);
        renderBlocks.a(0.0, 0.6875, 0.875, 0.875, 1.0, 1.0);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, block, -0.5f, -0.5f, -0.5f, iItemDamage);
        renderBlocks.a(0.875, 0.6875, 0.125, 1.0, 1.0, 1.0);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, block, -0.5f, -0.5f, -0.5f, iItemDamage);
        renderBlocks.a(0.125, 0.6875, 0.0, 1.0, 1.0, 0.125);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, block, -0.5f, -0.5f, -0.5f, iItemDamage);
    }
}

