/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.model.BlockModel;
import btw.block.model.PistonShovelModel;
import btw.block.util.RayTraceUtils;
import btw.util.MiscUtils;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class PistonShovelBlock
extends apa {
    protected PistonShovelModel model = new PistonShovelModel();
    @Environment(value=EnvType.CLIENT)
    private lx iconEdge;
    @Environment(value=EnvType.CLIENT)
    private lx iconEdgeBack;
    @Environment(value=EnvType.CLIENT)
    private lx iconEdgeMiddle;

    public PistonShovelBlock(int iBlockID) {
        super(iBlockID, aif.f);
        this.c(5.0f);
        this.setPicksEffectiveOn();
        this.initBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.a(k);
        this.c("fcBlockShovel");
        this.a(ve.d);
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, aqx boundingBox, List list, mp entity) {
        BlockModel transformedModel = this.getTransformedModelForMetadata(this.model.collisionModel, world.h(i2, j2, k));
        transformedModel.addIntersectingBoxesToCollisionList(world, i2, j2, k, boundingBox, list);
    }

    @Override
    public int a(aab world, int i2, int j2, int k, int iFacing, float fClickX, float fClickY, float fClickZ, int iMetadata) {
        int iVerticalOrientation = 1;
        int iBlockFacing = 2;
        if (iFacing >= 2) {
            if (fClickY > 0.5f) {
                iVerticalOrientation = 0;
            }
            iBlockFacing = iFacing;
        } else if (iFacing == 0) {
            iVerticalOrientation = 0;
        }
        iMetadata = this.setFacing(iMetadata, iBlockFacing);
        iMetadata = this.setVerticalOrientation(iMetadata, iVerticalOrientation);
        return iMetadata;
    }

    @Override
    public int preBlockPlacedBy(aab world, int i2, int j2, int k, int iMetadata, ng entityBy) {
        int iFacing = MiscUtils.convertOrientationToFlatBlockFacingReversed(entityBy);
        return this.setFacing(iMetadata, iFacing);
    }

    @Override
    public ara a(aab world, int i2, int j2, int k, arc startRay, arc endRay) {
        RayTraceUtils rayTrace = new RayTraceUtils(world, i2, j2, k, startRay, endRay);
        BlockModel transformedModel = this.getTransformedModelForMetadata(this.model.rayTraceModel, world.h(i2, j2, k));
        transformedModel.addToRayTrace(rayTrace);
        return rayTrace.getFirstIntersection();
    }

    @Override
    public int getFacing(int iMetadata) {
        return (iMetadata & 3) + 2;
    }

    @Override
    public int setFacing(int iMetadata, int iFacing) {
        iMetadata &= 0xFFFFFFFC;
        return iMetadata |= kx.a(iFacing, 2, 5) - 2;
    }

    @Override
    public boolean canRotateOnTurntable(aak iBlockAccess, int i2, int j2, int k) {
        return true;
    }

    @Override
    public boolean canTransmitRotationHorizontallyOnTurntable(aak blockAccess, int i2, int j2, int k) {
        return true;
    }

    @Override
    public boolean canTransmitRotationVerticallyOnTurntable(aak blockAccess, int i2, int j2, int k) {
        return true;
    }

    @Override
    public int getPistonShovelEjectDirection(aab world, int i2, int j2, int k, int iToFacing) {
        int iMetadata = world.h(i2, j2, k);
        if (iToFacing >= 2) {
            if (iToFacing == this.getFacing(iMetadata)) {
                return this.getVerticalOrientation(iMetadata);
            }
        } else if (iToFacing == this.getVerticalOrientation(iMetadata)) {
            return this.getFacing(iMetadata);
        }
        return -1;
    }

    public int getVerticalOrientation(aak blockAccess, int i2, int j2, int k) {
        return this.getVerticalOrientation(blockAccess.h(i2, j2, k));
    }

    public int getVerticalOrientation(int iMetadata) {
        return (iMetadata & 0xC) >> 2;
    }

    public void setVerticalOrientation(aab world, int i2, int j2, int k, int iLevel) {
        int iMetadata = this.setVerticalOrientation(world.h(i2, j2, k), iLevel);
        world.setBlockMetadataWithNotify(i2, j2, k, iMetadata);
    }

    public int setVerticalOrientation(int iMetadata, int iLevel) {
        iMetadata &= 0xFFFFFFF3;
        return iMetadata |= iLevel << 2;
    }

    private BlockModel getTransformedModelForMetadata(BlockModel model, int iMetadata) {
        BlockModel transformedModel = model.makeTemporaryCopy();
        if (this.getVerticalOrientation(iMetadata) == 0) {
            transformedModel.tiltToFacingAlongY(0);
        }
        transformedModel.rotateAroundYToFacing(this.getFacing(iMetadata));
        return transformedModel;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        super.a(register);
        this.iconEdge = register.a("fcBlockShovel_edge");
        this.iconEdgeBack = register.a("fcBlockShovel_edge_back");
        this.iconEdgeMiddle = register.a("fcBlockShovel_edge_middle");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx getIconByIndex(int iIndex) {
        if (iIndex == 1) {
            return this.iconEdge;
        }
        if (iIndex == 2) {
            return this.iconEdgeBack;
        }
        if (iIndex == 3) {
            return this.iconEdgeMiddle;
        }
        return this.cQ;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        return this.currentBlockRenderer.shouldSideBeRenderedBasedOnCurrentBounds(iNeighborI, iNeighborJ, iNeighborK, iSide);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderBlocks, int i2, int j2, int k) {
        BlockModel transformedModel = this.getTransformedModelForMetadata(this.model, renderBlocks.a.h(i2, j2, k));
        return transformedModel.renderAsBlockWithColorMultiplier(renderBlocks, this, i2, j2, k);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderBlocks, int iItemDamage, float fBrightness) {
        BlockModel transformedModel = this.model.makeTemporaryCopy();
        transformedModel.rotateAroundYToFacing(3);
        transformedModel.renderAsItemBlock(renderBlocks, this, iItemDamage);
    }
}

