/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.blocks.PistonBlockMoving;
import btw.world.util.BlockPos;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class PistonBlockBase
extends aqt {
    @Environment(value=EnvType.CLIENT)
    public static boolean isRenderingExtendedBase = false;

    public PistonBlockBase(int iBlockID, boolean bIsSticky) {
        super(iBlockID, bIsSticky);
        this.setPicksEffectiveOn(true);
        this.initBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    @Override
    public boolean canContainPistonPackingToFacing(aab world, int i2, int j2, int k, int iFacing) {
        int iMetadata = world.h(i2, j2, k);
        return !PistonBlockBase.e(iMetadata) || apa.getOppositeFacing(PistonBlockBase.d(iMetadata)) == iFacing;
    }

    @Override
    public int getFacing(int iMetadata) {
        return iMetadata & 7;
    }

    @Override
    public int setFacing(int iMetadata, int iFacing) {
        return (iMetadata &= 0xFFFFFFF8) | iFacing;
    }

    @Override
    public boolean canRotateOnTurntable(aak blockAccess, int i2, int j2, int k) {
        return !PistonBlockBase.e(blockAccess.h(i2, j2, k));
    }

    @Override
    public boolean canTransmitRotationHorizontallyOnTurntable(aak blockAccess, int i2, int j2, int k) {
        return !PistonBlockBase.e(blockAccess.h(i2, j2, k));
    }

    @Override
    public boolean canTransmitRotationVerticallyOnTurntable(aak blockAccess, int i2, int j2, int k) {
        return !PistonBlockBase.e(blockAccess.h(i2, j2, k));
    }

    @Override
    public int rotateMetadataAroundJAxis(int iMetadata, boolean bReverse) {
        if (!PistonBlockBase.e(iMetadata)) {
            return super.rotateMetadataAroundJAxis(iMetadata, bReverse);
        }
        return iMetadata;
    }

    @Override
    public boolean canBlockBePushedByPiston(aab world, int i2, int j2, int k, int iToFacing) {
        return !PistonBlockBase.e(world.h(i2, j2, k));
    }

    @Override
    protected void k(aab world, int i2, int j2, int k) {
        this.validatePistonState(world, i2, j2, k);
        super.k(world, i2, j2, k);
    }

    @Override
    protected boolean e(aab world, int i2, int j2, int k, int iToFacing) {
        int iOffsetI = i2 + s.b[iToFacing];
        int iOffsetJ = j2 + s.c[iToFacing];
        int iOffsetK = k + s.d[iToFacing];
        for (int iDist = 0; iDist < 13; ++iDist) {
            if (iOffsetJ <= 0 || iOffsetJ >= 255) {
                return false;
            }
            apa tempBlock = r[world.a(iOffsetI, iOffsetJ, iOffsetK)];
            if (tempBlock != null) {
                if (!tempBlock.canBlockBePushedByPiston(world, iOffsetI, iOffsetJ, iOffsetK, iToFacing)) {
                    return false;
                }
                int iMobility = tempBlock.h();
                int iShovelEjectDirection = this.getPistonShovelEjectionDirection(world, iOffsetI, iOffsetJ, iOffsetK, iToFacing);
                if (iMobility != 1 && iShovelEjectDirection < 0) {
                    if (iDist == 12) {
                        return false;
                    }
                    iOffsetI += s.b[iToFacing];
                    iOffsetJ += s.c[iToFacing];
                    iOffsetK += s.d[iToFacing];
                    continue;
                }
            }
            return true;
        }
        return true;
    }

    @Override
    protected boolean f(aab world, int x2, int y2, int z2, int facingTo) {
        int movingZ;
        int movingY;
        int movingX;
        int offsetX = x2 + s.b[facingTo];
        int offsetY = y2 + s.c[facingTo];
        int offsetZ = z2 + s.d[facingTo];
        for (int distance = 0; distance < 13; ++distance) {
            if (offsetY <= 0 || offsetY >= 255) {
                return false;
            }
            int movingBlockID = world.a(offsetX, offsetY, offsetZ);
            apa movingBlock = r[movingBlockID];
            if (movingBlock == null) break;
            if (!movingBlock.canBlockBePushedByPiston(world, offsetX, offsetY, offsetZ, facingTo)) {
                return false;
            }
            int mobilityFlag = movingBlock.h();
            int shovelEjectDirection = this.getPistonShovelEjectionDirection(world, offsetX, offsetY, offsetZ, facingTo);
            if (mobilityFlag != 1 && shovelEjectDirection < 0) {
                if (distance == 12) {
                    return false;
                }
                offsetX += s.b[facingTo];
                offsetY += s.c[facingTo];
                offsetZ += s.d[facingTo];
                continue;
            }
            int movingBlockMetadata = world.h(offsetX, offsetY, offsetZ);
            if (shovelEjectDirection >= 0) {
                movingBlockMetadata = movingBlock.adjustMetadataForPistonMove(movingBlockMetadata);
                int ejectX = offsetX + s.b[shovelEjectDirection];
                int ejectY = offsetY + s.c[shovelEjectDirection];
                int ejectZ = offsetZ + s.d[shovelEjectDirection];
                this.onShovelEjectIntoBlock(world, ejectX, ejectY, ejectZ);
                world.f(ejectX, ejectY, ejectZ, apa.ag.cz, movingBlockMetadata, 4);
                world.a(ejectX, ejectY, ejectZ, PistonBlockMoving.getShoveledTileEntity(movingBlockID, movingBlockMetadata, shovelEjectDirection));
            } else {
                movingBlock.onBrokenByPistonPush(world, offsetX, offsetY, offsetZ, movingBlockMetadata);
            }
            world.i(offsetX, offsetY, offsetZ);
            break;
        }
        int previousOffsetX = offsetX;
        int previousOffsetY = offsetY;
        int previousOffsetZ = offsetZ;
        int blockCounter = 0;
        int[] blockIDList = new int[13];
        while (offsetX != x2 || offsetY != y2 || offsetZ != z2) {
            movingX = offsetX - s.b[facingTo];
            movingY = offsetY - s.c[facingTo];
            movingZ = offsetZ - s.d[facingTo];
            int movingBlockID = world.a(movingX, movingY, movingZ);
            int movingBlockMetadata = world.h(movingX, movingY, movingZ);
            bs tileEntityData = PistonBlockBase.getBlockTileEntityData(world, movingX, movingY, movingZ);
            world.s(movingX, movingY, movingZ);
            if (movingBlockID == this.cz && movingX == x2 && movingY == y2 && movingZ == z2) {
                world.f(offsetX, offsetY, offsetZ, apa.ag.cz, facingTo | (this.a ? 8 : 0), 4);
                world.a(offsetX, offsetY, offsetZ, aqv.a(apa.ae.cz, facingTo | (this.a ? 8 : 0), facingTo, true, false));
            } else {
                if (apa.r[movingBlockID] != null) {
                    movingBlockMetadata = apa.r[movingBlockID].adjustMetadataForPistonMove(movingBlockMetadata);
                }
                world.f(offsetX, offsetY, offsetZ, apa.ag.cz, movingBlockMetadata, 4);
                world.a(offsetX, offsetY, offsetZ, aqv.a(movingBlockID, movingBlockMetadata, facingTo, true, false));
                if (tileEntityData != null) {
                    ((aqw)world.r(offsetX, offsetY, offsetZ)).storeTileEntity(tileEntityData);
                }
            }
            blockIDList[blockCounter++] = movingBlockID;
            offsetX = movingX;
            offsetY = movingY;
            offsetZ = movingZ;
        }
        offsetX = previousOffsetX;
        offsetY = previousOffsetY;
        offsetZ = previousOffsetZ;
        blockCounter = 0;
        while (offsetX != x2 || offsetY != y2 || offsetZ != z2) {
            movingX = offsetX - s.b[facingTo];
            movingY = offsetY - s.c[facingTo];
            movingZ = offsetZ - s.d[facingTo];
            world.f(movingX, movingY, movingZ, blockIDList[blockCounter++]);
            offsetX = movingX;
            offsetY = movingY;
            offsetZ = movingZ;
        }
        return true;
    }

    @Override
    public void a(aak blockAccess, int i2, int j2, int k) {
    }

    @Override
    public void g() {
    }

    @Override
    public aqx getBlockBoundsFromPoolBasedOnState(aak blockAccess, int i2, int j2, int k) {
        int iMetadata = blockAccess.h(i2, j2, k);
        if (PistonBlockBase.e(iMetadata)) {
            switch (PistonBlockBase.d(iMetadata)) {
                case 0: {
                    return aqx.a().a(0.0, 0.25, 0.0, 1.0, 1.0, 1.0);
                }
                case 1: {
                    return aqx.a().a(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
                }
                case 2: {
                    return aqx.a().a(0.0, 0.0, 0.25, 1.0, 1.0, 1.0);
                }
                case 3: {
                    return aqx.a().a(0.0, 0.0, 0.0, 1.0, 1.0, 0.75);
                }
                case 4: {
                    return aqx.a().a(0.25, 0.0, 0.0, 1.0, 1.0, 1.0);
                }
                case 5: {
                    return aqx.a().a(0.0, 0.0, 0.0, 0.75, 1.0, 1.0);
                }
            }
        }
        return super.getBlockBoundsFromPoolBasedOnState(blockAccess, i2, j2, k);
    }

    @Override
    public void a(aab world, int i2, int j2, int k, aqx intersectingBox, List list, mp entity) {
        this.b(world, i2, j2, k).addToListIfIntersects(intersectingBox, list);
    }

    @Override
    public aqx b(aab world, int i2, int j2, int k) {
        return this.getBlockBoundsFromPoolBasedOnState(world, i2, j2, k).d(i2, j2, k);
    }

    @Override
    public boolean canSupportFallingBlocks(aak blockAccess, int i2, int j2, int k) {
        return true;
    }

    @Override
    public int a(aab world, int i2, int j2, int k, int iFacing, float fClickX, float fClickY, float fClickZ, int iMetadata) {
        return PistonBlockBase.getOppositeFacing(iFacing);
    }

    @Override
    public int preBlockPlacedBy(aab world, int i2, int j2, int k, int iMetadata, ng entityBy) {
        int facing = PistonBlockBase.a(world, i2, j2, k, entityBy);
        if (entityBy.isUsingSpecialKey()) {
            facing = s.a[facing];
        }
        return facing;
    }

    @Override
    public void a(aab world, int i2, int j2, int k, ng entityBy, wm stack) {
    }

    @Override
    public void k(aab world, int i2, int j2, int k, int iMetadata) {
        if (!world.I) {
            this.k(world, i2, j2, k);
        }
    }

    protected void validatePistonState(aab world, int i2, int j2, int k) {
        int iMetadata = world.h(i2, j2, k);
        if (!PistonBlockBase.e(iMetadata)) {
            int iTargetMetadata;
            int iFacing = PistonBlockBase.d(iMetadata);
            BlockPos targetPos = new BlockPos(i2, j2, k, iFacing);
            int iTargetBlockID = world.a(targetPos.x, targetPos.y, targetPos.z);
            if (iTargetBlockID == apa.ae.cz && aqu.d(iTargetMetadata = world.h(targetPos.x, targetPos.y, targetPos.z)) == iFacing) {
                world.SetBlockMetadataWithNotify(i2, j2, k, iMetadata | 8, 2);
            }
        }
    }

    protected int getPistonShovelEjectionDirection(aab world, int i2, int j2, int k, int iToFacing) {
        int iShovelEjectDirection;
        int iShovelK;
        int iShovelJ;
        int iOppFacing;
        int iShovelI;
        apa shovelBlock;
        apa block = apa.r[world.a(i2, j2, k)];
        if (block != null && block.canBePistonShoveled(world, i2, j2, k) && (shovelBlock = apa.r[world.a(iShovelI = i2 + s.b[iOppFacing = apa.getOppositeFacing(iToFacing)], iShovelJ = j2 + s.c[iOppFacing], iShovelK = k + s.d[iOppFacing])]) != null && (iShovelEjectDirection = shovelBlock.getPistonShovelEjectDirection(world, iShovelI, iShovelJ, iShovelK, iToFacing)) >= 0 && this.canShovelEjectToFacing(world, i2, j2, k, iShovelEjectDirection)) {
            return iShovelEjectDirection;
        }
        return -1;
    }

    protected boolean canShovelEjectToFacing(aab world, int i2, int j2, int k, int iFacing) {
        int iDestI = i2 + s.b[iFacing];
        int iDestJ = j2 + s.c[iFacing];
        int iDestK = k + s.d[iFacing];
        apa destBlock = apa.r[world.a(iDestI, iDestJ, iDestK)];
        if (destBlock != null) {
            return destBlock.h() == 1;
        }
        return true;
    }

    protected void onShovelEjectIntoBlock(aab world, int i2, int j2, int k) {
        apa block = apa.r[world.a(i2, j2, k)];
        if (block != null && block.h() == 1) {
            block.c(world, i2, j2, k, world.h(i2, j2, k), 0);
            world.i(i2, j2, k);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        int iFacing = PistonBlockBase.d(iMetadata);
        if (iFacing > 5) {
            return this.d;
        }
        if (iSide == iFacing) {
            if (!isRenderingExtendedBase) {
                return this.d;
            }
            return this.b;
        }
        if (iSide == PistonBlockBase.getOppositeFacing(iFacing)) {
            return this.c;
        }
        return this.cQ;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderer, int i2, int j2, int k) {
        renderer.setRenderBounds(this.getBlockBoundsFromPoolBasedOnState(renderer.a, i2, j2, k));
        return renderer.b((apa)this, i2, j2, k, false);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        return this.currentBlockRenderer.shouldSideBeRenderedBasedOnCurrentBounds(iNeighborI, iNeighborJ, iNeighborK, iSide);
    }
}

