/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.FurnaceBlock;
import btw.block.model.BlockModel;
import btw.block.model.OvenModel;
import btw.block.tileentity.OvenTileEntity;
import btw.world.util.BlockPos;
import btw.world.util.WorldUtils;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class OvenBlock
extends FurnaceBlock {
    protected final BlockModel modelBlockInterior = new OvenModel();
    protected final float clickYTopPortion = 0.375f;
    protected final float clickYBottomPortion = 0.375f;
    @Environment(value=EnvType.CLIENT)
    private lx[] fuelOverlays;
    @Environment(value=EnvType.CLIENT)
    private lx currentFuelOverlay = null;
    @Environment(value=EnvType.CLIENT)
    private lx blankOverlay;
    @Environment(value=EnvType.CLIENT)
    protected boolean isRenderingInterior = false;
    @Environment(value=EnvType.CLIENT)
    private int interiorBrightness = 0;

    protected OvenBlock(int iBlockID, boolean bIsLit) {
        super(iBlockID, bIsLit);
        this.setPicksEffectiveOn();
        this.c(2.0f);
        this.b(3.33f);
        this.c("fcBlockFurnaceBrick");
    }

    @Override
    public aqp b(aab world) {
        return new OvenTileEntity();
    }

    @Override
    public boolean a(aab world, int i2, int j2, int k, sq player, int iFacing, float fXClick, float fYClick, float fZClick) {
        int iItemDamage;
        wk item;
        int iMetadata = world.h(i2, j2, k);
        int iBlockFacing = iMetadata & 7;
        if (iBlockFacing != iFacing) {
            return false;
        }
        wm heldStack = player.cd();
        OvenTileEntity tileEntity = (OvenTileEntity)world.r(i2, j2, k);
        wm cookStack = tileEntity.getCookStack();
        if (fYClick > 0.375f) {
            if (cookStack != null) {
                tileEntity.givePlayerCookStack(player, iFacing);
                return true;
            }
            if (heldStack != null && this.isValidCookItem(heldStack)) {
                if (!world.I) {
                    tileEntity.addCookStack(new wm(heldStack.c, 1, heldStack.k()));
                }
                --heldStack.a;
                return true;
            }
        } else if (fYClick < 0.375f && heldStack != null && (item = heldStack.b()).getCanBeFedDirectlyIntoBrickOven(iItemDamage = heldStack.k())) {
            int iItemsConsumed;
            if (!world.I && (iItemsConsumed = tileEntity.attemptToAddFuel(heldStack)) > 0) {
                if (this.b) {
                    world.a((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "mob.ghast.fireball", 0.2f + world.s.nextFloat() * 0.1f, world.s.nextFloat() * 0.25f + 1.25f);
                } else {
                    world.a((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "random.pop", 0.25f, ((world.s.nextFloat() - world.s.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                }
                heldStack.a -= iItemsConsumed;
            }
            return true;
        }
        return false;
    }

    @Override
    public int a(Random rand) {
        return 4 + rand.nextInt(6);
    }

    @Override
    public int a(int iMetaData, Random random, int iFortuneModifier) {
        return wk.aI.cp;
    }

    public void onBlockDestroyedWithImproperTool(aab world, sq player, int i2, int j2, int k, int iMetadata) {
        this.c(world, i2, j2, k, iMetadata, 0);
    }

    public boolean c(aab world, int i2, int j2, int k) {
        if (!WorldUtils.doesBlockHaveSolidTopSurface(world, i2, j2 - 1, k)) {
            return false;
        }
        return super.c(world, i2, j2, k);
    }

    public void a(aab world, int i2, int j2, int k, int iBlockID) {
        if (!WorldUtils.doesBlockHaveSolidTopSurface(world, i2, j2 - 1, k)) {
            this.c(world, i2, j2, k, world.h(i2, j2, k), 0);
            world.setBlockWithNotify(i2, j2, k, 0);
        }
    }

    public boolean hasLargeCenterHardPointToFacing(aak blockAccess, int i2, int j2, int k, int iFacing, boolean bIgnoreTransparency) {
        int iBlockFacing = blockAccess.h(i2, j2, k) & 7;
        return iBlockFacing != iFacing;
    }

    @Override
    public void updateFurnaceBlockState(boolean bBurning, aab world, int i2, int j2, int k, boolean bHasContents) {
        int iMetadata = world.h(i2, j2, k);
        aqp tileEntity = world.r(i2, j2, k);
        c = true;
        if (bBurning) {
            world.c(i2, j2, k, BTWBlocks.burningOven.cz);
        } else {
            world.c(i2, j2, k, BTWBlocks.idleOven.cz);
        }
        c = false;
        iMetadata = !bHasContents ? (iMetadata &= 7) : (iMetadata |= 8);
        world.SetBlockMetadataWithNotify(i2, j2, k, iMetadata, 2);
        if (tileEntity != null) {
            tileEntity.s();
            world.a(i2, j2, k, tileEntity);
        }
    }

    public boolean getCanBeSetOnFireDirectly(aak blockAccess, int i2, int j2, int k) {
        OvenTileEntity tileEntity;
        return !this.b && (tileEntity = (OvenTileEntity)blockAccess.r(i2, j2, k)).getVisualFuelLevel() > 0;
    }

    public boolean setOnFireDirectly(aab world, int i2, int j2, int k) {
        OvenTileEntity tileEntity;
        if (!this.b && (tileEntity = (OvenTileEntity)world.r(i2, j2, k)).attemptToLight()) {
            world.a((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "mob.ghast.fireball", 1.0f, world.s.nextFloat() * 0.4f + 0.8f);
            return true;
        }
        return false;
    }

    public int getChanceOfFireSpreadingDirectlyTo(aak blockAccess, int i2, int j2, int k) {
        OvenTileEntity tileEntity;
        if (!this.b && (tileEntity = (OvenTileEntity)blockAccess.r(i2, j2, k)).hasValidFuel()) {
            return 60;
        }
        return 0;
    }

    public boolean b() {
        return false;
    }

    @Override
    protected int iddroppedsilktouch() {
        return BTWBlocks.idleOven.cz;
    }

    public boolean getIsBlockWarm(aak blockAccess, int i2, int j2, int k) {
        return this.b;
    }

    public boolean doesBlockHopperInsert(aab world, int i2, int j2, int k) {
        return true;
    }

    public boolean isValidCookItem(wm stack) {
        return yg.a().b(stack.b().cp) != null;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        this.cQ = register.a("fcBlockFurnaceBrick_side");
        this.d = register.a("fcBlockFurnaceBrick_top");
        this.e = this.b ? register.a("fcBlockFurnaceBrick_front_lit") : register.a("fcBlockFurnaceBrick_front");
        this.fuelOverlays = new lx[9];
        for (int iTempIndex = 0; iTempIndex < 9; ++iTempIndex) {
            this.fuelOverlays[iTempIndex] = register.a("fcOverlayFurnaceFuel_" + iTempIndex);
        }
        this.blankOverlay = register.a("fcOverlayBlank");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int d(aab world, int i2, int j2, int k) {
        return BTWBlocks.idleOven.cz;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        int iFacing = iMetadata & 7;
        if (iFacing < 2 || iFacing > 5) {
            iFacing = 3;
        }
        if (this.currentFuelOverlay == null) {
            if (iFacing == iSide) {
                return this.e;
            }
            if (iSide < 2) {
                return this.d;
            }
            return this.cQ;
        }
        if (iFacing == iSide) {
            return this.currentFuelOverlay;
        }
        return this.blankOverlay;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        if (this.isRenderingInterior) {
            BlockPos myPos = new BlockPos(iNeighborI, iNeighborJ, iNeighborK, apa.getOppositeFacing(iSide));
            int iFacing = blockAccess.h(myPos.x, myPos.y, myPos.z) & 7;
            return iSide != apa.getOppositeFacing(iFacing);
        }
        return super.a(blockAccess, iNeighborI, iNeighborJ, iNeighborK, iSide);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderer, int i2, int j2, int k) {
        renderer.setRenderBounds(this.getBlockBoundsFromPoolBasedOnState(renderer.a, i2, j2, k));
        renderer.p((apa)((Object)this), i2, j2, k);
        int iFacing = renderer.a.h(i2, j2, k) & 7;
        BlockModel transformedModel = this.modelBlockInterior.makeTemporaryCopy();
        transformedModel.rotateAroundYToFacing(iFacing);
        BlockPos interiorFacesPos = new BlockPos(i2, j2, k, iFacing);
        this.interiorBrightness = this.e(renderer.a, interiorFacesPos.x, interiorFacesPos.y, interiorFacesPos.z);
        renderer.a(this.cQ);
        this.isRenderingInterior = true;
        boolean bReturnValue = transformedModel.renderAsBlockWithColorMultiplier(renderer, (apa)((Object)this), i2, j2, k);
        this.isRenderingInterior = false;
        renderer.a();
        return bReturnValue;
    }

    @Environment(value=EnvType.CLIENT)
    public void renderBlockSecondPass(bgf renderer, int i2, int j2, int k, boolean bFirstPassResult) {
        int iFuelLevel;
        aqp tileEntity;
        if (bFirstPassResult && (tileEntity = renderer.a.r(i2, j2, k)) instanceof OvenTileEntity && (iFuelLevel = ((OvenTileEntity)tileEntity).getVisualFuelLevel()) > 0) {
            iFuelLevel = kx.a(iFuelLevel - 2, 0, 8);
            this.currentFuelOverlay = this.fuelOverlays[iFuelLevel];
            renderer.setRenderBounds(this.getBlockBoundsFromPoolBasedOnState(renderer.a, i2, j2, k));
            renderer.p((apa)((Object)this), i2, j2, k);
            this.currentFuelOverlay = null;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public int e(aak par1IBlockAccess, int par2, int par3, int par4) {
        if (this.isRenderingInterior) {
            return this.interiorBrightness;
        }
        return super.e(par1IBlockAccess, par2, par3, par4);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean renderBlockWithTexture(bgf renderer, int i2, int j2, int k, lx texture) {
        renderer.setRenderBounds(this.getBlockBoundsFromPoolBasedOnState(renderer.a, i2, j2, k));
        renderer.a(texture);
        boolean bReturnValue = renderer.p((apa)((Object)this), i2, j2, k);
        renderer.a();
        return bReturnValue;
    }

    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderBlocks, int iItemDamage, float fBrightness) {
        renderBlocks.renderBlockAsItemVanilla((apa)((Object)this), iItemDamage, fBrightness);
        BlockModel transformedModel = this.modelBlockInterior.makeTemporaryCopy();
        transformedModel.rotateAroundYToFacing(3);
        transformedModel.renderAsItemBlock(renderBlocks, (apa)((Object)this), iItemDamage);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void b(aab world, int i2, int j2, int k, Random rand) {
        if (this.b) {
            wm cookStack;
            OvenTileEntity tileEntity = (OvenTileEntity)world.r(i2, j2, k);
            int iFuelLevel = tileEntity.getVisualFuelLevel();
            if (iFuelLevel == 1) {
                int iFacing = world.h(i2, j2, k) & 7;
                float fX = (float)i2 + 0.5f;
                float fY = (float)j2 + 0.0f + rand.nextFloat() * 6.0f / 16.0f;
                float fZ = (float)k + 0.5f;
                float fFacingOffset = 0.52f;
                float fRandOffset = rand.nextFloat() * 0.6f - 0.3f;
                if (iFacing == 4) {
                    world.a("largesmoke", (double)(fX - fFacingOffset), (double)fY, (double)(fZ + fRandOffset), 0.0, 0.0, 0.0);
                } else if (iFacing == 5) {
                    world.a("largesmoke", (double)(fX + fFacingOffset), (double)fY, (double)(fZ + fRandOffset), 0.0, 0.0, 0.0);
                } else if (iFacing == 2) {
                    world.a("largesmoke", (double)(fX + fRandOffset), (double)fY, (double)(fZ - fFacingOffset), 0.0, 0.0, 0.0);
                } else if (iFacing == 3) {
                    world.a("largesmoke", (double)(fX + fRandOffset), (double)fY, (double)(fZ + fFacingOffset), 0.0, 0.0, 0.0);
                }
            }
            if ((cookStack = tileEntity.getCookStack()) != null && this.isValidCookItem(cookStack)) {
                for (int iTempCount = 0; iTempCount < 1; ++iTempCount) {
                    float fX = (float)i2 + 0.375f + rand.nextFloat() * 0.25f;
                    float fY = (float)j2 + 0.45f + rand.nextFloat() * 0.1f;
                    float fZ = (float)k + 0.375f + rand.nextFloat() * 0.25f;
                    world.a("fcwhitecloud", (double)fX, (double)fY, (double)fZ, 0.0, 0.0, 0.0);
                }
            }
        }
        super.b(world, i2, j2, k, rand);
    }

    @Environment(value=EnvType.CLIENT)
    public void renderBlockMovedByPiston(bgf renderBlocks, int i2, int j2, int k) {
        this.renderBlock(renderBlocks, i2, j2, k);
    }
}

