/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.blocks.OreBlock;
import btw.block.blocks.RoughStoneBlock;
import btw.item.BTWItems;
import btw.item.items.ChiselItem;
import btw.item.items.PickaxeItem;
import btw.item.items.ToolItem;
import btw.item.util.ItemUtils;
import java.util.Random;

public abstract class OreBlockStaged
extends OreBlock {
    public OreBlockStaged(int iBlockID) {
        super(iBlockID);
        this.setChiselsEffectiveOn();
    }

    public boolean canConvertBlock(wm stack, aab world, int i2, int j2, int k) {
        return true;
    }

    public boolean convertBlock(wm stack, aab world, int i2, int j2, int k, int iFromSide) {
        int iLevel;
        int iOldMetadata = world.h(i2, j2, k);
        int iStrata = this.getStrata(iOldMetadata);
        world.setBlockAndMetadataWithNotify(i2, j2, k, RoughStoneBlock.strataLevelBlockArray[iStrata].cz, 4);
        if (!world.I && (iLevel = this.getConversionLevelForTool(stack, world, i2, j2, k)) > 0) {
            world.e(2269, i2, j2, k, 0);
            if (iLevel >= 3) {
                this.ejectItemsOnGoodPickConversion(stack, world, i2, j2, k, iOldMetadata, iFromSide);
            } else if (iLevel == 2) {
                this.ejectItemsOnStonePickConversion(stack, world, i2, j2, k, iOldMetadata, iFromSide);
            } else {
                this.ejectItemsOnChiselConversion(stack, world, i2, j2, k, iOldMetadata, iFromSide);
            }
        }
        return true;
    }

    public void a(aab world, int i2, int j2, int k, int iMetadata, float fChance, int iFortuneModifier) {
        super.a(world, i2, j2, k, iMetadata, fChance, iFortuneModifier);
        if (!world.I) {
            this.dropItemsIndividually(world, i2, j2, k, BTWItems.stone.cp, 6, this.getStrata(iMetadata), 1.0f);
        }
    }

    public int getEfficientToolLevel(aak blockAccess, int i2, int j2, int k) {
        return this.getRequiredToolLevelForOre(blockAccess, i2, j2, k);
    }

    public int getHarvestToolLevel(aak blockAccess, int i2, int j2, int k) {
        int iLevelForOre = this.getRequiredToolLevelForOre(blockAccess, i2, j2, k);
        int iLevelForStrata = this.getRequiredToolLevelForStrata(blockAccess, i2, j2, k);
        if (iLevelForStrata > iLevelForOre) {
            return iLevelForStrata;
        }
        return iLevelForOre;
    }

    public abstract int idDroppedOnConversion(int var1);

    public int damageDroppedOnConversion(int iMetadata) {
        return 0;
    }

    public int quantityDroppedOnConversion(Random rand) {
        return 1;
    }

    public int idDroppedOnStonePickConversion(int iMetadata, Random rand, int iFortuneModifier) {
        return this.a(iMetadata, rand, iFortuneModifier);
    }

    public int damageDroppedOnStonePickConversion(int iMetadata) {
        return this.a(iMetadata);
    }

    public int quantityDroppedOnStonePickConversion(Random rand) {
        return this.a(rand);
    }

    protected void ejectItemsOnGoodPickConversion(wm stack, aab world, int i2, int j2, int k, int iOldMetadata, int iFromSide) {
        ItemUtils.ejectStackFromBlockTowardsFacing(world, i2, j2, k, new wm(this.a(iOldMetadata, world.s, 0), this.a(world.s), this.a(iOldMetadata)), iFromSide);
    }

    protected void ejectItemsOnStonePickConversion(wm stack, aab world, int i2, int j2, int k, int iOldMetadata, int iFromSide) {
        ItemUtils.ejectStackFromBlockTowardsFacing(world, i2, j2, k, new wm(this.idDroppedOnStonePickConversion(iOldMetadata, world.s, 0), this.quantityDroppedOnStonePickConversion(world.s), this.damageDroppedOnStonePickConversion(iOldMetadata)), iFromSide);
    }

    protected void ejectItemsOnChiselConversion(wm stack, aab world, int i2, int j2, int k, int iOldMetadata, int iFromSide) {
        ItemUtils.ejectStackFromBlockTowardsFacing(world, i2, j2, k, new wm(this.idDroppedOnConversion(iOldMetadata), this.quantityDroppedOnConversion(world.s), this.damageDroppedOnConversion(iOldMetadata)), iFromSide);
    }

    public int getRequiredToolLevelForOre(aak blockAccess, int i2, int j2, int k) {
        return 0;
    }

    private int getConversionLevelForTool(wm stack, aab world, int i2, int j2, int k) {
        if (stack != null) {
            int iToolLevel;
            if (stack.b() instanceof PickaxeItem) {
                int iToolLevel2 = ((ToolItem)stack.b()).toolMaterial.d();
                if (iToolLevel2 >= this.getRequiredToolLevelForOre(world, i2, j2, k)) {
                    if (iToolLevel2 > 1) {
                        return 3;
                    }
                    return 2;
                }
            } else if (stack.b() instanceof ChiselItem && (iToolLevel = ((ToolItem)stack.b()).toolMaterial.d()) >= this.getRequiredToolLevelForOre(world, i2, j2, k)) {
                return 1;
            }
        }
        return 0;
    }
}

