/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.util.CustomDamageSource;
import btw.world.util.BlockPos;
import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class NetherGrothBlock
extends apa {
    private static final float BLOCK_HARDNESS = 0.2f;
    @Environment(value=EnvType.CLIENT)
    private lx[] iconBySideArray = new lx[6];
    @Environment(value=EnvType.CLIENT)
    private lx iconTopGrown;

    public NetherGrothBlock(int iBlockID) {
        super(iBlockID, BTWBlocks.netherGrothMaterial);
        this.c(0.2f);
        this.setAxesEffectiveOn(true);
        this.a(BTWBlocks.stepSoundSquish);
        this.c("fcBlockGroth");
        this.b(true);
    }

    @Override
    public void a(aab world, int i2, int j2, int k) {
        super.a(world, i2, j2, k);
        int iBlockBelowID = world.a(i2, j2 - 1, k);
        if (iBlockBelowID == apa.bf.cz) {
            world.setBlockAndMetadata(i2, j2 - 1, k, BTWBlocks.aestheticOpaque.cz, 8);
        }
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iBlockID, int iMetadata) {
        int iHeight = this.getHeightLevel(world, i2, j2, k);
        if (iHeight == 7) {
            this.releaseSpores(world, i2, j2, k);
        }
        super.a(world, i2, j2, k, iBlockID, iMetadata);
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public aqx getBlockBoundsFromPoolBasedOnState(aak blockAccess, int i2, int j2, int k) {
        double dHeight = (double)(this.getHeightLevel(blockAccess, i2, j2, k) + 1) / 16.0;
        return aqx.a().a(0.0, 0.0, 0.0, 1.0, dHeight, 1.0);
    }

    @Override
    public int h() {
        return 1;
    }

    @Override
    public int a(Random random) {
        return 0;
    }

    @Override
    public int a(int iMetaData, Random random, int iFortuneModifier) {
        return 0;
    }

    @Override
    public boolean c(aab world, int i2, int j2, int k) {
        return world.w(i2, j2 - 1, k);
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iChangedBlockID) {
        if (!this.c(world, i2, j2, k)) {
            world.e(2001, i2, j2, k, this.cz + (world.h(i2, j2, k) << 12));
            world.setBlockWithNotify(i2, j2, k, 0);
        }
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random random) {
        int iSubtype;
        int iHeight = this.getHeightLevel(world, i2, j2, k);
        int iBlockBelowID = world.a(i2, j2 - 1, k);
        boolean bOnNetherrack = false;
        if (iBlockBelowID == apa.bf.cz) {
            world.setBlockAndMetadata(i2, j2 - 1, k, BTWBlocks.aestheticOpaque.cz, 8);
            bOnNetherrack = true;
        } else if (iBlockBelowID == BTWBlocks.aestheticOpaque.cz && (iSubtype = world.h(i2, j2 - 1, k)) == 8) {
            bOnNetherrack = true;
        }
        if (iHeight < 7) {
            boolean bGrow = false;
            if (bOnNetherrack) {
                bGrow = true;
            } else if (this.getMaxHeightOfNeighbors(world, i2, j2, k) > iHeight + 1) {
                bGrow = true;
            }
            if (bGrow) {
                this.setHeightLevel(world, i2, j2, k, ++iHeight);
                world.g(i2, j2, k, i2, j2, k);
            }
        }
        if (iHeight >= 1) {
            int iFacing = random.nextInt(4) + 2;
            BlockPos targetPos = new BlockPos(i2, j2, k);
            targetPos.addFacingAsOffset(iFacing);
            if (this.isBlockOpenToSpread(world, targetPos.x, targetPos.y, targetPos.z)) {
                if (world.w(targetPos.x, targetPos.y - 1, targetPos.z)) {
                    this.spreadToBlock(world, targetPos.x, targetPos.y, targetPos.z);
                } else if (bOnNetherrack) {
                    --targetPos.y;
                    if (this.isBlockOpenToSpread(world, targetPos.x, targetPos.y, targetPos.z) && world.w(targetPos.x, targetPos.y - 1, targetPos.z)) {
                        this.spreadToBlock(world, targetPos.x, targetPos.y, targetPos.z);
                    }
                }
            } else if (world.c(i2, j2 + 1, k) && world.a(targetPos.x, targetPos.y, targetPos.z) == apa.bf.cz) {
                ++targetPos.y;
                if (this.isBlockOpenToSpread(world, targetPos.x, targetPos.y, targetPos.z)) {
                    this.spreadToBlock(world, targetPos.x, targetPos.y, targetPos.z);
                }
            }
        }
    }

    @Override
    public void a(aab world, int i2, int j2, int k, mp entity) {
        int iHeight;
        if (!entity.M && !world.I && (iHeight = this.getHeightLevel(world, i2, j2, k)) >= 7) {
            if (entity instanceof ng) {
                sq player;
                boolean bAttack = true;
                if (entity instanceof sq && (player = (sq)entity).isWearingSoulforgedBoots()) {
                    bAttack = false;
                }
                if (bAttack && entity.a(CustomDamageSource.damageSourceGroth, 2)) {
                    entity.an = true;
                    entity.y += 0.84;
                    world.e(2225, i2, j2, k, 0);
                }
            } else if (entity instanceof rh) {
                rh entityItem = (rh)entity;
                if (entityItem.b <= 0 && (entityItem.d().b() instanceof wf || entityItem.d().c == apa.ak.cz || entityItem.d().c == apa.aj.cz)) {
                    entityItem.w();
                    world.e(2226, i2, j2, k, 0);
                }
            }
        }
    }

    @Override
    public float getMovementModifier(aab world, int i2, int j2, int k) {
        return 0.8f;
    }

    public int getHeightLevel(aak blockAccess, int i2, int j2, int k) {
        return this.getHeightLevelFromMetadata(blockAccess.h(i2, j2, k));
    }

    public int getHeightLevelFromMetadata(int iMetdata) {
        return iMetdata & 7;
    }

    public void setHeightLevel(aab world, int i2, int j2, int k, int iHeight) {
        int iMetadata = world.h(i2, j2, k) & 8;
        world.setBlockMetadataWithNotify(i2, j2, k, iMetadata |= iHeight);
    }

    private int getMaxHeightOfNeighbors(aab world, int i2, int j2, int k) {
        int iMaxHeight = -1;
        for (int iTempFacing = 2; iTempFacing <= 5; ++iTempFacing) {
            int iTempHeight;
            BlockPos tempPos = new BlockPos(i2, j2, k);
            tempPos.addFacingAsOffset(iTempFacing);
            if (world.a(tempPos.x, tempPos.y, tempPos.z) != this.cz || (iTempHeight = this.getHeightLevel(world, tempPos.x, tempPos.y, tempPos.z)) <= iMaxHeight) continue;
            iMaxHeight = iTempHeight;
        }
        return iMaxHeight;
    }

    private void spreadToBlock(aab world, int i2, int j2, int k) {
        if (world.a(i2, j2, k) == apa.av.cz) {
            world.e(2227, i2, j2, k, 0);
        } else if (world.a(i2, j2, k) == apa.aj.cz || world.a(i2, j2, k) == apa.ak.cz) {
            world.e(2226, i2, j2, k, 0);
        }
        if (world.setBlockWithNotify(i2, j2, k, this.cz)) {
            world.e(2228, i2, j2, k, 0);
        }
    }

    private boolean isBlockOpenToSpread(aab world, int i2, int j2, int k) {
        if (world.c(i2, j2, k)) {
            return true;
        }
        int iBlockID = world.a(i2, j2, k);
        return iBlockID == apa.av.cz || iBlockID == apa.ak.cz || iBlockID == apa.aj.cz;
    }

    private void releaseSpores(aab world, int i2, int j2, int k) {
        world.e(2224, i2, j2, k, 0);
        for (int iTempI = i2 - 3; iTempI <= i2 + 3; ++iTempI) {
            for (int iTempJ = j2 - 3; iTempJ <= j2 + 3; ++iTempJ) {
                for (int iTempK = k - 3; iTempK <= k + 3; ++iTempK) {
                    if (iTempI == i2 && iTempJ == j2 && iTempK == k || !this.isBlockOpenToSpread(world, iTempI, iTempJ, iTempK) || !world.w(iTempI, iTempJ - 1, iTempK) || world.s.nextInt(2) != 0) continue;
                    world.setBlockWithNotify(iTempI, iTempJ, iTempK, this.cz);
                }
            }
        }
        double posX = (double)i2 + 0.5;
        double posY = (double)j2 + 0.5;
        double posZ = (double)k + 0.5;
        List list = world.a(ng.class, aqx.a().a(posX - 5.0, posY - 5.0, posZ - 5.0, posX + 5.0, posY + 5.0, posZ + 5.0));
        if (list != null && list.size() > 0) {
            for (int listIndex = 0; listIndex < list.size(); ++listIndex) {
                sq player;
                ng targetEntity = (ng)list.get(listIndex);
                boolean bDamageEntity = true;
                if (targetEntity instanceof sq && (player = (sq)targetEntity).isWearingFullSuitSoulforgedArmor()) {
                    bDamageEntity = false;
                }
                if (!bDamageEntity) continue;
                targetEntity.a(CustomDamageSource.damageSourceGrothSpores, 4);
                targetEntity.d(new ml(mk.u.H, 300, 0));
            }
        }
    }

    @Override
    public boolean attemptToAffectBlockWithSoul(aab world, int x2, int y2, int z2) {
        int iHeightLevel = this.getHeightLevel(world, x2, y2, z2);
        if (iHeightLevel < 7) {
            this.setHeightLevel(world, x2, y2, z2, 7);
            return true;
        }
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        lx sideIcon;
        lx bottomIcon;
        this.cQ = bottomIcon = register.a("fcBlockGroth_bottom");
        this.iconBySideArray[0] = bottomIcon;
        this.iconBySideArray[1] = register.a("fcBlockGroth_top");
        this.iconBySideArray[2] = sideIcon = register.a("fcBlockGroth_side");
        this.iconBySideArray[3] = sideIcon;
        this.iconBySideArray[4] = sideIcon;
        this.iconBySideArray[5] = sideIcon;
        this.iconTopGrown = register.a("fcBlockGroth_top_grown");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        int iHeight;
        if (iSide == 1 && (iHeight = this.getHeightLevelFromMetadata(iMetadata)) >= 7) {
            return this.iconTopGrown;
        }
        return this.iconBySideArray[iSide];
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void b(aab world, int i2, int j2, int k, Random random) {
        super.b(world, i2, j2, k, random);
        if (random.nextInt(10) == 0) {
            float fHeight = (float)(this.getHeightLevel(world, i2, j2, k) + 1) / 16.0f;
            world.a("townaura", (double)((float)i2 + random.nextFloat()), (double)((float)j2 + fHeight + 0.1f), (double)((float)k + random.nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        if (iSide == 0) {
            return false;
        }
        if (iSide != 1) {
            int iNeighborBlockID = blockAccess.a(iNeighborI, iNeighborJ, iNeighborK);
            if (iNeighborBlockID == this.cz) {
                int iNeighborHeightLevel = this.getHeightLevel(blockAccess, iNeighborI, iNeighborJ, iNeighborK);
                if (iNeighborHeightLevel >= 7) {
                    return false;
                }
                BlockPos myPos = new BlockPos(iNeighborI, iNeighborJ, iNeighborK, apa.getOppositeFacing(iSide));
                int iMyHeightLevel = this.getHeightLevel(blockAccess, myPos.x, myPos.y, myPos.z);
                if (iNeighborHeightLevel >= iMyHeightLevel) {
                    return false;
                }
            } else {
                apa neighborBlock = apa.r[iNeighborBlockID];
                if (neighborBlock != null) {
                    return neighborBlock.shouldRenderNeighborHalfSlabSide(blockAccess, iNeighborI, iNeighborJ, iNeighborK, iSide, false);
                }
            }
        }
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean shouldRenderNeighborHalfSlabSide(aak blockAccess, int i2, int j2, int k, int iNeighborSlabSide, boolean bNeighborUpsideDown) {
        return bNeighborUpsideDown || this.getHeightLevel(blockAccess, i2, j2, k) < 7;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean shouldRenderNeighborFullFaceSide(aak blockAccess, int i2, int j2, int k, int iNeighborSide) {
        return iNeighborSide != 1;
    }
}

