/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.AttachedSlabBlock;
import btw.block.blocks.MyceliumBlock;
import btw.item.BTWItems;
import com.prupe.mcpatcher.mal.block.RenderBlocksUtils;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class MyceliumSlabBlock
extends AttachedSlabBlock {
    @Environment(value=EnvType.CLIENT)
    private lx iconTopSparse;
    @Environment(value=EnvType.CLIENT)
    private lx iconBottom;
    @Environment(value=EnvType.CLIENT)
    private lx iconSide;
    @Environment(value=EnvType.CLIENT)
    private lx iconSideHalf;
    @Environment(value=EnvType.CLIENT)
    private lx iconSideSnow;
    @Environment(value=EnvType.CLIENT)
    private lx iconSideHalfSnow;

    public MyceliumSlabBlock(int iBlockID) {
        super(iBlockID, aif.b);
        this.c(0.6f);
        this.setShovelsEffectiveOn();
        this.a(apa.i);
        this.c("fcBlockMyceliumSlab");
        this.b(true);
        this.a(ve.b);
    }

    @Override
    public void a(aab world, int x2, int y2, int z2, Random rand) {
        if (!MyceliumBlock.canMyceliumSurviveAtLocation(world, x2, y2, z2)) {
            this.revertToDirt(world, x2, y2, z2);
        } else {
            MyceliumBlock.checkForMyceliumSpreadFromLocation(world, x2, y2, z2);
            if (this.isSparse(world, x2, y2, z2) && rand.nextInt(4) == 0) {
                this.setFullyGrown(world, x2, y2, z2);
            }
        }
    }

    @Override
    public int a(int metadata, Random random, int fortuneModifier) {
        return BTWBlocks.looseDirtSlab.cz;
    }

    @Override
    public boolean dropComponentItemsOnBadBreak(aab world, int x2, int y2, int z2, int iMetadata, float fChanceOfDrop) {
        this.dropItemsIndividually(world, x2, y2, z2, BTWItems.dirtPile.cp, 3, 0, fChanceOfDrop);
        return true;
    }

    @Override
    public boolean attemptToCombineWithFallingEntity(aab world, int x2, int y2, int z2, rg entity) {
        if (entity.a == BTWBlocks.looseDirtSlab.cz && !this.getIsUpsideDown(world, x2, y2, z2)) {
            world.setBlockWithNotify(x2, y2, z2, BTWBlocks.looseDirt.cz);
            return true;
        }
        return super.attemptToCombineWithFallingEntity(world, x2, y2, z2, entity);
    }

    @Override
    protected void onAnchorBlockLost(aab world, int x2, int y2, int z2) {
        world.f(x2, y2, z2, BTWBlocks.looseDirtSlab.cz, world.h(x2, y2, z2) & 3, 2);
    }

    @Override
    public int getCombinedBlockID(int metadata) {
        return apa.bC.cz;
    }

    @Override
    public boolean canBePistonShoveled(aab world, int x2, int y2, int z2) {
        return true;
    }

    @Override
    protected boolean r_() {
        return true;
    }

    @Override
    public boolean canMobsSpawnOn(aab world, int x2, int y2, int z2) {
        return false;
    }

    @Override
    public boolean canBeGrazedOn(aak blockAccess, int x2, int y2, int z2, qh animal) {
        if (!this.isSparse(blockAccess, x2, y2, z2) || animal.isStarving() || animal.getDisruptsEarthOnGraze()) {
            return animal.canGrazeMycelium();
        }
        return false;
    }

    @Override
    public void onGrazed(aab world, int x2, int y2, int z2, qh animal) {
        if (!animal.getDisruptsEarthOnGraze()) {
            if (this.isSparse(world, x2, y2, z2)) {
                world.setBlockWithNotify(x2, y2, z2, apa.z.cz);
            } else {
                this.setSparse(world, x2, y2, z2);
            }
        } else {
            world.setBlockWithNotify(x2, y2, z2, BTWBlocks.looseDirt.cz);
            this.notifyNeighborsBlockDisrupted(world, x2, y2, z2);
        }
    }

    @Override
    public void onVegetationAboveGrazed(aab world, int x2, int y2, int z2, qh animal) {
        if (animal.getDisruptsEarthOnGraze()) {
            world.setBlockWithNotify(x2, y2, z2, BTWBlocks.looseDirt.cz);
            this.notifyNeighborsBlockDisrupted(world, x2, y2, z2);
        }
    }

    @Override
    public void onBlockDestroyedWithImproperTool(aab world, sq player, int i2, int j2, int k, int iMetadata) {
        super.onBlockDestroyedWithImproperTool(world, player, i2, j2, k, iMetadata);
        this.onDirtSlabDugWithImproperTool(world, i2, j2, k, this.getIsUpsideDown(iMetadata));
    }

    @Override
    public void a(aab world, int i2, int j2, int k, zw explosion) {
        super.a(world, i2, j2, k, explosion);
        this.onDirtSlabDugWithImproperTool(world, i2, j2, k, this.getIsUpsideDown(world, i2, j2, k));
    }

    public void revertToDirt(aab world, int x2, int y2, int z2) {
        boolean isUpsideDown = this.getIsUpsideDown(world, x2, y2, z2);
        world.setBlockWithNotify(x2, y2, z2, BTWBlocks.dirtSlab.cz);
        BTWBlocks.dirtSlab.setSubtype(world, x2, y2, z2, 0);
        BTWBlocks.dirtSlab.setIsUpsideDown(world, x2, y2, z2, isUpsideDown);
    }

    public boolean isSparse(aak blockAccess, int x2, int y2, int z2) {
        return this.isSparse(blockAccess.h(x2, y2, z2));
    }

    public boolean isSparse(int metadata) {
        return (metadata & 0xFFFFFFFF) == 2;
    }

    public void setSparse(aab world, int x2, int y2, int z2) {
        int metadata = world.h(x2, y2, z2);
        world.setBlockMetadata(x2, y2, z2, metadata | 2);
    }

    public void setFullyGrown(aab world, int x2, int y2, int z2) {
        int metadata = world.h(x2, y2, z2);
        world.setBlockMetadata(x2, y2, z2, metadata & 1);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        this.cQ = register.a("fcBlockMyceliumSlab_top");
        this.iconTopSparse = register.a("fcBlockMyceliumSparse");
        this.iconBottom = register.a("fcBlockMyceliumSlab_bottom");
        this.iconSide = register.a("fcBlockMyceliumSlab_side");
        this.iconSideHalf = register.a("fcBlockMyceliumSlab_side_half");
        this.iconSideSnow = register.a("snow_side");
        this.iconSideHalfSnow = register.a("FCBlockSlabDirt_grass_snow_side");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int metadata) {
        if (iSide < 2) {
            if (iSide == 0) {
                return this.iconBottom;
            }
            lx topIcon = this.isSparse(metadata) ? this.iconTopSparse : this.cQ;
            return topIcon;
        }
        if (this.getIsUpsideDown(metadata)) {
            return this.iconSide;
        }
        return this.iconSideHalf;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx b_(aak blockAccess, int x2, int y2, int z2, int side) {
        int metadata = blockAccess.h(x2, y2, z2);
        lx topIcon = this.isSparse(blockAccess, x2, y2, z2) ? this.iconTopSparse : this.cQ;
        if (side > 1 && this.isSnowCoveringTopSurface(blockAccess, x2, y2, z2)) {
            lx betterGrassIcon = RenderBlocksUtils.getGrassTexture(this, blockAccess, x2, y2, z2, side, topIcon);
            if (betterGrassIcon != null) {
                return betterGrassIcon;
            }
            if (this.getIsUpsideDown(metadata)) {
                return this.iconSideSnow;
            }
            return this.iconSideHalfSnow;
        }
        lx betterGrassIcon = RenderBlocksUtils.getGrassTexture(apa.bC, blockAccess, x2, y2, z2, side, topIcon);
        if (betterGrassIcon != null) {
            return betterGrassIcon;
        }
        return this.a(side, metadata);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void b(aab world, int i2, int j2, int k, Random rand) {
        super.b(world, i2, j2, k, rand);
        if (rand.nextInt(10) == 0) {
            double dYParticle = (double)j2 + 0.6;
            if (this.getIsUpsideDown(world, i2, j2, k)) {
                dYParticle += 0.5;
            }
            world.a("townaura", (double)i2 + rand.nextDouble(), dYParticle, (double)k + rand.nextDouble(), 0.0, 0.0, 0.0);
        }
    }
}

