/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.blocks.SidingAndCornerBlock;
import btw.block.util.RayTraceUtils;
import btw.world.util.BlockPos;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class MouldingBlock
extends apa {
    protected static final double MOULDING_WIDTH = 0.5;
    protected static final double MOULDING_HALF_WIDTH = 0.25;
    protected static final double MOULDING_LENGTH = 1.0;
    private static final int[][] facingOfConnections = new int[][]{{-1, 4, -1, 5, 5, 4, 4, 5, -1, 4, -1, 5}, {1, 1, 1, 1, -1, -1, -1, -1, 0, 0, 0, 0}, {3, -1, 2, -1, 3, 3, 2, 2, 3, -1, 2, -1}};
    private static final int[][] alignmentOffsetAlongAxis = new int[][]{{0, 1, 0, -1, -1, 1, 1, -1, 0, 1, 0, -1}, {-1, -1, -1, -1, 0, 0, 0, 0, 1, 1, 1, 1}, {-1, 0, 1, 0, -1, -1, 1, 1, -1, 0, 1, 0}};
    protected int matchingCornerBlockID;
    String textureName;

    protected MouldingBlock(int iBlockID, aif material, String sTextureName, int iMatchingCornerBlockID, float fHardness, float fResistance, ape stepSound, String name) {
        super(iBlockID, material);
        this.c(fHardness);
        this.b(fResistance);
        this.initBlockBounds(0.25, 0.25, 0.0, 0.75, 0.75, 1.0);
        this.a(stepSound);
        this.c(name);
        this.matchingCornerBlockID = iMatchingCornerBlockID;
        this.textureName = sTextureName;
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public ara a(aab world, int i2, int j2, int k, arc startRay, arc endRay) {
        int iAlignment = this.getMouldingAlignment(world, i2, j2, k);
        RayTraceUtils rayTrace = new RayTraceUtils(world, i2, j2, k, startRay, endRay);
        rayTrace.addBoxWithLocalCoordsToIntersectionList(this.getBlockBoundsFromPoolForAlignment(iAlignment));
        for (int iAxis = 0; iAxis <= 2; ++iAxis) {
            aqx tempBox = this.getBlockBoundsFromPoolForConnectingBlocksAlongAxis(world, i2, j2, k, iAxis);
            if (tempBox == null) continue;
            rayTrace.addBoxWithLocalCoordsToIntersectionList(tempBox);
        }
        return rayTrace.getFirstIntersection();
    }

    @Override
    public void a(aab world, int i2, int j2, int k, aqx intersectingBox, List list, mp entity) {
        int iAlignment = this.getMouldingAlignment(world, i2, j2, k);
        this.getBlockBoundsFromPoolForAlignment(iAlignment).d(i2, j2, k).addToListIfIntersects(intersectingBox, list);
        for (int iAxis = 0; iAxis <= 2; ++iAxis) {
            aqx tempBox = this.getBlockBoundsFromPoolForConnectingBlocksAlongAxis(world, i2, j2, k, iAxis);
            if (tempBox == null) continue;
            tempBox.d(i2, j2, k).addToListIfIntersects(intersectingBox, list);
        }
    }

    @Override
    public int a(aab world, int i2, int j2, int k, int iFacing, float fClickX, float fClickY, float fClickZ, int iMetadata) {
        int iAlignment = 0;
        float fXOffsetFromCenter = Math.abs(fClickX - 0.5f);
        float fYOffsetFromCenter = Math.abs(fClickY - 0.5f);
        float fZOffsetFromCenter = Math.abs(fClickZ - 0.5f);
        switch (iFacing) {
            case 0: {
                if (fXOffsetFromCenter > fZOffsetFromCenter) {
                    if (fClickX > 0.5f) {
                        iAlignment = 9;
                        break;
                    }
                    iAlignment = 11;
                    break;
                }
                if (fClickZ > 0.5f) {
                    iAlignment = 10;
                    break;
                }
                iAlignment = 8;
                break;
            }
            case 1: {
                if (fXOffsetFromCenter > fZOffsetFromCenter) {
                    if (fClickX > 0.5f) {
                        iAlignment = 1;
                        break;
                    }
                    iAlignment = 3;
                    break;
                }
                if (fClickZ > 0.5f) {
                    iAlignment = 2;
                    break;
                }
                iAlignment = 0;
                break;
            }
            case 2: {
                if (fXOffsetFromCenter > fYOffsetFromCenter) {
                    if (fClickX > 0.5f) {
                        iAlignment = 6;
                        break;
                    }
                    iAlignment = 7;
                    break;
                }
                if (fClickY > 0.5f) {
                    iAlignment = 10;
                    break;
                }
                iAlignment = 2;
                break;
            }
            case 3: {
                if (fXOffsetFromCenter > fYOffsetFromCenter) {
                    if (fClickX > 0.5f) {
                        iAlignment = 5;
                        break;
                    }
                    iAlignment = 4;
                    break;
                }
                if (fClickY > 0.5f) {
                    iAlignment = 8;
                    break;
                }
                iAlignment = 0;
                break;
            }
            case 4: {
                if (fZOffsetFromCenter > fYOffsetFromCenter) {
                    if (fClickZ > 0.5f) {
                        iAlignment = 6;
                        break;
                    }
                    iAlignment = 5;
                    break;
                }
                if (fClickY > 0.5f) {
                    iAlignment = 9;
                    break;
                }
                iAlignment = 1;
                break;
            }
            default: {
                if (fZOffsetFromCenter > fYOffsetFromCenter) {
                    if (fClickZ > 0.5f) {
                        iAlignment = 7;
                        break;
                    }
                    iAlignment = 4;
                    break;
                }
                iAlignment = fClickY > 0.5f ? 11 : 3;
            }
        }
        return this.setMouldingAlignmentInMetadata(iMetadata, iAlignment);
    }

    @Override
    public boolean canRotateOnTurntable(aak blockAccess, int i2, int j2, int k) {
        int iAlignment = this.getMouldingAlignment(blockAccess, i2, j2, k);
        return iAlignment < 8;
    }

    @Override
    public int rotateMetadataAroundJAxis(int iMetadata, boolean bReverse) {
        int iAlignment = this.getMouldingAlignmentFromMetadata(iMetadata);
        if (bReverse) {
            if (++iAlignment == 4) {
                iAlignment = 0;
            } else if (iAlignment == 8) {
                iAlignment = 4;
            } else if (iAlignment >= 12) {
                iAlignment = 8;
            }
        } else if (--iAlignment < 0) {
            iAlignment = 3;
        } else if (iAlignment == 3) {
            iAlignment = 7;
        } else if (iAlignment == 7) {
            iAlignment = 11;
        }
        iMetadata = this.setMouldingAlignmentInMetadata(iMetadata, iAlignment);
        return iMetadata;
    }

    @Override
    public boolean toggleFacing(aab world, int i2, int j2, int k, boolean bReverse) {
        int iAlignment = this.getMouldingAlignment(world, i2, j2, k);
        if (!bReverse) {
            if (++iAlignment > 11) {
                iAlignment = 0;
            }
        } else if (--iAlignment < 0) {
            iAlignment = 11;
        }
        this.setMouldingAlignment(world, i2, j2, k, iAlignment);
        world.g(i2, j2, k, i2, j2, k);
        return true;
    }

    @Override
    public float mobSpawnOnVerticalOffset(aab world, int i2, int j2, int k) {
        int iAlignment = this.getMouldingAlignment(world, i2, j2, k);
        if (iAlignment < 4) {
            return -0.5f;
        }
        return 0.0f;
    }

    @Override
    public aqx getBlockBoundsFromPoolBasedOnState(aak blockAccess, int i2, int j2, int k) {
        return this.getBlockBoundsFromPoolForAlignment(this.getMouldingAlignment(blockAccess, i2, j2, k));
    }

    public aqx getBlockBoundsFromPoolForAlignment(int iAlignment) {
        aqx bounds = aqx.a().a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        if (iAlignment == 0) {
            bounds.e = bounds.b + 0.5;
            bounds.f = bounds.c + 0.5;
        } else if (iAlignment == 1) {
            bounds.a += 0.5;
            bounds.e = bounds.b + 0.5;
        } else if (iAlignment == 2) {
            bounds.e = bounds.b + 0.5;
            bounds.c += 0.5;
        } else if (iAlignment == 3) {
            bounds.d = bounds.a + 0.5;
            bounds.e = bounds.b + 0.5;
        } else if (iAlignment == 4) {
            bounds.d = bounds.a + 0.5;
            bounds.f = bounds.c + 0.5;
        } else if (iAlignment == 5) {
            bounds.a += 0.5;
            bounds.f = bounds.c + 0.5;
        } else if (iAlignment == 6) {
            bounds.a += 0.5;
            bounds.c += 0.5;
        } else if (iAlignment == 7) {
            bounds.d = bounds.a + 0.5;
            bounds.c += 0.5;
        } else if (iAlignment == 8) {
            bounds.b += 0.5;
            bounds.f = bounds.c + 0.5;
        } else if (iAlignment == 9) {
            bounds.a += 0.5;
            bounds.b += 0.5;
        } else if (iAlignment == 10) {
            bounds.b += 0.5;
            bounds.c += 0.5;
        } else {
            bounds.d = bounds.a + 0.5;
            bounds.b += 0.5;
        }
        return bounds;
    }

    protected boolean isMouldingOfSameType(aak blockAccess, int i2, int j2, int k) {
        return blockAccess.a(i2, j2, k) == this.cz;
    }

    public int getMouldingAlignment(aak iBlockAccess, int i2, int j2, int k) {
        return this.getMouldingAlignmentFromMetadata(iBlockAccess.h(i2, j2, k));
    }

    public int getMouldingAlignmentFromMetadata(int iMetadata) {
        return iMetadata;
    }

    public void setMouldingAlignment(aab world, int i2, int j2, int k, int iAlignment) {
        int iMetadata = world.h(i2, j2, k);
        iMetadata = this.setMouldingAlignmentInMetadata(iMetadata, iAlignment);
        world.setBlockMetadataWithNotify(i2, j2, k, iMetadata);
    }

    public int setMouldingAlignmentInMetadata(int iMetadata, int iAlignment) {
        return iAlignment;
    }

    private float clickOffsetFromCenter(float fClickPos) {
        return Math.abs(fClickPos - 0.5f);
    }

    private static void offsetCornerBoundingBoxAlongAxis(int iAxis, int iOffset, arc min, arc max) {
        if (iOffset > 0) {
            if (iAxis == 0) {
                min.c += 0.5;
                max.c += 0.5;
            } else if (iAxis == 1) {
                min.d += 0.5;
                max.d += 0.5;
            } else {
                min.e += 0.5;
                max.e += 0.5;
            }
        }
    }

    private boolean isAlignedAlongAxis(aak blockAccess, int i2, int j2, int k, int iAxis) {
        int iAlignment = this.getMouldingAlignment(blockAccess, i2, j2, k);
        return facingOfConnections[iAxis][iAlignment] < 0;
    }

    private int getAlignmentOfConnectingMouldingAtLocation(aak blockAccess, int i2, int j2, int k, int iAlignmentToConnectTo, int iAxisToConnectAlong) {
        int iBlockID = blockAccess.a(i2, j2, k);
        if (this.isMouldingOfSameType(blockAccess, i2, j2, k) && this.isAlignedAlongAxis(blockAccess, i2, j2, k, iAxisToConnectAlong)) {
            int iTargetAlignment = this.getMouldingAlignment(blockAccess, i2, j2, k);
            for (int iTempAxis = 0; iTempAxis <= 2; ++iTempAxis) {
                if (iTempAxis == iAxisToConnectAlong || facingOfConnections[iTempAxis][iTargetAlignment] != facingOfConnections[iTempAxis][iAlignmentToConnectTo]) continue;
                return iTargetAlignment;
            }
        }
        return -1;
    }

    private int getConnectingCornerFacingAtLocation(aak blockAccess, int i2, int j2, int k, int iAlignmentToConnectTo, int iAxisToConnectAlong) {
        int iMetadata;
        SidingAndCornerBlock corner;
        int iBlockID = blockAccess.a(i2, j2, k);
        if (iBlockID == this.matchingCornerBlockID && (corner = (SidingAndCornerBlock)apa.r[iBlockID]).getIsCorner(iMetadata = blockAccess.h(i2, j2, k))) {
            int iCornerFacing = corner.getFacing(iMetadata);
            if (alignmentOffsetAlongAxis[iAxisToConnectAlong][iAlignmentToConnectTo] == SidingAndCornerBlock.getCornerAlignmentOffsetAlongAxis(iCornerFacing, iAxisToConnectAlong)) {
                int iReturnValue = -1;
                for (int iTempAxis = 0; iTempAxis <= 2; ++iTempAxis) {
                    if (iTempAxis == iAxisToConnectAlong) continue;
                    if (alignmentOffsetAlongAxis[iTempAxis][iAlignmentToConnectTo] == 0) {
                        iReturnValue = iCornerFacing;
                        continue;
                    }
                    if (alignmentOffsetAlongAxis[iTempAxis][iAlignmentToConnectTo] == SidingAndCornerBlock.getCornerAlignmentOffsetAlongAxis(iCornerFacing, iTempAxis)) continue;
                    return -1;
                }
                return iReturnValue;
            }
        }
        return -1;
    }

    private aqx getBlockBoundsFromPoolForConnectingBlocksAlongAxis(aak blockAccess, int i2, int j2, int k, int iAxis) {
        int iAlignment = this.getMouldingAlignment(blockAccess, i2, j2, k);
        int iConnectionToFacing = facingOfConnections[iAxis][iAlignment];
        if (iConnectionToFacing >= 0) {
            BlockPos connectingPos = new BlockPos(i2, j2, k, iConnectionToFacing);
            int iConnectingAlignment = this.getAlignmentOfConnectingMouldingAtLocation(blockAccess, connectingPos.x, connectingPos.y, connectingPos.z, iAlignment, iAxis);
            if (iConnectingAlignment >= 0) {
                return this.getBlockBoundsFromPoolForConnectingMoulding(iConnectionToFacing, iConnectingAlignment);
            }
            int iConnectingFacing = this.getConnectingCornerFacingAtLocation(blockAccess, connectingPos.x, connectingPos.y, connectingPos.z, iAlignment, iAxis);
            if (iConnectingFacing >= 0) {
                return this.getBlockBoundsFromPoolForConnectingCorner(iAxis, alignmentOffsetAlongAxis[iAxis][iAlignment], iConnectingFacing);
            }
        }
        return null;
    }

    private aqx getBlockBoundsFromPoolForConnectingMoulding(int iToFacing, int iToAlignment) {
        aqx box = this.getBlockBoundsFromPoolForAlignment(iToAlignment);
        if (iToFacing == 0) {
            box.e = 0.5;
        } else if (iToFacing == 1) {
            box.b = 0.5;
        } else if (iToFacing == 2) {
            box.f = 0.5;
        } else if (iToFacing == 3) {
            box.c = 0.5;
        } else if (iToFacing == 4) {
            box.d = 0.5;
        } else {
            box.a = 0.5;
        }
        return box;
    }

    private aqx getBlockBoundsFromPoolForConnectingCorner(int iConnectingAxis, int iOffsetAlongAxis, int iCornerFacing) {
        arc cornerMin = arc.a(0.0, 0.0, 0.0);
        arc cornerMax = arc.a(0.5, 0.5, 0.5);
        this.offsetBoundingBoxForConnectingCorner(iConnectingAxis, iOffsetAlongAxis, iCornerFacing, cornerMin, cornerMax);
        return aqx.a().a(cornerMin.c, cornerMin.d, cornerMin.e, cornerMax.c, cornerMax.d, cornerMax.e);
    }

    private void offsetBoundingBoxForConnectingCorner(int iConnectingAxis, int iOffsetAlongAxis, int iCornerFacing, arc boundingMin, arc boundingMax) {
        for (int iTempAxis = 0; iTempAxis <= 2; ++iTempAxis) {
            if (iTempAxis == iConnectingAxis) {
                MouldingBlock.offsetCornerBoundingBoxAlongAxis(iTempAxis, -iOffsetAlongAxis, boundingMin, boundingMax);
                continue;
            }
            MouldingBlock.offsetCornerBoundingBoxAlongAxis(iTempAxis, SidingAndCornerBlock.getCornerAlignmentOffsetAlongAxis(iCornerFacing, iTempAxis), boundingMin, boundingMax);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        this.cQ = register.a(this.textureName);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        return this.currentBlockRenderer.shouldSideBeRenderedBasedOnCurrentBounds(iNeighborI, iNeighborJ, iNeighborK, iSide);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public aqx c_(aab world, int i2, int j2, int k) {
        int iAlignment = this.getMouldingAlignment(world, i2, j2, k);
        aqx box = this.getBlockBoundsFromPoolForAlignment(iAlignment);
        for (int iAxis = 0; iAxis <= 2; ++iAxis) {
            aqx tempBox = this.getBlockBoundsFromPoolForConnectingBlocksAlongAxis(world, i2, j2, k, iAxis);
            if (tempBox == null) continue;
            box.expandToInclude(tempBox);
        }
        return box.d(i2, j2, k);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderer, int i2, int j2, int k) {
        aak blockAccess = renderer.a;
        int iAlignment = this.getMouldingAlignment(blockAccess, i2, j2, k);
        renderer.setRenderBounds(this.getBlockBoundsFromPoolForAlignment(iAlignment));
        renderer.p(this, i2, j2, k);
        for (int iAxis = 0; iAxis <= 2; ++iAxis) {
            aqx tempBox = this.getBlockBoundsFromPoolForConnectingBlocksAlongAxis(blockAccess, i2, j2, k, iAxis);
            if (tempBox == null) continue;
            renderer.setRenderBounds(tempBox);
            renderer.p(this, i2, j2, k);
        }
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int d(aab world, int i2, int j2, int k) {
        return this.a(world.h(i2, j2, k), world.s, 0);
    }
}

