/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.MouldingBlock;
import btw.block.util.RayTraceUtils;
import btw.client.render.util.RenderUtils;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class MouldingAndDecorativeBlock
extends MouldingBlock {
    public static final int SUBTYPE_COLUMN = 12;
    public static final int SUBTYPE_PEDESTAL_UP = 13;
    public static final int SUBTYPE_PEDESTAL_DOWN = 14;
    public static final int SUBTYPE_TABLE = 15;
    protected static final double COLUM_WIDTH = 0.625;
    protected static final double COLUM_HALF_WIDTH = 0.3125;
    protected static final double PEDESTAL_BASE_HEIGHT = 0.75;
    protected static final double PEDESTAL_MIDDLE_HEIGHT = 0.125;
    protected static final double PEDESTAL_MIDDLE_WIDTH = 0.875;
    protected static final double PEDESTAL_MIDDLE_HALF_WIDTH = 0.4375;
    protected static final double PEDESTAL_TOP_HEIGHT = 0.125;
    protected static final double PEDESTAL_TOP_WIDTH = 0.75;
    protected static final double PEDESTAL_TOP_HALF_WIDTH = 0.375;
    protected static final double TABLE_TOP_HEIGHT = 0.125;
    protected static final double TABLE_LEG_HEIGHT = 0.875;
    protected static final double TABLE_LEG_WIDTH = 0.25;
    protected static final double TABLE_LEG_HALF_WIDTH = 0.125;
    String columnSideTextureName;
    String columnTopAndBottomTextureName;
    String pedestalSideTextureName;
    String pedestalTopAndBottomTextureName;
    @Environment(value=EnvType.CLIENT)
    private lx iconColumnSide;
    @Environment(value=EnvType.CLIENT)
    private lx iconColumnTopAndBottom;
    @Environment(value=EnvType.CLIENT)
    private lx iconPedestalSide;
    @Environment(value=EnvType.CLIENT)
    private lx iconPedestalTopAndBottom;

    public MouldingAndDecorativeBlock(int iBlockID, aif material, String sTextureName, String sColumnSideTextureName, int iMatchingCornerBlockID, float fHardness, float fResistance, ape stepSound, String name) {
        super(iBlockID, material, sTextureName, iMatchingCornerBlockID, fHardness, fResistance, stepSound, name);
        this.columnSideTextureName = sColumnSideTextureName;
        this.columnTopAndBottomTextureName = sTextureName;
        this.pedestalSideTextureName = sTextureName;
        this.pedestalTopAndBottomTextureName = sTextureName;
    }

    public MouldingAndDecorativeBlock(int iBlockID, aif material, String sTextureName, String sColumnSideTextureName, String sColumnTopAndBottomTextureName, String sPedestalSideTextureName, String sPedestalTopAndBottomTextureName, int iMatchingCornerBlockID, float fHardness, float fResistance, ape stepSound, String name) {
        super(iBlockID, material, sTextureName, iMatchingCornerBlockID, fHardness, fResistance, stepSound, name);
        this.columnSideTextureName = sColumnSideTextureName;
        this.columnTopAndBottomTextureName = sColumnTopAndBottomTextureName;
        this.pedestalSideTextureName = sPedestalSideTextureName;
        this.pedestalTopAndBottomTextureName = sPedestalTopAndBottomTextureName;
    }

    @Override
    public int a(int iMetadata) {
        if (!this.isDecorative(iMetadata)) {
            return super.a(iMetadata);
        }
        if (iMetadata == 14) {
            iMetadata = 13;
        }
        return iMetadata;
    }

    @Override
    public int a(aab world, int i2, int j2, int k, int iFacing, float fClickX, float fClickY, float fClickZ, int iMetadata) {
        int iSubtype = iMetadata;
        if (iSubtype == 13) {
            if (iFacing == 0 || iFacing != 1 && (double)fClickY > 0.5) {
                return 14;
            }
        } else if (!this.isDecorative(iMetadata)) {
            return super.a(world, i2, j2, k, iFacing, fClickX, fClickY, fClickZ, iMetadata);
        }
        return iMetadata;
    }

    @Override
    public aqx getBlockBoundsFromPoolBasedOnState(aak blockAccess, int i2, int j2, int k) {
        int iMetadata = blockAccess.h(i2, j2, k);
        if (this.isDecorative(iMetadata)) {
            switch (iMetadata) {
                case 12: {
                    return aqx.a().a(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125);
                }
                case 15: {
                    if (!this.doesTableHaveLeg(blockAccess, i2, j2, k)) {
                        return aqx.a().a(0.0, 0.875, 0.0, 1.0, 1.0, 1.0);
                    }
                    return aqx.a().a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                }
                case 13: 
                case 14: {
                    return aqx.a().a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                }
            }
            return aqx.a().a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
        return super.getBlockBoundsFromPoolBasedOnState(blockAccess, i2, j2, k);
    }

    @Override
    public ara a(aab world, int i2, int j2, int k, arc startRay, arc endRay) {
        if (this.isDecorative(world, i2, j2, k)) {
            if (this.isBlockTable(world, i2, j2, k) && this.doesTableHaveLeg(world, i2, j2, k)) {
                return this.collisionRayTraceTableWithLeg(world, i2, j2, k, startRay, endRay);
            }
            return this.collisionRayTraceVsBlockBounds(world, i2, j2, k, startRay, endRay);
        }
        return super.a(world, i2, j2, k, startRay, endRay);
    }

    @Override
    public void a(aab world, int i2, int j2, int k, aqx intersectingBox, List list, mp entity) {
        if (this.isDecorative(world, i2, j2, k)) {
            this.b(world, i2, j2, k).addToListIfIntersects(intersectingBox, list);
        } else {
            super.a(world, i2, j2, k, intersectingBox, list, entity);
        }
    }

    @Override
    public boolean hasCenterHardPointToFacing(aak blockAccess, int i2, int j2, int k, int iFacing, boolean bIgnoreTransparency) {
        int iSubtype = blockAccess.h(i2, j2, k);
        switch (iSubtype) {
            case 12: {
                return iFacing == 0 || iFacing == 1;
            }
            case 13: 
            case 14: {
                return true;
            }
        }
        return super.hasCenterHardPointToFacing(blockAccess, i2, j2, k, iFacing, bIgnoreTransparency);
    }

    @Override
    public boolean hasLargeCenterHardPointToFacing(aak blockAccess, int i2, int j2, int k, int iFacing, boolean bIgnoreTransparency) {
        int iSubtype = blockAccess.h(i2, j2, k);
        switch (iSubtype) {
            case 13: {
                return iFacing == 0;
            }
            case 14: {
                return iFacing == 1;
            }
            case 15: {
                return iFacing == 1;
            }
        }
        return super.hasLargeCenterHardPointToFacing(blockAccess, i2, j2, k, iFacing, bIgnoreTransparency);
    }

    @Override
    public int rotateMetadataAroundJAxis(int iMetadata, boolean bReverse) {
        if (!this.isDecorative(iMetadata)) {
            return super.rotateMetadataAroundJAxis(iMetadata, bReverse);
        }
        return iMetadata;
    }

    @Override
    public boolean toggleFacing(aab world, int i2, int j2, int k, boolean bReverse) {
        if (!this.isDecorative(world, i2, j2, k)) {
            return super.toggleFacing(world, i2, j2, k, bReverse);
        }
        return false;
    }

    @Override
    public boolean canTransmitRotationHorizontallyOnTurntable(aak blockAccess, int i2, int j2, int k) {
        int iMetadata = blockAccess.h(i2, j2, k);
        if (this.isDecorative(iMetadata)) {
            return iMetadata == 13 || iMetadata == 14;
        }
        return super.canTransmitRotationHorizontallyOnTurntable(blockAccess, i2, j2, k);
    }

    @Override
    public boolean canTransmitRotationVerticallyOnTurntable(aak blockAccess, int i2, int j2, int k) {
        int iMetadata = blockAccess.h(i2, j2, k);
        if (this.isDecorative(iMetadata)) {
            return iMetadata != 15;
        }
        return super.canTransmitRotationVerticallyOnTurntable(blockAccess, i2, j2, k);
    }

    @Override
    public float mobSpawnOnVerticalOffset(aab world, int i2, int j2, int k) {
        int iSubtype = world.h(i2, j2, k);
        if (iSubtype < 12) {
            return super.mobSpawnOnVerticalOffset(world, i2, j2, k);
        }
        return 0.0f;
    }

    @Override
    public boolean isBenchOrTable(int metadata) {
        return metadata == 15;
    }

    @Override
    public boolean shouldWallFormPostBelowThisBlock(aak blockAccess, int x2, int y2, int z2) {
        return blockAccess.h(x2, y2, z2) == 15 && this.doesTableHaveLeg(blockAccess, x2, y2, z2);
    }

    @Override
    protected boolean isMouldingOfSameType(aak blockAccess, int i2, int j2, int k) {
        return blockAccess.a(i2, j2, k) == this.cz && !this.isDecorative(blockAccess, i2, j2, k);
    }

    public boolean isDecorative(aak blockAccess, int i2, int j2, int k) {
        return this.isDecorative(blockAccess.h(i2, j2, k));
    }

    public boolean isDecorative(int iMetadata) {
        return iMetadata >= 12;
    }

    public boolean isBlockTable(aak blockAccess, int i2, int j2, int k) {
        return blockAccess.a(i2, j2, k) == this.cz && blockAccess.h(i2, j2, k) == 15;
    }

    public boolean doesTableHaveLeg(aak blockAccess, int i2, int j2, int k) {
        int iBlockBelowMetadata;
        int iBlockBelowID = blockAccess.a(i2, j2 - 1, k);
        if (this.cz == BTWBlocks.netherBrickMouldingAndDecorative.cz ? iBlockBelowID == apa.bF.cz : iBlockBelowID == this.matchingCornerBlockID && (iBlockBelowMetadata = blockAccess.h(i2, j2 - 1, k)) == 14) {
            return true;
        }
        boolean positiveITable = this.isBlockTable(blockAccess, i2 + 1, j2, k);
        boolean negativeITable = this.isBlockTable(blockAccess, i2 - 1, j2, k);
        boolean positiveKTable = this.isBlockTable(blockAccess, i2, j2, k + 1);
        boolean negativeKTable = this.isBlockTable(blockAccess, i2, j2, k - 1);
        return !positiveITable && (!positiveKTable || !negativeKTable) || !negativeITable && (!positiveKTable || !negativeKTable);
    }

    public ara collisionRayTraceTableWithLeg(aab world, int i2, int j2, int k, arc startRay, arc endRay) {
        RayTraceUtils rayTrace = new RayTraceUtils(world, i2, j2, k, startRay, endRay);
        rayTrace.addBoxWithLocalCoordsToIntersectionList(0.0, 0.875, 0.0, 1.0, 1.0, 1.0);
        rayTrace.addBoxWithLocalCoordsToIntersectionList(0.375, 0.0, 0.375, 0.625, 0.875, 0.625);
        return rayTrace.getFirstIntersection();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        super.a(register);
        this.iconColumnSide = register.a(this.columnSideTextureName);
        this.iconColumnTopAndBottom = register.a(this.columnTopAndBottomTextureName);
        this.iconPedestalSide = register.a(this.pedestalSideTextureName);
        this.iconPedestalTopAndBottom = register.a(this.pedestalTopAndBottomTextureName);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        if (iMetadata == 12) {
            if (iSide < 2) {
                return this.iconColumnTopAndBottom;
            }
            return this.iconColumnSide;
        }
        if (iMetadata == 13 || iMetadata == 14) {
            if (iSide < 2) {
                return this.iconPedestalTopAndBottom;
            }
            return this.iconPedestalSide;
        }
        return super.a(iSide, iMetadata);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderBlocks, int i2, int j2, int k) {
        aak blockAccess = renderBlocks.a;
        int iMetadata = blockAccess.h(i2, j2, k);
        if (!this.isDecorative(iMetadata)) {
            return super.renderBlock(renderBlocks, i2, j2, k);
        }
        switch (iMetadata) {
            case 13: {
                return this.renderPedestalUp(renderBlocks, i2, j2, k);
            }
            case 14: {
                return this.renderPedestalDown(renderBlocks, i2, j2, k);
            }
            case 15: {
                return this.renderTable(renderBlocks, i2, j2, k);
            }
        }
        renderBlocks.setRenderBounds(this.getBlockBoundsFromPoolBasedOnState(renderBlocks.a, i2, j2, k));
        return renderBlocks.p(this, i2, j2, k);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderBlocks, int iItemDamage, float fBrightness) {
        if (this.isDecorative(iItemDamage)) {
            this.renderDecorativeInvBlock(renderBlocks, this, iItemDamage, fBrightness);
        } else {
            super.renderBlockAsItem(renderBlocks, iItemDamage, fBrightness);
        }
    }

    @Environment(value=EnvType.CLIENT)
    protected void renderDecorativeInvBlock(bgf renderBlocks, apa block, int iItemDamage, float fBrightness) {
        switch (iItemDamage) {
            case 13: {
                this.renderPedestalUpInvBlock(renderBlocks, block);
                break;
            }
            case 14: {
                this.renderPedestalDownInvBlock(renderBlocks, block);
                break;
            }
            case 15: {
                this.renderTableInvBlock(renderBlocks, block);
                break;
            }
            case 12: {
                renderBlocks.a(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125);
                RenderUtils.renderInvBlockWithMetadata(renderBlocks, block, -0.5f, -0.5f, -0.5f, iItemDamage);
                break;
            }
            default: {
                renderBlocks.renderBlockAsItemVanilla(block, iItemDamage, fBrightness);
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public aqx c_(aab world, int i2, int j2, int k) {
        int iMetadata = world.h(i2, j2, k);
        if (this.isDecorative(iMetadata)) {
            return this.getBlockBoundsFromPoolBasedOnState(world, i2, j2, k).d(i2, j2, k);
        }
        return super.c_(world, i2, j2, k);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean renderPedestalUp(bgf renderBlocks, int i2, int j2, int k) {
        renderBlocks.a(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
        renderBlocks.p(this, i2, j2, k);
        renderBlocks.a(0.0625, 0.75, 0.0625, 0.9375, 0.875, 0.9375);
        renderBlocks.p(this, i2, j2, k);
        renderBlocks.a(0.125, 0.875, 0.125, 0.875, 1.0, 0.875);
        renderBlocks.p(this, i2, j2, k);
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public void renderPedestalUpInvBlock(bgf renderBlocks, apa block) {
        renderBlocks.a(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, block, -0.5f, -0.5f, -0.5f, 13);
        renderBlocks.a(0.0625, 0.75, 0.0625, 0.9375, 0.875, 0.9375);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, block, -0.5f, -0.5f, -0.5f, 13);
        renderBlocks.a(0.125, 0.875, 0.125, 0.875, 1.0, 0.875);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, block, -0.5f, -0.5f, -0.5f, 13);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean renderPedestalDown(bgf renderBlocks, int i2, int j2, int k) {
        renderBlocks.a(0.0, 0.25, 0.0, 1.0, 1.0, 1.0);
        renderBlocks.p(this, i2, j2, k);
        renderBlocks.a(0.0625, 0.125, 0.0625, 0.9375, 0.25, 0.9375);
        renderBlocks.p(this, i2, j2, k);
        renderBlocks.a(0.125, 0.0, 0.125, 0.875, 0.125, 0.875);
        renderBlocks.p(this, i2, j2, k);
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public void renderPedestalDownInvBlock(bgf renderBlocks, apa block) {
        renderBlocks.a(0.0, 0.25, 0.0, 1.0, 1.0, 1.0);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, block, -0.5f, -0.5f, -0.5f, 14);
        renderBlocks.a(0.0625, 0.125, 0.0625, 0.9375, 0.25, 0.9375);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, block, -0.5f, -0.5f, -0.5f, 14);
        renderBlocks.a(0.125, 0.0, 0.125, 0.875, 0.125, 0.875);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, block, -0.5f, -0.5f, -0.5f, 14);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean renderTable(bgf renderBlocks, int i2, int j2, int k) {
        renderBlocks.a(0.0, 0.875, 0.0, 1.0, 1.0, 1.0);
        renderBlocks.p(this, i2, j2, k);
        if (this.doesTableHaveLeg(renderBlocks.a, i2, j2, k)) {
            renderBlocks.a(0.375, 0.0, 0.375, 0.625, 0.875, 0.625);
            renderBlocks.p(this, i2, j2, k);
        }
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public void renderTableInvBlock(bgf renderBlocks, apa block) {
        renderBlocks.a(0.0, 0.875, 0.0, 1.0, 1.0, 1.0);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, block, -0.5f, -0.5f, -0.5f, 15);
        renderBlocks.a(0.375, 0.0, 0.375, 0.625, 0.875, 0.625);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, block, -0.5f, -0.5f, -0.5f, 15);
    }
}

