/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.util.Flammability;
import btw.entity.MiningChargeEntity;
import btw.world.util.BlockPos;
import btw.world.util.WorldUtils;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class MiningChargeBlock
extends apa {
    public static final double BOUNDING_BOX_HEIGHT = 0.5;
    private static final int TICK_RATE = 1;
    @Environment(value=EnvType.CLIENT)
    private lx iconBottom;
    @Environment(value=EnvType.CLIENT)
    private lx iconTop;
    @Environment(value=EnvType.CLIENT)
    private lx iconSide;
    @Environment(value=EnvType.CLIENT)
    private lx iconSideFlipped;

    public MiningChargeBlock(int iBlockID) {
        super(iBlockID, aif.t);
        this.c(0.0f);
        this.setFireProperties(Flammability.EXPLOSIVES);
        this.initBlockBounds(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
        this.a(i);
        this.c("fcBlockMiningCharge");
        this.b(true);
        this.a(ve.d);
    }

    @Override
    public int a(aab world) {
        return 1;
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public int a(Random random) {
        return 0;
    }

    @Override
    public boolean c(aab world, int i2, int j2, int k) {
        for (int iTempFacing = 0; iTempFacing <= 5; ++iTempFacing) {
            if (!this.isValidAnchorToFacing(world, i2, j2, k, iTempFacing)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void a(aab world, int i2, int j2, int k) {
        super.a(world, i2, j2, k);
        world.a(i2, j2, k, this.cz, this.a(world));
    }

    @Override
    public int a(aab world, int i2, int j2, int k, int iFacing, float fClickX, float fClickY, float fClickZ, int iMetadata) {
        if (!this.isValidAnchorToFacing(world, i2, j2, k, iFacing = apa.getOppositeFacing(iFacing))) {
            iFacing = 0;
            for (int iTempFacing = 0; iTempFacing <= 5; ++iTempFacing) {
                if (!this.isValidAnchorToFacing(world, i2, j2, k, iTempFacing)) continue;
                iFacing = iTempFacing;
                break;
            }
        }
        return this.setFacing(iMetadata, iFacing);
    }

    @Override
    public aqx getBlockBoundsFromPoolBasedOnState(aak blockAccess, int i2, int j2, int k) {
        int iFacing = this.getFacing(blockAccess, i2, j2, k);
        switch (iFacing) {
            case 0: {
                return aqx.a().a(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
            }
            case 1: {
                return aqx.a().a(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
            }
            case 2: {
                return aqx.a().a(0.0, 0.0, 0.0, 1.0, 1.0, 0.5);
            }
            case 3: {
                return aqx.a().a(0.0, 0.0, 0.5, 1.0, 1.0, 1.0);
            }
            case 4: {
                return aqx.a().a(0.0, 0.0, 0.0, 0.5, 1.0, 1.0);
            }
        }
        return aqx.a().a(0.5, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iNeighborBlockID) {
        if (!world.isUpdatePendingThisTickForBlock(i2, j2, k, this.cz)) {
            world.a(i2, j2, k, this.cz, this.a(world));
        }
    }

    @Override
    public void a(aab world, int i2, int j2, int k, zw explosion) {
        if (world.I) {
            return;
        }
        int iFacing = this.getFacing(world, i2, j2, k);
        MiningChargeEntity entityMiningCharge = MiningChargeBlock.createPrimedEntity(world, i2, j2, k, iFacing);
        entityMiningCharge.fuse = 1;
    }

    @Override
    public void g(aab world, int i2, int j2, int k, int iMetaData) {
        if (world.I) {
            return;
        }
        this.b(world, i2, j2, k, new wm(BTWBlocks.miningCharge.cz, 1, 0));
    }

    @Override
    public boolean a(aab world, int i2, int j2, int k, sq player, int iFacing, float fXClick, float fYClick, float fZClick) {
        wm playerEquippedItem = player.cd();
        if (playerEquippedItem != null && playerEquippedItem.c == wk.j.cp) {
            if (!world.I) {
                int iMetaData = world.h(i2, j2, k);
                world.setBlockWithNotify(i2, j2, k, 0);
                MiningChargeBlock.createPrimedEntity(world, i2, j2, k, iMetaData);
            }
            playerEquippedItem.a(1, (ng)player);
            return true;
        }
        return super.a(world, i2, j2, k, player, iFacing, fXClick, fYClick, fZClick);
    }

    @Override
    public void a(aab world, int i2, int j2, int k, Random random) {
        if (this.isGettingRedstonePower(world, i2, j2, k)) {
            int iMetaData = world.h(i2, j2, k);
            world.setBlockWithNotify(i2, j2, k, 0);
            MiningChargeBlock.createPrimedEntity(world, i2, j2, k, iMetaData);
        } else if (!this.isValidAnchorToFacing(world, i2, j2, k, this.getFacing(world, i2, j2, k))) {
            world.setBlockWithNotify(i2, j2, k, 0);
            this.b(world, i2, j2, k, new wm(BTWBlocks.miningCharge.cz, 1, 0));
        }
    }

    @Override
    public void onDestroyedByFire(aab world, int i2, int j2, int k, int iFireAge, boolean bForcedFireSpread) {
        MiningChargeBlock.createPrimedEntity(world, i2, j2, k, world.h(i2, j2, k));
        super.onDestroyedByFire(world, i2, j2, k, iFireAge, bForcedFireSpread);
    }

    @Override
    public int getFacing(int iMetadata) {
        return iMetadata & 7;
    }

    @Override
    public int setFacing(int iMetadata, int iFacing) {
        iMetadata &= 0xFFFFFFF8;
        return iMetadata |= iFacing;
    }

    @Override
    public boolean canRotateOnTurntable(aak iBlockAccess, int i2, int j2, int k) {
        int iFacing = this.getFacing(iBlockAccess, i2, j2, k);
        return iFacing != 1;
    }

    @Override
    public boolean rotateAroundJAxis(aab world, int i2, int j2, int k, boolean bReverse) {
        if (super.rotateAroundJAxis(world, i2, j2, k, bReverse)) {
            world.a(i2, j2, k, this.cz, this.a(world));
            return true;
        }
        return false;
    }

    @Override
    public boolean toggleFacing(aab world, int i2, int j2, int k, boolean bReverse) {
        int iFacing = this.getFacing(world, i2, j2, k);
        iFacing = apa.cycleFacing(iFacing, bReverse);
        this.setFacing(world, i2, j2, k, iFacing);
        world.a(i2, j2, k, this.cz, this.a(world));
        return true;
    }

    public boolean isGettingRedstonePower(aab world, int i2, int j2, int k) {
        return world.C(i2, j2, k);
    }

    public boolean isValidAnchorToFacing(aab world, int i2, int j2, int k, int iFacing) {
        BlockPos anchorBlockPos = new BlockPos(i2, j2, k, iFacing);
        return WorldUtils.doesBlockHaveLargeCenterHardpointToFacing(world, anchorBlockPos.x, anchorBlockPos.y, anchorBlockPos.z, MiningChargeBlock.getOppositeFacing(iFacing), true);
    }

    public static MiningChargeEntity createPrimedEntity(aab world, int i2, int j2, int k, int iMetaData) {
        MiningChargeEntity entityMiningCharge = (MiningChargeEntity)mv.createEntityOfType(MiningChargeEntity.class, world, i2, j2, k, BTWBlocks.miningCharge.getFacing(iMetaData));
        world.d(entityMiningCharge);
        world.a(entityMiningCharge, "random.fuse", 1.0f, 1.0f);
        return entityMiningCharge;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        this.iconBottom = register.a("fcBlockMiningCharge_bottom");
        this.iconTop = register.a("fcBlockMiningCharge_top");
        this.iconSide = register.a("fcBlockMiningCharge_side");
        this.iconSideFlipped = register.a("fcBlockMiningCharge_side_vert");
        this.cQ = this.iconSide;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        if (iSide <= 3) {
            return this.iconSideFlipped;
        }
        if (iSide == 4) {
            return this.iconTop;
        }
        return this.iconBottom;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx b_(aak blockAccess, int i2, int j2, int k, int iSide) {
        int iFacing = this.getFacing(blockAccess, i2, j2, k);
        if (iFacing <= 1) {
            if (iSide <= 3) {
                return this.iconSideFlipped;
            }
            if (iSide == 4) {
                return this.iconTop;
            }
            return this.iconBottom;
        }
        if (iSide == 0) {
            return this.iconBottom;
        }
        if (iSide == 1) {
            return this.iconTop;
        }
        return this.iconSide;
    }

    @Environment(value=EnvType.CLIENT)
    public lx getBlockTextureFromMetadataCustom(int iSide, int iMetadata) {
        int iFacing = this.getFacing(iMetadata);
        if (iFacing <= 1) {
            if (iSide <= 3) {
                return this.iconSideFlipped;
            }
            if (iSide == 4) {
                return this.iconTop;
            }
            return this.iconBottom;
        }
        if (iSide == 0) {
            return this.iconBottom;
        }
        if (iSide == 1) {
            return this.iconTop;
        }
        return this.iconSide;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        return this.currentBlockRenderer.shouldSideBeRenderedBasedOnCurrentBounds(iNeighborI, iNeighborJ, iNeighborK, iSide);
    }
}

