/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.MechanicalBlock;
import btw.block.model.MillstoneModel;
import btw.block.tileentity.MillstoneTileEntity;
import btw.block.util.MechPowerUtils;
import btw.block.util.RayTraceUtils;
import btw.inventory.util.InventoryUtils;
import btw.item.BTWItems;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class MillstoneBlock
extends akz
implements MechanicalBlock {
    private static final int TICK_RATE = 10;
    public static final int CONTENTS_NOTHING = 0;
    public static final int CONTENTS_NORMAL_GRINDING = 1;
    public static final int CONTENTS_NETHERRACK = 2;
    public static final int CONTENTS_COMPANION_CUBE = 3;
    public static final int CONTENTS_JAMMED = 4;
    public static final MillstoneModel model = new MillstoneModel();
    @Environment(value=EnvType.CLIENT)
    private final lx[] iconsBySide = new lx[6];
    @Environment(value=EnvType.CLIENT)
    private final lx[] iconsBySideFull = new lx[6];
    @Environment(value=EnvType.CLIENT)
    private final lx[] iconsBySideOn = new lx[6];
    @Environment(value=EnvType.CLIENT)
    private final lx[] iconsBySideOnFull = new lx[6];
    @Environment(value=EnvType.CLIENT)
    private boolean renderingBase = false;

    public MillstoneBlock(int iBlockID) {
        super(iBlockID, aif.e);
        this.c(3.5f);
        this.a(j);
        this.c("fcBlockMillStone");
        this.b(true);
        this.a(ve.d);
    }

    public boolean c() {
        return false;
    }

    public boolean b() {
        return false;
    }

    public int a(aab world) {
        return 10;
    }

    public void a(aab world, int i2, int j2, int k) {
        super.a(world, i2, j2, k);
        world.a(i2, j2, k, this.cz, this.a(world));
    }

    public boolean a(aab world, int i2, int j2, int k, sq player, int iFacing, float fXClick, float fYClick, float fZClick) {
        int iState = this.getCurrentGrindingType(world, i2, j2, k);
        MillstoneTileEntity tileEntity = (MillstoneTileEntity)world.r(i2, j2, k);
        if (iState == 0) {
            wm heldStack = player.cd();
            if (heldStack != null) {
                if (!world.I) {
                    world.e(2231, i2, j2, k, 0);
                    tileEntity.attemptToAddSingleItemFromStack(heldStack);
                } else {
                    --heldStack.a;
                }
            }
        } else if (!world.I) {
            world.e(2231, i2, j2, k, 0);
            tileEntity.ejectContents(iFacing);
        }
        return true;
    }

    public void a(aab world, int i2, int j2, int k, int iBlockID, int iMetadata) {
        InventoryUtils.ejectInventoryContents(world, i2, j2, k, (lt)world.r(i2, j2, k));
        super.a(world, i2, j2, k, iBlockID, iMetadata);
    }

    public aqp b(aab world) {
        return new MillstoneTileEntity();
    }

    public void a(aab world, int i2, int j2, int k, Random random) {
        boolean bReceivingPower = this.isInputtingMechanicalPower(world, i2, j2, k);
        boolean bOn = this.getIsMechanicalOn(world, i2, j2, k);
        if (bOn != bReceivingPower) {
            this.setIsMechanicalOn(world, i2, j2, k, bReceivingPower);
        }
    }

    public void randomUpdateTick(aab world, int i2, int j2, int k, Random rand) {
        if (!this.isCurrentStateValid(world, i2, j2, k) && !world.isUpdateScheduledForBlock(i2, j2, k, this.cz)) {
            world.a(i2, j2, k, this.cz, this.a(world));
        }
    }

    public void a(aab world, int i2, int j2, int k, int iBlockID) {
        if (!this.isCurrentStateValid(world, i2, j2, k) && !world.isUpdatePendingThisTickForBlock(i2, j2, k, this.cz)) {
            world.a(i2, j2, k, this.cz, this.a(world));
        }
    }

    public ara a(aab world, int i2, int j2, int k, arc startRay, arc endRay) {
        RayTraceUtils rayTrace = new RayTraceUtils(world, i2, j2, k, startRay, endRay);
        model.addToRayTrace(rayTrace);
        rayTrace.addBoxWithLocalCoordsToIntersectionList(MillstoneBlock.model.boxBase);
        return rayTrace.getFirstIntersection();
    }

    public boolean hasCenterHardPointToFacing(aak blockAccess, int i2, int j2, int k, int iFacing, boolean bIgnoreTransparency) {
        return true;
    }

    public boolean hasLargeCenterHardPointToFacing(aak blockAccess, int i2, int j2, int k, int iFacing, boolean bIgnoreTransparency) {
        return iFacing == 0 || bIgnoreTransparency;
    }

    @Override
    public boolean canOutputMechanicalPower() {
        return false;
    }

    @Override
    public boolean canInputMechanicalPower() {
        return true;
    }

    @Override
    public boolean isInputtingMechanicalPower(aab world, int i2, int j2, int k) {
        return MechPowerUtils.isBlockPoweredByAxle(world, i2, j2, k, this) || MechPowerUtils.isBlockPoweredByHandCrank(world, i2, j2, k);
    }

    @Override
    public boolean canInputAxlePowerToFacing(aab world, int i2, int j2, int k, int iFacing) {
        return iFacing < 2;
    }

    @Override
    public boolean isOutputtingMechanicalPower(aab world, int i2, int j2, int k) {
        return false;
    }

    @Override
    public void overpower(aab world, int i2, int j2, int k) {
        this.breakMillStone(world, i2, j2, k);
    }

    public boolean q_() {
        return true;
    }

    public int b_(aab par1World, int par2, int par3, int par4, int par5) {
        return ((MillstoneTileEntity)par1World.r((int)par2, (int)par3, (int)par4)).stackMilling == null ? 0 : 15;
    }

    public boolean getIsMechanicalOn(aak blockAccess, int i2, int j2, int k) {
        return this.getIsMechanicalOn(blockAccess.h(i2, j2, k));
    }

    public boolean getIsMechanicalOn(int iMetadata) {
        return (iMetadata & 1) > 0;
    }

    public void setIsMechanicalOn(aab world, int i2, int j2, int k, boolean bOn) {
        int iMetadata = this.setIsMechanicalOn(world.h(i2, j2, k), bOn);
        world.setBlockMetadataWithNotify(i2, j2, k, iMetadata);
    }

    public int setIsMechanicalOn(int iMetadata, boolean bOn) {
        if (bOn) {
            return iMetadata | 1;
        }
        return iMetadata & 0xFFFFFFFE;
    }

    public int getCurrentGrindingType(aak blockAccess, int i2, int j2, int k) {
        return this.getCurrentGrindingType(blockAccess.h(i2, j2, k));
    }

    public int getCurrentGrindingType(int iMetadata) {
        return (iMetadata & 0xE) >> 1;
    }

    public void setCurrentGrindingType(aab world, int i2, int j2, int k, int iGrindingType) {
        int iMetadata = this.setCurrentGrindingType(world.h(i2, j2, k), iGrindingType);
        world.setBlockMetadataWithClient(i2, j2, k, iMetadata);
    }

    public int setCurrentGrindingType(int iMetadata, int iGrindingType) {
        return (iMetadata &= 0xFFFFFFF1) | iGrindingType << 1;
    }

    private void breakMillStone(aab world, int i2, int j2, int k) {
        this.dropItemsIndividually(world, i2, j2, k, BTWItems.stone.cp, 16, 0, 0.75f);
        world.e(2235, i2, j2, k, 0);
        world.setBlockWithNotify(i2, j2, k, 0);
    }

    public boolean isCurrentStateValid(aab world, int i2, int j2, int k) {
        boolean bReceivingPower = this.isInputtingMechanicalPower(world, i2, j2, k);
        boolean bOn = this.getIsMechanicalOn(world, i2, j2, k);
        return bOn == bReceivingPower;
    }

    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        this.cQ = register.a("stone");
        this.iconsBySideFull[0] = this.iconsBySide[0] = register.a("fcBlockMillStone_bottom");
        this.iconsBySideFull[1] = this.iconsBySide[1] = register.a("fcBlockMillStone_top");
        this.iconsBySideOn[0] = this.iconsBySideOnFull[0] = register.a("fcBlockMillStone_bottom_on");
        this.iconsBySideOn[1] = this.iconsBySideOnFull[1] = register.a("fcBlockMillStone_top_on");
        lx sideIcon = register.a("fcBlockMillStone_side");
        lx sideIconFull = register.a("fcBlockMillStone_side_full");
        lx sideIconOn = register.a("fcBlockMillStone_side_on");
        lx sideIconOnFull = register.a("fcBlockMillStone_side_on_full");
        for (int iTempSide = 2; iTempSide <= 5; ++iTempSide) {
            this.iconsBySide[iTempSide] = sideIcon;
            this.iconsBySideFull[iTempSide] = sideIconFull;
            this.iconsBySideOn[iTempSide] = sideIconOn;
            this.iconsBySideOnFull[iTempSide] = sideIconOnFull;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public lx a(int iSide, int iMetadata) {
        if (this.renderingBase) {
            return this.iconsBySide[iSide];
        }
        if (this.getIsMechanicalOn(iMetadata)) {
            if (this.getCurrentGrindingType(iMetadata) == 0) {
                return this.iconsBySideOn[iSide];
            }
            return this.iconsBySideOnFull[iSide];
        }
        if (this.getCurrentGrindingType(iMetadata) == 0) {
            return this.iconsBySide[iSide];
        }
        return this.iconsBySideFull[iSide];
    }

    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderBlocks, int i2, int j2, int k) {
        this.renderingBase = true;
        MillstoneBlock.model.boxBase.renderAsBlock(renderBlocks, (apa)((Object)this), i2, j2, k);
        this.renderingBase = false;
        return model.renderAsBlock(renderBlocks, (apa)((Object)this), i2, j2, k);
    }

    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderBlocks, int iItemDamage, float fBrightness) {
        this.renderingBase = true;
        MillstoneBlock.model.boxBase.renderAsItemBlock(renderBlocks, (apa)((Object)this), iItemDamage);
        this.renderingBase = false;
        model.renderAsItemBlock(renderBlocks, (apa)((Object)this), iItemDamage);
    }

    @Environment(value=EnvType.CLIENT)
    public void b(aab world, int i2, int j2, int k, Random random) {
        if (this.getIsMechanicalOn(world, i2, j2, k)) {
            int iCurrentGrindingType = this.getCurrentGrindingType(world, i2, j2, k);
            this.emitMillingParticles(world, i2, j2, k, iCurrentGrindingType, random);
            if (iCurrentGrindingType == 4) {
                world.playSound((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "minecart.base", 1.0f + world.s.nextFloat() * 0.1f, 1.25f + world.s.nextFloat() * 0.1f);
            } else if (iCurrentGrindingType != 0) {
                world.playSound((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "minecart.base", 1.0f + world.s.nextFloat() * 0.1f, 0.75f + world.s.nextFloat() * 0.1f);
            } else if (random.nextInt(2) == 0) {
                world.playSound((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "minecart.base", 1.5f + random.nextFloat() * 0.1f, 0.5f + random.nextFloat() * 0.1f);
            }
            if (iCurrentGrindingType == 2) {
                if (random.nextInt(3) <= 1) {
                    world.playSound((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "mob.ghast.scream", 0.75f, random.nextFloat() * 0.4f + 0.8f);
                }
            } else if (iCurrentGrindingType == 3 && random.nextInt(3) <= 1) {
                world.playSound((float)i2 + 0.5f, (float)j2 + 0.5f, (float)k + 0.5f, "mob.wolf.hurt", 2.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public aqx c_(aab world, int i2, int j2, int k) {
        aqx transformedBox = MillstoneBlock.model.boxSelection.makeTemporaryCopy();
        transformedBox.d(i2, j2, k);
        return transformedBox;
    }

    @Environment(value=EnvType.CLIENT)
    public void clientNotificationOfMetadataChange(aab world, int i2, int j2, int k, int iOldMetadata, int iNewMetadata) {
        if (!this.getIsMechanicalOn(iOldMetadata) && this.getIsMechanicalOn(iNewMetadata)) {
            int iGrindType = this.getCurrentGrindingType(iNewMetadata);
            if (iGrindType == 3) {
                world.playSound((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "mob.wolf.hurt", 5.0f, (world.s.nextFloat() - world.s.nextFloat()) * 0.2f + 1.0f);
            }
            world.playSound((double)i2 + 0.5, (double)j2 + 0.5, (double)k + 0.5, "minecart.base", 1.5f + world.s.nextFloat() * 0.1f, 0.5f + world.s.nextFloat() * 0.1f);
            this.emitMillingParticles(world, i2, j2, k, iGrindType, world.s);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void emitMillingParticles(aab world, int i2, int j2, int k, int iGrindType, Random rand) {
        String sParticle = iGrindType == 0 ? "smoke" : (iGrindType == 4 ? "largesmoke" : "fcwhitesmoke");
        for (int iTempCount = 0; iTempCount < 5; ++iTempCount) {
            float smokeX = (float)i2 + rand.nextFloat();
            float smokeY = (float)j2 + rand.nextFloat() * 0.5f + 1.0f;
            float smokeZ = (float)k + rand.nextFloat();
            world.a(sParticle, (double)smokeX, (double)smokeY, (double)smokeZ, 0.0, 0.0, 0.0);
        }
    }
}

