/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.blocks.CandleBlock;
import btw.block.model.BlockModel;
import btw.block.model.MetalSpikeModel;
import btw.world.util.BlockPos;
import btw.world.util.WorldUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class MetalSpikeBlock
extends apa {
    protected static MetalSpikeModel model = new MetalSpikeModel();

    public MetalSpikeBlock(int iBlockID) {
        super(iBlockID, aif.f);
        this.c(2.0f);
        this.setPicksEffectiveOn();
        this.initBlockBounds(MetalSpikeBlock.model.boxCollisionCenter);
        this.a(k);
        this.c("fcBlockSpikeIron");
        this.a(ve.c);
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public aqx b(aab world, int i2, int j2, int k) {
        int iFacing = this.getFacing(world, i2, j2, k);
        if (iFacing >= 2) {
            aqx tempBox = MetalSpikeBlock.model.boxCollisionStrut.makeTemporaryCopy();
            tempBox.rotateAroundYToFacing(iFacing);
            tempBox.d(i2, j2, k);
            return tempBox;
        }
        return MetalSpikeBlock.model.boxCollisionCenter.makeTemporaryCopy().d(i2, j2, k);
    }

    @Override
    public ara a(aab world, int i2, int j2, int k, arc startRay, arc endRay) {
        BlockModel m_modelTransformed = new BlockModel();
        m_modelTransformed.addPrimitive(MetalSpikeBlock.model.boxCollisionCenter.makeTemporaryCopy());
        BlockModel transformedSupportsModel = this.getSideSupportsTemporaryModel(world, i2, j2, k);
        if (transformedSupportsModel != null) {
            transformedSupportsModel.makeTemporaryCopyOfPrimitiveList(m_modelTransformed);
        }
        return m_modelTransformed.collisionRayTrace(world, i2, j2, k, startRay, endRay);
    }

    @Override
    public boolean c(aab world, int i2, int j2, int k, int iSide) {
        return this.canConnectToBlockToFacing(world, i2, j2, k, apa.getOppositeFacing(iSide));
    }

    @Override
    public int a(aab world, int i2, int j2, int k, int iFacing, float fClickX, float fClickY, float fClickZ, int iMetadata) {
        return this.setFacing(iMetadata, apa.getOppositeFacing(iFacing));
    }

    @Override
    public void a(aab world, int i2, int j2, int k, int iNeighborBlockID) {
        super.a(world, i2, j2, k, iNeighborBlockID);
        if (!this.canConnectToBlockToFacing(world, i2, j2, k, this.getFacing(world, i2, j2, k))) {
            this.c(world, i2, j2, k, world.h(i2, j2, k), 0);
            world.i(i2, j2, k);
        }
    }

    @Override
    public int getFacing(int iMetadata) {
        return iMetadata & 7;
    }

    @Override
    public int setFacing(int iMetadata, int iFacing) {
        return (iMetadata &= 0xFFFFFFF8) | iFacing;
    }

    @Override
    public boolean hasSmallCenterHardPointToFacing(aak blockAccess, int i2, int j2, int k, int iFacing, boolean bIgnoreTransparency) {
        return iFacing < 2;
    }

    @Override
    public boolean canGroundCoverRestOnBlock(aab world, int i2, int j2, int k) {
        return world.w(i2, j2 - 1, k);
    }

    @Override
    public float groundCoverRestingOnVisualOffset(aak blockAccess, int i2, int j2, int k) {
        return -1.0f;
    }

    protected boolean canConnectToBlockToFacing(aak blockAccess, int i2, int j2, int k, int iFacing) {
        BlockPos targetPos = new BlockPos(i2, j2, k, iFacing);
        return WorldUtils.doesBlockHaveSmallCenterHardpointToFacing(blockAccess, targetPos.x, targetPos.y, targetPos.z, apa.getOppositeFacing(iFacing)) || blockAccess.a(targetPos.x, targetPos.y, targetPos.z) == this.cz;
    }

    protected boolean isConnectedSpikeToFacing(aak blockAccess, int i2, int j2, int k, int iFacing) {
        BlockPos targetPos = new BlockPos(i2, j2, k, iFacing);
        return blockAccess.a(targetPos.x, targetPos.y, targetPos.z) == this.cz && this.getFacing(blockAccess, targetPos.x, targetPos.y, targetPos.z) == apa.getOppositeFacing(iFacing);
    }

    BlockModel getSideSupportsTemporaryModel(aak blockAccess, int i2, int j2, int k) {
        BlockModel supportsModel = null;
        int iBlockFacing = this.getFacing(blockAccess, i2, j2, k);
        for (int iTempFacing = 2; iTempFacing <= 5; ++iTempFacing) {
            if (iTempFacing != iBlockFacing && !this.isConnectedSpikeToFacing(blockAccess, i2, j2, k, iTempFacing)) continue;
            BlockModel tempSupportsModel = MetalSpikeBlock.model.modelSideSupport.makeTemporaryCopy();
            tempSupportsModel.rotateAroundYToFacing(iTempFacing);
            if (supportsModel == null) {
                supportsModel = tempSupportsModel;
                continue;
            }
            tempSupportsModel.makeTemporaryCopyOfPrimitiveList(supportsModel);
        }
        return supportsModel;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int iNeighborI, int iNeighborJ, int iNeighborK, int iSide) {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf renderBlocks, int i2, int j2, int k) {
        aak blockAccess = renderBlocks.a;
        int iFacing = this.getFacing(blockAccess, i2, j2, k);
        BlockModel transformedSupportsModel = this.getSideSupportsTemporaryModel(blockAccess, i2, j2, k);
        BlockModel transformedCenterModel = model.makeTemporaryCopy();
        if ((iFacing == 0 && blockAccess.a(i2, j2 - 1, k) != this.cz || iFacing == 1 && blockAccess.a(i2, j2 + 1, k) != this.cz) && !WorldUtils.isGroundCoverOnBlock(renderBlocks.a, i2, j2, k)) {
            MetalSpikeBlock.model.modelBase.makeTemporaryCopyOfPrimitiveList(transformedCenterModel);
        }
        if (iFacing == 1) {
            int iBlockBelowID = blockAccess.a(i2, j2 - 1, k);
            if (iBlockBelowID != this.cz && transformedSupportsModel == null) {
                MetalSpikeBlock.model.modelBall.makeTemporaryCopyOfPrimitiveList(transformedCenterModel);
            }
        } else {
            int iBlockAboveID = blockAccess.a(i2, j2 + 1, k);
            if (iBlockAboveID != this.cz) {
                if (WorldUtils.isBlockRestingOnThatBelow(blockAccess, i2, j2 + 1, k)) {
                    apa block = apa.r[blockAccess.a(i2, j2 + 1, k)];
                    if (block instanceof CandleBlock && ((CandleBlock)block).getCandleCount(blockAccess, i2, j2 + 1, k) > 1) {
                        MetalSpikeBlock.model.holderModelLarge.makeTemporaryCopyOfPrimitiveList(transformedCenterModel);
                    } else {
                        MetalSpikeBlock.model.modelHolder.makeTemporaryCopyOfPrimitiveList(transformedCenterModel);
                    }
                } else if (transformedSupportsModel == null) {
                    MetalSpikeBlock.model.modelBall.makeTemporaryCopyOfPrimitiveList(transformedCenterModel);
                }
            }
        }
        if (iFacing == 1) {
            transformedCenterModel.tiltToFacingAlongY(0);
        }
        if (transformedSupportsModel != null) {
            transformedSupportsModel.renderAsBlock(renderBlocks, this, i2, j2, k);
            MetalSpikeBlock.model.modelCenterBrace.makeTemporaryCopyOfPrimitiveList(transformedCenterModel);
        }
        return transformedCenterModel.renderAsBlock(renderBlocks, this, i2, j2, k);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderBlocks, int iItemDamage, float fBrightness) {
        model.renderAsItemBlock(renderBlocks, this, iItemDamage);
    }
}

