/*
 * Decompiled with CFR 0.152.
 */
package btw.block.blocks;

import btw.block.BTWBlocks;
import btw.block.blocks.FallingFullBlock;
import btw.block.blocks.GrassBlock;
import btw.client.render.util.RenderUtils;
import btw.item.BTWItems;
import btw.item.items.HoeItem;
import btw.item.util.ItemUtils;
import com.prupe.mcpatcher.mal.block.RenderBlocksUtils;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class LooseSparseGrassBlock
extends FallingFullBlock {
    @Environment(value=EnvType.CLIENT)
    private boolean hasSnowOnTop;
    @Environment(value=EnvType.CLIENT)
    public static boolean secondPass;
    @Environment(value=EnvType.CLIENT)
    private lx iconGrassTopSparse;
    @Environment(value=EnvType.CLIENT)
    private lx iconGrassTopSparseDirt;
    @Environment(value=EnvType.CLIENT)
    private lx iconSnowSide;
    @Environment(value=EnvType.CLIENT)
    private lx iconGrassSideOverlay;

    public LooseSparseGrassBlock(int blockID) {
        super(blockID, aif.b);
        this.c(0.5f);
        this.setShovelsEffectiveOn();
        this.setHoesEffectiveOn();
        this.a(apa.h);
        this.c("fcBlockGrassSparseLoose");
        this.a(ve.b);
    }

    @Override
    public void a(aab world, int x2, int y2, int z2, Random rand) {
        super.a(world, x2, y2, z2, rand);
        if (!GrassBlock.canGrassSurviveAtLocation(world, x2, y2, z2)) {
            world.setBlockWithNotify(x2, y2, z2, BTWBlocks.looseDirt.cz);
        } else if (GrassBlock.canGrassSpreadFromLocation(world, x2, y2, z2)) {
            if (rand.nextFloat() <= 0.8f) {
                GrassBlock.checkForGrassSpreadFromLocation(world, x2, y2, z2);
            }
            if (rand.nextInt(12) == 0) {
                world.setBlockWithNotify(x2, y2, z2, apa.y.cz);
            }
        }
    }

    @Override
    protected wm c_(int metadata) {
        return new wm(BTWBlocks.looseDirt);
    }

    @Override
    public int a(int metadata, Random rand, int fortuneModifier) {
        return BTWBlocks.looseDirt.cz;
    }

    @Override
    public boolean dropComponentItemsOnBadBreak(aab world, int x2, int y2, int z2, int metadata, float chanceOfDrop) {
        this.dropItemsIndividually(world, x2, y2, z2, BTWItems.dirtPile.cp, 6, 0, chanceOfDrop);
        return true;
    }

    @Override
    public boolean canBePistonShoveled(aab world, int x2, int y2, int z2) {
        return true;
    }

    @Override
    public boolean canBeGrazedOn(aak blockAccess, int x2, int y2, int z2, qh animal) {
        return animal.isStarving();
    }

    @Override
    public void onGrazed(aab world, int x2, int y2, int z2, qh animal) {
        world.setBlockWithNotify(x2, y2, z2, BTWBlocks.looseDirt.cz);
        this.notifyNeighborsBlockDisrupted(world, x2, y2, z2);
    }

    @Override
    public void onVegetationAboveGrazed(aab world, int x2, int y2, int z2, qh animal) {
        if (animal.getDisruptsEarthOnGraze()) {
            world.setBlockWithNotify(x2, y2, z2, BTWBlocks.looseDirt.cz);
            this.notifyNeighborsBlockDisrupted(world, x2, y2, z2);
        }
    }

    @Override
    public boolean canReedsGrowOnBlock(aab world, int x2, int y2, int z2) {
        return true;
    }

    @Override
    public boolean canSaplingsGrowOnBlock(aab world, int x2, int y2, int z2) {
        return true;
    }

    @Override
    public boolean canWildVegetationGrowOnBlock(aab world, int x2, int y2, int z2) {
        return true;
    }

    @Override
    public boolean getCanBlightSpreadToBlock(aab world, int x2, int y2, int z2, int blightLevel) {
        return true;
    }

    @Override
    public boolean canConvertBlock(wm stack, aab world, int x2, int y2, int z2) {
        return stack != null && stack.b() instanceof HoeItem;
    }

    @Override
    public boolean convertBlock(wm stack, aab world, int x2, int y2, int z2, int fromSide) {
        world.setBlockWithNotify(x2, y2, z2, BTWBlocks.looseDirt.cz);
        if (!world.I && world.s.nextInt(25) == 0) {
            ItemUtils.ejectStackFromBlockTowardsFacing(world, x2, y2, z2, new wm(BTWItems.hempSeeds), fromSide);
        }
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(ly register) {
        this.cQ = register.a("fcBlockGrassSparseLoose_side");
        this.iconSnowSide = register.a("snow_side");
        this.iconGrassSideOverlay = register.a("grass_side_overlay");
        this.iconGrassTopSparse = register.a("fcBlockGrassSparseLoose");
        this.iconGrassTopSparseDirt = register.a("fcBlockGrassSparseDirtLoose");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int c(aak blockAccess, int x2, int y2, int z2) {
        return apa.y.c(blockAccess, x2, y2, z2);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int o() {
        return apa.y.o();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int b(int par1) {
        return apa.y.b(par1);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean a(aak blockAccess, int neighborX, int neighborY, int neighborZ, int side) {
        if (secondPass) {
            if (side == 0) {
                return false;
            }
            if (side >= 2 && this.hasSnowOnTop) {
                return false;
            }
        }
        return super.a(blockAccess, neighborX, neighborY, neighborZ, side);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public lx b_(aak blockAccess, int x2, int y2, int z2, int side) {
        if (!secondPass) {
            if (side == 1) {
                return this.iconGrassTopSparseDirt;
            }
            if (side > 1) {
                lx betterGrassIcon = RenderBlocksUtils.getGrassTexture(this, blockAccess, x2, y2, z2, side, this.iconGrassTopSparse);
                if (betterGrassIcon != null && betterGrassIcon != this.iconGrassTopSparse) {
                    return betterGrassIcon;
                }
                if (this.hasSnowOnTop) {
                    return this.iconSnowSide;
                }
                return this.cQ;
            }
            return BTWBlocks.looseDirt.cQ;
        }
        return this.getBlockTextureSecondPass(blockAccess, x2, y2, z2, side);
    }

    @Environment(value=EnvType.CLIENT)
    public lx getBlockTextureSecondPass(aak blockAccess, int x2, int y2, int z2, int side) {
        lx topIcon = this.iconGrassTopSparse;
        lx betterGrassIcon = RenderBlocksUtils.getGrassTexture(this, blockAccess, x2, y2, z2, side, topIcon);
        if (betterGrassIcon != null) {
            return betterGrassIcon;
        }
        if (side == 1) {
            return topIcon;
        }
        if (side > 1) {
            return this.iconGrassSideOverlay;
        }
        return null;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderBlock(bgf render, int x2, int y2, int z2) {
        this.hasSnowOnTop = this.isSnowCoveringTopSurface(render.a, x2, y2, z2);
        render.a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        return render.p(this, x2, y2, z2);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockSecondPass(bgf render, int x2, int y2, int z2, boolean firstPassResult) {
        secondPass = true;
        render.a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        render.p(this, x2, y2, z2);
        secondPass = false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderBlockAsItem(bgf renderBlocks, int itemDamage, float brightness) {
        renderBlocks.a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        RenderUtils.renderInvBlockWithMetadata(renderBlocks, this, -0.5f, -0.5f, -0.5f, 0);
    }
}

